#
# Copyright (c) 1997,1998 Akira Yoshiyama <yosshy@debian.or.jp>
# Copyright (c) 1998 Fumitoshi UKAI <ukai@debian.or.jp>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public Licenses as
# published by the Free Software Foundation; either version 2 of 
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# Makefile.inc
# 
# This rules is included from subdirs
#
# LOCALENAME=<locale-name>
# MAPS= map files
# CHARMAP=<locale charmap>
# LOCALEINPUT=<locale input>
#
# or
#
# ALIAS_LOCALE=<alias locale name>
# DEF_LOCALE=<real locale name>
# 
#CC=gcc
#MAKE=make

TOOLS=../TOOLS
MKWCS2MBS=$(TOOLS)/mkwcs2mbs
MKMBS2WCS=$(TOOLS)/mkmbs2wcs.pl
GENMBS2WCS=$(TOOLS)/genmbs2wcs.pl
UNMASK=$(TOOLS)/unmask.pl

SRCDIR=../src
OBJS =	$(SRCDIR)/wcrtomb_locale.o \
	$(SRCDIR)/wcsrtombs_locale.o \
	$(SRCDIR)/wcsnrtombs_locale.o \
	$(SRCDIR)/mbrtowc_locale.o \
	$(SRCDIR)/mbsrtowcs_locale.o \
	$(SRCDIR)/mbsnrtowcs_locale.o

CFLAGS= -I$(SRCDIR) -Wall -D_LIBC -D_LIBC_REENTRANT
DESTPATH=$(DESTDIR)/usr/lib/wcsmbs/$(LOCALENAME)
TARGET= wcsmbs.so

MAP= map.c
MAPOBJ= map.o

LOCALEDEF=/usr/bin/localedef
LOCALEDATADIR=../localedata
LOCALEDIR=$(DESTDIR)/usr/share/locale/$(LOCALENAME)

ifndef ALIAS_LOCALE

all: $(TARGET)

$(TARGET): $(OBJS) $(MAPOBJ)
	$(CC) -shared -o $@ $(OBJS) $(MAPOBJ) -lc

$(OBJS):
	$(MAKE) -C $(SRCDIR)

.c.o: 
	$(CC) -c -fPIC $(CFLAGS) $<

map: table_mbs2wcs table_wcs2mbs
	(echo '/* THIS FILE IS AUTOMATICALLY GENERATED' ; \
	 echo ' * This code is generated from Unicode map table and' ; \
	 echo ' * tools in TOOLS/ directory, which were developed by' ; \
	 echo ' * Akira YOSHIYAMA <yosshy@debian.or.jp>' ; \
	 echo ' */' ; \
	 cat header table_mbs2wcs table_wcs2mbs def) > $(MAP)

$(MKWCS2MBS):
	(cd ../TOOLS; $(MAKE))

install: install_so install_locale

install_so: $(TARGET)
	install -d $(DESTPATH)
	-rm -f $(DESTPATH)/$(TARGET)
	install $(TARGET) $(DESTPATH)/$(TARGET)

install_locale:
	[ "$(NO_LOCALE)" != "" ] || ( \
	install -d $(LOCALEDIR) && \
	install -d $(LOCALEDIR)/LC_MESSAGES && \
	$(LOCALEDEF) -c -f $(LOCALEDATADIR)/charmaps/$(CHARMAP) \
		-i $(LOCALEDATADIR)/$(LOCALEINPUT) $(LOCALEDIR) )

clean:
	-rm -f $(MAPOBJ) $(MAPS) \
		table_mbs2wcs table_mbs2wcs_tmp table_wcs2mbs core
	$(MAKE) -C $(SRCDIR) clean

distclean: clean
	-rm -f $(MAP)
	-rm -f $(TARGET)

else
# defined ALIAS_LOCALE
LOCALE_DATA=LC_COLLATE LC_CTYPE LC_MONETARY LC_NUMERIC LC_TIME

all:

install:
	install -d $(DESTDIR)/usr/lib/wcsmbs/$(ALIAS_LOCALE)
	cd $(DESTDIR)/usr/lib/wcsmbs/$(ALIAS_LOCALE) && ln -s ../$(DEF_LOCALE)/* .
	install -d $(DESTDIR)/usr/share/locale/$(ALIAS_LOCALE)
	install -d $(DESTDIR)/usr/share/locale/$(ALIAS_LOCALE)/LC_MESSAGES
	cd $(DESTDIR)/usr/share/locale/$(ALIAS_LOCALE) && \
	for i in $(LOCALE_DATA); do \
		ln -s ../$(DEF_LOCALE)/$$i . ; done
	cd $(DESTDIR)/usr/share/locale/$(ALIAS_LOCALE)/LC_MESSAGES && \
		ln -s ../../$(DEF_LOCALE)/LC_MESSAGES/SYS_LC_MESSAGES .

map:

clean:

distclean:

endif
		
# EOF
