/*
 * Copyright (c) 1997,1998 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Mon Sep 28 17:18:47 EDT 1998 */

#include <fftw-int.h>
#include <fftw.h>

/* Generated by: ./genfft -magic-alignment-check -magic-twiddle-load-all -magic-variables 4 -magic-loopi -hc2hc-forward 10 */

/*
 * This function contains 210 FP additions, 115 FP multiplications,
 * (or, 170 additions, 75 multiplications, 40 fused multiply/add),
 * 44 stack variables, and 80 memory accesses
 */
static const fftw_real K587785252 = FFTW_KONST(+0.587785252292473129168705954639072768597652438);
static const fftw_real K951056516 = FFTW_KONST(+0.951056516295153572116439333379382143405698634);
static const fftw_real K250000000 = FFTW_KONST(+0.250000000000000000000000000000000000000000000);
static const fftw_real K559016994 = FFTW_KONST(+0.559016994374947424102293417182819058860154590);

/*
 * Generator Id's : 
 * $Id: exprdag.ml,v 1.35 1998/09/25 19:14:16 athena Exp $
 * $Id: fft.ml,v 1.40 1998/09/14 14:43:06 fftw Exp $
 * $Id: to_c.ml,v 1.23 1998/09/14 14:43:08 fftw Exp $
 */

void fftw_hc2hc_forward_10(fftw_real *A, const fftw_complex *W, int iostride, int m, int dist)
{
     int i;
     fftw_real *X;
     fftw_real *Y;
     X = A;
     Y = A + (10 * iostride);
     {
	  fftw_real tmp226;
	  fftw_real tmp237;
	  fftw_real tmp218;
	  fftw_real tmp231;
	  fftw_real tmp221;
	  fftw_real tmp232;
	  fftw_real tmp222;
	  fftw_real tmp239;
	  fftw_real tmp211;
	  fftw_real tmp234;
	  fftw_real tmp214;
	  fftw_real tmp235;
	  fftw_real tmp215;
	  fftw_real tmp238;
	  fftw_real tmp224;
	  fftw_real tmp225;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp224 = X[0];
	  tmp225 = X[5 * iostride];
	  tmp226 = tmp224 - tmp225;
	  tmp237 = tmp224 + tmp225;
	  {
	       fftw_real tmp216;
	       fftw_real tmp217;
	       fftw_real tmp219;
	       fftw_real tmp220;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp216 = X[4 * iostride];
	       tmp217 = X[9 * iostride];
	       tmp218 = tmp216 - tmp217;
	       tmp231 = tmp216 + tmp217;
	       tmp219 = X[6 * iostride];
	       tmp220 = X[iostride];
	       tmp221 = tmp219 - tmp220;
	       tmp232 = tmp219 + tmp220;
	  }
	  tmp222 = tmp218 + tmp221;
	  tmp239 = tmp231 + tmp232;
	  {
	       fftw_real tmp209;
	       fftw_real tmp210;
	       fftw_real tmp212;
	       fftw_real tmp213;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp209 = X[2 * iostride];
	       tmp210 = X[7 * iostride];
	       tmp211 = tmp209 - tmp210;
	       tmp234 = tmp209 + tmp210;
	       tmp212 = X[8 * iostride];
	       tmp213 = X[3 * iostride];
	       tmp214 = tmp212 - tmp213;
	       tmp235 = tmp212 + tmp213;
	  }
	  tmp215 = tmp211 + tmp214;
	  tmp238 = tmp234 + tmp235;
	  {
	       fftw_real tmp223;
	       fftw_real tmp227;
	       fftw_real tmp228;
	       fftw_real tmp242;
	       fftw_real tmp240;
	       fftw_real tmp241;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp223 = K559016994 * (tmp215 - tmp222);
	       tmp227 = tmp215 + tmp222;
	       tmp228 = tmp226 - (K250000000 * tmp227);
	       X[iostride] = tmp223 + tmp228;
	       X[3 * iostride] = tmp228 - tmp223;
	       X[5 * iostride] = tmp226 + tmp227;
	       tmp242 = K559016994 * (tmp238 - tmp239);
	       tmp240 = tmp238 + tmp239;
	       tmp241 = tmp237 - (K250000000 * tmp240);
	       X[2 * iostride] = tmp241 - tmp242;
	       X[4 * iostride] = tmp242 + tmp241;
	       X[0] = tmp237 + tmp240;
	  }
	  {
	       fftw_real tmp229;
	       fftw_real tmp230;
	       fftw_real tmp233;
	       fftw_real tmp236;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp229 = tmp211 - tmp214;
	       tmp230 = tmp218 - tmp221;
	       Y[-iostride] = -((K951056516 * tmp229) + (K587785252 * tmp230));
	       Y[-3 * iostride] = (K587785252 * tmp229) - (K951056516 * tmp230);
	       tmp233 = tmp231 - tmp232;
	       tmp236 = tmp234 - tmp235;
	       Y[-2 * iostride] = (K951056516 * tmp233) - (K587785252 * tmp236);
	       Y[-4 * iostride] = (K951056516 * tmp236) + (K587785252 * tmp233);
	  }
     }
     X = X + dist;
     Y = Y - dist;
     for (i = 2; i < m; i = i + 2, X = X + dist, Y = Y - dist, W = W + 9) {
	  fftw_real tmp95;
	  fftw_real tmp143;
	  fftw_real tmp188;
	  fftw_real tmp200;
	  fftw_real tmp129;
	  fftw_real tmp140;
	  fftw_real tmp141;
	  fftw_real tmp147;
	  fftw_real tmp148;
	  fftw_real tmp149;
	  fftw_real tmp156;
	  fftw_real tmp159;
	  fftw_real tmp184;
	  fftw_real tmp177;
	  fftw_real tmp178;
	  fftw_real tmp198;
	  fftw_real tmp106;
	  fftw_real tmp117;
	  fftw_real tmp118;
	  fftw_real tmp144;
	  fftw_real tmp145;
	  fftw_real tmp146;
	  fftw_real tmp163;
	  fftw_real tmp166;
	  fftw_real tmp183;
	  fftw_real tmp174;
	  fftw_real tmp175;
	  fftw_real tmp197;
	  ASSERT_ALIGNED_DOUBLE();
	  {
	       fftw_real tmp89;
	       fftw_real tmp187;
	       fftw_real tmp94;
	       fftw_real tmp186;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp89 = X[0];
	       tmp187 = Y[-9 * iostride];
	       {
		    fftw_real tmp91;
		    fftw_real tmp93;
		    fftw_real tmp90;
		    fftw_real tmp92;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp91 = X[5 * iostride];
		    tmp93 = Y[-4 * iostride];
		    tmp90 = c_re(W[4]);
		    tmp92 = c_im(W[4]);
		    tmp94 = (tmp90 * tmp91) - (tmp92 * tmp93);
		    tmp186 = (tmp92 * tmp91) + (tmp90 * tmp93);
	       }
	       tmp95 = tmp89 - tmp94;
	       tmp143 = tmp89 + tmp94;
	       tmp188 = tmp186 + tmp187;
	       tmp200 = tmp187 - tmp186;
	  }
	  {
	       fftw_real tmp123;
	       fftw_real tmp154;
	       fftw_real tmp139;
	       fftw_real tmp158;
	       fftw_real tmp128;
	       fftw_real tmp155;
	       fftw_real tmp134;
	       fftw_real tmp157;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp120;
		    fftw_real tmp122;
		    fftw_real tmp119;
		    fftw_real tmp121;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp120 = X[4 * iostride];
		    tmp122 = Y[-5 * iostride];
		    tmp119 = c_re(W[3]);
		    tmp121 = c_im(W[3]);
		    tmp123 = (tmp119 * tmp120) - (tmp121 * tmp122);
		    tmp154 = (tmp121 * tmp120) + (tmp119 * tmp122);
	       }
	       {
		    fftw_real tmp136;
		    fftw_real tmp138;
		    fftw_real tmp135;
		    fftw_real tmp137;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp136 = X[iostride];
		    tmp138 = Y[-8 * iostride];
		    tmp135 = c_re(W[0]);
		    tmp137 = c_im(W[0]);
		    tmp139 = (tmp135 * tmp136) - (tmp137 * tmp138);
		    tmp158 = (tmp137 * tmp136) + (tmp135 * tmp138);
	       }
	       {
		    fftw_real tmp125;
		    fftw_real tmp127;
		    fftw_real tmp124;
		    fftw_real tmp126;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp125 = X[9 * iostride];
		    tmp127 = Y[0];
		    tmp124 = c_re(W[8]);
		    tmp126 = c_im(W[8]);
		    tmp128 = (tmp124 * tmp125) - (tmp126 * tmp127);
		    tmp155 = (tmp126 * tmp125) + (tmp124 * tmp127);
	       }
	       {
		    fftw_real tmp131;
		    fftw_real tmp133;
		    fftw_real tmp130;
		    fftw_real tmp132;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp131 = X[6 * iostride];
		    tmp133 = Y[-3 * iostride];
		    tmp130 = c_re(W[5]);
		    tmp132 = c_im(W[5]);
		    tmp134 = (tmp130 * tmp131) - (tmp132 * tmp133);
		    tmp157 = (tmp132 * tmp131) + (tmp130 * tmp133);
	       }
	       tmp129 = tmp123 - tmp128;
	       tmp140 = tmp134 - tmp139;
	       tmp141 = tmp129 + tmp140;
	       tmp147 = tmp123 + tmp128;
	       tmp148 = tmp134 + tmp139;
	       tmp149 = tmp147 + tmp148;
	       tmp156 = tmp154 + tmp155;
	       tmp159 = tmp157 + tmp158;
	       tmp184 = tmp156 + tmp159;
	       tmp177 = tmp154 - tmp155;
	       tmp178 = tmp157 - tmp158;
	       tmp198 = tmp177 + tmp178;
	  }
	  {
	       fftw_real tmp100;
	       fftw_real tmp161;
	       fftw_real tmp116;
	       fftw_real tmp165;
	       fftw_real tmp105;
	       fftw_real tmp162;
	       fftw_real tmp111;
	       fftw_real tmp164;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp97;
		    fftw_real tmp99;
		    fftw_real tmp96;
		    fftw_real tmp98;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp97 = X[2 * iostride];
		    tmp99 = Y[-7 * iostride];
		    tmp96 = c_re(W[1]);
		    tmp98 = c_im(W[1]);
		    tmp100 = (tmp96 * tmp97) - (tmp98 * tmp99);
		    tmp161 = (tmp98 * tmp97) + (tmp96 * tmp99);
	       }
	       {
		    fftw_real tmp113;
		    fftw_real tmp115;
		    fftw_real tmp112;
		    fftw_real tmp114;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp113 = X[3 * iostride];
		    tmp115 = Y[-6 * iostride];
		    tmp112 = c_re(W[2]);
		    tmp114 = c_im(W[2]);
		    tmp116 = (tmp112 * tmp113) - (tmp114 * tmp115);
		    tmp165 = (tmp114 * tmp113) + (tmp112 * tmp115);
	       }
	       {
		    fftw_real tmp102;
		    fftw_real tmp104;
		    fftw_real tmp101;
		    fftw_real tmp103;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp102 = X[7 * iostride];
		    tmp104 = Y[-2 * iostride];
		    tmp101 = c_re(W[6]);
		    tmp103 = c_im(W[6]);
		    tmp105 = (tmp101 * tmp102) - (tmp103 * tmp104);
		    tmp162 = (tmp103 * tmp102) + (tmp101 * tmp104);
	       }
	       {
		    fftw_real tmp108;
		    fftw_real tmp110;
		    fftw_real tmp107;
		    fftw_real tmp109;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp108 = X[8 * iostride];
		    tmp110 = Y[-iostride];
		    tmp107 = c_re(W[7]);
		    tmp109 = c_im(W[7]);
		    tmp111 = (tmp107 * tmp108) - (tmp109 * tmp110);
		    tmp164 = (tmp109 * tmp108) + (tmp107 * tmp110);
	       }
	       tmp106 = tmp100 - tmp105;
	       tmp117 = tmp111 - tmp116;
	       tmp118 = tmp106 + tmp117;
	       tmp144 = tmp100 + tmp105;
	       tmp145 = tmp111 + tmp116;
	       tmp146 = tmp144 + tmp145;
	       tmp163 = tmp161 + tmp162;
	       tmp166 = tmp164 + tmp165;
	       tmp183 = tmp163 + tmp166;
	       tmp174 = tmp161 - tmp162;
	       tmp175 = tmp164 - tmp165;
	       tmp197 = tmp174 + tmp175;
	  }
	  {
	       fftw_real tmp171;
	       fftw_real tmp142;
	       fftw_real tmp172;
	       fftw_real tmp180;
	       fftw_real tmp182;
	       fftw_real tmp176;
	       fftw_real tmp179;
	       fftw_real tmp181;
	       fftw_real tmp173;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp171 = K559016994 * (tmp118 - tmp141);
	       tmp142 = tmp118 + tmp141;
	       tmp172 = tmp95 - (K250000000 * tmp142);
	       tmp176 = tmp174 - tmp175;
	       tmp179 = tmp177 - tmp178;
	       tmp180 = (K951056516 * tmp176) + (K587785252 * tmp179);
	       tmp182 = (K951056516 * tmp179) - (K587785252 * tmp176);
	       Y[-5 * iostride] = tmp95 + tmp142;
	       tmp181 = tmp172 - tmp171;
	       Y[-7 * iostride] = tmp181 - tmp182;
	       X[3 * iostride] = tmp181 + tmp182;
	       tmp173 = tmp171 + tmp172;
	       Y[-9 * iostride] = tmp173 - tmp180;
	       X[iostride] = tmp173 + tmp180;
	  }
	  {
	       fftw_real tmp204;
	       fftw_real tmp199;
	       fftw_real tmp205;
	       fftw_real tmp203;
	       fftw_real tmp207;
	       fftw_real tmp201;
	       fftw_real tmp202;
	       fftw_real tmp208;
	       fftw_real tmp206;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp204 = K559016994 * (tmp197 - tmp198);
	       tmp199 = tmp197 + tmp198;
	       tmp205 = tmp200 - (K250000000 * tmp199);
	       tmp201 = tmp106 - tmp117;
	       tmp202 = tmp129 - tmp140;
	       tmp203 = (K951056516 * tmp201) + (K587785252 * tmp202);
	       tmp207 = (K587785252 * tmp201) - (K951056516 * tmp202);
	       X[5 * iostride] = -(tmp199 + tmp200);
	       tmp208 = tmp205 - tmp204;
	       X[7 * iostride] = tmp207 - tmp208;
	       Y[-3 * iostride] = tmp207 + tmp208;
	       tmp206 = tmp204 + tmp205;
	       X[9 * iostride] = -(tmp203 + tmp206);
	       Y[-iostride] = tmp206 - tmp203;
	  }
	  {
	       fftw_real tmp152;
	       fftw_real tmp150;
	       fftw_real tmp151;
	       fftw_real tmp168;
	       fftw_real tmp170;
	       fftw_real tmp160;
	       fftw_real tmp167;
	       fftw_real tmp169;
	       fftw_real tmp153;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp152 = K559016994 * (tmp146 - tmp149);
	       tmp150 = tmp146 + tmp149;
	       tmp151 = tmp143 - (K250000000 * tmp150);
	       tmp160 = tmp156 - tmp159;
	       tmp167 = tmp163 - tmp166;
	       tmp168 = (K951056516 * tmp160) - (K587785252 * tmp167);
	       tmp170 = (K951056516 * tmp167) + (K587785252 * tmp160);
	       X[0] = tmp143 + tmp150;
	       tmp169 = tmp152 + tmp151;
	       X[4 * iostride] = tmp169 - tmp170;
	       Y[-6 * iostride] = tmp169 + tmp170;
	       tmp153 = tmp151 - tmp152;
	       X[2 * iostride] = tmp153 - tmp168;
	       Y[-8 * iostride] = tmp153 + tmp168;
	  }
	  {
	       fftw_real tmp190;
	       fftw_real tmp185;
	       fftw_real tmp189;
	       fftw_real tmp194;
	       fftw_real tmp196;
	       fftw_real tmp192;
	       fftw_real tmp193;
	       fftw_real tmp195;
	       fftw_real tmp191;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp190 = K559016994 * (tmp183 - tmp184);
	       tmp185 = tmp183 + tmp184;
	       tmp189 = tmp188 - (K250000000 * tmp185);
	       tmp192 = tmp147 - tmp148;
	       tmp193 = tmp144 - tmp145;
	       tmp194 = (K951056516 * tmp192) - (K587785252 * tmp193);
	       tmp196 = (K951056516 * tmp193) + (K587785252 * tmp192);
	       Y[0] = tmp185 + tmp188;
	       tmp195 = tmp190 + tmp189;
	       X[6 * iostride] = -(tmp195 - tmp196);
	       Y[-4 * iostride] = tmp196 + tmp195;
	       tmp191 = tmp189 - tmp190;
	       X[8 * iostride] = -(tmp191 - tmp194);
	       Y[-2 * iostride] = tmp194 + tmp191;
	  }
     }
     if (i == m) {
	  fftw_real tmp1;
	  fftw_real tmp4;
	  fftw_real tmp5;
	  fftw_real tmp39;
	  fftw_real tmp76;
	  fftw_real tmp77;
	  fftw_real tmp27;
	  fftw_real tmp34;
	  fftw_real tmp35;
	  fftw_real tmp82;
	  fftw_real tmp81;
	  fftw_real tmp55;
	  fftw_real tmp60;
	  fftw_real tmp61;
	  fftw_real tmp70;
	  fftw_real tmp71;
	  fftw_real tmp44;
	  fftw_real tmp49;
	  fftw_real tmp50;
	  fftw_real tmp74;
	  fftw_real tmp73;
	  fftw_real tmp12;
	  fftw_real tmp19;
	  fftw_real tmp20;
	  fftw_real tmp3;
	  fftw_real tmp2;
	  fftw_real tmp38;
	  ASSERT_ALIGNED_DOUBLE();
	  tmp1 = X[0];
	  tmp3 = X[5 * iostride];
	  tmp2 = c_re(W[4]);
	  tmp4 = tmp2 * tmp3;
	  tmp5 = tmp1 + tmp4;
	  tmp38 = c_im(W[4]);
	  tmp39 = tmp38 * tmp3;
	  {
	       fftw_real tmp23;
	       fftw_real tmp52;
	       fftw_real tmp33;
	       fftw_real tmp59;
	       fftw_real tmp26;
	       fftw_real tmp54;
	       fftw_real tmp30;
	       fftw_real tmp57;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp22;
		    fftw_real tmp21;
		    fftw_real tmp51;
		    fftw_real tmp32;
		    fftw_real tmp31;
		    fftw_real tmp58;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp22 = X[4 * iostride];
		    tmp21 = c_re(W[3]);
		    tmp23 = tmp21 * tmp22;
		    tmp51 = c_im(W[3]);
		    tmp52 = tmp51 * tmp22;
		    tmp32 = X[iostride];
		    tmp31 = c_re(W[0]);
		    tmp33 = tmp31 * tmp32;
		    tmp58 = c_im(W[0]);
		    tmp59 = tmp58 * tmp32;
	       }
	       {
		    fftw_real tmp25;
		    fftw_real tmp24;
		    fftw_real tmp53;
		    fftw_real tmp29;
		    fftw_real tmp28;
		    fftw_real tmp56;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp25 = X[9 * iostride];
		    tmp24 = c_re(W[8]);
		    tmp26 = tmp24 * tmp25;
		    tmp53 = c_im(W[8]);
		    tmp54 = tmp53 * tmp25;
		    tmp29 = X[6 * iostride];
		    tmp28 = c_re(W[5]);
		    tmp30 = tmp28 * tmp29;
		    tmp56 = c_im(W[5]);
		    tmp57 = tmp56 * tmp29;
	       }
	       tmp76 = tmp23 - tmp26;
	       tmp77 = tmp30 - tmp33;
	       tmp27 = tmp23 + tmp26;
	       tmp34 = tmp30 + tmp33;
	       tmp35 = tmp27 + tmp34;
	       tmp82 = tmp57 - tmp59;
	       tmp81 = tmp52 - tmp54;
	       tmp55 = tmp52 + tmp54;
	       tmp60 = tmp57 + tmp59;
	       tmp61 = tmp55 + tmp60;
	  }
	  {
	       fftw_real tmp8;
	       fftw_real tmp41;
	       fftw_real tmp18;
	       fftw_real tmp48;
	       fftw_real tmp11;
	       fftw_real tmp43;
	       fftw_real tmp15;
	       fftw_real tmp46;
	       ASSERT_ALIGNED_DOUBLE();
	       {
		    fftw_real tmp7;
		    fftw_real tmp6;
		    fftw_real tmp40;
		    fftw_real tmp17;
		    fftw_real tmp16;
		    fftw_real tmp47;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp7 = X[2 * iostride];
		    tmp6 = c_re(W[1]);
		    tmp8 = tmp6 * tmp7;
		    tmp40 = c_im(W[1]);
		    tmp41 = tmp40 * tmp7;
		    tmp17 = X[3 * iostride];
		    tmp16 = c_re(W[2]);
		    tmp18 = tmp16 * tmp17;
		    tmp47 = c_im(W[2]);
		    tmp48 = tmp47 * tmp17;
	       }
	       {
		    fftw_real tmp10;
		    fftw_real tmp9;
		    fftw_real tmp42;
		    fftw_real tmp14;
		    fftw_real tmp13;
		    fftw_real tmp45;
		    ASSERT_ALIGNED_DOUBLE();
		    tmp10 = X[7 * iostride];
		    tmp9 = c_re(W[6]);
		    tmp11 = tmp9 * tmp10;
		    tmp42 = c_im(W[6]);
		    tmp43 = tmp42 * tmp10;
		    tmp14 = X[8 * iostride];
		    tmp13 = c_re(W[7]);
		    tmp15 = tmp13 * tmp14;
		    tmp45 = c_im(W[7]);
		    tmp46 = tmp45 * tmp14;
	       }
	       tmp70 = tmp41 - tmp43;
	       tmp71 = tmp46 - tmp48;
	       tmp44 = tmp41 + tmp43;
	       tmp49 = tmp46 + tmp48;
	       tmp50 = tmp44 + tmp49;
	       tmp74 = tmp15 - tmp18;
	       tmp73 = tmp8 - tmp11;
	       tmp12 = tmp8 + tmp11;
	       tmp19 = tmp15 + tmp18;
	       tmp20 = tmp12 + tmp19;
	  }
	  {
	       fftw_real tmp66;
	       fftw_real tmp69;
	       fftw_real tmp68;
	       fftw_real tmp36;
	       fftw_real tmp67;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp66 = tmp44 - tmp49;
	       tmp69 = K559016994 * (tmp20 - tmp35);
	       tmp68 = tmp55 - tmp60;
	       tmp36 = tmp20 + tmp35;
	       tmp67 = tmp5 - (K250000000 * tmp36);
	       X[0] = tmp5 + tmp36;
	       X[4 * iostride] = tmp69 + tmp67 - (K587785252 * tmp68) - (K951056516 * tmp66);
	       X[2 * iostride] = (K587785252 * tmp66) + tmp67 - (K951056516 * tmp68) - tmp69;
	  }
	  {
	       fftw_real tmp87;
	       fftw_real tmp88;
	       fftw_real tmp84;
	       fftw_real tmp85;
	       fftw_real tmp86;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp87 = tmp76 - tmp77;
	       tmp88 = tmp73 - tmp74;
	       tmp84 = tmp70 + tmp71;
	       tmp85 = tmp81 + tmp82;
	       tmp86 = K559016994 * (tmp84 - tmp85);
	       Y[-iostride] = tmp86 - (tmp39 + (K250000000 * (tmp84 + tmp85))) - (K587785252 * tmp87) - (K951056516 * tmp88);
	       Y[-3 * iostride] = (K587785252 * tmp88) - (tmp39 + (K250000000 * (tmp84 + tmp85))) - tmp86 - (K951056516 * tmp87);
	  }
	  {
	       fftw_real tmp37;
	       fftw_real tmp65;
	       fftw_real tmp64;
	       fftw_real tmp62;
	       fftw_real tmp63;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp37 = tmp27 - tmp34;
	       tmp65 = tmp12 - tmp19;
	       tmp64 = K559016994 * (tmp50 - tmp61);
	       tmp62 = tmp50 + tmp61;
	       tmp63 = tmp39 - (K250000000 * tmp62);
	       Y[0] = tmp39 + tmp62;
	       Y[-4 * iostride] = (K951056516 * tmp65) + (K587785252 * tmp37) + tmp64 + tmp63;
	       Y[-2 * iostride] = (K951056516 * tmp37) + tmp63 - tmp64 - (K587785252 * tmp65);
	  }
	  {
	       fftw_real tmp72;
	       fftw_real tmp83;
	       fftw_real tmp80;
	       fftw_real tmp79;
	       fftw_real tmp75;
	       fftw_real tmp78;
	       ASSERT_ALIGNED_DOUBLE();
	       tmp72 = tmp70 - tmp71;
	       tmp83 = tmp81 - tmp82;
	       tmp75 = tmp73 + tmp74;
	       tmp78 = tmp76 + tmp77;
	       tmp80 = K559016994 * (tmp75 - tmp78);
	       tmp79 = tmp1 - (K250000000 * (tmp75 + tmp78)) - tmp4;
	       X[iostride] = (K951056516 * tmp72) + tmp79 + tmp80 + (K587785252 * tmp83);
	       X[3 * iostride] = tmp79 + (K951056516 * tmp83) - tmp80 - (K587785252 * tmp72);
	  }
     }
}

static const int twiddle_order[] =
{1, 2, 3, 4, 5, 6, 7, 8, 9};
fftw_codelet_desc fftw_hc2hc_forward_10_desc =
{
     "fftw_hc2hc_forward_10",
     (void (*)()) fftw_hc2hc_forward_10,
     10,
     FFTW_FORWARD,
     FFTW_HC2HC,
     163,
     9,
     twiddle_order,
};
