/* localfunctions.c
 * geg, a GTK+ Equation Grapher
 * David Bryant 1998
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif /* HAVE_CONFIG_H */

#include "localfunctions.h"
#include <math.h>

#ifndef M_PI
#define M_PI 3.14159265358979323846
#endif /* M_PI */

double
l_sinc(double x)
{
  if(x == 0)
    return 1;
  else
    return(sin(M_PI * x) / (M_PI * x));
}

double
l_cbrt(double x)
{
  if(x < 0)
    return(0);
  else
    return(pow(x, (double)1 / 3));
}

double
l_u(double x)
{
  return(x >= 0);
}
