/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#ifndef _GEOMCLASS_SM_
#define _GEOMCLASS_SM_

#define	IsInSM(addr, sm)   ((sm)->sm_base <= (char *)(addr) && \
			     (char *)(addr) < (sm)->sm_base + (sm)->sm_mapped)

#define	GeomRefreshSM(sm)  ((sm)->sm_mapped < ROOTSYM(sm)->s_size ? GeomRemapSM(sm) : (sm)->sm_mapped)

#define	ROOTSYM(sm)	((GeomSMSym *)(sm)->sm_base)

#define	GOffset(sym, type, ptr)  ((type *)(((char *)(ptr)) + \
				   (((char *)(sym)) - (sym)->s_here)))

#define	MAXSM		4	/* Max number of simultaneous shared mem's */

#define	SM_MAGIC  0x4AB3B8B9	/* s_version field for SM root symbol */

#endif _GEOMCLASS_SM_
