/* Copyright (c) 1992 The Geometry Center; University of Minnesota
   1300 South Second Street;  Minneapolis, MN  55454, USA;
   
This file is part of geomview/OOGL. geomview/OOGL is free software;
you can redistribute it and/or modify it only under the terms given in
the file COPYING, which you should have received along with this file.
This and other related software may be obtained via anonymous ftp from
geom.umn.edu; email: software@geom.umn.edu. */

/* Authors: Charlie Gunn, Stuart Levy, Tamara Munzner, Mark Phillips */

#include "discgrpP.h"

DiscGrpElList *
DiscGrpElListDelete (DiscGrpElList *exist)
{
    if (exist)	{
	if (exist->el_list)	OOGLFree(exist->el_list);
	OOGLFree(exist);
	}
    return NULL;
}

DiscGrp *
DiscGrpDelete(dg)
DiscGrp           *dg;
{
	if (dg)
	{
		if (dg->name)
			OOGLFree(dg->name);
		if (dg->comment)
			OOGLFree(dg->comment);
		if (dg->fsa)
			OOGLFree(dg->fsa);
		if (dg->gens) {
			if (dg->gens->el_list)
				OOGLFree(dg->gens->el_list);
			OOGLFree(dg->gens);
			}

		if (dg->nhbr_list) {
			if (dg->nhbr_list->el_list)
				OOGLFree(dg->nhbr_list->el_list);
			OOGLFree(dg->nhbr_list);
			}

		if (dg->big_list) {
			if (dg->big_list->el_list)
				OOGLFree(dg->big_list->el_list);
			OOGLFree(dg->big_list);
			}

		if (dg->geom && dg->geom != dg->ddgeom)
			GeomDelete(dg->geom);

		if (dg->ddgeom) GeomDelete(dg->ddgeom);
	}
	return NULL;
}
