### Force loading of the lme dynamic library in R
### and patch up a few little problems

is.R <- function() { ## returns  'TRUE'  iff we are using 'R'
  exists("version") && !is.null(vl <- version$language) && vl == "R"
}

is.S <- function() !is.R()

coef <- function(x, ...) UseMethod("coef")
fitted <- function(x, ...) UseMethod("fitted")

solve <- function(a, b, ...) UseMethod("solve")
solve.default <- function (a, b, tol = 1e-07) 
{
  if (!is.qr(a)) 
    a <- qr(a, tol = tol)
  nc <- ncol(a$qr)
  if (a$rank != nc) 
    stop("singular matrix 'a' in solve")
  if (missing(b)) {
    if (nc != nrow(a$qr)) 
      stop("only square matrices can be inverted")
    b <- diag(1, nc)
  }
  b <- as.matrix(b)
  return(qr.coef(a, b))
}

formula.default <- function (x) 
{
  if (!is.null(x$formula)) 
    return(eval(x$formula))
  if (!is.null(x$call$formula)) 
    return(eval(x$call$formula))
  if (!is.null(x$terms)) 
    return(x$terms)
  if (!is.null(attr(x, "formula")))
    return(attr(x, "formula"))
  switch(mode(x), NULL = structure(NULL, class = "formula"), 
         character = formula(eval(parse(text = x)[[1]])), 
         call = eval(x), stop("invalid formula"))
}

zapsmall <-
  ## forces small values to 0, for the sake of printing
  function(x, digits = .Options$digits)
{
	x.ok <- x[!is.na(x)]
	if(length(x.ok) == 0)
		return(x)
	m <- max(abs(x.ok))
	if(m > 0)
		digits <- max(digits - log10(m), 0)
	round(x, digits)
}

library.dynam("lme")
provide("lme")
