% $Id: corCompSymm.Rd,v 1.5 1998/04/02 18:53:10 pinheiro Exp $
\name{corCompSymm}
\title{Compound Symmetry Correlation Structure}
\usage{
corCompSymm(value, form)
}
\alias{corCompSymm}
\arguments{
 \item{value}{the correlation between any two correlated
   observations. Defaults to 0.} 
 \item{form}{a one sided formula of the form \code{~ t}, or code{~ t |
     g}, specifying a time covariate \code{t} and,  optionally, a
   grouping factor \code{g}. When a grouping factor is present in
   \code{form}, the correlation structure is assumed to apply only
   to observations within the same grouping level; observations with
   different grouping levels are assumed to be uncorrelated. Defaults to
   \code{~ 1}, which corresponds to using the order of the observations
   in the data as a covariate, and no groups.}  
}
\description{
  This function is a constructor for the \code{corCompSymm} class,
  representing a compound symmetry structure corresponding to uniform
  correlation. Objects created using this constructor need to be later
  initialized using the appropriate \code{initialize} method. 
}
\value{
  an object of class \code{corCompSymm}, representing a compound
  symmetry correlation structure. 
}
\references{
  Milliken, G. A. and Johnson, D. E. (1992) "Analysis of Messy Data,
  Volume I: Designed Experiments", Van Nostrand Reinhold.
}
\author{Jose Pinheiro and Douglas Bates}
\seealso{\code{\link{initialize.corStruct}}}
\examples{
library(lme)
## covariate is observation order and grouping factor is Subject
cs1 <- corCompSymm(0.5, form = ~ 1 | Subject)
}
\keyword{models}

