\name{load.if.needed}
\title{
dynamically loads an object file if needed
}
\usage{
load.if.needed(file, fun.name, FUN = dyn.load, \dots)
}
\arguments{
\item{file}{
name of an object file. This is the name of a .o file as produced
by Fortran or C.
}
\item{fun.name}{
optionally the name of the function that needs the file.
Default is the function calling \code{load.if.needed}.
}
\item{FUN}{
function to actually dynamically load \code{file}. By default
the function \code{dyn.load()} is used.
}
\item{...}{
any arguments to \code{FUN}.
}}
\value{
The output of \code{FUN} (by default \code{dyn.load}) i.e., a character vector 
of symbols in file (C function names or Fortran subroutine names).


\code{load.if.needed} ensures that \code{FUN} is invoked only once;
it assumes that the object file resides in the parent directory
where the calling function is stored; for instance if \code{fast.stats}
is in \code{/usr/dj/s/.Data} and it calls \code{load.if.needed("cmpstats.o")}
then the file \code{/usr/dj/s/cmpstats.o} is dynamically loaded once.


}
\examples{
fast.stats <- function(x, y, by)
{
	load.if.needed("cmpstats.o")
	out <- .C("by_int",
                x = as.double(x),
                y = as.double(y),
                by = as.integer(by))
	return(out)
}
}
\seealso{
dyn.load 
}
% Converted by Sd2Rd version 0.2-a3.
