\name{as.function.polynomial}
\title{Method Function to Coerce a Polynomial
to a Function}
\usage{
as.function(p)
}
\arguments{
\item{p}{An object of class polynomial}
}
\description{
Takes a polynomial argument and constructs an S function to evaluate it
at arbitrary abscissae, x.

The polynomial is evaluated within the function using the Horner scheme.
If the argument x is a polynomial also, then a polynomial substitution
is done and the result is a polynomial.
}
\value{
A function to evaluate it.
}
\seealso{
make.expression.polynomial, poly.value
}
\examples{
pr <- (poly.from.zeros(-1:1) - 2 * polynomial(c(1,2,1)))^2
pr
## 4 + 20*x + 33*x^2 + 16*x^3 - 6*x^4 - 4*x^5 + x^6 
prf <- as.function(pr)
prf
## function(x, nam = as.character(x))
## {
##     val <- 4 + x * (20 + x * (33 + x * (16 + x * (-6 + 
##         x * (-4 + x * (1))))))
##     if(!inherits(val, "polynomial"))
##         names(val) <- nam
##     val
## }
prf(-3:3)
##    -3 -2 -1 0  1   2  3 
##  1024 64  0 4 64 144 64
}
