"codamenu" <-
function () 
{
        #
        # codamenu -- main menu driver for CODA system
        #
        # Original author: Kate Cowles (University of Nebraska Medical Centre, USA)
        # Modified by: Nicky Best (MRC Biostatistics Unit, Cambridge, UK)
        # Additional contributions: Karen Vines (MRC Biostatistics Unit, Cambridge, UK)
        # R support: Martyn Plummer (IARC, France)
        # 
        # Date of last update: 9/3/98
        #
        options(object.size = 1e+09)
        on.exit(tidy.up())
        file.menu <- c("Begin a new CODA session using BUGS output files", 
                "Begin a new CODA session using data saved from a previous CODA session", 
                "Quit")
        coda.credits()
	cat("CODA startup menu\n\n")
        pick <- menu(file.menu)
        if (pick == 0 || pick == 3) 
		return(invisible())
	else if (pick == 1)
		coda.dat <<- read.bugs.interactive()
	else if (pick == 2) {
                msg <- "\nEnter name of R data object saved from a previous CODA session:\n"
                while (T) {
                        cat(msg, "\n")
                        outname <- scan(what = character(), sep = "\n", 
                                nmax = 1, strip.white = T)
                        if (length(outname) == 0) 
                                msg <- "You must enter something"
                        else if (outname == "0") {
                                return()
                        }
                        else if (!exists(outname)) 
                                msg <- "Can\'t find this object"
                        else if (!is.mcmc(eval(parse(text = outname)))) 
                                msg <- "Not an mcmc object"
                        else {
                                coda.dat <<- eval(parse(text = outname))
                                break
                        }
                        msg <- paste(msg, "Please re-enter another name or type 0 to quit:\n", 
                                sep = "\n")
		}
        }
	else stop("Invalid option")
	#
	# Create working data (Isn't this a bit wasteful? This could be the third copy of the
	# data in the workspace... MTP)
	#
	work.dat <<- coda.dat
	#
        # Enter menu loop.
        #
        current.menu <- "codamenu.main"
        repeat {
                next.menu <- do.call(current.menu, NULL)
                if (next.menu == "quit") {
                        cat("Are you sure you want to quit? (y/N)\n")
                        if (any(readline() == c("y", "Y"))) 
                                break
                }
                else current.menu <- next.menu
        }
        invisible()
}
