"codamenu.options.geweke.win" <-
function (next.menu) 
{
        msg1 <- "Enter fraction of chain to include in 1st window of \nGeweke's diagnostic:"
        msg2 <- "Enter fraction of chain to include in 2nd window of \nGeweke's diagnostic:"
        ans1 <- ans2 <- 1
        while (ans1 + ans2 >= 1) {
                ans1 <- read.and.check(msg1, lower = 0, upper = 1, 
                        default = coda.options("frac1"))
                ans2 <- read.and.check(msg2, lower = 0, upper = 1, 
                        default = coda.options("frac2"))
                # Check that sum of fractions doesn't exceed 1.0
                msg1 <- if (ans1 + ans2 == 1) 
                        "Error: Sum of fractions in 1st and 2nd windows equals 1.0\nYou must leave a gap in the chain between the 2 windows\nPlease re-enter fraction of chain to include in 1st window:"
                else "Error: Sum of fractions in 1st and 2nd windows exceeds 1.0\nPlease re-enter fraction of chain to include in 1st window:"
                msg2 <- "Now re-enter fraction of chain to include in 2nd window:"
        }
        coda.options(frac1 = ans1, frac2 = ans2)
        return(next.menu)
}
