"codamenu.options.plot" <-
function () 
{
        next.menu <- "codamenu.options.plot"
        choices <- c("Show current plotting options", "Plot trace of samples", 
                "Plot kernel density estimate", "Add smooth line through trace plot", 
                "Separate plots per chain", "Separate page of plots per variable", 
                "Specify page layout for plots", "Select bandwidth function for kernel smoothing", 
                "Options for saving plots to postscript file", 
                "Return to main options menu")
        cat("\nCODA Plotting Options Menu\n***************************\n")
        #
        pick <- menu(choices)
        # Scientific notation  
        #
        if (pick == 0) 
                return("quit")
        switch(pick, print.coda.options(plots = T), change.tfoption(choices[2], 
                "trace"), change.tfoption(choices[3], "densplot"), 
                change.tfoption(choices[4], "lowess"), change.tfoption(choices[5], 
                        "sepplot"), change.tfoption(choices[6], 
                        "onepage"), {
                        change.tfoption("Do you want to specify your own page layout for the plots", 
                                "user.layout")
                        if (coda.options("user.layout")) {
                                mrows <- read.and.check("Enter number of rows of plots per page (maximum=7)", 
                                 lower = 1, upper = 7)
                                mcols <- read.and.check("Enter number of columns of plots per page (maximum=8)", 
                                 lower = 1, upper = 8)
                                coda.options(mrows = mrows)
                                coda.options(mcols = mcols)
                                par(mfrow = c(mrows, mcols))
                        }
                }, {
                        next.menu <- "codamenu.options.plot.kernel"
                }, {
                        next.menu <- "codamenu.options.plot.ps"
                }, NULL)
        if (pick == length(choices)) 
                next.menu <- "codamenu.options"
        return(next.menu)
}
