"densplot" <-
function (x, combine.chains = F, bwf) 
{
        x <- as.mcmc(x)
        do.densplot <- function(j, i) {
                #NB Using R scoping rules
                #
                if (missing(i)) 
                        y <- as.vector(x[, j, , drop = T])
                else y <- as.vector(x[, j, i, drop = T])
                y.orig <- y
                if (missing(bwf)) {
                        N <- length(!is.na(y))
                        bw <- 1.06 * min(sd(y), IQR(y)/1.34) * 
                                N^-0.2
                }
                else {
                        bw <- bwf(y)
                        if (bw == 0) 
                                bw <- 0.1
                }
                if (max(y) <= 1 && 1 - max(y) < 2 * bw) {
                        if (min(y) >= 0 && min(y) < 2 * bw) {
                                scale <- "proportion"
                                y <- c(y, -y, 2 - y)
                        }
                }
                else if (min(y) >= 0 && min(y) < 2 * bw) {
                        scale <- "positive"
                        y <- c(y, -y)
                }
                else scale <- "open"
                dens <- density(y, bw = bw)
                if (scale == "proportion") {
                        dens$y[dens$x >= 0 & dens$x <= 1] <- 3 * 
                                dens$y[dens$x >= 0 & dens$x <= 
                                 1]
                        dens$y[dens$x < 0] <- 0
                        dens$y[dens$x > 1] <- 0
                        dens$x[dens$x < 0] <- 0
                        dens$x[dens$x > 1] <- 1
                }
                else if (scale == "positive") {
                        dens$y[dens$x >= 0] <- 2 * dens$y[dens$x >= 
                                0]
                        dens$y[dens$x < 0] <- 0
                        dens$x[dens$x < 0] <- 0
                }
                plot(dens, xlab = varnames(x)[j], ylab = "")
                points(y.orig, rep(0, length(y.orig)))
        }
        if (combine.chains) 
                for (j in 1:nvar(x)) {
                        do.densplot(j)
                        mtext(paste("Density of", varnames(x)[j]), 
                                side = 3, line = 2.5)
                        mtext(paste("(", format(niter(x)), " values per trace)", 
                                sep = ""), side = 3, line = 0.65)
                }
        else for (i in 1:nchain(x)) {
                for (j in 1:nvar(x)) {
                        do.densplot(j, i)
                        mtext(paste("Density from", chanames(x)[i]), 
                                side = 3, line = 2.5)
                        mtext(paste("(", format(niter(x)), " values per trace)", 
                                sep = ""), side = 3, line = 0.65)
                }
        }
        return()
}
