"heidel.diag" <-
function (x, eps = 0.1) 
{
        # 
        # Heidelberger and Welch diagnostic 
        # 
        # Author: Kate Cowles 
        # Modified by: Nicky Best 
        # 
        HW.list <- vector("list", nchain(x))
        names(HW.list) <- chanames(x)
        HW.mat0 <- matrix(0, ncol = 7, nrow = nvar(x))
        dimnames(HW.mat0) <- list(varnames(x), c("stest", "keep", 
                "discard", "C-vonM", "htest", "mean", "halfwidth"))
        for (i in 1:nchain(x)) {
                HW.mat <- HW.mat0
                for (j in 1:nvar(x)) {
                        Y <- x[, j, i, drop = T]
                        n1 <- length(Y)
                        n <- length(Y)
                        S0 <- geweke.power(Y[(n/2 + 1):n])
                        passed <- F
                        while (n >= n1/2 && !passed) {
                                T1 <- cumsum(Y)
                                ybar <- mean(Y)
                                B <- T1 - ybar * (1:n)
                                Bsq <- (B * B)/(n * S0)
                                I <- (2 * sum(Bsq[seq(2, n - 
                                 2, by = 2)]) + 4 * sum(Bsq[seq(1, 
                                 n - 1, by = 2)]) + Bsq[n])/(3 * 
                                 n)
                                passed <- !is.na(I) & I < 0.46
                                if (!passed) {
                                 Y <- Y[(n1/10 + 1):n]
                                 n <- length(Y)
                                }
                        }
                        S0ci <- geweke.power(Y)
                        halfwidth <- 1.96 * sqrt(S0ci/n)
                        passed2 <- (!is.na(halfwidth) & abs(halfwidth/ybar) <= 
                                eps)
                        if (is.na(I) | is.na(halfwidth) | !passed) {
                                n <- NA
                                nd <- NA
                                passed2 <- NA
                                ybar <- NA
                                halfwidth <- NA
                        }
                        else {
                                nd <- length(x[, j, i, drop = T]) - 
                                 n
                        }
                        HW.mat[j, ] <- c(passed, n * thin(x), 
                                nd * thin(x), I, passed2, ybar, 
                                halfwidth)
                }
                HW.list[[i]] <- HW.mat
        }
        class(HW.list) <- "heidel.diag"
        return(HW.list)
}
