"tidy.up" <-
function () 
{
        # 
        # tidy.up -- gives option to save input files in S format; then deletes all  
        #	     S-plus objects created during current CODA session, and 
        #	     closes all graphics windows 
        # 
        # Author: Nicky Best 
        # 
        cat("\nQuitting CODA....\n")
        if (exists("coda.dat", where = 1)) {
                while (T) {
                        cat("\nDo you want to save the BUGS output as an R object file(y/n) ?\n")
                        ans <- scan(what = character(), nmax = 1, 
                                strip.white = T)
                        if (length(ans) > 0) 
                                break
                }
                if (ans == "Y" | ans == "y") {
                        cat("Enter name you want to call this object file:\n")
                        fname <- scan(what = character(), nmax = 1, 
                                strip.white = T)
                        assign(fname, coda.dat, envir = sys.frame(0))
                }
        }
        coda.objects <- c("coda.dat", "work.dat")
        if (!is.null(Version()$language) && Version()$language == 
                "R") 
                for (i in coda.objects) {
                        if (exists(i)) 
                                rm(list = i, inherits = TRUE)
                }
        else if (is.null(Version()$language)) {
                for (i in coda.objects) {
                        if (exists(i)) 
                                remove(i, where = 1)
                }
                graphics.off()
        }
        else error("language not recognized")
        cat("Have a BUGS-free day!\n")
}
