#include "myheader.h"
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <sys/stat.h>
#include <dirent.h>
#include <sys/mman.h>
#include <sys/types.h>
#include <fcntl.h>

#define NAME_SIZE 50
#define SYMBOL_SIZE 25

/*******************************************************************************************/
int main (int argc, char *argv[])
{
	char tstring[250], tstring2[250], *gs_home, datapath[250];
	struct dirent **dirlist;
	int tint, tint2, tint3, moving, moving2, moving3, data_size, header_size;
	unsigned int tuint;
	float volumeroc, closeroc, threshold;
   	FILE *infile, *outfile;
	struct record2 header;
	struct record1 data;
	
	
	
	
	printf("\nThis utility converts version 1.0.6 or greater chart files to the most recent version.\n");
	printf("Do you want to continue? (y/n)\n");
	tint = tolower(fgetc(stdin));
	if (tint != 'y')
		return 0;
	
	data_size = sizeof(struct record1);
	header_size = sizeof(struct record2);
   	
   	gs_home = getenv ("HOME");
        if (gs_home != NULL)
        {
           	strcpy (datapath, gs_home);
           	strcat(datapath, "/gstalker/data/");
        }
        else
        {
        	printf("Cant get HOME environment.\n");
        	return 1;
        }
	
	printf("Converting files...\n");
	
	tint = scandir(datapath, &dirlist, NULL, alphasort);
	if (tint < 2)
    		return 0;
	tint2 = tint;
	for (tint = 2; tint < tint2; tint++)
	{
		strcpy(tstring, datapath);
		strcat(tstring, dirlist[tint]->d_name); 
   		infile = fopen(tstring, "rb");
   		if (infile)
   		{
   			strcpy(tstring2, datapath);
   			strcat(tstring2, "temp.dat");
   			outfile = fopen(tstring2, "wb");
   			if (outfile)
   			{
   				fread(&tuint, sizeof(unsigned int), 1, infile);
   				if ((tuint > 106) && (tuint < 108))
   				{
   					fclose(outfile);
   					fclose(infile);
   					break;
   				}
   				fseek(infile, 0L, SEEK_SET);
   				fread(&header.name, NAME_SIZE, 1, infile);
				fread(&header.symbol, SYMBOL_SIZE, 1, infile);
				fread(&header.records, sizeof(int), 1, infile);
				fread(&header.styleflag, sizeof(int), 1, infile);
				fread(&header.pixelspace, sizeof(int), 1, infile);
				fread(&header.volume, sizeof(int), 1, infile);
				fread(&moving, sizeof(int), 1, infile);
				fread(&moving2, sizeof(int), 1, infile);
				fread(&moving3, sizeof(int), 1, infile);
				fread(&volumeroc, sizeof(float), 1, infile);
				fread(&closeroc, sizeof(float), 1, infile);
				fread(&threshold, sizeof(float), 1, infile);
				
				header.version = FILE_VERSION;
				if (moving > 0)
				{
					header.moving[0] = 1;
					header.moving[1] = 1;
					header.moving[2] = moving;
				}
				else
				{
					header.moving[0] = 0;
					header.moving[1] = 1;
					header.moving[2] = 10;
				}
				if (moving2 > 0)
				{
					header.moving2[0] = 1;
					header.moving2[1] = 1;
					header.moving2[2] = moving2;
				}
				else
				{
					header.moving2[0] = 0;
					header.moving2[1] = 1;
					header.moving2[2] = 10;
				}
   				if (moving3 > 0)
				{
					header.moving3[0] = 1;
					header.moving3[1] = 1;
					header.moving3[2] = moving3;
				}
				else
				{
					header.moving3[0] = 0;
					header.moving3[1] = 1;
					header.moving3[2] = 10;
				}
   				if (volumeroc)
   				{
   					header.volumeroc_status = 1;
   					header.volumeroc = volumeroc;
   				}
   				else
   				{
   					header.volumeroc_status = 0;
   					header.volumeroc = 0;
   				}
   				if (closeroc)
   				{
   					header.closeroc_status = 1;
   					header.closeroc = closeroc;
   				}
   				else
   				{
   					header.closeroc_status = 0;
   					header.closeroc = 0;
   				}
				if (threshold)
   				{
   					header.threshold_status = 1;
   					header.threshold = threshold;
   				}
   				else
   				{
   					header.threshold_status = 0;
   					header.threshold = 0;
   				}
   				header.ma_alert = 0;
   				header.ma2_alert = 0;
   				header.ma3_alert = 0;
   				header.first_date = 99999999;
   				header.last_date = 0;
   				fwrite(&header, header_size, 1, outfile);
   				for (tint3 = 0; tint3 < header.records; tint3++)
   				{
   					fread(&data.date, sizeof(unsigned long), 1, infile);
					fread(&data.open, sizeof(float), 1, infile);
					fread(&data.high, sizeof(float), 1, infile);
					fread(&data.low, sizeof(float), 1, infile);
					fread(&data.close, sizeof(float), 1, infile);
					fread(&data.volume, sizeof(unsigned long), 1, infile);
					fread(&data.openint, sizeof(unsigned long), 1, infile);
					if (data.date < header.first_date)
						header.first_date = data.date;
					if (data.date > header.last_date)
						header.last_date = data.date;
					fwrite(&data, data_size, 1, outfile);
   				}
   				fclose(infile);
   				fseek(outfile, 0L, SEEK_SET);
   				fwrite(&header, header_size, 1, outfile);
   				fclose(outfile);
   				unlink(tstring);
   				rename(tstring2, tstring);
			}
		}
   	}
   	printf("Done.\n");
   	unlink(tstring2);
	return 0;
}