/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * check_job.c,v 3.2 1998/03/19 14:21:33 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"


void check_job_end()
{
	int fftries = 0;
	int timeout = 30;
	int n, err, diff;
	char buf[MAXLINE+1];
	int i;
	long start_time, end_time;

	log(2,"Checking printer for job end");

	/*
	 * the printer may be tied up doing postscript or offline;
	 * it is also possible that somebody turned the printer off;
	 * Looking for the end of job string may not work if
	 * somebody screwed up by sending a bad PJL language print job
	 * We look for idle printer OR echo job string;  in fact we may not
	 * get either of these if somebody sent a bad 'change personality'
	 * command to the printer.  I suspect that by clever use of
	 * embedded printer job language commands in a file somebody could
	 * appear to have terminated their job while in actual fact it
	 * was still printing.
	 * we try to end the job when the printer is idle
	 */

	i = 0;
	query[i++]= UEL;
	query[i++]= UELPJL ;
	plp_snprintf(buf,sizeof(buf)-1,"@PJL EOJ %s\r\n", job_end);
	query[i++] = buf;
	if( true_eoj ) query[i++]= TRUEEOJ;
	query[i]= 0;
	do{
		pr_query(STDOUT, i);
		if( timeout > 300 ){
			timeout = 300;
		}
		start_time = time( (void *)0 );
		do{
			err = readpipe(&n,timeout);
			if( err < 0 ){
				log(2, "EOF reading from printer");
				fexit(FILTABORT);
			}
			end_time = time( (void *)0 );
			diff = end_time - start_time;
		} while( !job_ended && diff < timeout );
		log(4, "check_job_end: fftries=%d, code %d, job_ended %d",
			++fftries, n, job_ended );
		timeout += timeout; /* double it each time */
	} while( !job_ended );
}
