/**************************************************************************
 * LPRng IFHP Filter
 * Copyright 1994-1997 Patrick Powell, San Diego, CA <papowell@astart.com>
 *
 * Based on the CTI printer filters.
 *  See COPYRIGHT for details.
 *
 * sendjob.c,v 3.2 1998/03/19 14:21:38 papowell Exp
 */

#include "portable.h"
#include "common.h"
#include "hp4.h"

/*
 * send job to the remote printer
 */

void sendjob(fd, sockfd)
int    fd;
int    sockfd;
{
	int 	rdcnt;
	int i;
	char *s, *ps;
	int discard = 0;

	/* read an input line */
	log(9,"sendjob: reading input");
	/* set up the options using PJL.
     * Note: you may need to do this again in PCL or PostScript
	 */
	if( (rdcnt=file_readline(fd,sendline,sizeof(sendline)-1)) > 0){
		log(6,"sendjob: read %d '%s'", rdcnt,sendline);
		/* try to determine which mode you are in */
		if( literal || autodetect ){
			mode = LITERAL;
			job_page_set();
		} else {
			if( (ps = strstr(sendline, "%!" )) ){
				for( s = sendline; ps && s!=ps; ++s ){
					/* we must have a control char string */
					if( !iscntrl(*s) ) ps = 0;
				}
			}
			if( ps && cartridge ){
				mode = POSTSCRIPT ;
				job_page_set();
			} else {
				mode = PCL ;
				job_page_set();
				if( ps ){
					s = UNABLE;
					i = strlen(s);
					writecn(sockfd,s,i);
				}
			}
		}
		log(2,"Transferring file");
		if( !discard && rdcnt != writecn(sockfd, sendline, rdcnt) ){
			logerr_die(2,"Cannot write what read (%d bytes)",rdcnt);
		}
		log(4,"sendjob: wrote first line '%s'", sendline );
		/* now we read the rest of the file */
		if( !discard ){
			while( (rdcnt=read(fd,sendline,sizeof(sendline)-1)) > 0){
				log(4,"sendjob: next line '%s'", sendline );
				if( rdcnt != writecn(sockfd, sendline, rdcnt ) ){
					logerr_die(2,"Cannot write what read (%d bytes)",rdcnt);
				}
			}
		}
    }
	/* read an input line */
	log(2,"Finished transferring file");
}
