/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;

void mserver_dial (char *name)
{
	int i, n;
	int found;
	int retval;

	char temp[1024];
	char cname[1024];
	char script[1024];
	char parsetype[1024];

	fprintf (outsock,"BEGIN\n");
	fflush (outsock);

	found = false;
	config_getvalue("cname", temp, 1024);

	for (i = 0, n = 0; i < strlen(temp); i++, n++)
	{
		if (temp[i] == ',')
		{
			cname[n] = '\0';
			if (!strncmp(cname, name, 1024))
			{
				found = true;	
				break;
			}
			n = -1;
		}
		else
		{
			cname[n] = temp[i];
		}
	}

	cname[n] = '\0';
	if (!strncmp(cname, name, 1024))
		found = true;		

	if (!found)
	{
		fprintf(outsock, "ERROR: Unknown connection!\n");
		fprintf(outsock,"END\n");
		return;
	}

	if (!auth_check(cname))
	{
		fprintf(outsock, "ERROR: You are not authorized to manipulate this connection!!\n");
		fprintf(outsock,"END\n");
		return;
	}

	if (!cfile_write("Connection Pending"))
	{
		fprintf(outsock, "Could not write connection information file!\n");
		fprintf(outsock, "END\n");
		return;
	}

	fprintf(outsock, "Dialing connection: %s\n", cname);
	syslog(LOG_INFO, "Dialing connection: %s\n", cname);
	fflush (outsock);

	snprintf(temp, 1024, "%s_script", cname);
	config_getvalue(temp, script, 1024);
	fprintf(outsock, "Executing: %s\n", script);
	fflush (outsock);

	config_getvalue("parselog", parsetype, 1024);
	if(!strncmp(parsetype, "pppd", 1024))
	{
		if (!parse_pppd_init())
		{
			return;
		}
	}
	else if (!strncmp(parsetype, "none", 1024))
	{
		/* Do nothing */
	}
	else
	{
		syslog(LOG_ERR, "Unknown parselog action: %s", parsetype);
	}

	retval = util_system(script);	

	if (retval != 0)
	{
		syslog (LOG_WARNING, "There was an error while executing %s", script);
		fprintf(outsock, "ERROR:There was an error while executing %s\n", script);
		fprintf(outsock,"END\n");
		return;
	}

	config_getvalue("parselog", parsetype, 1024);
	if(!strncmp(parsetype, "pppd", 1024))
	{
		parse_pppd();
	}
	else if (!strncmp(parsetype, "none", 1024))
	{
		/* Do nothing */
	}
	else
	{
		syslog(LOG_ERR, "Unknown parselog action: %s", parsetype);
	}

	if (getstat())
	{
		cfile_write(cname);
	}
	else
	{
		cfile_unlink();
	}

	fprintf(outsock,"END\n");
	fflush (outsock);
}
