/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <time.h>
#include <syslog.h>

#include "mserver.h"

FILE *insock;
FILE *outsock;

int sfd;
int csfd;

bool demon;
bool inetd;

void main(int argc, char **argv)
{
	FILE *tfile;

	int argp;

	int port;
	
	struct sockaddr_in address;
	struct sockaddr_in caddress;

	int result;
	int len, clen;
	int slimit;

	
	char temp[1024];
	char config_file[1024] = "/etc/mserver.conf";
	
#ifdef DEBUG
	openlog ("mserver", LOG_NDELAY | LOG_PERROR | LOG_PID, LOG_DAEMON);
#else
	openlog ("mserver", LOG_NDELAY | LOG_PID | LOG_PERROR, LOG_DAEMON);
	signal(SIGCHLD, SIG_IGN);
	(void) signal(SIGHUP, config_refresh);
	(void) signal(SIGTERM, mserver_halt);
#endif


	argp = 1;

	while (argc > argp)
	{		
		if (argv[argp][0] == '-')
		{
			switch (argv[argp][1])
			{
			case 'c':
				if (argp < argc)
				{
					strncpy(config_file, argv[++argp], 1024);		
				}
				else
				{
					syslog(LOG_ERR, "Option requires an argument: %s", argv[argp - 1]);
					exit(1);
				}
				break;
			default:
				syslog(LOG_ERR, "Unkown option: %s", argv[argp]);
				exit(1);
			}
		}	
		else
		{
			syslog(LOG_ERR, "Unkown option: %s", argv[argp]);
			exit(1);
		}
		argp++;	
	}

	if (!config_init(config_file))
	{
		syslog(LOG_ERR, "Could not open configuration file: %s", config_file);
		exit(1);
	}

	inetd = config_getvalue_bool ("inetd", false);

	if (inetd)
	{
		int continue_client;

		closelog();
		openlog ("mserver", LOG_NDELAY | LOG_PID, LOG_DAEMON);


		syslog (LOG_DEBUG, "Using inetd!\n");

		insock = stdin;
		outsock = stdout;

		continue_client = true;
	
		while(continue_client == true)
		{	
			mserver_serve();
		}

		exit(0);
	}
	else
	{
		config_getvalue ("confile", temp, 1024);	
		unlink(temp);

#ifdef DEBUG
		port = config_getvalue_int ("debugport");
#else
		port = config_getvalue_int ("port");
#endif

		slimit = config_getvalue_int ("slimit");

		if (port == 0)
		{
			syslog(LOG_ERR, "You must enter a port other than zero.");
			exit(1);
		}

		sfd = socket (AF_INET, SOCK_STREAM, 0);
						
		address.sin_family = AF_INET;
		address.sin_port = htons(port);
		address.sin_addr.s_addr = htonl (INADDR_ANY);
		len = sizeof(address);
	
		result = bind(sfd, (struct sockaddr *) &address, len);
	
		if (result == -1)
		{
			syslog(LOG_ERR, "Can not bind socket to address.");
			exit (1);
		}
	
		listen(sfd, slimit);
		
#ifdef NO_FORK
		demon = false;
		syslog (LOG_INFO, "NO_FORK selected, not forking into background!");
#else
		demon = config_getvalue_bool ("demon", false);
#endif


		if (demon)
		{
			if (chdir("/") != 0)
			{
				syslog (LOG_ERR, "Can't change directory to \"/\"!");
				exit(1);
			}
			
			if (setpgrp() == -1)
			{
				syslog(LOG_ERR, "Could not create process group");
				exit(1);
			}

			close(0);
			close(1);
			close(2);

			if (fork() != 0)
			{
				exit(0);
			}
		}

		while (true)
		{
			csfd = accept(sfd, (struct sockaddr *) &caddress, &clen);

#ifndef DEBUG
			if (fork() == 0)
#endif
			{
				int continue_client;

				insock = fdopen(csfd, "r");
				outsock = fdopen(csfd, "w");

				continue_client = true;
	
				while(continue_client == true)
				{	
					mserver_serve();
				}

				shutdown (csfd, 2);

				exit(0);
			}
#ifndef DEBUG
			else
			{
				close(csfd);
			}	
#endif
		}
	}
}

void mserver_cleanup(void)
{
	fflush(outsock);
	fclose (outsock);
	fclose (insock);

	if (!inetd)
	{
		close (csfd);
		close (sfd);
	}
	else
	{
		close (0);
		close (1);
	}

	closelog();
}
