/*  Protocol compatible masqdialer server written in C
    Copyright (C) 1998 Charles P. Wright 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>

#include "mserver.h"

extern FILE *outsock;

void mserver_time (void)
{
	FILE *tfile;

	int i;
	int n;
		
	char cname[1024];
	char cspeed[1024];
	char ctime[1024];
	char temp[1024];

	if (getstat())
	{
		config_getvalue ("confile", temp, 1024);						
		tfile = fopen(temp, "r");
		if (tfile == NULL)
		{
			fprintf (outsock, "-1\n");
		}
		else
		{
			fgets(temp, 1024, tfile);
			fclose (tfile);

			for (i = 0; i < strlen(temp) && (temp[i] != ':'); i++)
			{
				cname[i] = temp[i];
			}
			cname[i] = '\0';

			for (i++, n = 0; i < strlen(temp) && (temp[i] != ':'); i++, n++)
			{
				cspeed[n] = temp[i];
			}
			cspeed[n] = '\0';

			for (i++, n = 0; i < strlen(temp) && (temp[i] != '\n'); i++, n++)
			{
				ctime[n] = temp[i];
			}
			ctime[n] = '\0';

			fprintf (outsock, "%s\n", ctime);
		}
	}
	else
	{
		fprintf (outsock, "DOWN\n");	
	}
}
