/* pref.h
 * 
 * Copyright (c) 1992-1998 by Mike Gleason.
 * All rights reserved.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 * 
 */

#define kFirewallPrefFileName			"firewall"
#define kGlobalFirewallPrefFileName		"/etc/ncftp.firewall"
#define kGlobalFixedFirewallPrefFileName	"/etc/ncftp.firewall.fixed"
#define kPrefFileName				"prefs"
#define kFirstFileName				"v3init"
#define kOpenSelectedBookmarkFileName		"bm2open"

typedef void (*PrefProc)(int i, const char *const, FILE *const fp);
typedef struct PrefOpt {
	const char *varname;
	PrefProc proc;
	int visible;
} PrefOpt;

#define kPrefOptObselete (-1)
#define kPrefOptInvisible 0
#define kPrefOptVisible 1

#define PREFOBSELETE (PrefProc) 0, kPrefOptObselete,

/* pref.c */
void SetAnonPass(int, const char *const, FILE *);
void SetConfirmClose(int, const char *const, FILE *);
void SetConnTimeout(int, const char *const, FILE *);
void SetCtrlTimeout(int, const char *const, FILE *);
void SetPager(int, const char *const, FILE *);
void SetPassive(int, const char *const, FILE *);
void SetProgressMeter(int, const char *const, FILE *);
void SetSavePasswords(int, const char *const, FILE *);
void SetXferTimeout(int, const char *const, FILE *);
void SetXtTitle(int, const char *const, FILE *);
void Set(const char *const, const char *const);
void LoadPrefs(void);
void InitPrefs(void);
void PostInitPrefs(void);
void SavePrefs(void);
void WriteDefaultFirewallPrefs(FILE *);
void ProcessFirewallPrefFile(FILE *);
void LoadFirewallPrefs(void);
void CheckForNewV3User(void);
