/*
  $Id: strerror.c,v 1.4 1996/08/10 14:09:27 luik Exp $

  strerror.c - strerror(3C) library function to return a string
  representation of errno.
  Copyright (C) 1996, Andreas Luik, <luik@pharao.s.bawue.de>.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 1, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <errno.h>
#include <stdio.h>
#include <string.h>

/* strerror() - return a string representation of errno. */
char *strerror(int e)
{
    extern int sys_nerr;
    extern char *sys_errlist[];

    return (e >= 0 && e < sys_nerr) ? sys_errlist[e] : NULL;
}
