# At any given time, a single user is the active user. This sets that user.

# Yes, it's simple now, but once we get threads, this will
# become more complex. I will probably use the pid() method
# of a thread to figure out its id, and then use a lookup table
# to figure out which user "owns" the thread.

package ActiveUser;
use strict;

{ # Hide $active inside a closure so it can't be accessed directly.
	my $active=undef;

	# Set the currently active user.
	sub setactive {
		$active=shift;
	}

	# Get the currently active user.
	sub getactive {
		return $active;
	}
}

1;
