/*
Copyright (c) 1998 Peter Zelezny.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

#include "xchat.h"
#include <fcntl.h>
#include <pwd.h>
#include <sys/stat.h>


extern struct xchatprefs prefs;


char *get_xdir(void)
{
   static char xdir[64];
   struct passwd *pw;
   int uid = getuid();
   pw = getpwuid(uid);
   sprintf(xdir, "%s/.xchat", pw->pw_dir);
   return(xdir);
}

void check_prefs_dir(void)
{
   struct stat st;
   char *xdir = get_xdir();
   
   if(stat(xdir, &st) < 0) mkdir(xdir, S_IRUSR | S_IWUSR | S_IXUSR);
}

char *default_file(void)
{
   static char file[96];
   struct passwd *pw;
   int uid = getuid();
   pw = getpwuid(uid);
   sprintf(file, "%s/.xchat/xchat.cfg", pw->pw_dir);
   return(file);
}

void load_config(void)
{
   int fh;

   memset(&prefs, 0, sizeof(struct xchatprefs));

   fh = open(default_file(), O_RDONLY);
   if(fh != -1)
   {
      read(fh, &prefs, sizeof(struct xchatprefs));
      close(fh);
      prefs.flags &= ~(1<<PREFS_AWAY);
   } else {
      struct passwd *pw = getpwuid(getuid());
      strcpy(prefs.nick1, pw->pw_name);
      strcpy(prefs.nick2, pw->pw_name); strcat(prefs.nick2, "_");
      strcpy(prefs.nick3, pw->pw_name); strcat(prefs.nick3, "__");
      strcpy(prefs.realname, pw->pw_name);
      strcpy(prefs.username, pw->pw_name);
      //prefs.flags = 0;
      prefs.flags = (1<<PREFS_AUTOSAVE) |
	             (1<<PREFS_AUTODIALOG) |
	             (1<<PREFS_AUTOREJOIN) |
	             (1<<PREFS_AUTORECONNECT);
      prefs.bg_color = 1;
      prefs.dialog_bg_color = 1;
      //prefs.fg_color = 0;  
      strcpy(prefs.awayreason, "I'm busy");
      sprintf(prefs.quitreason, "%s has no reason", prefs.nick1);
      strcpy(prefs.font_normal, "-adobe-courier-medium-r-normal--*-120-*-*-*-*-*-*");
      strcpy(prefs.font_bold, "-adobe-courier-bold-r-normal--*-120-*-*-*-*-*-*");
      
      strcpy(prefs.dialog_font_normal, prefs.font_normal);
      strcpy(prefs.dialog_font_bold, prefs.font_bold);
   }
}

void save_config(void)
{
   int fh;

   check_prefs_dir();

   fh = open(default_file(), O_WRONLY | O_CREAT, 0600);
   if(fh != -1)
   {
      write(fh, &prefs, sizeof(struct xchatprefs));
      close(fh);
   }
}
