/*
 * Checkgroups: script that updates the description of newsgroups
 * Input file : a checkgroups script that contains the name of
 *              the newsgroup and its description in one line
 *
 * Cornelius Krasel, April 1997
 * Source code borrows a lot from fetch(1).
 */

#include <sys/types.h>
#ifdef BSD
#include <sys/errno.h>
#endif
#include <ctype.h>
#include <dirent.h>
#include <fcntl.h>
#include <stdlib.h>
#include <pwd.h>
#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>
#include <syslog.h>
#include <time.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <unistd.h>

const int debug = 0;
const int verbose = 0;

#include "leafnode.h"

void process_input(char *s);

void process_input(char *s) {
    FILE * f;
    char * l;
   
    f = fopen( s, "r" );
    if (!f) {
        fprintf(stderr,"%s deleted (shouldn't happen)\n",s);
        return;
    }

    while ( (l=getaline( f )) ) {
        char * p;
        struct newsgroup * g;

        p = l;
        if (isalnum(*p)) {
            while (!isspace(*p))
                p++;
            if (*p)
                *p++ = '\0';
            if ((g = findgroup(l)) != NULL) {
	        fprintf( stderr, "%s\n", l );
                if (strlen(p) > 0)
                    g->desc = strdup(p);
	    }
        }
    }

    fclose( f );
}

int main(int argc, char *argv[] ) {
    struct passwd * pw;
    FILE * f;

    pw = getpwnam( "news" );
    if ( !pw ) {
        fprintf( stderr, "no such user: news\n" );
        exit( 1 );
    }

    setgid( pw->pw_gid );
    setreuid( pw->pw_uid, pw->pw_uid );

    if ( getuid() != pw->pw_uid || getgid() != pw->pw_gid ) {
        fprintf( stderr, "%s: must be run as news or root\n", argv[0] );
        exit( 1 );
    }

    if (argc != 2) {
        fprintf( stderr, "Usage: %s [checkgrous file]\n", argv[0] );
        exit( 1 );
    }

    /* Check whether input file exists */
    if ( !( f = fopen( argv[1], "r" ))) {
        fprintf( stderr, "%s: checkgroups file %s doesn't exist\n",
	         argv[0], argv[1] );
        exit( 1 );
    }
    else
        fclose(f);

    whoami();
    umask(2);

    readactive();	/* read groupinfo file */
    process_input(argv[1]);
    writeactive();	/* write groupinfo file */
    exit(0);
}
