#include <fstream.h>
#include <string>

#include "readline.h"

int nlreadline(istream &is,             // Input-Stream
	       string &strg,            // String to store line
	       int keepnl=1             // Keep newline
	       ) 
{
  int pos,len;
  getline(is,strg);
  pos=len=strg.length();
  while(pos) {
    pos--;
    if(strg[pos]!='\r' && strg[pos]!='\n') { pos++; break; }
  }
  if(keepnl) {
    strg.replace(pos,len-pos,"\r\n");
  } else {
    strg.replace(pos,len-pos,NULL,0);
  }
  return strg.length();
}

int readtext(istream &is,               // Input-Stream
	     string &strg,              // String to store line
	     int keepnl=1,              // Keep newlines in text
	     char *eot=".\r\n"          // EndOfText Marker
	     ) 
{
  int lines=0;
  string line;

  for(;;) {
    nlreadline(is,line,keepnl);
    if(line==eot || !is.good()) break;
    strg+=line;
    lines++;
  }

  return lines;
}
