#ifndef __Config_h__
#define __Config_h__

/* Copyright Th Gschwind 1996, 1997 */
#include <sys/param.h>
#include <time.h>

#include <iostream.h>

#include "OverviewFmt.h"
/*#include "Logger.h"*/
#include "MPList.h"

class Config {
public:
  char Username[256];
  char Groupname[256];

  char SpoolDirectory[MAXPATHLEN];
  int SpoolSize;
  char LogDirectory[MAXPATHLEN];
  char PrefetchFile[MAXPATHLEN];
  char PidFile[MAXPATHLEN];
  char Admin[512];
  enum { inetd, standalone };
  int ServerType;
  char CachePort[256];
  int ClientTimeout;

  MPList srvrs;

  time_t ttl_list;
  time_t ttl_desc;

  int Retries;

  enum {
    LogINN = 0x1,
    LogName = 0x2,
    LogAddr = 0x4    
  };
  int LogStyle;

  Config() {
    init();
  }
  
  Config(const char *fn) { init(); read(fn); }

  void init() {
    Username[0]=Groupname[0]='\0';
    SpoolDirectory[0]='\0';
    SpoolSize=102400;
    ClientTimeout=1200;
    LogDirectory[0]='\0';
    PrefetchFile[0]='\0';
    strcpy(Admin,"notset");
    ServerType=standalone;
    CachePort[0]='\0';
    ttl_list=600;    /* 10min */
    ttl_desc=3600;   /* 1hr */
    Retries=3;
    LogStyle=LogName+LogAddr;
  }
  void read(const char *fn);
  MPListEntry *server(const char *group) {
    return srvrs.server(group);
  }
};

#endif
