#include "emusic.h"

int playing = FALSE;
int paused = FALSE;
int directAccess = FALSE;
int loop_mode = TRUE;
int repeat_mode = FALSE;
int playtype = FORWARD;
int cur_second = 0;
int seconds_timer = 0;
int num_seconds = 0;
PlayList *playlist, *cdlist, *songlist, *shufflelist;
struct playlist_item *cur_item;
int end_of_song = FALSE;
int dumbcdmode = FALSE;

int end_song = FALSE, stop_song = FALSE;
int shuffled = FALSE;

pthread_mutex_t player_lock = PTHREAD_MUTEX_INITIALIZER;
pthread_t player_thread;

void seek_to_second(int second)
{
   EDBUG(2, "seek_to_second");
   pthread_mutex_lock(&player_lock);
   cur_item->player->seek_to_frame(second);
   flush_audio();
   pthread_mutex_unlock(&player_lock);
   seconds_timer = second;
   EDBUG_RETURN_;
}

int play(int start_second, struct playlist_item *song)
{
   int i = 0;

   EDBUG(2, "play");
   if (song) {
      i = song->player->play(start_second, song->path);
      if (i) {
	 fprintf(stderr, "Now Playing with %s: %s\n", song->player->id, song->name);
	 alarm(1);
      }
      else
	 fprintf(stderr, "Error playing %s\n", song->path);
      if (song->player == ReturnPlayerPlugin("cd"))
	 CheckAnalysisStreamType(1);
      else {
	 CheckAnalysisStreamType(0);
	 SaveItemCache(song);
      }
   }
   EDBUG_RETURN(i);
}

void play_frame(void)
{
   EDBUG(6, "play_frame");
   if (!playing)
      EDBUG_RETURN_;
   if (end_song)
      handle_end();
   else if (stop_song) {
      control(STOP);
   }
   if (end_song || stop_song)
      end_song = stop_song = FALSE;
   EDBUG_RETURN_;
}

void pause_it(void)
{
   EDBUG(2, "pause_it");
   if (paused) {
      alarm(0);
      pthread_mutex_lock(&player_lock);
   }
   else {
      alarm(1);
      pthread_mutex_unlock(&player_lock);
   }
   cur_item->player->pause_it();
   EDBUG_RETURN_;
}

void stop(void)
{
   EDBUG(2, "stop");
   if (!cur_item) {
      EDBUG_RETURN_;
   }
   if (paused)
      control(PAUSE);
   cur_item->player->stop(playing);
   pthread_mutex_init(&player_lock, NULL);
   cur_second = 0;
   seconds_timer = 0;
   if ((!cur_item->next) ||
       ((cur_item->next) && (cur_item->next->player != cur_item->player)))
/*      UnloadPlayerPlugin(cur_item->player); */ ;
   EDBUG_RETURN_;
}

void switchmodes(void)
{
   int tracks;

   EDBUG(2, "switchmodes");
   tracks = getnumtracks_cda();
   if (tracks == 0) {
      SetMultiButton(CurMW->playmodebutton, 0);
      EDBUG_RETURN_;
   }
   playing = TRUE;
   stop();
   playing = paused = cur_second = FALSE;
   if (dumbcdmode) {
      if (songlist)
	 cur_item = songlist->first;
      playlist = songlist;
      dumbcdmode = FALSE;
   }
   else {
      makelistofnums(cdlist, tracks);
      if (cdlist)
	 cur_item = cdlist->first;
      playlist = cdlist;
      dumbcdmode = TRUE;
   }
   SetPlaylistListBox(listbox, playlist);
   EDBUG_RETURN_;
}

void ShuffleIt(void)
{
   int pos;

   EDBUG(2, "ShuffleIt");
   if (cur_item)
      pos = cur_item->pos;
   else
      pos = 0;
   if (!shuffled) {
      copylist(songlist, shufflelist);
      shufflelist = shuffle_list(shufflelist);
      playlist = shufflelist;
      setcurposition(playlist, pos);
      shuffled = TRUE;
   }
   else {
      clearplaylist(playlist);
      playlist = songlist;
      setcurposition(playlist, pos);
      if (playlist && playlist->first)
	 cur_item = playlist->first;
      else
	 cur_item = NULL;
      shuffled = FALSE;
   }
   SetPlaylistListBox(listbox, playlist);
   EDBUG_RETURN_;
}

void control(int cmd)
{
   EDBUG(2, "control");
   switch (cmd) {
   case PLAY:
      if (!paused && cur_item) {
	 if (!play(cur_second, cur_item))
	    handle_end();
	 num_seconds = cur_item->length;
	 playing = TRUE;
	 paused = FALSE;
	 break;
      }
   case PAUSE:
      if (paused) {
	 paused = FALSE;
	 playing = TRUE;
	 pause_it();
      }
      else if (playing) {
	 flush_audio();
	 playing = FALSE;
	 paused = TRUE;
	 pause_it();
      }
      break;
   case STOP:
      if (playing || paused || (cur_item)) {
	 stop();
	 /*     if ((cur_item) && (cur_item->player->loaded)) 
	    UnloadPlayerPlugin(cur_item->player); */
	 cur_second = 0;
	 playing = FALSE;
	 paused = FALSE;
      }
      break;
   case DIRECTACCESS:
      if (CurMW->timer_bar->dragging == 0) {
	 cur_second = ((float) CurMW->timer_bar->percent * (float) num_seconds);
	 if (playing || paused) {
	    seek_to_second(cur_second);
	 }
      }
      break;
   case UPTRACK:
      if (playing)
	 stop();
      if (paused)
	 paused = FALSE;
      cur_second = 0;
      if ((cur_item == playlist->last) && (loop_mode))
	 cur_item = playlist->first;
      else if (cur_item == playlist->last)
	 playing = FALSE;
      else
	 cur_item = cur_item->next;
      if (playing)
	 control(PLAY);
      break;
   case DNTRACK:
      if (playing)
	 stop();
      if (paused)
	 paused = FALSE;
      cur_second = 0;
      if ((cur_item == playlist->first) && (loop_mode))
	 cur_item = playlist->last;
      else if (cur_item == playlist->first)
	 playing = FALSE;
      else
	 cur_item = cur_item->prev;
      if (playing)
	 control(PLAY);
      break;
   case FIRST:
      if (playing)
	 stop();
      if (paused)
	 paused = FALSE;
      cur_second = 0;
      cur_item = playlist->first;
      if (playing)
	 control(PLAY);
      break;
   case LAST:
      if (playing)
	 stop();
      if (paused)
	 paused = FALSE;
      cur_second = 0;
      cur_item = playlist->last;
      if (playing)
	 control(PLAY);
      break;
   case CUE:
      cur_second = seconds_timer + 5;
      if (cur_second > num_seconds)
	 cur_second = num_seconds;
      if (playing && !paused)
	 seek_to_second(cur_second);
      break;
   case REV:
      cur_second = seconds_timer - 5;
      if (cur_second < 0)
	 cur_second = 0;
      if (playing && !paused)
	 seek_to_second(cur_second);
      break;
   }
   EDBUG_RETURN_;
}

void getlist(char *list)
{
   char *temp;

   EDBUG(2, "getlist");
   temp = GetRightPath(list);
   loadplaylist(temp);
   if (playtype == SHUFFLE)
      ShuffleIt();
   Efree(temp);
   EDBUG_RETURN_;
}

void handle_end(void)
{
   EDBUG(2, "handle_end");
   end_of_song = TRUE;
   /* flush_audio(); */
   alarm(0);
   if (!cur_item)
      EDBUG_RETURN_;
   if (repeat_mode) {
      control(PLAY);
   }
   else
      switch (playtype) {
      case FORWARD:
	 control(UPTRACK);
	 break;
      case REVERSE:
	 control(DNTRACK);
	 break;
      case SHUFFLE:
	 control(UPTRACK);
	 break;
      case REPEAT:
	 control(PLAY);
	 break;
      default:
	 control(UPTRACK);
	 break;
      }
   end_of_song = FALSE;
   EDBUG_RETURN_;
}

void SecondTimer(int sig)
{
   EDBUG(8, "SecondTime");
   if (playing)
      seconds_timer++;
   alarm(1);
   EDBUG_RETURN_;
}

int get_second(void)
{
   EDBUG(6, "get_second");
   if (!cur_item)
      EDBUG_RETURN(0);
   EDBUG_RETURN(seconds_timer);
}

void get_info(struct playlist_item *song)
{
   EDBUG(2, "get_info");
   if (!song)
      EDBUG_RETURN_;
   if (song->name) {
      Efree(song->name);
      song->name = NULL;
   }
   song->player->get_info(song);
   if (song->player != ReturnPlayerPlugin("cd"))
      SaveItemCache(song);
   EDBUG_RETURN_;
}
