#include "emusic.h"

MainWindowCollection *MainWindow;
MainWindowCollection *MinimizedWindow;
MainWindowCollection *CurMW;

int dummy;

int double_size = FALSE;

void Vol_callback(void)
{
   int vol;

   EDBUG(6, "Vol_callback");
   vol = (GetSliderPosition(CurMW->master_volume) * 100);
   ChangeMasterVolume(vol);
   EDBUG_RETURN_;
}

void Bal_callback(void)
{
   int left, right;
   float temp;
   int bal;

   EDBUG(6, "Bal_callback");
   bal = (GetSliderPosition(CurMW->balance) * 100);
   if (bal == 50) {
      left = 100;
      right = 100;
   }
   else if (bal < 50) {
      temp = (float) bal / 50;
      left = 100;
      right = temp * 100;
   }
   else {
      temp = (float) (bal - 50) / 50;
      left = (1 - temp) * 100;
      right = 100;
   }
   ChangeBalance(left, right);
   EDBUG_RETURN_;
}

void MinMax_MainWin(void)
{
   int x, y;

   EDBUG(4, "MinMax_MainWin");
   if (!MinimizedWindow)
      EDBUG_RETURN_;
   HideWidget(CurMW->MainWin);
   x = CurMW->MainWin->x;
   y = CurMW->MainWin->y;
   if (CurMW == MainWindow)
      CurMW = MinimizedWindow;
   else
      CurMW = MainWindow;
   if (CurMW == MinimizedWindow && MinimizedWindow->MainWin->deferred) {
      MinimizedWindow->MainWin->x = MinimizedWindow->back->x;
      MinimizedWindow->MainWin->y = MinimizedWindow->back->y;
      CreateWidget(MinimizedWindow->MainWin);
   }
   UnhideWidget(CurMW->MainWin);
/*   MoveWidget(CurMW->MainWin, NULL, x, y); */
   if (CurMW->analyze)
      SetAnalysisWin(CurMW->analyze->win);
   if (double_size && !CurMW->doublesize) {
      ScaleWidget(CurMW->MainWin, 2, 2);
      CurMW->doublesize = TRUE;
   }
   else if (!double_size && CurMW->doublesize) {
      ScaleWidget(CurMW->MainWin, 0.5, 0.5);
      CurMW->doublesize = FALSE;
   }
   EDBUG_RETURN_;
}

void ToggleSize(void)
{
   EDBUG(4, "ToggleSize");
   CurMW->doublesize = double_size = !double_size;
   if (double_size)
      ScaleWidget(CurMW->MainWin, 2, 2);
   else
      ScaleWidget(CurMW->MainWin, 0.5, 0.5);
   EDBUG_RETURN_;
}

void Create_MainWin(MainWindowCollection * win)
{
   int i;

   EDBUG(4, "Create_MainWin");
   win->visible = TRUE;
   if (win->timedisplay)
      for (i = 0; i < 4; i++)
	 SetButtonPart(win->digit[i], 11);
   if (win->trackdisplay)
      for (i = 4; i <= 6; i++)
	 SetButtonPart(win->digit[i], 0);
   EDBUG_RETURN_;
}

void Display_MainWin(MainWindowCollection * win)
{
   int track[3];
   int cdtime[4];
   int i;
   int disp_time = 0;
   time_t flash_time;
   int flash;
   int frame = 0;
   int l = -1, r = -1;

   EDBUG(4, "Display_MainWin");
   frame = get_second();
   if (!frame)
      frame = cur_second;
   if (win->timer_bar) {
      if (win->timer_bar->dragging)
	 frame = GetSliderPosition(win->timer_bar) * num_seconds;
      else
	 SetSliderPosition(win->timer_bar, (float) frame / (float) num_seconds);
   }
   if (win->name_box) {
      if (cur_item)
	 SetTextTextBox(win->name_box, cur_item->name);
      else
	 SetTextTextBox(win->name_box, NULL);
      UpdateTextBox(win->name_box);
   }
   if (win->statuswin)
      UpdateStatusWin(win->statuswin);
   if (win->master_volume) {
      SetSliderPosition(win->master_volume, (float) GetVolume(&l, &r) / 100);
   }
   else if (win->balance) {
      GetVolume(&l, &r);
   }
   if (win->balance) {
      if (l > r)
	 SetSliderPosition(win->balance, ((float) l / 100) / 2);
      else if (r > l)
	 SetSliderPosition(win->balance, ((float) r / 100) / 2 + 0.5);
      else
	 SetSliderPosition(win->balance, 0.5);
   }
   if (!win->timedisplay)
      EDBUG_RETURN_;
   if (p_list[0] == '\0' || !cur_item) {
      for (i = 0; i < 4; i++)
	 cdtime[i] = 11;
      for (i = 0; i < 3; i++)
	 track[i] = 0;
      disp_time = 0;
   }
   else if (!playing && !paused) {
      if (cur_item)
	 disp_time = cur_item->length;
      else
	 disp_time = 0;
      cdtime[0] = 0;
      cdtime[1] = (disp_time / 60);
      if (cdtime[1] >= 10) {
	 cdtime[0] = cdtime[1] / 10;
	 cdtime[1] = cdtime[1] % 10;
      }
      cdtime[2] = ((disp_time % 60) / 10);
      cdtime[3] = (disp_time % 10);
      track[2] = ((cur_item->pos % 100) % 10);
      track[1] = ((cur_item->pos % 100) / 10);
      track[0] = (cur_item->pos / 100);
   }
   else {
      if (paused) {
	 flash_time = tv.tv_sec;
	 flash = ((flash_time % 2) == 1);
      }
      else
	 flash = FALSE;
      track[2] = ((cur_item->pos % 100) % 10);
      track[1] = ((cur_item->pos % 100) / 10);
      track[0] = (cur_item->pos / 100);
      if (win->time_mode == 0)
	 disp_time = frame;
      else if (win->time_mode == 1)
	 disp_time = num_seconds - frame;
      else if (win->time_mode == 2)
	 disp_time = playlist->length;
      else
	 disp_time = playlist->length;
      cdtime[0] = 0;
      cdtime[1] = (disp_time / 60);
      if (cdtime[1] >= 10) {
	 cdtime[0] = cdtime[1] / 10;
	 cdtime[1] = cdtime[1] % 10;
      }
      cdtime[2] = ((disp_time % 60) / 10);
      cdtime[3] = (disp_time % 10);
      if (flash) {
	 for (i = 0; i < 4; i++)
	    cdtime[i] = 11;
      }
   }
   if (disp_time != win->old_time) {
      for (i = 0; i < 4; i++)
	 if (win->old_digit[i] != cdtime[i]) {
	    SetButtonPart(win->digit[i], cdtime[i]);
	    win->old_digit[i] = cdtime[i];
	 }
      win->old_time = disp_time;
   }
   if (win->trackdisplay) {
      for (i = 4; i <= 6; i++)
	 if (win->old_digit[i] != track[i - 4]) {
	    SetButtonPart(win->digit[i], track[i - 4]);
	    win->old_digit[i] = track[i - 4];
	 }
   }
   EDBUG_RETURN_;
}

void Event_MainWin(MainWindowCollection * win, XEvent ev)
{
   EDBUG(4, "Event_MainWin");
   if (!FindEventWidget(win->MainWin, ev)) {
      if ((ev.type == ButtonPress) && (ev.xbutton.window == win->MainWin->win)) {
	 moving = TRUE;
	 move_x = ev.xbutton.x;
	 move_y = ev.xbutton.y;
      }
      else if ((ev.type == ButtonRelease) &&
	       (ev.xbutton.window == win->MainWin->win)) {
	 if (ev.xbutton.button == 3) {
	    RaiseLowerWidget(win->MainWin);
	    if (PlayWin->visible)
	       RaiseLowerWidget(PlayWin);
	 }
	 else
	    moving = FALSE;
      }
   }
   EDBUG_RETURN_;
}

void ChangePlayType(void)
{
   EDBUG(4, "ChangePlayType");
   switch (playtype) {
   case SHUFFLE:
      ShuffleIt();
      break;
   default:
      break;
   }
   if (PlayWin->visible)
      DisplayListBox(listbox);
   EDBUG_RETURN_;
}

void Defaults_MainWin(MainWindowCollection * win)
{
   EDBUG(8, "Defaults_MainWin");
   win->MainWin = Emalloc(sizeof(Widget));
   win->MainWin->visible = TRUE;
   win->MainWin->raised = TRUE;
   win->MainWin->win = root;
   win->MainWin->first = NULL;
   win->MainWin->x = win->MainWin->y = 0;
   win->timedisplay = FALSE;
   win->trackdisplay = FALSE;
   win->timer_bar = NULL;
   win->name_box = NULL;
   win->playbutton = NULL;
   win->playmodebutton = NULL;
   win->timedisplay = FALSE;
   win->trackdisplay = FALSE;
   win->statuswin = NULL;
   win->analyze = NULL;
   win->master_volume = NULL;
   win->balance = NULL;
   win->old_time = -1;
   win->doublesize = FALSE;
   win->digit[0] = win->digit[1] = win->digit[2] = win->digit[3] =
      win->digit[4] = win->digit[5] = win->digit[6] = NULL;
   EDBUG_RETURN_;
}

MainWindowCollection *ConfigMainWin(FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   struct _widget *cur = NULL;
   int counter = 0;
   int digit_count = 0;
   int track_count = 4;
   int end = FALSE;
   MainWindowCollection *win;

   EDBUG(2, "ConfigMainWin");
   if (textmode)
      EDBUG_RETURN(NULL);
   win = Emalloc(sizeof(MainWindowCollection));
   Defaults_MainWin(win);
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("TIMERMODE", s1, 9))
	    win->time_mode = atoi(s2);
	 else if (!strncmp("VISIBLE", s1, 7)) {
	    win->MainWin->state = parsebool(s2);
	    deferred = win->MainWin->deferred = !win->MainWin->state;
	 }
	 else if (!strncmp("BEGIN", s1, 5)) {
	    upstr(s2);
	    if (!win->MainWin->first) {
	       win->MainWin->first = Emalloc(sizeof(struct _widget));

	       cur = win->MainWin->first;
	    }
	    else {
	       cur->next = Emalloc(sizeof(struct _widget));

	       cur = cur->next;
	    }
	    cur->widget = NULL;
	    win->MainWin->last = cur;
	    cur->next = NULL;
	    if (!strncmp("BACKGROUND", s2, 9)) {
	       cur->type = BACKGROUND;
	       cur->widget = ConfigBack(file);
	       win->back = cur->widget;
	       win->MainWin->win = win->back->win;
	       win->MainWin->shaped = win->back->shaped;
	       win->MainWin->x = win->back->x;
	       win->MainWin->y = win->back->y;
	       win->MainWin->w = win->back->w;
	       win->MainWin->h = win->back->h;
	    }
	    else if (!strncmp("ANALYSIS", s2, 8)) {
	       cur->type = CONTAINER;
	       cur->widget = ConfigContainer(win->MainWin->win, file);
	       win->analyze = cur->widget;
	       if (!deferred)
		  SetAnalysisWin(win->analyze->win);
	    }
	    else if (!strncmp("BUTTON", s2, 6)) {
	       cur->type = BUTTON;
	       cur->widget = ConfigButton(win->MainWin->win, file);
	    }
	    else if (!strncmp("MULTIBUTTON", s2, 11)) {
	       cur->type = MULTIBUTTON;
	       cur->widget = ConfigMultiButton(win->MainWin->win, file, &dummy);
	    }
	    else if (!strncmp("PLAYTYPE", s2, 8)) {
	       if (!counter) {
		  cur->type = MULTIBUTTON;
		  cur->widget = ConfigMultiButton(win->MainWin->win, file, &playtype);
		  counter = 1;
	       }
	    }
	    else if (!strncmp("REPEATMODE", s2, 10)) {
	       cur->type = MULTIBUTTON;
	       cur->widget = ConfigMultiButton(win->MainWin->win, file, &repeat_mode);
	    }
	    else if (!strncmp("PLAYBUTTON", s2, 10)) {
	       cur->type = MULTIBUTTON;
	       cur->widget = ConfigMultiButton(win->MainWin->win, file, &dummy);
	       win->playbutton = cur->widget;
	    }
	    else if (!strncmp("PLAYMODE", s2, 8)) {
	       cur->type = MULTIBUTTON;
	       cur->widget = ConfigMultiButton(win->MainWin->win, file, &dumbcdmode);
	       win->playmodebutton = cur->widget;
	    }
	    else if (!strncmp("SLIDER", s2, 6)) {
	       cur->type = SLIDER;
	       cur->widget = ConfigSlider(win->MainWin->win, file);
	       win->timer_bar = cur->widget;
	    }
	    else if (!strncmp("TIME_DIGIT", s2, 5)) {
	       if (digit_count < 4) {
		  win->timedisplay = TRUE;
		  cur->type = BUTTON;
		  cur->widget = ConfigButton(win->MainWin->win, file);
		  win->digit[digit_count] = cur->widget;
		  win->old_digit[digit_count] = -1;
		  digit_count++;
	       }
	    }
	    else if (!strncmp("TRACK_DIGIT", s2, 5)) {
	       if (track_count < 7) {
		  win->trackdisplay = TRUE;
		  cur->type = BUTTON;
		  cur->widget = ConfigButton(win->MainWin->win, file);
		  win->digit[track_count] = cur->widget;
		  win->old_digit[track_count] = -1;
		  track_count++;
	       }
	    }
	    else if (!strncmp("COLON", s2, 5)) {
	       cur->type = BUTTON;
	       cur->widget = ConfigButton(win->MainWin->win, file);
	       SetButtonPart(cur->widget, 10);
	    }
	    else if (!strncmp("NAME", s2, 4)) {
	       cur->type = TEXTBOX;
	       cur->widget = ConfigTextBox(win->MainWin->win, file);
	       win->name_box = cur->widget;
	    }
	    else if (!strncmp("VOLUME_CONTROL", s2, 14)) {
	       cur->type = SLIDER;
	       cur->widget = ConfigSlider(win->MainWin->win, file);
	       win->master_volume = cur->widget;
	       SliderSetCallback(cur->widget, Vol_callback);
	    }
	    else if (!strncmp("BALANCE_CONTROL", s2, 15)) {
	       cur->type = SLIDER;
	       cur->widget = ConfigSlider(win->MainWin->win, file);
	       win->balance = cur->widget;
	       SliderSetCallback(cur->widget, Bal_callback);
	    }
	    else if (!strncmp("STATUS", s2, 6)) {
	       cur->type = STATUS;
	       cur->widget = ConfigStatusWin(win->MainWin->win, file);
	       win->statuswin = cur->widget;
	    }
	    else if (!strncmp("HOTSPOT", s2, 7)) {
	       cur->type = CONTAINER;
	       cur->widget = ConfigContainer(win->MainWin->win, file);
	    }
	    else if (!strncmp("STRIP", s2, 5)) {
	       cur->type = STRIP;
	       cur->widget = ConfigStrip(win->MainWin->win, file);
	    }
	 }
	 else
	    /*  fprintf(stderr,"Unknown line in MainWin config\n") */ ;
      }
      else
	 end = TRUE;
   }
   if (!deferred)
      Create_MainWin(win);
   else {
      win->MainWin->visible = FALSE;
      win->visible = FALSE;
   }
   deferred = FALSE;
   EDBUG_RETURN(win);
}
