
#include "widget.h"
#include "../econfig.h"

struct _hotspots *FindSpot(Strip * strip, int x, int y)
{
   struct _hotspots *cur;

   EDBUG(5, "FindSpot");
   if (!strip || !strip->first)
      EDBUG_RETURN(NULL);
   cur = strip->first;
   while (cur) {
      if ((x >= cur->x) && (x <= (cur->w + cur->w)))
	 if ((y >= cur->y) && (y <= (cur->y + cur->h)))
	    EDBUG_RETURN(cur);
      cur = cur->next;
   }
   EDBUG_RETURN(NULL);
}

void HideStrip(Strip * strip)
{
   EDBUG(6, "HideStrip");
   if (strip->visible) {
      XUnmapWindow(disp, strip->win);
      strip->visible = FALSE;
   }
   EDBUG_RETURN_;
}

void UnhideStrip(Strip * strip)
{
   EDBUG(5, "UnhideStrip");
   if (!strip->visible) {
      XMapWindow(disp, strip->win);
      strip->visible = TRUE;
   }
   EDBUG_RETURN_;
}

void CreateStrip(Strip * strip, Window parent)
{
   EDBUG(5, "CreateStrip");
   strip->parent = parent;
   strip->win = CreateWin(parent, strip->x, strip->y, strip->w, strip->h);
   XMapWindow(disp, strip->win);
   Imlib_apply_image(imlib, strip->normal->im, strip->win);
   EDBUG_RETURN_;
}

void Defaults_hotspots(struct _hotspots *hot)
{
   hot->x = hot->y = hot->w = hot->h = 0;
   hot->clicked = hot->over = NULL;
   hot->action_left = hot->action_middle = hot->action_right = 0;
   hot->next = NULL;
}

void DefaultsStrip(Strip * strip)
{
   strip->x = strip->y = strip->w = strip->h = 0;
   strip->visible = TRUE;
   strip->normal = NULL;
   strip->first = strip->last = NULL;
}

struct _hotspots *Config_hotspots(FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   struct _hotspots *hot = Emalloc(sizeof(struct _hotspots));

   EDBUG(5, "Config_hotspots");
   Defaults_hotspots(hot);
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("LOCATION", s1, 8))
	    getcoords(s2, &hot->x, &hot->y);
	 else if (!strncmp("SIZE", s1, 4))
	    getcoords(s2, &hot->w, &hot->h);
	 else if (!strncmp("CLICKED", s1, 7))
	    hot->clicked = LoadImage(s2);
	 else if (!strncmp("OVER", s1, 4))
	    hot->over = LoadImage(s2);
	 else if (!strncmp("ACTION_R", s1, 8))
	    hot->action_right = parse_action(s2);
	 else if (!strncmp("ACTION_M", s1, 8))
	    hot->action_middle = parse_action(s2);
	 else if (!strncmp("ACTION_L", s1, 8))
	    hot->action_left = parse_action(s2);
      }
      else
	 end = TRUE;
   }
   if (hot->over && !hot->clicked)
      hot->clicked = hot->over;
   else if (hot->clicked && !hot->over)
      hot->over = hot->clicked;
   EDBUG_RETURN(hot);
}

Strip *ConfigStrip(Window parent, FILE * file)
{
   char st[FILEPATH_LEN_MAX];
   char s1[FILEPATH_LEN_MAX], s2[FILEPATH_LEN_MAX];
   int end = FALSE;
   Strip *strip = Emalloc(sizeof(Strip));
   struct _hotspots *cur = NULL;

   EDBUG(5, "ConfigStrip");
   DefaultsStrip(strip);
   strip->parent = parent;
   while (!end) {
      if (GetNextLine(st, file)) {
	 splitstring(s1, s2, st);
	 if (!strncmp("END", s1, 3))
	    end = TRUE;
	 else if (!strncmp("LOCATION", s1, 8))
	    getcoords(s2, &strip->x, &strip->y);
	 else if (!strncmp("BACK", s1, 4)) {
	    strip->normal = LoadImage(s2);
	    strip->w = strip->normal->w;
	    strip->h = strip->normal->h;
	 }
	 else if (!strncmp("VISIBLE", s1, 7))
	    strip->visible = parsebool(s2);
	 else if (!strncmp("BEGIN", s1, 4) && !strncasecmp("SPOT", s2, 4)) {
	    if (!strip->first)
	       cur = strip->last = strip->first = Config_hotspots(file);
	    else {
	       cur->next = Config_hotspots(file);
	       cur = cur->next;
	       strip->last = cur;
	    }
	 }
      }
      else
	 end = FALSE;
   }
   if (!deferred)
      CreateStrip(strip, parent);
   EDBUG_RETURN(strip);
}

void ScaleStrip(Strip * strip, double scale_w, double scale_h)
{
   struct _hotspots *cur;

   EDBUG(5, "ScaleStrip");
   strip->x *= scale_w;
   strip->y *= scale_h;
   strip->w *= scale_w;
   strip->h *= scale_h;
   XMoveResizeWindow(disp, strip->win, strip->w, strip->y, strip->w, strip->h);
   Imlib_render(imlib, strip->normal->im, strip->w, strip->h);
   Imlib_apply_image(imlib, strip->normal->im, strip->win);
   cur = strip->first;
   while (cur) {
      cur->x *= scale_w;
      cur->y *= scale_h;
      cur->w *= scale_w;
      cur->h *= scale_h;
      if (cur->clicked != cur->over) {
	 if (cur->clicked)
	    Imlib_render(imlib, cur->clicked->im, strip->w, strip->h);
	 if (cur->over)
	    Imlib_render(imlib, cur->over->im, strip->w, strip->h);
      }
      else
	 Imlib_render(imlib, cur->over->im, strip->w, strip->h);
      cur = cur->next;
   }
   EDBUG_RETURN_;
}

void EventStrip(Strip * strip, XEvent ev)
{
   int x, y, rx, ry;
   Window rr, cr;
   unsigned int mr;
   struct _hotspots *cur = NULL;

   EDBUG(5, "EventStrip");
   XQueryPointer(disp, strip->win, &rr, &cr, &rx, &ry, &x, &y, &mr);
   cur = FindSpot(strip, x, y);
   if (!cur)
      Imlib_apply_image(imlib, strip->normal->im, strip->win);
   else {
      if (ev.type == ButtonPress) {
	 Imlib_apply_image(imlib, cur->clicked->im, strip->win);
	 if (ev.xbutton.button == 3 && !cur->action_right)
	    ev.xbutton.button = 1;
	 else if (ev.xbutton.button == 2 && !cur->action_middle)
	    ev.xbutton.button = 1;
	 if (ev.xbutton.button == 3)
	    do_action(cur->action_right);
	 else if (ev.xbutton.button == 2)
	    do_action(cur->action_middle);
	 else
	    do_action(cur->action_left);
      }
      else
	 Imlib_apply_image(imlib, cur->over->im, strip->win);
   }
   EDBUG_RETURN_;
}

int isEventStrip(Strip * strip, XEvent ev)
{
   EDBUG(5, "isEventStrip");
   if (ev.xbutton.subwindow == strip->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xcrossing.subwindow == strip->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xbutton.window == strip->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xcrossing.window == strip->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xany.window == strip->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xmotion.window == strip->win) {
      EDBUG_RETURN(TRUE);
   }
   else if (ev.xmotion.subwindow == strip->win) {
      EDBUG_RETURN(TRUE);
   }
   EDBUG_RETURN(FALSE);
}

void FreeStrip(Strip * strip)
{
   struct _hotspots *cur, *temp;

   EDBUG(5, "FreeStrip");
   cur = strip->first;
   while (cur) {
      FreeImageDat(cur->clicked);
      FreeImageDat(cur->over);
      temp = cur;
      cur = cur->next;
      Efree(temp);
   }
   FreeImageDat(strip->normal);
   Efree(strip);
   strip = NULL;
   EDBUG_RETURN_;
}
