#include "libpdftex.h"

typedef struct {
    internalfontnumber font;
    char *dataptr;
    int  len;
} packet_entry;

static packet_entry *packet_ptr, *packet_tab = 0;
static packet_max;

typedef struct {
    char **data;
    int *len;
    internalfontnumber font;
}  vf_entry;

static vf_entry *vf_ptr, *vf_tab = 0;
static vf_max;

static char *packet_data_ptr;

integer newvfpacket(internalfontnumber f)
{
    int i, n = fontec[f] - fontbc[f] + 1;
    if (vf_tab == 0) {
        vf_max = 256;
        vf_tab = XTALLOC(vf_max, vf_entry);
        vf_ptr = vf_tab;
    }
    else if (vf_ptr - vf_tab == vf_max) {
        vf_tab = XRETALLOC(vf_tab, vf_max + 256, vf_entry);
        vf_ptr = vf_tab + vf_max;
        vf_max += 256;
    }
    vf_ptr->len = XTALLOC(n, int);
    vf_ptr->data = XTALLOC(n, char *);
    for (i = 0; i < n; i++) {
        vf_ptr->data[i] = 0;
        vf_ptr->len[i] = 0;
    }
    vf_ptr->font = f;
    return vf_ptr++ - vf_tab;
}

void storepacket(int f, int c, int s)
{
    int l = strstart[s + 1] - strstart[s];
    vf_tab[vfpacketbase[f]].len[c - fontbc[f]] = l;
    vf_tab[vfpacketbase[f]].data[c - fontbc[f]] = XTALLOC(l, char);
    memcpy((void *)vf_tab[vfpacketbase[f]].data[c - fontbc[f]], 
           (void *)(strpool + strstart[s]), l);
}

void pushpacketstate()
{
    if (packet_tab == 0) {
        packet_max = 256;
        packet_tab = XTALLOC(packet_max, packet_entry);
        packet_ptr = packet_tab;
    }
    else if (packet_ptr - packet_tab == packet_max) {
        packet_tab = XRETALLOC(packet_tab, packet_max + 256, packet_entry);
        packet_ptr = packet_tab + packet_max;
        packet_max += 256;
    }
    packet_ptr->font = f;
    packet_ptr->dataptr = packet_data_ptr;
    packet_ptr->len = vfpacketlength;
    packet_ptr++;
}

void poppacketstate()
{
    if (packet_ptr == packet_tab)
        FAIL("packet stack empty, impossible to pop");
    packet_ptr--;
    f = packet_ptr->font;
    packet_data_ptr = packet_ptr->dataptr;
    vfpacketlength = packet_ptr->len;
}

void startpacket(internalfontnumber f, int c)
{
    packet_data_ptr = vf_tab[vfpacketbase[f]].data[c - fontbc[f]];
    vfpacketlength = vf_tab[vfpacketbase[f]].len[c - fontbc[f]];
}

eightbits packetbyte()
{
    vfpacketlength--;
    return *packet_data_ptr++;
}

void vf_free()
{
    vf_entry *v;
    int n;
    char **p;
    if (vf_tab != 0)
        for (v = vf_tab; v < vf_ptr; v++) {
            XFREE(v->len);
            n = fontec[v->font] - fontec[v->font] + 1;
            for (p = v->data; p - v->data < n ; p++)
                XFREE(*p);
            XFREE(v->data);
        }
    XFREE(packet_tab);
}
