dnl Check for a program from a list, with user control.
dnl Generates corresponding prog_XXX.h file with corresponding flags defs.
dnl "#undef USE_COMPRESSOR" must be put into acconfig.h if the latter is used.
dnl Use:  ct_CHECK_WITH_PROGS(genericname, proglist)

dnl TODO:
dnl + add generated prog_*.h to maintclean files.
dnl + add prog_*.h deps and rules on configure.in.
dnl + make a similar macro allowing USE_XX to be a combination of all flags ?

dnl  Expands to one shell "case" sub-statement, 
dnl suitable for use within a "case" statement.
dnl Internal, for use by "ct_CASES".
dnl
define([ct_ONE_CASE], [dnl
dnl Add this possible choice in .h file *on m4 processing*
syscmd([echo '#define ]translit($1_$2,[a-z],[A-Z])[ (1 << ]$3[)' >> prog_]$1[.h])dnl
$2)
    translit($1,[a-z],[A-Z])=$2		# turn "yes" into default
dnl Add the choice as a #define
    AC_DEFINE_UNQUOTED(USE_[]translit($1,[a-z],[A-Z]), (1 << $3))
    ;;
])

dnl  Expands to shell sub-statements suitable for use
dnl within a "case" statement.
dnl  Acts recursively, on each of the space-separated $2.
dnl
define([ct_CASES], [dnl
ifelse($2, , , [dnl
ct_ONE_CASE($1, patsubst($2, [ *\(\w*\).*], \1), $3)
ct_CASES($1, patsubst($2, ^\w* *,), incr($3))
])
])

AC_DEFUN(ct_CHECK_WITH_PROGS,[dnl
AC_ARG_WITH($1, [  --with-]$1[
                          Force support of specified ]$1[ instead of scanning
                           the system to know which one can be used.
                          ]$1[s I know of: ]$2[.],
[translit($1,[a-z],[A-Z])=${withval}],
[AC_CHECK_PROGS(translit($1,[a-z],[A-Z]), $2, [no])])

# Find which $1 to support

dnl Set the CPP symbol bits; save them to .h file
syscmd([echo > prog_]$1[.h \
'/* This file was automatically generated by autoconf */
/* with the ct_CHECK_WITH_PROGS macro */

/* DO NOT EDIT BY HAND */
'])
case ${translit($1,[a-z],[A-Z])} in
  yes | ct_CASES($1, $2, 0)
  no)
    ;;
  *)
    AC_MSG_ERROR([Don't know how to support ]$1[ \`${]translit($1,[a-z],[A-Z])[}'.])
    ;;
esac

dnl Show the user what was selected
dnl
case ${[]translit($1,[a-z],[A-Z])[]} in
  patsubst($2, [\> *\<], [ | ]))
    AC_MSG_RESULT([Using ]translit($1,_,[ ])[ program \`${]translit($1,[a-z],[A-Z])[}'.])
    ;;
  *)
    AC_MSG_RESULT([Using NO ]$1[ program.])
    ;;
esac

ct_cv_prog_[]translit($1,[a-z],[A-Z])=${[]translit($1,[a-z],[A-Z])[]}

dnl Allow its use in Makefiles
dnl eg. "... | $(DECOMPRESSOR)"
dnl
AC_SUBST(translit($1,[a-z],[A-Z]))
])
