#ifndef ___ARENA_DEFS_H___
#  define ___ARENA_DEFS_H___


/* A couple of useful macro */ 
#ifndef max
#  define max(a, b)   ((a) > (b) ? (a) : (b))
#  define min(a, b)   ((a) < (b) ? (a) : (b))
#endif

/* useful macro for freeing heap strings */
#define Free(s) {if (s) {free(s); s = NULL;};};


#ifndef CONST
#  define CONST const
#endif


/*
 * Document types
 */
#define TEXT_DOCUMENT          "text/plain"
#define HTML_DOCUMENT          "text/html"
#define HTML3_DOCUMENT         "text/x-html3"
#define HTML_LEVEL3_DOCUMENT   "text/html; level=3"
#define GIF_DOCUMENT           "image/gif"
#define JPEG_DOCUMENT          "image/jpeg"
#define PNG_DOCUMENT           "image/png"
#define PNG_EXP_DOCUMENT       "image/x-png"
#define XPM_DOCUMENT           "image/x-xpixmap"
#define XBM_DOCUMENT           "image/x-xbitmap"
#if 1
#define CSS_DOCUMENT           "text/css"
#define CSS1_DOCUMENT          "text/css1"
                                   /* QingLong.10-02-97 */
#endif


/*
 * fonts are held in an array to allow them to be identified by a 4 bit index.
 */

#define FONTS  256

#define IDX_H1FONT              0
#define IDX_H2FONT              1
#define IDX_H3FONT              2
#define IDX_H4FONT              3
#define IDX_LABELFONT           4
#define IDX_NORMALFONT          5
#define IDX_INORMALFONT         6
#define IDX_BNORMALFONT         7
#define IDX_BINORMALFONT        8
#define IDX_FIXEDFONT           9
#define IDX_IFIXEDFONT         10
#define IDX_BFIXEDFONT         11
#define IDX_BIFIXEDFONT        12
#define IDX_SMALLFONT          13
#define IDX_SYMBOLFONT         14
#define IDX_SUBSYMFONT         15

#define IDX_FONTS_NUMBER       16


/*
 * Default image parameters?
 */
#define IMG_WIDTH    32
#define IMG_HEIGHT   32
#define IMG_INDICATOR 3


/*
 * Mouse button events.
 */
#define BUTTONUP      1     /* used by WhichAnchor() */
#define BUTTONDOWN    2
#define MOVEUP        3     /* Mouse move in button up state */
#define MOVEDOWN      4     /* Mouse move in button down state */


/* Codes returned by button down handlers to
 * indicate interest in receiving the corresponding button up event.
 */
#define VOID          0
#define WINDOW        1
#define SCROLLBAR     2
#define TOOLBAR       3
#define STATUS        4


#endif	/* ifndef ___ARENA_DEFS_H___ */
