/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.application.ApplicationObserver;
import netscape.application.Event;
import netscape.application.EventLoop;
import netscape.application.FoundationDialog;
import netscape.application.FoundationFrame;
import netscape.application.FoundationPanel;
import netscape.application.FoundationWindow;
import netscape.application.Menu;
import netscape.application.MenuView;
import netscape.application.ModalDialogManager;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.View;
import netscape.application.Window;
import netscape.application.WindowInvalidationAgent;
import netscape.application.WindowOwner;
import netscape.util.InconsistencyException;

public class ExternalWindow
implements Window,
ApplicationObserver {
    java.awt.Window awtWindow;
    private FoundationPanel panel;
    private WindowOwner owner;
    private int type;
    private Size minimumSize;
    private String title;
    private Rect bounds;
    private boolean resizable = true;
    private boolean visible = false;
    private boolean hideOnPause = true;
    private boolean showOnResume = false;
    private boolean containsDocument = false;
    private boolean waitingForInvalidation = false;
    Menu menu;
    MenuView menuView;
    static final String AWTWINDOW_KEY = "awtWindow";
    static final String PANEL_KEY = "panel";
    static final String OWNER_KEY = "owner";
    static final String TYPE_KEY = "type";
    static final String MINSIZE_KEY = "minimumSize";
    static final String MENU_KEY = "menu";
    static final String HIDEONPAUSE_KEY = "hideOnPause";
    static final String CONTAINS_DOCUMENT_KEY = "containsDocument";

    public ExternalWindow() {
        this(1);
    }

    private Frame firstRootViewParentFrame() {
        RootView firstRootView;
        Application app = Application.application();
        if (app != null && (firstRootView = app.firstRootView()) != null) {
            FoundationPanel panel = firstRootView.panel();
            Container parent = panel.getParent();
            while (parent != null && !(parent instanceof Frame)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                return (Frame)parent;
            }
        }
        return this.appletParentFrame();
    }

    private Frame appletParentFrame() {
        Container parent;
        Applet applet = AWTCompatibility.awtApplet();
        if (applet != null) {
            parent = applet.getParent();
            while (parent != null && !(parent instanceof Frame)) {
                parent = parent.getParent();
            }
        } else {
            return null;
        }
        return (Frame)parent;
    }

    private synchronized void validateAWTWindow(int type, boolean modal) {
        if (this.waitingForInvalidation) {
            this.waitingForInvalidation = false;
        }
        if (this.awtWindow == null) {
            Application.application();
            this.panel.rootView();
            if (modal) {
                FoundationDialog dialog = this.createDialog();
                dialog.setExternalWindow(this);
                this.awtWindow = dialog;
            } else if (type == 1) {
                FoundationFrame netcodeFrame = this.createFrame();
                netcodeFrame.setExternalWindow(this);
                this.awtWindow = netcodeFrame;
            } else {
                FoundationWindow netcodeWindow = this.createWindow();
                netcodeWindow.setExternalWindow(this);
                this.awtWindow = netcodeWindow;
            }
            if (this.awtWindow instanceof Dialog) {
                ((Dialog)this.awtWindow).setResizable(this.resizable);
            } else if (this.awtWindow instanceof FoundationFrame) {
                ((FoundationFrame)this.awtWindow).setResizable(this.resizable);
            }
            this.awtWindow.addNotify();
            this.awtWindow.add(this.panel);
            ((Component)this.awtWindow).reshape(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            this.awtWindow.layout();
            if (type == 1) {
                if (this.awtWindow instanceof Dialog) {
                    ((Dialog)this.awtWindow).setTitle(this.title);
                } else {
                    ((FoundationFrame)this.awtWindow).setTitle(this.title);
                }
            }
            if (this.menu != null) {
                ((FoundationFrame)this.awtWindow).setMenuBar(this.menu.awtMenuBar());
            }
        }
    }

    synchronized void invalidateAWTWindow() {
        if (this.waitingForInvalidation) {
            this._invalidateAWTWindow();
        }
        this.waitingForInvalidation = false;
    }

    void _invalidateAWTWindow() {
        if (this.awtWindow != null) {
            this.bounds = this.bounds();
            this.awtWindow.remove(this.panel);
            this.awtWindow.dispose();
            this.awtWindow = null;
        }
    }

    public ExternalWindow(int windowType) {
        Application.application();
        this.title = "";
        this.type = windowType;
        this.panel = this.createPanel();
        this.bounds = new Rect(0, 0, 0, 0);
        this.setBounds(0, 0, 150, 150);
        Application.application().addObserver(this);
    }

    public void setTitle(String aTitle) {
        if (aTitle == null) {
            aTitle = "";
        }
        this.title = aTitle;
        if (this.awtWindow != null && this.type == 1) {
            if (this.awtWindow instanceof Dialog) {
                ((Dialog)this.awtWindow).setTitle(this.title);
                return;
            }
            ((FoundationFrame)this.awtWindow).setTitle(this.title);
        }
    }

    public String title() {
        return this.title;
    }

    public void show() {
        this.validateAWTWindow(this.type, false);
        if (this.owner == null || this.owner.windowWillShow(this)) {
            this.awtWindow.show();
            this.panel.rootView.setVisible(true);
            this.visible = true;
            this.showOnResume = false;
            this.awtWindow.toFront();
            if (this.owner != null) {
                this.owner.windowDidShow(this);
            }
        }
    }

    public void showModally() {
        Application application = Application.application();
        EventLoop eventLoop = Application.application().eventLoop();
        if (this.type == 0) {
            throw new InconsistencyException("Cannot run blank windows modally");
        }
        if (this.owner == null || this.owner.windowWillShow(this)) {
            this.validateAWTWindow(this.type, true);
            ModalDialogManager modalManager = new ModalDialogManager((Dialog)this.awtWindow);
            modalManager.show();
            this.showOnResume = false;
            this.panel.rootView.setVisible(true);
            this.visible = true;
            if (this.owner != null) {
                this.owner.windowDidShow(this);
            }
            application.beginModalSessionForView(this.rootView());
            application.drawAllDirtyViews();
            while (this.isVisible()) {
                Event event = eventLoop.getNextEvent();
                try {
                    eventLoop.processEvent(event);
                }
                catch (Exception e) {
                    System.err.println("Uncaught Exception.");
                    e.printStackTrace(System.err);
                    System.err.println("Restarting modal EventLoop.");
                }
            }
            application.endModalSessionForView(this.rootView());
        }
    }

    public void hide() {
        if (this.awtWindow == null) {
            return;
        }
        if (this.owner == null || this.owner.windowWillHide(this)) {
            if (this.containsDocument() && this.isCurrentDocument()) {
                Application.application().chooseNextCurrentDocumentWindow(this);
            }
            ((Component)this.awtWindow).hide();
            this.visible = false;
            this.panel.rootView.setVisible(false);
            this.showOnResume = false;
            if (this.owner != null) {
                this.owner.windowDidHide(this);
            }
            WindowInvalidationAgent agent = new WindowInvalidationAgent(this);
            this.waitingForInvalidation = true;
            agent.run();
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void dispose() {
        RootView rootView = this.rootView();
        Application app = rootView.application();
        if (this.containsDocument() && this.isCurrentDocument()) {
            app.chooseNextCurrentDocumentWindow(this);
        }
        this.visible = false;
        this._invalidateAWTWindow();
        app.removeObserver(this);
        app.removeRootView(rootView);
        this.panel.rootView.setVisible(false);
        this.panel.rootView = null;
    }

    public void setMenu(Menu aMenu) {
        this.menu = aMenu;
        if (!this.menu.isTopLevel()) {
            throw new InconsistencyException("menu must be main menu");
        }
        this.menu.setApplication(this.rootView().application());
        MenuBar menuBar = this.menu.awtMenuBar();
        if (this.awtWindow != null) {
            ((FoundationFrame)this.awtWindow).setMenuBar(menuBar);
        }
    }

    public Menu menu() {
        return this.menu;
    }

    public void setMenuView(MenuView aMenuView) {
        if (aMenuView != null && aMenuView == this.menuView) {
            return;
        }
        if (this.menuView != null) {
            this.menuView.removeFromSuperview();
        }
        this.menuView = aMenuView;
        int x = this.rootView().bounds.x;
        int y = this.rootView().bounds.y;
        int width = this.rootView().bounds.width;
        int height = this.menuView.height();
        this.menuView.setBounds(x, y, width, height);
        this.addSubview(this.menuView);
    }

    public MenuView menuView() {
        return this.menuView;
    }

    public RootView rootView() {
        return this.panel.rootView;
    }

    Application application() {
        return Application.application();
    }

    public void setOwner(WindowOwner wOwner) {
        this.owner = wOwner;
    }

    public WindowOwner owner() {
        return this.owner;
    }

    void didBecomeMain() {
        if (this.owner != null) {
            this.owner.windowDidBecomeMain(this);
        }
        if (this.containsDocument()) {
            Application.application().makeCurrentDocumentWindow(this);
        }
    }

    void didResignMain() {
        if (this.owner != null) {
            this.owner.windowDidResignMain(this);
        }
    }

    public Size contentSize() {
        RootView rootView = this.rootView();
        if (rootView == null) {
            return null;
        }
        return new Size(rootView.bounds.width, rootView.bounds.height);
    }

    public void addSubview(View aView) {
        RootView rootView = this.rootView();
        if (rootView != null) {
            rootView.addSubview(aView);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean sizeChanged = false;
        if (this.owner != null && (this.bounds.width != width || this.bounds.height != height)) {
            Size deltaSize = new Size(width - this.bounds.width, height - this.bounds.height);
            this.owner.windowWillSizeBy(this, deltaSize);
            width = this.bounds.width + deltaSize.width;
            height = this.bounds.height + deltaSize.height;
        }
        if (this.bounds.x != x || this.bounds.y != y || this.bounds.width != width || this.bounds.height != height) {
            if (this.bounds.width != width || this.bounds.height != height) {
                sizeChanged = true;
            }
            this.bounds.setBounds(x, y, width, height);
            if (this.awtWindow != null) {
                ((Component)this.awtWindow).reshape(x, y, width, height);
                Rectangle wBounds = this.awtWindow.bounds();
                this.bounds.setBounds(wBounds.x, wBounds.y, wBounds.width, wBounds.height);
                this.awtWindow.layout();
            }
        }
        if (sizeChanged && this.awtWindow == null) {
            this.validateAWTWindow(this.type, false);
            this._invalidateAWTWindow();
        }
    }

    void validateBounds() {
        if (this.awtWindow != null) {
            Point location = this.awtWindow.location();
            Dimension size = this.awtWindow.size();
            Rect newBounds = new Rect(location.x, location.y, size.width, size.height);
            if (!newBounds.equals(this.bounds)) {
                Size deltaSize = new Size(newBounds.width - this.bounds.width, newBounds.height - this.bounds.height);
                if (this.owner != null) {
                    this.owner.windowWillSizeBy(this, deltaSize);
                }
                this.bounds.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
            }
        }
    }

    public void setBounds(Rect newBounds) {
        this.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
    }

    public void sizeTo(int width, int height) {
        this.setBounds(this.bounds.x, this.bounds.y, width, height);
    }

    public void sizeBy(int deltaWidth, int deltaHeight) {
        this.setBounds(this.bounds.x, this.bounds.y, this.bounds.width + deltaWidth, this.bounds.height + deltaHeight);
    }

    public void moveBy(int deltaX, int deltaY) {
        this.setBounds(this.bounds.x + deltaX, this.bounds.y + deltaY, this.bounds.width, this.bounds.height);
    }

    public void center() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Rect b = new Rect(this.bounds());
        b.x = (int)Math.floor((double)(screenSize.width - b.width) / 2.0);
        b.y = (int)Math.floor((double)(screenSize.height - b.height) / 2.0);
        this.setBounds(b);
    }

    public void moveTo(int x, int y) {
        this.setBounds(x, y, this.bounds.width, this.bounds.height);
    }

    public Size windowSizeForContentSize(int width, int height) {
        boolean hasAWTWindow;
        boolean bl = hasAWTWindow = this.awtWindow != null;
        if (!hasAWTWindow) {
            this.validateAWTWindow(this.type, false);
        }
        Insets insets = this.awtWindow.insets();
        if (!hasAWTWindow) {
            this._invalidateAWTWindow();
        }
        return new Size(width + insets.left + insets.right, height + insets.top + insets.bottom);
    }

    public View viewForMouse(int x, int y) {
        return this.rootView().viewForMouse(x, y);
    }

    public void setMinSize(int width, int height) {
        this.minimumSize = new Size(width, height);
    }

    public Size minSize() {
        return this.minimumSize;
    }

    public Rect bounds() {
        if (this.awtWindow != null) {
            Point location = this.awtWindow.location();
            Dimension size = this.awtWindow.size();
            return new Rect(location.x, location.y, size.width, size.height);
        }
        return new Rect(this.bounds);
    }

    public void setResizable(boolean flag) {
        this.resizable = flag;
        if (this.awtWindow != null) {
            throw new InconsistencyException("Cannot call setResizable on a visible external window");
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public FoundationPanel panel() {
        return this.panel;
    }

    public void setContainsDocument(boolean containsDocument) {
        this.containsDocument = containsDocument;
        if (!containsDocument && Application.application().currentDocumentWindow() == this) {
            Application.application().chooseNextCurrentDocumentWindow(this);
            return;
        }
        if (containsDocument && Application.application().firstRootView() == this.rootView()) {
            Application.application().makeCurrentDocumentWindow(this);
        }
    }

    public boolean containsDocument() {
        return this.containsDocument;
    }

    public void didBecomeCurrentDocument() {
    }

    public void didResignCurrentDocument() {
    }

    public boolean isCurrentDocument() {
        return Application.application().currentDocumentWindow() == this;
    }

    protected FoundationDialog createDialog() {
        return new FoundationDialog(this.firstRootViewParentFrame(), true);
    }

    protected FoundationFrame createFrame() {
        return new FoundationFrame();
    }

    protected FoundationWindow createWindow() {
        return new FoundationWindow(this.appletParentFrame());
    }

    protected FoundationPanel createPanel() {
        return new FoundationPanel();
    }

    public void applicationDidStart(Application application) {
    }

    public void applicationDidStop(Application application) {
        this.dispose();
    }

    public void focusDidChange(Application application, View focusedView) {
    }

    public void currentDocumentDidChange(Application application, Window document) {
    }

    public void applicationDidPause(Application application) {
        if (this.hideOnPause && this.visible) {
            this.hide();
            this.showOnResume = true;
        }
    }

    public void applicationDidResume(Application application) {
        if (this.showOnResume) {
            this.show();
        }
    }

    public void setHidesWhenPaused(boolean flag) {
        this.hideOnPause = flag;
    }

    public boolean hidesWhenPaused() {
        return this.hideOnPause;
    }

    public void performCommand(String command, Object data) {
        if ("show".equals(command)) {
            this.show();
            return;
        }
        if ("hide".equals(command)) {
            this.hide();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + command);
    }

    public void moveToFront() {
        if (!this.isVisible()) {
            return;
        }
        this.awtWindow.toFront();
    }

    public void moveToBack() {
        if (!this.isVisible()) {
            return;
        }
        this.awtWindow.toBack();
    }
}

