/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Button;
import netscape.application.Color;
import netscape.application.Event;
import netscape.application.EventLoop;
import netscape.application.Font;
import netscape.application.Graphics;
import netscape.application.InternalWindowBorder;
import netscape.application.MenuView;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.RootView;
import netscape.application.Size;
import netscape.application.View;
import netscape.application.Window;
import netscape.application.WindowContentView;
import netscape.application.WindowOwner;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class InternalWindow
extends View
implements Window {
    RootView rootView = this.application().mainRootView();
    WindowOwner _owner;
    WindowContentView _contentView;
    View _focusedView;
    View _defaultSelectedView;
    Button _closeButton;
    MenuView menuView;
    Font _titleFont = Font.fontNamed("Helvetica", 1, 12);
    String _title = "";
    Border _border;
    int _layer;
    int _type = 1;
    int _lastX;
    int _lastY;
    int _resizePart = 0;
    boolean _closeable;
    boolean _resizable;
    boolean _canBecomeMain = true;
    boolean _containsDocument = false;
    boolean _drewOnLastDrag;
    boolean _drawToBackingStore;
    boolean _onscreen = true;
    boolean _createdDrawingBuffer;
    boolean transparent = false;
    boolean scrollToVisible;
    static Vector _resizeWindowVector = new Vector();
    static final int ABOVE = 0;
    static final int BEHIND = 1;
    static final int NO_PART = 0;
    static final int LEFT_PART = 1;
    static final int MIDDLE_PART = 2;
    static final int RIGHT_PART = 3;
    static final String ownerKey = "owner";
    static final String contentViewKey = "contentView";
    static final String focusedViewKey = "focusedView";
    static final String closeButtonKey = "closeButton";
    static final String titleFontKey = "titleFont";
    static final String titleKey = "title";
    static final String borderKey = "border";
    static final String layerKey = "layer";
    static final String typeKey = "type";
    static final String closeableKey = "closeable";
    static final String resizableKey = "resizeable";
    static final String canBecomeMainKey = "canBecomeMain";
    static final String containsDocumentKey = "canBecomeDocument";
    static final String onscreenKey = "onscreen";
    static final String transparentKey = "transparent";
    static final String scrollToVisibleKey = "scrollToVisible";
    static final String defaultSelectedViewKey = "defaultSelectedView";
    static final String menuViewKey = "menuView";
    public static final int DEFAULT_LAYER = 0;
    public static final int PALETTE_LAYER = 100;
    public static final int MODAL_LAYER = 200;
    public static final int POPUP_LAYER = 300;
    public static final int DRAG_LAYER = 400;
    public static final int IGNORE_WINDOW_CLIPVIEW_LAYER = 500;

    public InternalWindow() {
        this(0, 0, 0, 0);
    }

    public InternalWindow(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public InternalWindow(int x, int y, int width, int height) {
        this(1, x, y, width, height);
    }

    public InternalWindow(int type, int x, int y, int width, int height) {
        super(x, y, width, height);
        this._contentView = new WindowContentView(0, 0, 1, 1);
        this._contentView.setHorizResizeInstruction(2);
        this._contentView.setVertResizeInstruction(16);
        this.addSubviewToWindow(this._contentView);
        this._layer = 0;
        this._border = new InternalWindowBorder(this);
        this.layoutParts();
        this.setType(type);
        this._defaultSelectedView = this;
    }

    int menuViewHeight() {
        if (this.menuView == null) {
            return 0;
        }
        return this.menuView.height();
    }

    int titleBarMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.topMargin();
    }

    int leftBorderMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.leftMargin();
    }

    int rightBorderMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.rightMargin();
    }

    int bottomBorderMargin() {
        if (this._type == 0) {
            return 0;
        }
        return this._border.bottomMargin();
    }

    public WindowContentView contentView() {
        return this._contentView;
    }

    public Size contentSize() {
        if (this._contentView == null) {
            return null;
        }
        return new Size(this._contentView.bounds.width, this._contentView.bounds.height);
    }

    public void layoutParts() {
        if (this._contentView != null) {
            this._contentView.setAutoResizeSubviews(false);
            this._contentView.setBounds(this.leftBorderMargin(), this.titleBarMargin() + this.menuViewHeight(), this.bounds.width - (this.leftBorderMargin() + this.rightBorderMargin()), this.bounds.height - (this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin()));
            this._contentView.setAutoResizeSubviews(true);
        }
        if (this._closeButton != null) {
            this._closeButton.removeFromSuperview();
            this._closeButton.moveTo(0, 2 + (this.titleBarMargin() - 4 - this._closeButton.bounds.height) / 2);
            if (this._closeable) {
                this.addSubview(this._closeButton);
            }
        }
    }

    public void addSubview(View aView) {
        if (aView == this._contentView || aView == this._closeButton) {
            this.addSubviewToWindow(aView);
            return;
        }
        if (this._contentView != null) {
            this._contentView.addSubview(aView);
        }
    }

    public void addSubviewToWindow(View aView) {
        super.addSubview(aView);
    }

    public void setRootView(RootView rView) {
        if (this.rootView != rView && this.rootView != null && this._superview != null) {
            this.rootView.removeWindow(this);
        }
        this.rootView = rView;
    }

    public void show() {
        if (this.rootView == null) {
            throw new InconsistencyException("Can't show Window.  No RootView");
        }
        if (this._owner == null || this._owner.windowWillShow(this)) {
            if (this._superview == null) {
                this.rootView.addWindowRelativeTo(this, 0, null);
            } else {
                this.rootView.makeWindowVisible(this, 0, null);
            }
            if (this._owner != null) {
                this._owner.windowDidShow(this);
            }
        }
    }

    public void showModally() {
        Application application = Application.application();
        EventLoop eventLoop = application.eventLoop();
        int previousLayer = this.layer();
        if (previousLayer < 200) {
            this.setLayer(200);
        }
        this.show();
        this.rootView()._setMainWindow(this);
        application.beginModalSessionForView(this);
        application.drawAllDirtyViews();
        while (this.isVisible()) {
            Event event = eventLoop.getNextEvent();
            try {
                eventLoop.processEvent(event);
            }
            catch (Exception e) {
                System.err.println("Uncaught Exception.");
                e.printStackTrace(System.err);
                System.err.println("Restarting modal EventLoop.");
            }
        }
        application.endModalSessionForView(this);
        if (previousLayer != this.layer()) {
            this.setLayer(previousLayer);
        }
    }

    public void showInFrontOf(InternalWindow aWindow) {
        if (aWindow.rootView != this.rootView) {
            this.setRootView(aWindow.rootView);
            this.rootView.addWindowRelativeTo(this, 0, aWindow);
            return;
        }
        if (this._superview == null) {
            this.rootView.addWindowRelativeTo(this, 0, aWindow);
            return;
        }
        this.rootView.makeWindowVisible(this, 0, aWindow);
    }

    public void showBehind(InternalWindow aWindow) {
        if (aWindow.rootView != this.rootView) {
            this.setRootView(aWindow.rootView);
            this.rootView.addWindowRelativeTo(this, 1, aWindow);
            return;
        }
        if (this._superview == null) {
            this.rootView.addWindowRelativeTo(this, 1, aWindow);
        }
    }

    public void moveToFront() {
        if (!this.isVisible()) {
            return;
        }
        InternalWindow topWindow = this.rootView.frontWindowWithLayer(this.layer());
        if (topWindow != null && topWindow != this) {
            this.rootView.makeWindowVisible(this, 0, topWindow);
        }
    }

    public void moveToBack() {
        if (!this.isVisible()) {
            return;
        }
        InternalWindow bottomWindow = this.rootView.backWindowWithLayer(this.layer());
        if (bottomWindow != null && bottomWindow != this) {
            this.rootView.makeWindowVisible(this, 1, bottomWindow);
        }
    }

    public void hide() {
        if (this.isVisible() && (this._owner == null || this._owner.windowWillHide(this))) {
            RootView rView;
            if (this.containsDocument() && this.isCurrentDocument()) {
                Application.application().chooseNextCurrentDocumentWindow(this);
            }
            if ((rView = this.rootView()) != null) {
                rView.removeWindow(this);
            }
            if (this._owner != null) {
                this._owner.windowDidHide(this);
            }
        }
    }

    public void setCanBecomeMain(boolean flag) {
        this._canBecomeMain = flag;
        if (this.isMain() && !this._canBecomeMain && this.rootView != null) {
            this.rootView._setMainWindow(null);
        }
    }

    public boolean canBecomeMain() {
        return this._canBecomeMain;
    }

    public boolean isVisible() {
        return this._superview != null;
    }

    public void setOnscreenAtStartup(boolean flag) {
        this._onscreen = flag;
    }

    public boolean onscreenAtStartup() {
        return this._onscreen;
    }

    public boolean isMain() {
        return this.rootView != null && this.rootView.mainWindow() == this;
    }

    protected Button createCloseButton() {
        Button button = new Button(0, 0, 1, 1);
        button.setImage(Bitmap.bitmapNamed("netscape/application/CloseButton.gif"));
        button.setAltImage(Bitmap.bitmapNamed("netscape/application/CloseButtonActive.gif"));
        button.setTransparent(true);
        button.sizeToMinSize();
        button.setHorizResizeInstruction(0);
        button.setVertResizeInstruction(4);
        button.moveTo(0, 2 + (this.titleBarMargin() - 4 - button.bounds.height) / 2);
        button.setTarget(this);
        button.setCommand("hide");
        button.removeAllCommandsForKeys();
        return button;
    }

    public void setCloseable(boolean flag) {
        this._closeable = flag;
        if (this._type == 0) {
            this._closeable = false;
        }
        if (this._closeable && this._closeButton == null) {
            this._closeButton = this.createCloseButton();
        }
        if (this._closeable) {
            this.addSubviewToWindow(this._closeButton);
            return;
        }
        if (this._closeButton != null) {
            this._closeButton.removeFromSuperview();
        }
    }

    public boolean isCloseable() {
        return this._closeable;
    }

    public void setResizable(boolean flag) {
        if (flag != this._resizable) {
            this._resizable = flag;
            if (this._resizable) {
                this._contentView.setHorizResizeInstruction(2);
                this._contentView.setVertResizeInstruction(16);
            }
            if (this._type == 1) {
                this.drawBottomBorder();
                this.layoutParts();
            }
        }
    }

    public boolean isResizable() {
        return this._resizable;
    }

    int resizePartWidth() {
        if (this._border instanceof InternalWindowBorder) {
            return ((InternalWindowBorder)this._border).resizePartWidth();
        }
        return 0;
    }

    public Size windowSizeForContentSize(int width, int height) {
        return new Size(width + this.leftBorderMargin() + this.rightBorderMargin(), height + this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin());
    }

    public void setTitle(String aString) {
        if (this._title != null && aString != null && this._title.equals(aString)) {
            return;
        }
        this._title = aString;
        this.drawTitleBar();
    }

    public String title() {
        return this._title;
    }

    public void setBorder(Border border) {
        this._border = border;
    }

    public Border border() {
        return this._border;
    }

    public void setLayer(int windowLayer) {
        this._layer = windowLayer;
    }

    public int layer() {
        return this._layer;
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        this.setMinSize(this.resizePartWidth() * 2 + 1, this.titleBarMargin() + this.menuViewHeight() + 2);
        if (this._type == 0) {
            this._minSize.width = 0;
            this._minSize.height = 0;
            return this._minSize;
        }
        if (this._minSize.width < this.leftBorderMargin() + this.rightBorderMargin()) {
            this._minSize.width = this.leftBorderMargin() + this.rightBorderMargin();
        }
        if (this._minSize.height < this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin()) {
            this._minSize.height = this.titleBarMargin() + this.menuViewHeight() + this.bottomBorderMargin();
        }
        return new Size(this._minSize);
    }

    public void setOwner(WindowOwner anObject) {
        this._owner = anObject;
    }

    public WindowOwner owner() {
        return this._owner;
    }

    public void setMenuView(MenuView aMenuView) {
        if (aMenuView != null && aMenuView == this.menuView) {
            return;
        }
        if (this.menuView != null) {
            this.menuView.removeFromSuperview();
        }
        this.menuView = aMenuView;
        int x = this.leftBorderMargin();
        int y = this.titleBarMargin();
        int width = this.bounds.width - (this.leftBorderMargin() + this.rightBorderMargin());
        int height = this.menuView.height();
        if (height == 0) {
            height = this.menuView.minSize().height;
        }
        this.menuView.setBounds(x, y, width, height);
        this.addSubviewToWindow(this.menuView);
        this.layoutParts();
    }

    public MenuView menuView() {
        return this.menuView;
    }

    public boolean isPointInBorder(int x, int y) {
        if (this._type == 0) {
            return Rect.contains(0, 0, this.bounds.width, this.bounds.height, x, y);
        }
        if (this._resizable && y > this.bounds.height - this.bottomBorderMargin()) {
            this._resizePart = x < this.resizePartWidth() ? 1 : (x > this.bounds.width - this.resizePartWidth() ? 3 : 2);
            return true;
        }
        return y <= this.titleBarMargin();
    }

    public View viewForMouse(int x, int y) {
        View theView = super.viewForMouse(x, y);
        if (this._type == 0 && theView == this._contentView) {
            theView = this;
        }
        return theView;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
        if (this.transparent) {
            this._contentView.setTransparent(true);
            this.setBuffered(true);
            return;
        }
        this.setBuffered(false);
        this._contentView.setTransparent(false);
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void setType(int windowType) {
        this._type = windowType;
        if (this._type == 0) {
            this.setCanBecomeMain(false);
            this.setCloseable(false);
        }
        this.layoutParts();
    }

    public int type() {
        return this._type;
    }

    void updateDrawingBuffer() {
        View bufferView;
        InternalWindow nextWindow;
        if (this.drawingBuffer == null) {
            return;
        }
        if (this.rootView == null) {
            throw new InconsistencyException("Can't draw window - no RootView");
        }
        Rect windowRect = Rect.newRect();
        this.rootView.disableWindowsAbove(this, true);
        this.reenableDrawing();
        Graphics bufferedGraphics = this.drawingBuffer.createGraphics();
        bufferedGraphics.setDebugOptions(this.shouldDebugGraphics());
        this.superview().convertRectToView(null, this.bounds, windowRect);
        bufferedGraphics.pushState();
        bufferedGraphics.translate(-windowRect.x, -windowRect.y);
        this.rootView.draw(bufferedGraphics, windowRect);
        bufferedGraphics.popState();
        int count = this.isTransparent() ? this.rootView.windows.count() : this.rootView.windows.indexOf(this);
        int start = 0;
        int i = count;
        while (i-- > 0 && start == 0) {
            nextWindow = (InternalWindow)this.rootView.windows.elementAt(i);
            if (nextWindow.isTransparent() || !nextWindow.bounds.contains(this.bounds)) continue;
            start = i;
        }
        if (start == 0 && (bufferView = this.rootView.viewWithBuffer(this.rootView, windowRect)) != null) {
            Rect bufferRect = Rect.newRect(0, 0, this.width(), this.height());
            this.convertRectToView(bufferView, bufferRect, bufferRect);
            bufferedGraphics.pushState();
            bufferedGraphics.translate(-bufferRect.x, -bufferRect.y);
            bufferView.draw(bufferedGraphics, bufferRect);
            bufferedGraphics.popState();
            Rect.returnRect(bufferRect);
        }
        i = start;
        while (i < count) {
            nextWindow = (InternalWindow)this.rootView.windows.elementAt(i);
            if (nextWindow.bounds.intersects(this.bounds)) {
                windowRect.setBounds(0, 0, this.width(), this.height());
                this.convertRectToView(nextWindow, windowRect, windowRect);
                bufferedGraphics.pushState();
                bufferedGraphics.translate(-windowRect.x, -windowRect.y);
                nextWindow.draw(bufferedGraphics, windowRect);
                bufferedGraphics.popState();
            }
            ++i;
        }
        Rect.returnRect(windowRect);
        this.rootView.disableWindowsAbove(this, false);
        this.reenableDrawing();
        bufferedGraphics.dispose();
    }

    public boolean mouseDown(MouseEvent event) {
        this.rootView.makeWindowVisible(this, 0, null);
        if (!this.isPointInBorder(event.x, event.y)) {
            return false;
        }
        this._lastX = event.x + this.bounds.x;
        this._lastY = event.y + this.bounds.y;
        if (this._resizePart != 0) {
            InternalWindow window = new InternalWindow(this.bounds.x, this.bounds.y, 1, this.bounds.height);
            window.setType(0);
            window._contentView.setTransparent(false);
            window._contentView.setBackgroundColor(Color.darkGray);
            window.setLayer(400);
            window.setVertResizeInstruction(16);
            window.setRootView(this.rootView());
            window.show();
            _resizeWindowVector.addElement(window);
            window = new InternalWindow(this.bounds.maxX() - 1, this.bounds.y, 1, this.bounds.height);
            window.setType(0);
            window._contentView.setTransparent(false);
            window._contentView.setBackgroundColor(Color.darkGray);
            window.setLayer(400);
            window.setVertResizeInstruction(16);
            window.setRootView(this.rootView());
            window.show();
            _resizeWindowVector.addElement(window);
            window = new InternalWindow(this.bounds.x + 1, this.bounds.y, this.bounds.width - 2, 1);
            window.setType(0);
            window._contentView.setTransparent(false);
            window._contentView.setBackgroundColor(Color.darkGray);
            window.setLayer(400);
            window.setHorizResizeInstruction(2);
            window.setRootView(this.rootView());
            window.show();
            _resizeWindowVector.addElement(window);
            window = new InternalWindow(this.bounds.x + 1, this.bounds.maxY() - 1, this.bounds.width - 2, 1);
            window.setType(0);
            window._contentView.setTransparent(false);
            window._contentView.setBackgroundColor(Color.darkGray);
            window.setLayer(400);
            window.setHorizResizeInstruction(2);
            window.setRootView(this.rootView());
            window.show();
            _resizeWindowVector.addElement(window);
            return true;
        }
        return true;
    }

    public void setBounds(int x, int y, int width, int height) {
        int dx = x - this.bounds.x;
        int dy = y - this.bounds.y;
        int dw = width - this.bounds.width;
        int dh = height - this.bounds.height;
        if (this.isVisible()) {
            this.moveByAndSizeBy(dx, dy, dw, dh);
            return;
        }
        this._moveBy(dx, dy);
        this._sizeBy(dw, dh);
        this._setBounds(x, y, width, height);
    }

    private void _super_moveBy(int dx, int dy) {
        if (dx == 0 && dy == 0) {
            return;
        }
        this._setBounds(this.bounds.x + dx, this.bounds.y + dy, this.bounds.width, this.bounds.height);
        if (this._superview != null) {
            this._superview.subviewDidMove(this);
        }
        this.didMoveBy(dx, dy);
    }

    private void _super_sizeBy(int dw, int dh) {
        if (dw == 0 && dh == 0) {
            return;
        }
        this._setBounds(this.bounds.x, this.bounds.y, this.bounds.width + dw, this.bounds.height + dh);
        if (this.buffered) {
            if (this.bounds.width != 0 && this.bounds.height != 0) {
                this.drawingBuffer = new Bitmap(this.bounds.width, this.bounds.height);
                this.drawingBufferValid = false;
            } else if (this.drawingBuffer != null) {
                this.drawingBuffer.flush();
                this.drawingBuffer = null;
            }
        }
        this.disableDrawing();
        if (this._superview != null) {
            this._superview.subviewDidResize(this);
        }
        super.didSizeBy(dw, dh);
        this.reenableDrawing();
    }

    protected void willMoveTo(Point newPoint) {
    }

    private void _moveBy(int deltaX, int deltaY) {
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        Point tmpPoint = Point.newPoint(this.bounds.x + deltaX, this.bounds.y + deltaY);
        this.willMoveTo(tmpPoint);
        deltaX = tmpPoint.x - this.bounds.x;
        deltaY = tmpPoint.y - this.bounds.y;
        Point.returnPoint(tmpPoint);
        if (!this.isVisible()) {
            this._super_moveBy(deltaX, deltaY);
            return;
        }
        this._lastX = this.bounds.x;
        this._lastY = this.bounds.y;
        MouseEvent moveEvent = new MouseEvent(0L, -2, this._lastX + deltaX, this._lastY + deltaY, 0);
        this.mouseDragged(moveEvent);
    }

    void _checkSize(Size deltaSize) {
        Size minSize = this.minSize();
        if (this.bounds.width + deltaSize.width < minSize.width) {
            deltaSize.width = minSize.width - this.bounds.width;
        }
        if (this.bounds.height + deltaSize.height < minSize.height) {
            deltaSize.height = minSize.height - this.bounds.height;
        }
        if (this._owner != null) {
            this._owner.windowWillSizeBy(this, deltaSize);
        }
    }

    private void _sizeBy(int deltaWidth, int deltaHeight) {
        if (deltaWidth == 0 && deltaHeight == 0) {
            return;
        }
        Size tmpSize = Size.newSize(deltaWidth, deltaHeight);
        this._checkSize(tmpSize);
        deltaWidth = tmpSize.width;
        deltaHeight = tmpSize.height;
        Size.returnSize(tmpSize);
        if (!this.isVisible()) {
            this._super_sizeBy(deltaWidth, deltaHeight);
            this.layoutParts();
            return;
        }
        Rect tmpRect = Rect.newRect(this.bounds);
        this._super_sizeBy(deltaWidth, deltaHeight);
        this.layoutParts();
        if (this.canDraw()) {
            tmpRect.unionWith(this.bounds);
            this.superview().convertRectToView(null, tmpRect, tmpRect);
            this.rootView.redraw(tmpRect);
        }
        Rect.returnRect(tmpRect);
    }

    private void moveByAndSizeBy(int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
        if (deltaX == 0 && deltaY == 0 && deltaWidth == 0 && deltaHeight == 0) {
            return;
        }
        Size tmpSize = Size.newSize(deltaWidth, deltaHeight);
        this._checkSize(tmpSize);
        deltaWidth = tmpSize.width;
        deltaHeight = tmpSize.height;
        Size.returnSize(tmpSize);
        Point tmpPoint = Point.newPoint(this.bounds.x + deltaX, this.bounds.y + deltaY);
        this.willMoveTo(tmpPoint);
        deltaX = tmpPoint.x - this.bounds.x;
        deltaY = tmpPoint.y - this.bounds.y;
        Point.returnPoint(tmpPoint);
        if (!this.isVisible()) {
            this._super_moveBy(deltaX, deltaY);
            this._super_sizeBy(deltaWidth, deltaHeight);
            this.layoutParts();
            return;
        }
        Rect tmpRect = Rect.newRect(this.bounds);
        this._super_moveBy(deltaX, deltaY);
        this._super_sizeBy(deltaWidth, deltaHeight);
        if (deltaWidth != 0 || deltaHeight != 0) {
            this.layoutParts();
        }
        tmpRect.unionWith(this.bounds);
        if (this.superview() != this.rootView) {
            this.superview().convertRectToView(this.rootView, tmpRect, tmpRect);
        }
        if (this.isTransparent()) {
            this.disableDrawing();
            this.rootView.redraw(tmpRect);
            this.reenableDrawing();
            this.draw();
        } else {
            this.rootView.redraw(tmpRect);
        }
        Rect.returnRect(tmpRect);
    }

    private void moveToAndSizeTo(int x, int y, int width, int height) {
        this.moveByAndSizeBy(x - this.bounds.x, y - this.bounds.y, width - this.bounds.width, height - this.bounds.height);
    }

    public void setScrollsToVisible(boolean flag) {
        this.scrollToVisible = flag;
    }

    public boolean scrollsToVisible() {
        return this.scrollToVisible;
    }

    public void scrollRectToVisible(Rect aRect) {
        int deltaX = 0;
        int deltaY = 0;
        if (!this.scrollToVisible) {
            return;
        }
        Rect visibleRect = Rect.newRect();
        this.computeVisibleRect(visibleRect);
        if (visibleRect.width == this.bounds.width && visibleRect.height == this.bounds.height) {
            Rect.returnRect(visibleRect);
            return;
        }
        if (!visibleRect.contains(aRect)) {
            this.convertRectToView(null, visibleRect, visibleRect);
            Rect tmpRect = Rect.newRect();
            this.convertRectToView(null, aRect, tmpRect);
            Rect absoluteBounds = Rect.newRect(0, 0, this.width(), this.height());
            this.convertRectToView(null, absoluteBounds, absoluteBounds);
            if (tmpRect.x < visibleRect.x && visibleRect.x > absoluteBounds.x) {
                deltaX = visibleRect.x - tmpRect.x;
            } else if (tmpRect.maxX() > visibleRect.maxX() && visibleRect.maxX() < absoluteBounds.maxX()) {
                deltaX = visibleRect.maxX() - tmpRect.maxX();
            }
            if (tmpRect.y < visibleRect.y && visibleRect.y > absoluteBounds.y) {
                deltaY = visibleRect.y - tmpRect.y;
            } else if (tmpRect.maxY() > visibleRect.maxY() && visibleRect.maxY() < absoluteBounds.maxY()) {
                deltaY = visibleRect.maxY() - tmpRect.maxY();
            }
            Rect backgroundBounds = this.rootView().bounds;
            if (deltaX > 0 && absoluteBounds.x + deltaX > 3) {
                deltaX = 3 - absoluteBounds.x;
            } else if (deltaX < 0 && absoluteBounds.maxX() + deltaX < backgroundBounds.maxX() - 3) {
                deltaX = backgroundBounds.maxX() - 3 - absoluteBounds.maxX();
            }
            if (deltaY > 0 && absoluteBounds.y + deltaY > 3) {
                deltaY = 3 - absoluteBounds.y;
            } else if (deltaY < 0 && absoluteBounds.maxY() + deltaY < backgroundBounds.maxY() - 3) {
                deltaY = backgroundBounds.maxY() - 3 - absoluteBounds.maxY();
            }
            this.moveBy(deltaX, deltaY);
            Rect.returnRect(tmpRect);
            Rect.returnRect(absoluteBounds);
        }
        Rect.returnRect(visibleRect);
    }

    public void subviewDidResize() {
    }

    public void center() {
        Rect rootViewBounds = this.rootView.bounds;
        Rect newBounds = new Rect((rootViewBounds.width - this.bounds.width) / 2, (rootViewBounds.height - this.bounds.height) / 2, this.bounds.width, this.bounds.height);
        if (newBounds.y < 0) {
            newBounds.y = 0;
        }
        this.setBounds(newBounds);
    }

    void mouseResizeDrag(MouseEvent event) {
        int deltaY = 0;
        event.x += this.bounds.x;
        event.y += this.bounds.y;
        if (this._resizePart == 2) {
            event.x = this._lastX;
        }
        Rect newBounds = Rect.newRect(this.bounds);
        if (this._resizePart == 1) {
            newBounds.moveBy(event.x - this._lastX, 0);
            newBounds.sizeBy(this._lastX - event.x, event.y - this._lastY);
        } else {
            newBounds.sizeBy(event.x - this._lastX, event.y - this._lastY);
        }
        if (newBounds.height > this.superview().height() - newBounds.y) {
            newBounds.sizeBy(0, this.superview().height() - newBounds.height - newBounds.y);
        }
        Size tmpSize = Size.newSize(newBounds.width - this.bounds.width, newBounds.height - this.bounds.height);
        this._checkSize(tmpSize);
        if (this._resizePart == 1) {
            if (newBounds.x > this.bounds.x + this.bounds.width) {
                newBounds.moveBy(this.bounds.x - newBounds.x - tmpSize.width, 0);
            } else {
                newBounds.moveBy(newBounds.width - this.bounds.width - tmpSize.width, 0);
            }
        }
        newBounds.sizeBy(tmpSize.width - (newBounds.width - this.bounds.width), tmpSize.height - (newBounds.height - this.bounds.height));
        Size.returnSize(tmpSize);
        InternalWindow window = (InternalWindow)_resizeWindowVector.elementAt(0);
        deltaY = newBounds.height - window.bounds.height;
        if (this._resizePart == 1) {
            if (deltaY < 0) {
                window = (InternalWindow)_resizeWindowVector.elementAt(1);
                window.sizeTo(1, newBounds.height);
                window = (InternalWindow)_resizeWindowVector.elementAt(2);
                window.moveToAndSizeTo(newBounds.x + 1, newBounds.y, newBounds.width - 2, 1);
                window = (InternalWindow)_resizeWindowVector.elementAt(3);
                window.moveToAndSizeTo(newBounds.x + 1, newBounds.maxY() - 1, newBounds.width - 2, 1);
                window = (InternalWindow)_resizeWindowVector.elementAt(0);
                window.moveToAndSizeTo(newBounds.x, newBounds.y, 1, newBounds.height);
            } else {
                window = (InternalWindow)_resizeWindowVector.elementAt(0);
                window.moveToAndSizeTo(newBounds.x, newBounds.y, 1, newBounds.height);
                window = (InternalWindow)_resizeWindowVector.elementAt(3);
                window.moveToAndSizeTo(newBounds.x + 1, newBounds.maxY() - 1, newBounds.width - 2, 1);
                window = (InternalWindow)_resizeWindowVector.elementAt(2);
                window.moveToAndSizeTo(newBounds.x + 1, newBounds.y, newBounds.width - 2, 1);
                window = (InternalWindow)_resizeWindowVector.elementAt(1);
                window.sizeTo(1, newBounds.height);
            }
        } else if (this._resizePart == 2) {
            if (deltaY < 0) {
                window = (InternalWindow)_resizeWindowVector.elementAt(1);
                window.sizeTo(1, newBounds.height);
                window = (InternalWindow)_resizeWindowVector.elementAt(0);
                window.sizeTo(1, newBounds.height);
                window = (InternalWindow)_resizeWindowVector.elementAt(3);
                window.moveToAndSizeTo(newBounds.x + 1, newBounds.maxY() - 1, window.bounds.width, window.bounds.height);
            } else {
                window = (InternalWindow)_resizeWindowVector.elementAt(3);
                window.moveToAndSizeTo(newBounds.x + 1, newBounds.maxY() - 1, window.bounds.width, window.bounds.height);
                window = (InternalWindow)_resizeWindowVector.elementAt(1);
                window.sizeTo(1, newBounds.height);
                window = (InternalWindow)_resizeWindowVector.elementAt(0);
                window.sizeTo(1, newBounds.height);
            }
        } else if (deltaY < 0) {
            window = (InternalWindow)_resizeWindowVector.elementAt(0);
            window.sizeTo(1, newBounds.height);
            window = (InternalWindow)_resizeWindowVector.elementAt(2);
            window.sizeTo(newBounds.width - 2, 1);
            window = (InternalWindow)_resizeWindowVector.elementAt(3);
            window.moveToAndSizeTo(newBounds.x + 1, newBounds.maxY() - 1, newBounds.width - 2, 1);
            window = (InternalWindow)_resizeWindowVector.elementAt(1);
            window.moveToAndSizeTo(newBounds.maxX() - 1, newBounds.y, 1, newBounds.height);
        } else {
            window = (InternalWindow)_resizeWindowVector.elementAt(1);
            window.moveToAndSizeTo(newBounds.maxX() - 1, newBounds.y, 1, newBounds.height);
            window = (InternalWindow)_resizeWindowVector.elementAt(3);
            window.moveToAndSizeTo(newBounds.x + 1, newBounds.maxY() - 1, newBounds.width - 2, 1);
            window = (InternalWindow)_resizeWindowVector.elementAt(2);
            window.sizeTo(newBounds.width - 2, 1);
            window = (InternalWindow)_resizeWindowVector.elementAt(0);
            window.sizeTo(1, newBounds.height);
        }
        Rect.returnRect(newBounds);
    }

    public void mouseDragged(MouseEvent event) {
        if (this._resizePart != 0) {
            this.mouseResizeDrag(event);
            return;
        }
        int eventX = event.x + this.bounds.x;
        int eventY = event.y + this.bounds.y;
        int minY = this._type == 0 ? -5 : -this.titleBarMargin() + 5;
        int maxY = this.superview().height() - 5;
        int y = this.bounds.y + eventY - this._lastY;
        if (y < minY) {
            eventY = minY + this._lastY - this.bounds.y;
        } else if (y > maxY) {
            eventY = maxY + this._lastY - this.bounds.y;
        }
        int minX = -this.bounds.width + 5;
        int maxX = this.superview().width() - 5;
        int x = this.bounds.x + eventX - this._lastX;
        if (x < minX) {
            eventX = minX + this._lastX - this.bounds.x;
        } else if (x > maxX) {
            eventX = maxX + this._lastX - this.bounds.x;
        }
        Point tmpPoint = Point.newPoint(this.bounds.x + eventX - this._lastX, this.bounds.y + eventY - this._lastY);
        this.willMoveTo(tmpPoint);
        eventX = tmpPoint.x + this._lastX - this.bounds.x;
        eventY = tmpPoint.y + this._lastY - this.bounds.y;
        Point.returnPoint(tmpPoint);
        Rect clipRect = Rect.newRect();
        this.computeVisibleRect(clipRect);
        Rect oldBounds = Rect.newRect();
        this.convertRectToView(null, clipRect, oldBounds);
        if (!this.isTransparent() && this.drawingBuffer == null) {
            this._createdDrawingBuffer = true;
            this.setBuffered(true);
            this._drawToBackingStore = true;
            Graphics bufferedGraphics = this.drawingBuffer.createGraphics();
            bufferedGraphics.setDebugOptions(this.shouldDebugGraphics());
            this.draw(bufferedGraphics, null);
            bufferedGraphics.dispose();
            bufferedGraphics = null;
            this._drawToBackingStore = false;
        }
        this._super_moveBy(eventX - this._lastX, eventY - this._lastY);
        if (!this.isTransparent()) {
            if (this.drawingBuffer != null) {
                this.drawingBufferIsBitCache = true;
            }
            this.draw();
            if (this.drawingBuffer != null) {
                this.drawingBufferIsBitCache = false;
            }
        }
        if (this.isTransparent()) {
            this.draw();
        }
        this.rootView.disableWindowsAbove(this, true);
        this.rootView.redraw(oldBounds);
        this.rootView.disableWindowsAbove(this, false);
        this._lastX = eventX;
        this._lastY = eventY;
        oldBounds.unionWith(this.superview().convertRectToView(null, this.bounds));
        this.rootView.redrawTransparentWindows(oldBounds, this);
        Rect.returnRect(clipRect);
    }

    public void mouseUp(MouseEvent event) {
        if (this._resizePart != 0) {
            InternalWindow nextWindow = (InternalWindow)_resizeWindowVector.elementAt(0);
            InternalWindow secondWindow = (InternalWindow)_resizeWindowVector.elementAt(1);
            if (this._resizePart == 1) {
                this.moveByAndSizeBy(nextWindow.bounds.x - this.bounds.x, 0, secondWindow.bounds.x - nextWindow.bounds.x - this.bounds.width + 1, nextWindow.bounds.height - this.bounds.height);
            } else {
                this.sizeTo(secondWindow.bounds.x - nextWindow.bounds.x + 1, nextWindow.bounds.height);
            }
            int i = _resizeWindowVector.count();
            while (i-- > 0) {
                nextWindow = (InternalWindow)_resizeWindowVector.elementAt(i);
                nextWindow.hide();
            }
            _resizeWindowVector.removeAllElements();
            this._resizePart = 0;
        }
        if (this._createdDrawingBuffer) {
            this.setBuffered(false);
            this._createdDrawingBuffer = false;
        }
    }

    void _drawLine(Graphics g, int x1, int x2, int y, Color c1, Color c2) {
        g.setColor(c1);
        int i = x1;
        while (i <= x2) {
            g.drawLine(i, y, i, y);
            i += 2;
        }
        g.setColor(c2);
        i = x1 + 1;
        while (i <= x2) {
            g.drawLine(i, y, i, y);
            i += 2;
        }
    }

    public void drawView(Graphics g) {
        if (this.drawingBuffer != null && !g.isDrawingBuffer() || this._type == 0) {
            return;
        }
        this._border.drawInRect(g, 0, 0, this.bounds.width, this.bounds.height);
    }

    public void drawTitleBar() {
        if (this._type == 0) {
            return;
        }
        Rect tmpRect = Rect.newRect(0, 0, this.bounds.width, this.titleBarMargin());
        this.draw(tmpRect);
        Rect.returnRect(tmpRect);
    }

    public void drawBottomBorder() {
        if (this._type == 0) {
            return;
        }
        Rect tmpRect = Rect.newRect(0, this.bounds.height - this.bottomBorderMargin(), this.bounds.width, this.bottomBorderMargin());
        this.draw(tmpRect);
        Rect.returnRect(tmpRect);
    }

    public void draw(Graphics g, Rect clipRect) {
        View containingView;
        if (this.isTransparent() && (g == null || !g.isDrawingBuffer()) && this.rootView._redrawTransWindows && ((containingView = null) == null || containingView.isTransparent())) {
            this.updateDrawingBuffer();
        }
        super.draw(g, clipRect);
    }

    public void didBecomeMain() {
        this.drawTitleBar();
        if (this._owner != null) {
            this._owner.windowDidBecomeMain(this);
        }
        this.rootView.setFocusedView(this.focusedView(), false);
        if (this.containsDocument()) {
            Application.application().makeCurrentDocumentWindow(this);
        }
    }

    public void didResignMain() {
        this.drawTitleBar();
        if (this._owner != null) {
            this._owner.windowDidResignMain(this);
        }
        if (this.rootView != null) {
            this.rootView.setFocusedView(null, false);
        }
    }

    public void setContainsDocument(boolean containsDocument) {
        this._containsDocument = containsDocument;
    }

    public boolean containsDocument() {
        return this._containsDocument;
    }

    public void setCanBecomeDocument(boolean containsDocument) {
        this.setContainsDocument(containsDocument);
    }

    public boolean canBecomeDocument() {
        return this.containsDocument();
    }

    public void didBecomeCurrentDocument() {
    }

    public void didResignCurrentDocument() {
    }

    public boolean isCurrentDocument() {
        return Application.application().currentDocumentWindow() == this;
    }

    public void setFocusedView(View view) {
        this._focusedView = view;
        if (this.rootView != null) {
            if (this.rootView.mainWindow() == this && view != null) {
                this.rootView.makeWindowVisible(this, 0, null);
            }
            this.rootView.setFocusedView(this.focusedView());
        }
    }

    public View focusedView() {
        if (this._focusedView != null && this._focusedView.descendsFrom(this)) {
            return this._focusedView;
        }
        this._focusedView = null;
        return this._focusedView;
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.InternalWindow", 3);
        info.addField(ownerKey, (byte)18);
        info.addField(contentViewKey, (byte)18);
        info.addField(focusedViewKey, (byte)18);
        info.addField(closeButtonKey, (byte)18);
        info.addField(titleFontKey, (byte)18);
        info.addField(titleKey, (byte)16);
        info.addField(borderKey, (byte)18);
        info.addField(layerKey, (byte)8);
        info.addField(typeKey, (byte)8);
        info.addField(closeableKey, (byte)0);
        info.addField(resizableKey, (byte)0);
        info.addField(canBecomeMainKey, (byte)0);
        info.addField(containsDocumentKey, (byte)0);
        info.addField(onscreenKey, (byte)0);
        info.addField(transparentKey, (byte)0);
        info.addField(scrollToVisibleKey, (byte)0);
        info.addField(defaultSelectedViewKey, (byte)18);
        info.addField(menuViewKey, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(ownerKey, (Codable)((Object)this._owner));
        encoder.encodeObject(contentViewKey, this._contentView);
        encoder.encodeObject(focusedViewKey, this.focusedView());
        encoder.encodeObject(closeButtonKey, this._closeButton);
        encoder.encodeObject(titleFontKey, this._titleFont);
        encoder.encodeString(titleKey, this._title);
        encoder.encodeObject(borderKey, this._border);
        encoder.encodeInt(layerKey, this._layer);
        encoder.encodeInt(typeKey, this._type);
        encoder.encodeBoolean(closeableKey, this._closeable);
        encoder.encodeBoolean(resizableKey, this._resizable);
        encoder.encodeBoolean(canBecomeMainKey, this._canBecomeMain);
        encoder.encodeBoolean(containsDocumentKey, this._containsDocument);
        encoder.encodeBoolean(onscreenKey, this._onscreen);
        encoder.encodeBoolean(transparentKey, this.transparent);
        encoder.encodeBoolean(scrollToVisibleKey, this.scrollToVisible);
        encoder.encodeObject(defaultSelectedViewKey, this._defaultSelectedView);
        encoder.encodeObject(menuViewKey, this.menuView);
    }

    public void decode(Decoder decoder) throws CodingException {
        int version = decoder.versionForClassName("netscape.application.TextField");
        super.decode(decoder);
        this._owner = (WindowOwner)decoder.decodeObject(ownerKey);
        this._contentView = (WindowContentView)decoder.decodeObject(contentViewKey);
        this._focusedView = (View)decoder.decodeObject(focusedViewKey);
        this._closeButton = (Button)decoder.decodeObject(closeButtonKey);
        this._titleFont = (Font)decoder.decodeObject(titleFontKey);
        this._title = decoder.decodeString(titleKey);
        this._border = (Border)decoder.decodeObject(borderKey);
        this._layer = decoder.decodeInt(layerKey);
        this._type = decoder.decodeInt(typeKey);
        this._closeable = decoder.decodeBoolean(closeableKey);
        this._resizable = decoder.decodeBoolean(resizableKey);
        this._canBecomeMain = decoder.decodeBoolean(canBecomeMainKey);
        this._containsDocument = decoder.decodeBoolean(containsDocumentKey);
        this._onscreen = decoder.decodeBoolean(onscreenKey);
        this.transparent = decoder.decodeBoolean(transparentKey);
        this.scrollToVisible = decoder.decodeBoolean(scrollToVisibleKey);
        if (version > 1) {
            this._defaultSelectedView = (View)decoder.decodeObject(defaultSelectedViewKey);
        }
        if (version > 2) {
            this.menuView = (MenuView)decoder.decodeObject(menuViewKey);
        }
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        if (this._closeButton != null) {
            this._closeButton.removeAllCommandsForKeys();
        }
    }

    public String toString() {
        if (this._title != null) {
            return "InternalWindow (" + this._title + ")";
        }
        return super.toString();
    }

    View ancestorWithDrawingBuffer() {
        if (this.drawingBuffer != null) {
            return this;
        }
        return null;
    }

    public InternalWindow window() {
        return this;
    }

    public Font font() {
        return this._titleFont;
    }

    public void performCommand(String command, Object data) {
        if ("show".equals(command)) {
            this.show();
            return;
        }
        if ("hide".equals(command)) {
            this.hide();
            return;
        }
        throw new NoSuchMethodError("unknown command: " + command);
    }

    public boolean hidesSubviewsFromKeyboard() {
        return true;
    }

    public void setDefaultSelectedView(View aView) {
        this._defaultSelectedView = aView;
    }

    public View defaultSelectedView() {
        return this._defaultSelectedView;
    }

    public boolean canBecomeSelectedView() {
        return this.isMain();
    }

    boolean wantsKeyboardArrow() {
        return false;
    }
}

