/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.BezelBorder;
import netscape.application.Bitmap;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.ContainerView;
import netscape.application.ExternalWindow;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.InternalWindow;
import netscape.application.ListItem;
import netscape.application.ListView;
import netscape.application.MouseEvent;
import netscape.application.PopupItem;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.View;
import netscape.application.Window;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Popup
extends View
implements Target,
FormElement {
    ListView popupList;
    Window popupWindow;
    ContainerView container;
    ListItem selectedItem;
    ListItem wasSelectedItem;
    Target target;
    Image image;
    boolean _showingPopupForKeyboard;
    boolean enabled = true;
    static final String LISTVIEW_KEY = "popupList";
    static final String WINDOW_KEY = "popupWindow";
    static final String CONTAINER_KEY = "container";
    static final String SELECTEDITEM_KEY = "selectedItem";
    static final String TARGET_KEY = "target";
    static final String SELECTEDIMAGE_KEY = "selectedImage";
    static final String ENABLED_KEY = "enabled";
    public static final String SELECT_NEXT_ITEM = ListView.SELECT_NEXT_ITEM;
    public static final String SELECT_PREVIOUS_ITEM = ListView.SELECT_PREVIOUS_ITEM;
    public static final String POPUP = "popup";
    static final String CLOSE_POPUP_AND_CANCEL = "cancel";
    static final String CLOSE_POPUP_AND_COMMIT = "commit";

    public Popup() {
        this(0, 0, 0, 0);
    }

    public Popup(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Popup(int x, int y, int width, int height) {
        super(x, y, width, height);
        InternalWindow internalWindow = new InternalWindow(x, y, width, height);
        internalWindow.setType(0);
        internalWindow.setLayer(300);
        internalWindow._contentView.setTransparent(true);
        internalWindow.setScrollsToVisible(true);
        InternalWindow window = internalWindow;
        this.container = new ContainerView(0, 0, width, height);
        this.container.setTransparent(true);
        this.container.setBorder(BezelBorder.raisedBezel());
        this.container.setVertResizeInstruction(16);
        this.container.setHorizResizeInstruction(2);
        ListView list = new ListView(0, 0, width, height);
        PopupItem prototype = new PopupItem();
        prototype.setPopup(this);
        this.setPopupList(list);
        this.setPrototypeItem(prototype);
        this.setPopupWindow(window);
        this.setPopupImage(Bitmap.bitmapNamed("netscape/application/PopupKnobH.gif"));
        this._setupKeyboard();
    }

    public void setPrototypeItem(ListItem item) {
        this.popupList.setPrototypeItem(item);
        if (item instanceof PopupItem) {
            ((PopupItem)item).setPopup(this);
        }
    }

    public ListItem prototypeItem() {
        return this.popupList.prototypeItem();
    }

    public void removeAllItems() {
        this.popupList.removeAllItems();
    }

    public ListItem addItem(String title, String command) {
        this.hidePopupIfNeeded();
        ListItem item = this.popupList.addItem();
        item.setTitle(title);
        item.setCommand(command);
        return item;
    }

    public void removeItem(String title) {
        if (title == null) {
            return;
        }
        int i = this.popupList.count();
        while (i-- > 0) {
            ListItem nextItem = this.itemAt(i);
            if (!title.equals(nextItem.title())) continue;
            this.hidePopupIfNeeded();
            this.popupList.removeItemAt(i);
            return;
        }
    }

    public void removeItemAt(int index) {
        if (this.popupList.count() > index) {
            this.hidePopupIfNeeded();
            this.popupList.removeItemAt(index);
        }
    }

    public int selectedIndex() {
        int index = this.popupList.indexOfItem(this.selectedItem);
        if (index < 0 && this.popupList.count() > 0) {
            index = 0;
            this.selectItemAt(0);
        }
        return index;
    }

    public ListItem selectedItem() {
        int index = this.selectedIndex();
        if (index < 0) {
            return null;
        }
        return this.popupList.itemAt(index);
    }

    public void selectItem(ListItem item) {
        this.selectedItem = item;
        this.draw();
    }

    public void selectItemAt(int index) {
        this.selectItem(this.popupList.itemAt(index));
    }

    public int count() {
        return this.popupList.count();
    }

    public ListItem itemAt(int index) {
        return this.popupList.itemAt(index);
    }

    public void setBorder(Border aBorder) {
        this.container.setBorder(aBorder);
    }

    public Border border() {
        return this.container.border();
    }

    public void setPopupList(ListView list) {
        this.popupList = list;
        this.popupList.setTarget(this);
        this.popupList.setAllowsMultipleSelection(false);
        this.popupList.setAllowsEmptySelection(true);
        this.popupList.setTracksMouseOutsideBounds(false);
        this.container.addSubview(this.popupList);
    }

    public ListView popupList() {
        return this.popupList;
    }

    public void setPopupWindow(Window window) {
        this.popupWindow = window;
        if (window instanceof InternalWindow) {
            InternalWindow internalWindow = (InternalWindow)window;
            internalWindow.setScrollsToVisible(true);
            window.addSubview(this.container);
        }
    }

    public Window popupWindow() {
        return this.popupWindow;
    }

    public void setPopupImage(Image anImage) {
        this.image = anImage;
    }

    public Image popupImage() {
        return this.image;
    }

    protected void layoutPopupWindow() {
        Border border = this.container.border();
        this.popupList.setRowHeight(this.bounds.height - border.heightMargin());
        this.popupList.setBounds(border.leftMargin(), border.topMargin(), this.bounds.width - border.widthMargin(), this.popupList.rowHeight() * this.popupList.count());
        int selectedIndex = this.selectedIndex();
        Rect windowRect = Rect.newRect(0, 0, this.width(), this.height());
        this.convertRectToView(null, windowRect, windowRect);
        if (this.rootView().windowClipView() != null) {
            this.rootView().convertRectToView(this.rootView().windowClipView(), windowRect, windowRect);
        }
        this.popupWindow.setBounds(windowRect.x, windowRect.y - selectedIndex * this.popupList.rowHeight(), this.popupList.width() + border.widthMargin(), this.popupList.height() + border.heightMargin());
        Rect.returnRect(windowRect);
    }

    protected void showPopupWindow(MouseEvent event) {
        if (this.popupWindow instanceof InternalWindow) {
            InternalWindow internalWindow = (InternalWindow)this.popupWindow;
            internalWindow.setRootView(this.rootView());
            Application.application().beginModalSessionForView(internalWindow);
        } else {
            ExternalWindow externalWindow = (ExternalWindow)this.popupWindow;
            Application.application().beginModalSessionForView(externalWindow.rootView());
        }
        this.popupWindow.show();
        this.rootView().setMouseView(this.popupList);
        if (event != null) {
            this.popupList.mouseDown(this.convertEventToView(this.popupList, event));
            return;
        }
        this.popupList.selectItem(this.selectedItem());
        this.rootView().makeSelectedView(this.popupList);
    }

    public boolean mouseDown(MouseEvent event) {
        if (!this.isEnabled()) {
            return false;
        }
        this.layoutPopupWindow();
        this.showPopupWindow(event);
        return true;
    }

    public void setEnabled(boolean flag) {
        this.enabled = flag;
        this.setDirty(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTransparent() {
        return this.popupList.isTransparent();
    }

    public void drawView(Graphics g) {
        Color color = null;
        Border border = this.container.border();
        if (this.selectedItem == null && this.popupList.selectedItem() == null) {
            this.selectItem(this.popupList.itemAt(0));
        }
        if (!this.popupList.isTransparent() && this.selectedItem != null && this.selectedItem.isTransparent()) {
            g.setColor(this.popupList.backgroundColor());
            g.fillRect(0, 0, this.width(), this.height());
        }
        if (this.selectedItem != null) {
            Rect itemRect = Rect.newRect(border.leftMargin(), border.topMargin(), this.bounds.width - border.widthMargin(), this.bounds.height - border.heightMargin());
            g.pushState();
            g.setClipRect(itemRect);
            if (!this.isEnabled()) {
                color = this.selectedItem.textColor();
                this.selectedItem.setTextColor(Color.gray);
            }
            this.selectedItem.drawInRect(g, itemRect);
            if (!this.isEnabled()) {
                this.selectedItem.setTextColor(color);
            }
            g.popState();
            Rect.returnRect(itemRect);
        }
        border.drawInRect(g, 0, 0, this.width(), this.height());
    }

    public void setTarget(Target newTarget) {
        this.target = newTarget;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String newCommand) {
        this.popupList.setCommand(newCommand);
    }

    public String command() {
        return this.popupList.command();
    }

    public void sendCommand() {
        if (this.target != null) {
            String realCommand = null;
            if (this.selectedItem != null) {
                realCommand = this.selectedItem.command();
            }
            if (realCommand == null) {
                realCommand = this.command();
            }
            this.target.performCommand(realCommand, this);
        }
    }

    public void performCommand(String command, Object data) {
        if (SELECT_NEXT_ITEM.equals(command)) {
            this.selectNextItem(true);
        } else if (SELECT_PREVIOUS_ITEM.equals(command)) {
            this.selectNextItem(false);
        } else if (POPUP.equals(command)) {
            this.layoutPopupWindow();
            this.wasSelectedItem = this.selectedItem();
            this._showingPopupForKeyboard = true;
            this.showPopupWindow(null);
            this._setupKeyboardToClosePopup(true);
        } else if (this.showingPopupForKeyboard()) {
            boolean shouldClose = false;
            if (CLOSE_POPUP_AND_CANCEL.equals(command)) {
                this.selectItem(this.wasSelectedItem);
                shouldClose = true;
            } else if (CLOSE_POPUP_AND_COMMIT.equals(command)) {
                this.selectItem(this.popupList.selectedItem());
                if (this.popupList.selectedItem() != null) {
                    this.sendCommand();
                }
                shouldClose = true;
            }
            if (shouldClose) {
                this.popupList.disableDrawing();
                this.popupList.deselectItem(this.popupList.selectedItem());
                this.popupList.reenableDrawing();
                this.popupWindow.hide();
                if (this.popupWindow instanceof InternalWindow) {
                    InternalWindow internalWindow = (InternalWindow)this.popupWindow;
                    Application.application().endModalSessionForView(internalWindow);
                } else {
                    ExternalWindow externalWindow = (ExternalWindow)this.popupWindow;
                    Application.application().endModalSessionForView(externalWindow.rootView());
                }
                this._setupKeyboardToClosePopup(false);
                this._showingPopupForKeyboard = false;
            }
        } else {
            if (this.popupList.selectedItem() != null) {
                this.selectedItem = this.popupList.selectedItem();
            }
            if (this.selectedItem != null) {
                this.sendCommand();
            }
            this.popupList.disableDrawing();
            this.popupList.deselectItem(this.selectedItem);
            this.popupList.reenableDrawing();
            this.popupWindow.hide();
            if (this.popupWindow instanceof InternalWindow) {
                InternalWindow internalWindow = (InternalWindow)this.popupWindow;
                Application.application().endModalSessionForView(internalWindow);
            } else {
                ExternalWindow externalWindow = (ExternalWindow)this.popupWindow;
                Application.application().endModalSessionForView(externalWindow.rootView());
            }
            this._setupKeyboardToClosePopup(false);
        }
        this.draw();
    }

    public Size minSize() {
        int bw = 0;
        int bh = 0;
        if (this.container.border() != null) {
            bw = this.container.border().widthMargin();
            bh = this.container.border().heightMargin();
        }
        int w = 0;
        int h = 0;
        if (this.popupList != null) {
            w = this.popupList.minItemWidth();
            h = this.popupList.minItemHeight();
        }
        int iw = 0;
        int ih = 0;
        if (this.image != null) {
            iw = this.image.width();
            ih = this.image.height();
        }
        ih = ih < h ? 0 : h - ih;
        return new Size(bw + w + iw, bh + h + ih);
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.Popup", 2);
        info.addField(LISTVIEW_KEY, (byte)18);
        info.addField(WINDOW_KEY, (byte)18);
        info.addField(CONTAINER_KEY, (byte)18);
        info.addField(SELECTEDITEM_KEY, (byte)18);
        info.addField(TARGET_KEY, (byte)18);
        info.addField(SELECTEDIMAGE_KEY, (byte)18);
        info.addField(ENABLED_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(LISTVIEW_KEY, this.popupList);
        encoder.encodeObject(WINDOW_KEY, this.popupWindow);
        encoder.encodeObject(CONTAINER_KEY, this.container);
        encoder.encodeObject(SELECTEDITEM_KEY, this.selectedItem);
        encoder.encodeObject(TARGET_KEY, this.target);
        encoder.encodeObject(SELECTEDIMAGE_KEY, this.image);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.popupList = (ListView)decoder.decodeObject(LISTVIEW_KEY);
        this.popupWindow = (Window)decoder.decodeObject(WINDOW_KEY);
        this.container = (ContainerView)decoder.decodeObject(CONTAINER_KEY);
        this.selectedItem = (ListItem)decoder.decodeObject(SELECTEDITEM_KEY);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.image = (Image)decoder.decodeObject(SELECTEDIMAGE_KEY);
        if (decoder.versionForClassName("netscape.application.Popup") > 1) {
            this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        }
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(SELECT_NEXT_ITEM, 1005, 0);
        this.setCommandForKey(SELECT_PREVIOUS_ITEM, 1004, 0);
        this.setCommandForKey(POPUP, 10, 0);
        this.setCommandForKey(POPUP, 32, 0);
    }

    void selectNextItem(boolean forward) {
        int index = this.selectedIndex();
        int count = this.count();
        if (forward && index < count - 1) {
            this.selectItemAt(index + 1);
        } else if (!forward && index > 0) {
            this.selectItemAt(index - 1);
        }
        if (this.selectedItem() != null) {
            this.sendCommand();
        }
    }

    public boolean canBecomeSelectedView() {
        return true;
    }

    void _setupKeyboardToClosePopup(boolean doIt) {
        if (doIt) {
            this.setCommandForKey(CLOSE_POPUP_AND_CANCEL, 27, 2);
            this.setCommandForKey(CLOSE_POPUP_AND_COMMIT, 10, 2);
            return;
        }
        this.removeCommandForKey(27);
        this.setCommandForKey(POPUP, 10, 0);
    }

    protected void ancestorWillRemoveFromViewHierarchy(View view) {
        super.ancestorWillRemoveFromViewHierarchy(view);
        this.hidePopupIfNeeded();
    }

    public void hidePopupIfNeeded() {
        if (this.showingPopupForKeyboard()) {
            this.performCommand(CLOSE_POPUP_AND_CANCEL, this);
        }
    }

    public boolean showingPopupForKeyboard() {
        return this._showingPopupForKeyboard;
    }

    public String formElementText() {
        if (this.selectedItem() != null) {
            return this.selectedItem().title();
        }
        return "";
    }
}

