/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.OutputStream;
import netscape.util.IdHashtable;

public class CompactOutputStream
extends OutputStream {
    OutputStream out;
    int booleanCount;
    int booleanBuffer;
    IdHashtable stringTable = new IdHashtable(true);
    int stringCount = 2;

    public CompactOutputStream(OutputStream out) {
        this.out = out;
    }

    private final void flushBooleanBuffer() throws IOException {
        if (this.booleanCount > 0) {
            this.out.write(this.booleanBuffer);
            this.booleanCount = 0;
            this.booleanBuffer = 0;
        }
    }

    public void write(int value) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(value);
    }

    public void write(byte[] value) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(value, 0, value.length);
    }

    public void write(byte[] value, int offset, int length) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(value, offset, length);
    }

    public void flush() throws IOException {
        this.flushBooleanBuffer();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flushBooleanBuffer();
        this.out.close();
    }

    public void writeCompactBoolean(boolean value) throws IOException {
        int count = this.booleanCount;
        if (value) {
            int buf = this.booleanBuffer;
            buf |= 1 << count;
            if (++count >= 8) {
                this.out.write(buf);
                this.booleanCount = 0;
                this.booleanBuffer = 0;
                return;
            }
            this.booleanCount = count;
            this.booleanBuffer = buf;
            return;
        }
        if (++count >= 8) {
            this.out.write(this.booleanBuffer);
            this.booleanCount = 0;
            this.booleanBuffer = 0;
            return;
        }
        this.booleanCount = count;
    }

    public void writeBoolean(boolean value) throws IOException {
        if (value) {
            this.out.write(1);
            return;
        }
        this.out.write(0);
    }

    public void writeByte(int value) throws IOException {
        this.flushBooleanBuffer();
        this.out.write(value);
    }

    public void writeShort(int value) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        out.write(value >>> 8 & 0xFF);
        out.write(value & 0xFF);
    }

    public void writeChar(int value) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        out.write(value >>> 8 & 0xFF);
        out.write(value & 0xFF);
    }

    public void writeCompactInt(int value) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                out.write(64);
                return;
            }
            if ((value = -value) < 64) {
                out.write(value | 0x40);
                return;
            }
            out.write(value & 0xFF | 0xC0);
        } else {
            if (value < 64) {
                out.write(value);
                return;
            }
            out.write(value & 0x3F | 0x80);
        }
        if ((value >>>= 6) < 128) {
            out.write(value);
            return;
        }
        out.write(value & 0xFF | 0x80);
        if ((value >>>= 7) < 128) {
            out.write(value);
            return;
        }
        out.write(value & 0xFF | 0x80);
        if ((value >>>= 7) < 128) {
            out.write(value);
            return;
        }
        out.write(value & 0xFF | 0x80);
        if ((value >>>= 7) > 0) {
            out.write(value);
        }
    }

    public void writeInt(int value) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        out.write(value >>> 24 & 0xFF);
        out.write(value >>> 16 & 0xFF);
        out.write(value >>> 8 & 0xFF);
        out.write(value & 0xFF);
    }

    public void writeLong(long value) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        out.write((int)(value >>> 56) & 0xFF);
        out.write((int)(value >>> 48) & 0xFF);
        out.write((int)(value >>> 40) & 0xFF);
        out.write((int)(value >>> 32) & 0xFF);
        out.write((int)(value >>> 24) & 0xFF);
        out.write((int)(value >>> 16) & 0xFF);
        out.write((int)(value >>> 8) & 0xFF);
        out.write((int)value & 0xFF);
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeLong(Double.doubleToLongBits(value));
    }

    public void writeBytes(String s) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            out.write((byte)s.charAt(i));
            ++i;
        }
    }

    public void writeChars(String s) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        int length = s.length();
        int i = 0;
        while (i < length) {
            char value = s.charAt(i);
            out.write(value >>> 8 & 0xFF);
            out.write(value & 0xFF);
            ++i;
        }
    }

    public void writeCompactUTF(String str) throws IOException {
        if (str == null) {
            this.writeCompactInt(0);
            return;
        }
        if (str.length() == 0) {
            this.writeCompactInt(1);
            return;
        }
        int id = this.stringTable.get(str);
        if (id == 0) {
            id = this.stringCount++;
            this.stringTable.putKnownAbsent(str, id);
            int length = this.utfLength(str);
            this.writeCompactInt(-length);
            this.writeUTFBytes(str);
            return;
        }
        this.writeCompactInt(id);
    }

    public void writeUTF(String str) throws IOException {
        OutputStream out = this.out;
        this.flushBooleanBuffer();
        if (str == null) {
            out.write(255);
            out.write(255);
            return;
        }
        int utflen = this.utfLength(str);
        if (utflen >= 65535) {
            throw new IOException("string too long");
        }
        out.write(utflen >>> 8 & 0xFF);
        out.write(utflen & 0xFF);
        this.writeUTFBytes(str);
    }

    private final int utfLength(String str) {
        int strlen = str.length();
        int utflen = 0;
        int i = 0;
        while (i < strlen) {
            char c = str.charAt(i);
            utflen = c >= '\u0001' && c <= '\u007f' ? ++utflen : (c > '\u07ff' ? (utflen += 3) : (utflen += 2));
            ++i;
        }
        return utflen;
    }

    private final void writeUTFBytes(String str) throws IOException {
        OutputStream out = this.out;
        int strlen = str.length();
        int i = 0;
        while (i < strlen) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                out.write(c);
            } else if (c > '\u07ff') {
                out.write(0xE0 | c >> 12 & 0xF);
                out.write(0x80 | c >> 6 & 0x3F);
                out.write(0x80 | c & 0x3F);
            } else {
                out.write(0xC0 | c >> 6 & 0x1F);
                out.write(0x80 | c & 0x3F);
            }
            ++i;
        }
    }
}

