/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPObjectClassSchema
extends LDAPSchemaElement {
    private String superior = "";
    private Vector must = new Vector();
    private Vector may = new Vector();
    private boolean auxiliary = false;

    public LDAPObjectClassSchema(String name, String oid, String superior, String description, String[] required, String[] optional) {
        super(name, oid, description);
        this.attrName = "objectclasses";
        this.superior = superior;
        int i = 0;
        while (i < required.length) {
            this.must.addElement(required[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < optional.length) {
            this.may.addElement(optional[i2]);
            ++i2;
        }
    }

    public LDAPObjectClassSchema(String raw) {
        this.attrName = "objectclasses";
        raw.trim();
        int l = raw.length();
        raw = raw.substring(2, l - 1);
        l = raw.length();
        int ind = raw.indexOf(32);
        this.oid = raw.substring(0, ind);
        char[] ch = new char[l];
        raw = raw.substring(ind + 1, l);
        l = raw.length();
        raw.getChars(0, l, ch, 0);
        ind = 0;
        l = ch.length;
        while (ind < l) {
            int last;
            block14: {
                String val;
                String s;
                block13: {
                    block16: {
                        block15: {
                            s = "";
                            while (ch[ind] == ' ') {
                                ++ind;
                            }
                            last = ind + 1;
                            while (last < l && ch[last] != ' ') {
                                ++last;
                            }
                            if (ind < l && last < l) {
                                s = new String(ch, ind, last - ind);
                                ind = last;
                                if (s.equalsIgnoreCase("AUXILIARY")) {
                                    this.auxiliary = true;
                                    continue;
                                }
                            } else {
                                ind = l;
                            }
                            while (ind < l && ch[ind] != '\'' && ch[ind] != '(') {
                                ++ind;
                            }
                            last = ind + 1;
                            if (ind >= l) break;
                            if (ch[ind] != '\'') break block13;
                            while (last < l && ch[last] != '\'') {
                                ++last;
                            }
                            if (ind >= last || last >= l) break block14;
                            val = new String(ch, ind + 1, last - ind - 1);
                            if (!s.equalsIgnoreCase("NAME")) break block15;
                            this.name = val;
                            break block14;
                        }
                        if (!s.equalsIgnoreCase("DESC")) break block16;
                        this.description = val;
                        break block14;
                    }
                    if (!s.equalsIgnoreCase("SUP")) break block14;
                    this.superior = val;
                    break block14;
                }
                Vector v = null;
                if (s.equalsIgnoreCase("MAY")) {
                    v = this.may;
                } else {
                    if (!s.equalsIgnoreCase("MUST")) continue;
                    v = this.must;
                }
                while (last < l && ch[last] != ')') {
                    ++last;
                }
                if (ind < last && last < l) {
                    val = new String(ch, ind + 1, last - ind - 1);
                    StringTokenizer st = new StringTokenizer(val, " ");
                    while (st.hasMoreTokens()) {
                        String tok = st.nextToken();
                        if (tok.equals("$")) continue;
                        v.addElement(tok);
                    }
                }
            }
            ind = last + 1;
        }
    }

    public String getSuperior() {
        return this.superior;
    }

    public Enumeration getRequiredAttributes() {
        return this.must.elements();
    }

    public Enumeration getOptionalAttributes() {
        return this.may.elements();
    }

    public String getValue() {
        String s = "( " + this.oid + " NAME '" + this.name + "' SUP '" + this.superior + "' DESC '" + this.description + "' ";
        if (this.auxiliary) {
            s = String.valueOf(s) + "AUXILIARY ";
        }
        s = String.valueOf(s) + "MUST ( ";
        int i = 0;
        Enumeration e = this.getRequiredAttributes();
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + " $ ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        s = String.valueOf(s) + " ) MAY ( ";
        e = this.getOptionalAttributes();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + " $ ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        s = String.valueOf(s) + ") )";
        return s;
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid + "; Superior: " + this.superior + "; Description: " + this.description + "; Required: ";
        int i = 0;
        Enumeration e = this.getRequiredAttributes();
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        s = String.valueOf(s) + "; Optional: ";
        e = this.getOptionalAttributes();
        i = 0;
        while (e.hasMoreElements()) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            ++i;
            s = String.valueOf(s) + (String)e.nextElement();
        }
        return s;
    }
}

