// -*- mode: cpp; mode: fold -*-
// Description								/*{{{*/
// $Id: basic.h,v 1.13 1998/06/06 03:09:18 jgg Exp $
/* ######################################################################

   BasicWidget - Base class for many of the widgets
   
   The Basic Widget provides many of the basic attributes that are found
   on all kinds of widgets from buttons to list boxes. It provides a 
   background colour, default draw function, border styles and handling
   as well as a uniform names for common things like 'Color'
   
   ##################################################################### */
									/*}}}*/
// Header section: deity
#ifndef DEITY_BASIC_H
#define DEITY_BASIC_H

#include <deity/widget.h>

class BasicWidget : public Widget
{
   protected:

   // Basic widget colouring and style
   Color iBackground;
   Color iBorderUl;                  
   Color iBorderLr;
   Color iColor;
   SimpleFont iFont;
   Point iMargins;
   
   unsigned long iBorderWidth;

   void BasicRender(CombinedGC &GC,bool Clear = true);
   virtual void Render(CombinedGC &GC) {BasicRender(GC,true);};
   
   public:

   virtual Point IdealSize();
      
   // BorderWidth
   void BorderWidth(unsigned long Width);
   inline unsigned long BorderWidth() const {return iBorderWidth;};

   void Margins(Point Margins);
   inline Point const Margins() const {return iMargins;};
   
   inline SimpleFont Font() const {return iFont;};
   
   inline Color Foreground() const {return iColor;};
   void Background(Color C);
   inline Color Background() const {return iBackground;};
   inline void SwapBorderColors() {Color Tmp = iBorderUl;iBorderUl = iBorderLr;iBorderLr = Tmp;};
   
   BasicWidget(Widget *Parent = 0);
};

#endif
