char *cknetv = "Network support, 6.1.119, 8 May 1998";

/*  C K C N E T  --  Network support  */

/*
  NOTE TO CONTRIBUTORS: This file, and all the other shared (ckc and cku)
  C-Kermit source files, must be compatible with C preprocessors that support
  only #ifdef, #else, #endif, #define, and #undef.  Please do not use #if,
  logical operators, or other preprocessor features in any of the portable
  C-Kermit modules.  You can, of course, use these constructions in
  system-specific modules when you know they are supported.  Also, don't use
  any ANSI C constructs except with #ifdef CK_ANSIC..#endif.
*/

/*
  Authors:

  Frank da Cruz (fdc@columbia.edu),
    Columbia University Academic Information Systems, New York City.
  netopen() routine for TCP/IP originally by Ken Yap, Rochester University
    (ken@cs.rochester.edu) (no longer at that address).
  Jeffrey E Altman (jaltman@columbia.edu) -- OS/2 & Windows and a lot more.
  Missing pieces for Excelan sockets library from William Bader.
  Telnet protocol by Frank da Cruz and Jeffrey Altman.
  Rlogin protocol by Jeffrey Altman.
  TGV MultiNet code by Frank da Cruz.
  MultiNet code adapted to WIN/TCP by Ray Hunter of TWG.
  MultiNet code adapted to DEC TCP/IP by Lee Tibbert of DEC and Frank da Cruz.
  TCP/IP support adapted to IBM TCP/IP 1.2.1,2.0 for OS/2 by Kai Uwe Rommel.
  CMU-OpenVMS/IP modifications by Mike O'Malley, Digital (DEC).
  X.25 support by Marcello Frutig, Catholic University,
    Rio de Janeiro, Brazil (frutig@rnp.impa.br) with fixes from
    Stefaan Eeckels, Eurokom, Luxembourg.
    David Lane added support for Stratus X.25 1996.
    Stephen Riehm added support for IBM AIX X.25 in April 1998.
  Other contributions as indicated in the code.

  Copyright (C) 1985, 1998, Trustees of Columbia University in the City of New
  York.  The C-Kermit software may not be, in whole or in part, licensed or
  sold for profit as a software product itself, nor may it be included in or
  distributed with commercial products or otherwise distributed by commercial
  concerns to their clients or customers without written permission of the
  Office of Kermit Development and Distribution, Columbia University.  This
  copyright notice must not be removed, altered, or obscured.
*/
#include "ckcsym.h"
#include "ckcdeb.h"
#include "ckcker.h"
#ifdef I386IX				/* Has to come before ckcnet.h in */
#include <errno.h>			/* this version, but after in others */
#endif /* I386IX */
#include "ckcnet.h"

#ifdef NETCONN
/* Don't need these if there is no network support. */

#ifdef CK_SOCKS				/* SOCKS Internet relay package */
#define accept  Raccept
#define bind    Rbind
#define connect Rconnect
#define getsockname Rgetsockname
#define listen Rlisten
#endif /* CK_SOCKS */

#ifdef DEC_TCPIP
#include <time.h>
#include <inet.h>
#endif /* DEC_TCPIP */

#ifdef CMU_TCPIP
#include <time.h>
#endif /* CMU_TCPIP */

#ifdef WINTCP

#include <setjmp.h>
#include <signal.h>
#include <sys/time.h>
/*
  The WIN/TCP code path is the same as that for MultiNet.
  Only the routine names have changed ...
*/
#define socket_read 	netread
#define socket_ioctl	ioctl
#define socket_write 	netwrite
#define socket_close 	netclose

#ifdef OLD_TWG                         /* some routines have evolved */
	extern int vmserrno, uerrno;
#define socket_errno    uerrno
#define socket_perror   perror         /* which uses errno, not uerrno! */
#else
#define socket_errno    errno
#define socket_perror   win$perror
#endif /* OLD_TWG */

#else /* Not WINTCP */

#ifndef I386IX
#include <errno.h>			/* Already included above */
#endif /* I386IX */

#include <signal.h>			/* Everybody needs this */

#ifdef ZILOG				/* Zilog has different name for this */
#include <setret.h>
#else /* !ZILOG */
#include <setjmp.h>
#ifdef CK_POSIX_SIG			/* POSIX signal handling */
#endif /* CK_POSIX_SIG */
#endif /* ZILOG */

#endif /* WINTCP */

#ifdef datageneral			/* Data General AOS/VS */
#include <:usr:include:vs_tcp_errno.h>
#include <:usr:include:sys:vs_tcp_types.h>
#ifdef SELECT
/*
  NOTE: This can be compiled and linked OK with SELECT defined
  but it doesn't work at all.  Anybody who cares and knows how
  to fix it, feel free.
*/
#include <:usr:include:sys:vs_tcp_time.h>
#endif /* SELECT */
#include <:usr:include:sys:socket.h>
#include <:usr:include:netinet:in.h>
#include <:usr:include:netdb.h>
#endif /* datageneral */

extern
#ifdef OS2
SIGTYP (* volatile saval)();		/* For saving alarm handler */
#else /* OS2 */
SIGTYP (*saval)();			/* For saving alarm handler */
#endif /* OS2 */

_PROTOTYP( VOID bgchk, (void) );
_PROTOTYP( VOID tn_debug, (char *) );
_PROTOTYP( static int tn_sndloc, () );

int tcp_rdns =				/* Reverse DNS lookup */
#ifdef DEC_TCPIP_OLD
SET_OFF					/* Doesn't seem to work in UCX */
#else
SET_AUTO
#endif /* DEC_TCPIP */
;

#ifdef RLOGCODE
#ifdef TCPIPLIB
_PROTOTYP( static VOID rlog_oob, (CHAR *, int) );
#else /* TCPIPLIB */
_PROTOTYP( static SIGTYP rlogoobh, ( int ) );
#endif /* TCPIPLIB */
_PROTOTYP( static int rlog_ini, (VOID) );
int rlog_mode = RL_COOKED;
int rlog_stopped = 0;
#endif /* RLOGCODE */

#ifdef CK_ENVIRONMENT
int tn_env_flg =
#ifdef OS2
1
#else
0
#endif /* OS2 */
;
#else
int tn_env_flg = 0;
#endif /* CK_ENVIRONMENT */

/* NAWS state - used in both TELNET and RLOGIN */
int nawsflg = 0;

extern int				/* External variables */
  duplex, debses, seslog, sessft,
  ttyfd, quiet, msgflg, what, nettype, ttmdm;

#ifndef NOICP
extern int doconx;			/* CONNECT-class command active */
#endif /* NOICP */

#ifdef IBMX25
/* This variable should probably be generalised for true client/server
 * support - ie: the fd of the listening server, accepted calls should
 * be forked or at least handled via a second fd (for IBM's X.25 -
 * ttyfd always holds the active fd - ie the server becomes inactive
 * as long as a client is connected, and becomes active again when the
 * connection is closed)
 */
int x25serverfd = 0;		/* extern in ckcnet.h */
int x25seqno = 0;		/* Connection sequence number */
int x25lastmsg = -1;		/* A cheapskate's state table */

#define X25_CLOSED	0	/* Default state: no connection, no STREAM */
#define	X25_SETUP	1	/* X.25 has been set up (no connection) */
#define X25_CONNECTED	2	/* X.25 connection has been established */
int x25_state = X25_CLOSED;	/* Default state */
#endif /* IBMX25 */



#ifdef DEBUG
extern int deblog;
#else
#define deblog 0
#endif /* DEBUG */

#ifdef OS2
extern int tt_rows[], tt_cols[];
extern int tt_status;
#else /* OS2 */
extern int tt_rows, tt_cols;		/* Everybody has this */
#endif /* OS2 */


#ifdef CK_TTGWSIZ
_PROTOTYP( int ttgwsiz, (void) );
#endif /* CK_TTGWSIZ */
#ifdef CK_NAWS				/* Negotiate About Window Size */
_PROTOTYP( int tn_snaws, (void) );
#ifdef RLOGCODE
#ifndef OS2
_PROTOTYP(static int rlog_naws, (void) );
#else
_PROTOTYP( int rlog_naws, (void) );
#endif /* OS2 */
#endif /* RLOGCODE */
#endif /* CK_NAWS */

#ifdef OS2				/* For terminal type name string */
#include "ckuusr.h"
#ifndef NT
#include <os2.h>
#undef COMMENT
#endif /* NT */
#include "ckocon.h"
extern int tt_type, max_tt;
extern struct tt_info_rec tt_info[];
extern char ttname[];
extern int  scrninitialized[];
#else /* OS2 */
#ifdef CK_AUTHENTICATION
#include "ckuusr.h"
#endif /* CK_AUTHENTICATION */
#endif /* OS2 */

#ifdef CK_AUTHENTICATION
#include "ckuath.h"
#endif /* CK_AUTHENTICATION */

#include "ckcsig.h"

#ifndef OS2				/* For timeout longjumps */
static ckjmpbuf njbuf;
#endif /* OS2 */

#define NAMECPYL 100			/* Local copy of hostname */
#ifndef OS2
static					/* OS2 needs access in ckonet.c */
#endif /* OS2 */
char namecopy[NAMECPYL];

char ipaddr[20] = { '\0' };		/* Global copy of IP address */
char myipaddr[20] = { '\0' };		/* Global copy of my IP address */

#endif /* NETCONN */

int ttnet = NET_NONE;			/* Network type */
int ttnproto = NP_NONE;			/* Network virtual terminal protocol */
int tn_init = 0;			/* Telnet protocol initialized flag */
int tn_exit = 0;			/* Exit on disconnect */
int tn_duplex = 1;			/* Initial echo status */
char *tn_term = NULL;			/* Terminal type override */
char *tcp_address = NULL;               /* Preferred IP Address */
#ifdef CK_SNDLOC
char *tn_loc = NULL;			/* Location override */
#endif /* CK_SNDLOC */
#ifdef CK_XDISPLOC
char *tn_xdisploc = NULL;               /* X-Display Location */
#endif /* CK_XDISPLOC */
int tn_nlm = TNL_CRLF;			/* Telnet CR -> CR LF mode */
int tn_binary = TN_NG_AC;		/* Binary negotiation accepted */
int tn_b_nlm = TNL_CR;			/* Telnet Binary CR RAW mode */
int tn_b_meu = 0;			/* Telnet Binary ME means U too */
int tn_b_ume = 0;			/* Telnet Binary U means ME too */
extern char uidbuf[];			/* User ID buffer */

#ifdef CK_AUTHENTICATION
int tn_auth = TN_NG_AC;                 /* Telnet Authentication mode */
#endif /* CK_AUTHENTICATION */
#ifdef CK_ENCRYPTION
int tn_encrypt = TN_NG_AC;              /* Telnet Encryption mode */
#endif /* CK_ENCRYPT */
#ifdef IKS_OPTION
int tn_iks = TN_NG_AC;                  /* Telnet Kermit-Server option */
#endif /* IKS_OPTION */
#ifdef OS2
int ttnum = -1;				/* Last Telnet Terminal Type sent */
int ttnumend = 0;			/* Has end of list been found */
#endif /* OS2 */

#ifdef TNCODE
#ifdef CK_AUTHENTICATION
char tn_msg[2048];                      /* For debugging keys */
char hexbuf[2048];
#else /* CK_AUTHENTICATION */
#ifdef CK_ENVIRONMENT
char tn_msg[1024];			/* For debugging */
char hexbuf[1024];
#else /* CK_ENVIRONMENT */
char tn_msg[128];
char hexbuf[6];
#endif /* CK_ENVIRONMENT */
#endif /* CK_AUTHENTICATION */
#endif /* TNCODE */

#ifdef NT
extern int WSASafeToCancel;
int win95selectbug = 0;                 /* For TCP/IP stacks whose select() */
/* always fails on write requests such as Cisco and Quarterdeck */
#define stricmp _stricmp
#endif /* NT */

#ifndef NOTCPOPTS

/* Skip all this if NOTCPOPTS specified. */

#ifdef SOL_SOCKET
#ifdef TCP_NODELAY
int tcp_nodelay = 0;			/* Nagle algorithm TCP_NODELAY */
#endif /* TCP_NODELAY */

#ifdef SO_LINGER
int tcp_linger  = 0;			/* SO_LINGER */
int tcp_linger_tmo = 0;			/* SO_LINGER timeout */
#endif /* SO_LINGER */

#ifdef HPUX				/* But the data structures */
#ifndef HPUX8				/* needed for linger are not */
#ifndef HPUX9				/* defined in HP-UX versions */
#ifndef HPUX10				/* prior to 8.00. */
#ifdef SO_LINGER
#undef SO_LINGER
#endif /* SO_LINGER */
#endif /* HPUX10 */
#endif /* HPUX9 */
#endif /* HPUX8 */
#endif /* HPUX */

#ifdef SO_SNDBUF
int tcp_sendbuf = -1;
#endif /* SO_SNDBUF */
#ifdef SO_RCVBUF
int tcp_recvbuf = -1;
#endif /* SO_RCVBUF */
#ifdef SO_KEEPALIVE
int tcp_keepalive = 1;
#endif /* SO_KEEPALIVE */
#endif /* SOL_SOCKET */

#endif /* NOTCPOPTS */

#ifndef NETCONN
/*
  Network support not defined.
  Dummy functions here in case #ifdef's forgotten elsewhere.
*/
int					/* Open network connection */
netopen(name, lcl, nett) char *name; int *lcl, nett; {
    return(-1);
}
int					/* Close network connection */
netclos() {
    return(-1);
}
int					/* Check network input buffer */
nettchk() {
    return(-1);
}
int					/* Flush network input buffer */
netflui() {
    return(-1);
}
int					/* Send network BREAK */
netbreak() {
    return(-1);
}
int					/* Input character from network */
netinc(timo) int timo; {
    return(-1);
}
int					/* Output character to network */
#ifdef CK_ANSIC
nettoc(char c)
#else
nettoc(c) char c;
#endif /* CK_ANSIC */
/* nettoc */ {
    return(-1);
}
int
nettol(s,n) char *s; int n; {
    return(-1);
}

#else /* NETCONN is defined (rest of this module...) */

#ifdef VMS
/*
  In edit 190, we moved tn_ini() to be called from within netopen().
  But tn_ini() calls ttol(), and ttol() checks to see if it's a net
  connection, but the flag for that isn't set until after netopen()
  is finished.  Since, in this module, we are always doing network
  output anyway, we just call nettol() directly, instead of going thru
  ttol().  Only needed for VMS, since UNIX, AOS/VS, and VOS can handle
  net connections just like regular connections in ttol(), and OS/2
  has a special routine for this.
*/
#define ttol nettol
#endif /* VMS */

extern int tn_binary;			/* Binary mode enabled */
int me_binary = 0;			/* I'm not in TELNET binary mode */
int u_binary = 0;			/* You're not in TELNET binary mode */

int me_auth = 0;                        /* I'm not Authenticating */
#ifdef CK_ENCRYPTION
int me_encrypt = 0;                     /* I'm not Encrypting */
int u_encrypt = 0;                      /* You're not Encrypting */
#endif /* CK_ENCRYPTION */
#ifdef IKS_OPTION
int me_iks = 0;                         /* I'm not negotiating IKS */
int u_iks  = 0;                         /* You're not negotiating IKS */
int me_iks_start = 0;                   /* I'm not IKS START */
int u_iks_start  = 0;                   /* You're not IKS START */
#endif /* IKS_OPTION */

int tcpsrfd = -1;

#ifdef CK_KERBEROS

char * krb4_d_principal = NULL;		/* Default principal */
char * krb5_d_principal = NULL;		/* Default principal */
char * krb4_d_realm = NULL;		/* Default realm */
char * krb5_d_realm = NULL;		/* Default realm */
char * krb5_d_cc = NULL;		/* Default credentials cache */
char * krb4_d_srv   = NULL;             /* Default Service */
char * krb5_d_srv   = NULL;             /* Default Service */

struct krb_op_data krb_op = {		/* Operational data structure */
    0, NULL				/* (version, cachefile) */
};

struct krb4_init_data krb4_init = {	/* Kerberos 4 INIT data structure */
    0, NULL, NULL, NULL, NULL             /* (see ckcnet.h) */
};

struct krb5_init_data krb5_init = {	/* Kerberos 5 INIT data structure */
    0, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, NULL /* (see ckcnet.h) */
};

struct krb5_list_cred_data krb5_lc = {	/* List Credentials data structure */
    0, 0
};

int krb_action = -1;			/* Kerberos action to perform */

#ifndef CK_AUTHENTICATION
char *
ck_krb4_getrealm() {
    return("");
}
char *
ck_krb5_getrealm(cc) char * cc; {
    return("");
}
#endif /* CK_AUTHENTICATION */

/*  I N I _ K E R B  --  Initialize Kerberos data  */

VOID
ini_kerb() {
    krb_action = -1;			/* No action specified */

    krb_op.version = 0;			/* Kerberos version (none) */
    krb_op.cache = NULL;		/* Cache file (none) */

/* Kerberos 5 */

    krb5_init.forwardable = 0;		/* Init switch values... */
    krb5_init.proxiable   = 0;
    krb5_init.lifetime    = 0;
    krb5_init.renew       = 0;
    krb5_init.renewable   = 0;
    krb5_init.validate    = 0;
    if (krb5_init.postdate) {
        free(krb5_init.postdate);
        krb5_init.postdate = NULL;
    }
    if (krb5_init.service) {
        free(krb5_init.service);
        krb5_init.service = NULL;
    }
    if (!krb5_d_realm) {		/* Set default realm */
	char * p;
	p = ck_krb5_getrealm(krb5_d_cc);
	makestr(&krb5_d_realm,p);
    }
    makestr(&krb5_init.realm,krb5_d_realm); /* Set realm from default */
    if (krb5_init.password) {
        free(krb5_init.password);
        krb5_init.password = NULL;
    }
    if (!krb5_d_principal)		/* Default principal */
      makestr(&(krb5_d_principal),(char *)uidbuf); /* Principal = user */
    makestr(&(krb5_init.principal),krb5_d_principal);

/* Kerberos 4 */

    krb4_init.lifetime = 0;
    if (krb4_init.instance) {
        free(krb4_init.instance);
        krb4_init.instance = NULL;
    }
    if (!krb4_d_realm) {		/* Set default realm */
	char * p;
	p = ck_krb4_getrealm();
	makestr(&krb4_d_realm,p);
    }
    makestr(&krb4_init.realm,krb4_d_realm);
    if (krb4_init.password) {
        free(krb4_init.password);
        krb4_init.password = NULL;
    }
    if (!krb4_d_principal)		/* Default principal */
      makestr(&(krb4_d_principal),(char *)uidbuf); /* Principal = user */
    makestr(&(krb4_init.principal),krb4_d_principal);
}

/*  D O A U T H  --  AUTHENTICATE action routine  */

int
doauth(cx) int cx; {			/* AUTHENTICATE action routine */
    int rc = 0;				/* Return code */

#ifdef CK_AUTHENTICATION
#ifdef OS2
    if (!ck_krb_loaddll())		/* Load Kerberos DLL */
      return(rc);
#endif /* OS2 */
#ifdef BETATEST
    sho_auth(cx);
#endif /* BETATEST */
    if (krb_op.version == 4) {		/* Version = 4 */
        if (!ck_krb4_is_installed()) {
            printf("?Kerberos 4 is not installed\n");
            return(0);
        }
        switch (krb_action) {		/* Perform V4 functions */
	  case KRB_A_IN:		/* INIT */
            rc |= !(ck_krb4_initTGT(&krb_op,&krb4_init) < 0);
            break;
	  case KRB_A_DE:		/* DESTROY */
            rc |= !(ck_krb4_destroy(&krb_op) < 0);
            break;
	  case KRB_A_LC:		/* LIST-CREDENTIALS */
            rc |= !(ck_krb4_list_creds(&krb_op) < 0);
            break;
        }
    }
    if (krb_op.version == 5) {		/* V5 functions */
        if (!ck_krb5_is_installed()) {
            printf("?Kerberos 5 is not installed\n");
            return(0);
        }
        switch (krb_action) {
	  case KRB_A_IN:		/* INIT */
            rc |= !(ck_krb5_initTGT(&krb_op,&krb5_init) < 0);
            break;
        case KRB_A_DE:                      /* DESTROY */
            rc |= !(ck_krb5_destroy(&krb_op) < 0);
            break;
        case KRB_A_LC:                      /* LIST-CREDENTIALS */
            if (krb_op.version == 0)
	      printf("\n");
            rc |= !(ck_krb5_list_creds(&krb_op,&krb5_lc) < 0);
            break;
        }
    }
#else
#ifndef NOICP
#ifndef NOSHOW
    rc = sho_auth(cx);			/* Just show the Kerberos data */
#endif /* NOSHOW */
#endif /* NOICP */
#endif /* CK_AUTHENTICATION */
    return(rc);
}
#endif /* CK_KERBEROS */

#ifdef TCPSOCKET
#ifndef OS2
#ifndef NOLISTEN			/* For incoming connections */

#ifndef INADDR_ANY
#define INADDR_ANY 0
#endif /* INADDR_ANY */

_PROTOTYP( int ttbufr, ( VOID ) );
_PROTOTYP( int tcpsrv_open, (char *, int *, int, int ) );

static unsigned short tcpsrv_port = 0;

#endif /* NOLISTEN */
#endif /* OS2 */

static char svcbuf[80];			/* TCP service string */
static int svcnum = 0;			/* TCP port number */

#endif /* TCPSOCKET */

#ifndef NOSIGWINCH
#ifdef CK_NAWS				/* Window size business */
#ifdef SIGWINCH
#ifdef UNIX
static int sw_armed = 0;		/* SIGWINCH armed flag */
SIGTYP
winchh(foo) int foo; {
    int x;
    debug(F100,"SIGWINCH caught","",0);
    signal(SIGWINCH,winchh);		/* Re-arm the signal */
    if (ttyfd == -1)
      return;
    x = ttgwsiz();			/* Get new window size */
/*
  This should be OK.  It might seem that sending this from
  interrupt level could interfere with another TELNET IAC string
  that was in the process of being sent.  But we always send
  TELNET strings with a single write(), which should prevent mixups.
*/
    if (x > 0 && tt_rows > 0 && tt_cols > 0) {
	tn_snaws();
#ifdef RLOGCODE
	rlog_naws();
#endif /* RLOGCODE */
    }
    return;
}
#endif /* UNIX */
#endif /* SIGWINCH */
#endif /* CK_NAWS */
#endif /* NOSIGWINCH */

/*
  TCPIPLIB means use separate socket calls for i/o, while on UNIX the
  normal file system calls are used for TCP/IP sockets too.
  Means "DEC_TCPIP or MULTINET or WINTCP or OS2 or BEBOX" (see ckcnet.h),
*/

#ifdef TCPIPLIB

/* For buffered network reads... */
/*
  If the buffering code is written right, it shouldn't matter
  how long this buffer is.
*/
#ifdef OS2
#ifdef NT
#define TTIBUFL 64240                   /* 44 * 1460 (MSS) */
#else
#define TTIBUFL 32120                   /* 22 * 1460 (MSS) */
#endif /* NT */
#else /* OS2 */
#define TTIBUFL 8191			/* Let's use 8K. */
#endif /* OS2 */

CHAR ttibuf[TTIBUFL+1];

/*
  select() is used in preference to alarm()/signal(), but different systems
  use different forms of select()...
*/
#ifndef NOSELECT         /* Option to override BSDSELECT */
#ifdef BELLV10
/*
  Note: Although BELLV10 does have TCP/IP support, and does use the unique
  form of select() that is evident in this module (and in ckutio.c), it does
  not have a sockets library and so we can't build Kermit TCP/IP support for
  it.  For this, somebody would have to write TCP/IP streams code.
*/
#define BELLSELECT
#ifndef FD_SETSIZE
#define FD_SETSIZE 128
#endif /* FD_SETSIZE */
#else
#ifdef WINTCP				/* VMS with Wollongong WIN/TCP */
#ifndef OLD_TWG				/* TWG 3.2 has only select(read) */
#define BSDSELECT
#endif /* OLD_TWG */
#else
#ifdef CMU_TCPIP			/* LIBCMU can do select */
#define BSDSELECT
#else
#ifdef DEC_TCPIP
#define BSDSELECT
#else
#ifdef OS2				/* OS/2 with TCP/IP */
#ifdef NT
#define BSDSELECT
#else /* NT */
#define IBMSELECT
#endif /* NT */
#endif /* OS2 */
#endif /* DEC_TCPIP */
#endif /* CMU_TCPIP */
#endif /* WINTCP */
#endif /* BELLV10 */
#endif /* NOSELECT */
/*
  Others (TGV, TCPware, ...) use alarm()/signal().  The BSDSELECT case does not
  compile at all; the IBMSELECT case compiles and links but crashes at runtime.
  NOTE: If any of these can be converted to select(), they should be for two
  reasons: (1) It's a lot faster; (2) certain sockets libraries do not like
  their socket_read() calls to be interrupted; subsequent socket_read()'s tend
  to fail with EBUSY.  This happened in the UCX case before it was converted
  to use select().
*/
#ifndef NT_TCP_OVERLAPPED
#ifndef VMS
static					/* These are used in CKVTIO.C */
#endif /* VMS */
#endif /* NT_TCP_OVERLAPPED */
int
  ttibp = 0,
  ttibn = 0;
/*
  Read bytes from network into internal buffer ttibuf[].
  To be called when input buffer is empty, i.e. when ttibn == 0.

  Other network reading routines, like ttinc, ttinl, ttxin, should check the
  internal buffer first, and call this routine for a refill if necessary.

  Returns -1 on error, 0 if nothing happens.  When data is read successfully,
  returns number of bytes read, and sets global ttibn to that number and
  ttibp (the buffer pointer) to zero.
*/
_PROTOTYP( int ttbufr, ( VOID ) );
int
ttbufr() {				/* TT Buffer Read */
    int count;

    ttibuf[0] = '\0';                   /* Make it easier to debug */

    if (ttnet != NET_TCPB)		/* First make sure current net is */
      return(-1);			/* TCP/IP; if not, do nothing. */

    if (ttibn > 0)			/* Our internal buffer is not empty, */
      return(ttibn);			/* so keep using it. */

    if (ttyfd == -1)			/* No connection, error */
	return(-2);

#ifdef WINTCP
    count = 512;			/* This works for WIN/TCP */
#else
#ifdef DEC_TCPIP
    count = 512;			/* UCX */
#else
#ifdef OS2
    count = TTIBUFL;
#else					/* Multinet, etc. */
    count = ttchk();			/* Check network input buffer, */
    if (ttibn > 0) return(ttibn);	/* which can put a char there! */
    if (count < 0)			/* Read error - connection closed */
      return(-2);
    else if (count > TTIBUFL)		/* Too many to read */
      count = TTIBUFL;
    else if (count == 0)		/* None, so force blocking read */
      count = 1;
#endif /* OS2 */
#endif /* DEC_TCPIP */
#endif /* WINTCP */
    debug(F101,"ttbufr count 1","",count);

#ifdef COMMENT
/*
 This is for nonblocking reads, which we don't do any more.  This code didn't
 work anyway, in the sense that a broken connection was never sensed.
*/
    if ((count = socket_read(ttyfd,ttibuf,count)) < 1) {
	if (count == -1 && socket_errno == EWOULDBLOCK) {
	    debug(F100,"ttbufr finds nothing","",0);
	    return(0);
	} else {
	    debug(F101,"ttbufr socket_read error","",socket_errno);
	    return(-1);
	}

    } else if (count == 0) {
	debug(F100,"ttbufr socket eof","",0);
	return(-1);
    }
#else /* COMMENT */

/* This is for blocking reads */

#ifndef VMS
#ifdef SO_OOBINLINE
    {
	int outofband = 0;
#ifdef BELLSELECT
	if (select(128, NULL, NULL, efds, 0) > 0 && FD_ISSET(ttyfd, efds))
	  outofband = 1;
#else
#ifdef BSDSELECT
	fd_set efds;
	struct timeval tv;
	FD_ZERO(&efds);
	FD_SET(ttyfd, &efds);
	tv.tv_sec  = tv.tv_usec = 0L;
	debug(F100,"Out-of-Band BSDSELECT","",0);
#ifdef NT
	WSASafeToCancel = 1;
#endif /* NT */
	if (select(FD_SETSIZE, NULL, NULL, &efds, &tv) > 0 &&
	    FD_ISSET(ttyfd, &efds))
	  outofband = 1;
#ifdef NT
	WSASafeToCancel = 0;
#endif /* NT */
#else /* !BSDSELECT */
#ifdef IBMSELECT
/* Was used by OS/2, currently not used, but might come in handy some day... */
/* ... and it came in handy!  For our TCP/IP layer, it avoids all the fd_set */
/* and timeval stuff since this is the only place where it is used. */
	int socket = ttyfd;
	debug(F100,"Out-of-Band IBMSELECT","",0);
	if ((select(&socket, 0, 0, 1, 0L) == 1) && (socket == ttyfd))
	  outofband = 1;
#else /* !IBMSELECT */
/*
  If we can't use select(), then we use the regular alarm()/signal()
  timeout mechanism.
*/
      debug(F101,"Out-of-Band data not supported","",0);
      outofband = 0;

#endif /* IBMSELECT */
#endif /* BSDSELECT */
#endif /* BELLSELECT */
      if (outofband) {
         /* Get the Urgent Data */
         /* if OOBINLINE is disabled this should be only a single byte      */
         /* MS Winsock has a bug in Windows 95.  Extra bytes are delivered  */
         /* That were never sent.                                           */
	  if ((count = socket_recv(ttyfd,ttibuf,count,MSG_OOB)) <= 0) {
	      int s_errno = socket_errno;
	      debug(F101, "ttbufr socket_recv MSG_OOB","",count);
	      debug(F101, "ttbufr socket_errno","",s_errno);
#ifndef OS2
	      netclos();			/* *** *** */
	      return(-2);
#else /* OS2 */
	      if (count == 0) {
		  debug(F100,"ttbufr Closing Connection","",0);
		  ttclos(0);		/* if the connection was  */
		  if (ttname[0] == '*') { /* incoming, wait for another */
		      int local;
		      os2_netopen(ttname,&local,ttnet);
		      debug(F101,
			    "ttbufr returns zero - try again immediately",
			    "",
			    0
			    );
		      return 0;		/* try again immediately */
		  } else {
		      debug(F101, "ttbufr returns hard error","",-3);
		      return -3;	/* return a hard error    */
		  }
	      } else {
#ifdef NT
		  if (s_errno == WSAETIMEDOUT)
		    debug(F100,"WSAETIMEDOUT","",0);
#endif /* NT */
		  switch (s_errno) {
#ifdef NT
		    case WSAETIMEDOUT:
#else
		    case SOCETIMEDOUT:
		    case SOCETIMEDOUT - SOCBASEERR:
#endif /* NT */
		      debug(F100,"ttbufr ETIMEDOUT","",0);
		      return(-1);
#ifdef NT
		    case WSAECONNRESET:
#else /* NT */
		    case SOCECONNRESET:
		    case SOCECONNRESET - SOCBASEERR:
#endif /* NT */
		      debug(F100,"ttbufr ECONRESET","",0);
		      netclos();	/* *** *** */
		      return(-2);	/* Connection is broken. */
#ifdef NT
		    case WSAECONNABORTED:
#else /* NT */
		    case SOCECONNABORTED:
		    case SOCECONNABORTED - SOCBASEERR:
#endif /* NT */
		      debug(F100,"ttbufr ECONNABORTED","",0);
		      netclos();	/* *** *** */
		      return(-2);	/* Connection is broken. */
#ifdef NT
		    case WSAENETRESET:
#else /* NT */
		    case SOCENETRESET:
		    case SOCENETRESET - SOCBASEERR:
#endif /* NT */
		      debug(F100,"ttbufr ENETRESET","",0);
		      netclos();	/* *** *** */
		      return(-2);	/* Connection is broken. */
#ifdef NT
		    case WSAENOTCONN:
#else /* NT */
		    case SOCENOTCONN:
		    case SOCENOTCONN - SOCBASEERR:
#endif /* NT */
		      debug(F100,"ttbufr ENOTCONN","",0);
		      netclos();	/* *** *** */
		      return(-2);	/* Connection is broken. */
#ifdef NT
		    case WSAEWOULDBLOCK:
#else
		    case SOCEWOULDBLOCK:
		    case SOCEWOULDBLOCK - SOCBASEERR:
#endif /* NT */
		      debug(F100,"ttbufr EWOULDBLOCK","",0);
		      count = 1;
		      break;
#ifdef NT
		    case WSAEINVAL:
#else /* NT */
		    case SOCEINVAL:
		    case SOCEINVAL - SOCBASEERR:
#endif /* NT */
                      case 0:
                      case 23: /* ??? */
		      /* These appear in OS/2 - don't know why   */
		      /* ignore it and read as normal data       */
		      /* and break, then we will attempt to read */
		      /* the port using normal read() techniques */
		      debug(F100,"ttbufr handing as in-band data","",0);
		      count = 1;
		      break;

		    default:
		      debug(F101, "ttbufr Unknown Error ","",s_errno);
		      netclos();
		      return -2;	/* Return a hard error */
		  }
	      }
#endif /* OS2 */
	  } else {			/* we got out-of-band data */
	      debug(F111,"ttbufr out-of-band chars","",count);
#ifdef BETATEST
              bleep(BP_NOTE);
#endif /* BETATEST */
#ifdef RLOGCODE				/* blah */
	      if (ttnproto == NP_RLOGIN) {
		  /*
		    When urgent data is read with MSG_OOB and not OOBINLINE
		    then urgent data and normal data are not mixed.  So
		    treat the entire buffer as urgent data.
		  */
		  rlog_oob(ttibuf, count);
		  return ttbufr();
	      } else
#endif /* RLOGCODE */ /* blah */
#ifdef COMMENT
            /*
	       I haven't written this yet, nor do I know what it should do
	     */
		if (ttnproto == NP_TELNET) {
		    tn_oob();
		    return 0;
		} else
#endif /* COMMENT */
		  {
		   /* For any protocols we don't have a special out-of-band  */
                   /* handler for, just put the bytes in the normal buffer   */
                   /* and return                                             */

		      ttibp = 0;	/* Reset buffer pointer. */
		      ttibn = count;
#ifdef DEBUG
		      /* Got some bytes. */
		      debug(F101,"ttbufr count 2","",count);
		      if (count > 0)
			ttibuf[count] = '\0';
		      debug(F111,"ttbufr ttibuf",ttibuf,ttibp);
#endif /* DEBUG */
		      return(ttibn);	/* Return buffer count. */
		  }
	  }
      }
    }
#endif /* SO_OOBINLINE */
#endif /* VMS */

    if ((count = socket_read(ttyfd,ttibuf,count)) <= 0) {
	int s_errno = socket_errno;
	debug(F101,"ttbufr socket_read","",count);
	debug(F101,"ttbufr socket_errno","",s_errno);
#ifndef OS2
	netclos();			/* *** *** */
	return(-2);
#else /* OS2 */
	if (count == 0) {
	    debug(F100,"ttbufr Closing Connection","",0);
	    ttclos(0);			/* if the connection was  */
	    if (ttname[0] == '*') {	/* incoming, wait for another */
		int local;
		os2_netopen(ttname,&local,ttnet);
		debug(F101,
		      "ttbufr returns zero - try again immediately","",0);
		return 0;		/* try again immediately */
	    } else {
		debug(F101, "ttbufr returns hard error","",-3);
		return -3;		/* return a hard error    */
	    }
	} else {
#ifdef NT
	    if (s_errno == WSAETIMEDOUT)
	      debug(F100, "WSAETIMEDOUT","",0);
#endif /* NT */
	    switch (s_errno) {
#ifdef NT
	      case WSAETIMEDOUT:
#else
	      case SOCETIMEDOUT:
	      case SOCETIMEDOUT - SOCBASEERR:
#endif /* NT */
		debug(F100,"ttbufr ETIMEDOUT","",0);
		return(-1);
#ifdef NT
	      case WSAECONNRESET:
#else /* NT */
	      case SOCECONNRESET:
	      case SOCECONNRESET - SOCBASEERR:
#endif /* NT */
		debug(F100,"ttbufr ECONRESET","",0);
		netclos();			/* *** *** */
		return(-2);			/* Connection is broken. */
#ifdef NT
	      case WSAECONNABORTED:
#else /* NT */
	      case SOCECONNABORTED:
	      case SOCECONNABORTED - SOCBASEERR:
#endif /* NT */
		debug(F100,"ttbufr ECONNABORTED","",0);
		netclos();			/* *** *** */
		return(-2);			/* Connection is broken. */
#ifdef NT
	      case WSAENETRESET:
#else /* NT */
	      case SOCENETRESET:
	      case SOCENETRESET - SOCBASEERR:
#endif /* NT */
		debug(F100,"ttbufr ENETRESET","",0);
		netclos();			/* *** *** */
		return(-2);			/* Connection is broken. */
#ifdef NT
	      case WSAENOTCONN:
#else /* NT */
	      case SOCENOTCONN:
	      case SOCENOTCONN - SOCBASEERR:
#endif /* NT */
		debug(F100,"ttbufr ENOTCONN","",0);
		netclos();			/* *** *** */
		return(-2);			/* Connection is broken. */
#ifdef NT
	      case WSAEWOULDBLOCK:
#else
	      case SOCEWOULDBLOCK:
	      case SOCEWOULDBLOCK - SOCBASEERR:
#endif /* NT */
		debug(F100,"ttbufr EWOULDBLOCK","",0);
		break;
	    }
	    debug(F101, "ttbufr returns timeout","",-1);
	    return -1;			/* Return a timeout */
	}
#endif /* OS2 */
    }
#endif /* COMMENT */
    else {
	ttibp = 0;			/* Reset buffer pointer. */
	ttibn = count;
#ifdef DEBUG
	debug(F101,"ttbufr count 2","",count); /* Got some bytes. */
	if (count > 0)
          ttibuf[count] = '\0';
	debug(F111,"ttbufr ttibuf",ttibuf,ttibp);
#endif /* DEBUG */
	return(ttibn);			/* Return buffer count. */
    }
}
#endif /* TCPIPLIB */

#ifndef IBMSELECT
#ifndef BELLSELECT
#ifndef BSDSELECT		/* Non-TCPIPLIB case */
#ifdef SELECT
#define BSDSELECT
#endif /* SELECT */
#endif /* BSDSELECT */
#endif /* BELLSELECT */
#endif /* IBMSELECT */

#define	TELNET_PORT 23	 	/* Should do lookup, but it won't change */
#define RLOGIN_PORT 513
#define KERMIT_PORT 1649

/* This symbol is not known to, e.g., Ultrix 2.0 */
#ifndef TELOPT_TTYPE
#define TELOPT_TTYPE 24
#endif /* TELOPT_TTYPE */

#ifdef CK_SNDLOC
#ifndef TELOPT_SNDLOC
#define TELOPT_SNDLOC 23
#endif /* TELOPT_SNDLOC */
#endif /* CK_SNDLOC */

/* This one seems to be not known to UCX */
#ifndef TELOPT_BINARY
#define TELOPT_BINARY 0
#endif /* TELOPT_BINARY */

/* Type needed as 5th argument (length) to get/setsockopt() */

#ifndef SOCKOPT_T
#define SOCKOPT_T int
#ifdef NT
#undef SOCKOPT_T
#define SOCKOPT_T int
#else /* NT */
#ifdef UNIXWARE
#undef SOCKOPT_T
#define SOCKOPT_T size_t
#else /* UNIXWARE */
#ifdef VMS
#ifdef DEC_TCPIP
#ifdef __DECC_VER
#undef SOCKOPT_T
#define SOCKOPT_T size_t
#endif /* __DECC_VER */
#endif /* DEC_TCPIP */
#endif /* VMS */
#endif /* UNIXWARE */
#endif /* NT */
#endif /* SOCKOPT_T */

/*
  C-Kermit network open/close functions for BSD-sockets.
  Much of this code shared by SunLink X.25, which also uses the socket library.
*/

/*  N E T O P N  --  Open a network connection.  */
/*
  Call with:
    name of host (or host:service),
    lcl - local-mode flag to be set if this function succeeds,
    network type - value defined in ckunet.h.
*/
#ifdef TCPSOCKET
#ifdef EXCELAN
/*
  Most other BSD sockets implementations define these in header files
  and libraries.
*/
struct servent {
    unsigned short s_port;
};

struct hostent {
    short h_addrtype;
    struct in_addr h_addr;
    int h_length;
};

struct servent *
getservbyname(service, connection) char *service,*connection; {
    static struct servent servrec;
    int port;

    port = 0;
    if (strcmp(service, "telnet") == 0) port = 23;
    else if (strcmp(service, "smtp") == 0) port = 25;
    else port = atoi(service);

    debug(F101,"getservbyname return port ","",port);

    if (port > 0) {
    	servrec.s_port = htons(port);
    	return(&servrec);
    }
    return((struct servent *) NULL);
}

struct hostent *
gethostbyname(hostname) char *hostname; {
    return((struct hostent *) NULL);
}

unsigned long
inet_addr(name) char *name; {
    unsigned long addr;

    addr = rhost(&name);
    debug(F111,"inet_addr ",name,(int)addr);
    return(addr);
}

char *
inet_ntoa(in) struct in_addr in; {
    static char name[80];
    sprintf(name, "%d.%d.%d.%d", in.s_net, in.s_host, in.s_lh, in.s_impno);
    return(name);
}
#else
#ifdef DEC_TCPIP			/* UCX */

int ucx_port_bug = 0;			/* Explained below */

#ifndef __DECC				/* VAXC or GCC */

#define getservbyname my_getservbyname

#ifdef CK_ANSIC
globalref int (*C$$GA_UCX_GETSERVBYNAME)();
extern void C$$TRANSLATE();
extern void C$$SOCK_TRANSLATE();
#else
globalref int (*C$$GA_UCX_GETSERVBYNAME)();
extern VOID C$$TRANSLATE();
extern VOID C$$SOCK_TRANSLATE();
#endif /* CK_ANSIC */

struct servent *
my_getservbyname (service, proto) char *service, *proto; {
    static struct servent sent;
    struct iosb {
	union {
	    unsigned long status;
	    unsigned short st[2];
	} sb;
	unsigned long spare;
    } s;
    struct {
	struct iosb *s;
	char *serv;
	char *prot;
    } par;
    unsigned long e;
    char sbuf[30], pbuf[30];
    char *p;

    debug(F111,"UCX getservbyname",service,(int)C$$GA_UCX_GETSERVBYNAME);

    p = sbuf;
    strcpy(p, service);
    while (*p = toupper(*p), *p++) {}
    p = pbuf;
    strcpy(p, proto);
    while (*p = toupper(*p), *p++) {}

    par.s = &s;

    par.serv = "";
    par.prot = "";
    /* reset file pointer or something like that!?!? */
    e = (*C$$GA_UCX_GETSERVBYNAME)(&par, &sent, par.s);
    par.serv = sbuf;
    par.prot = pbuf;		/* that is don't care */
    e = (*C$$GA_UCX_GETSERVBYNAME)(&par, &sent, par.s);
    if ((long)e == -1L)
      return NULL;
    if ((e & 1) == 0L) {
	C$$TRANSLATE(e);
	return NULL;
    }
    if ((s.sb.st[0] & 1) == 0) {
	C$$SOCK_TRANSLATE(&s.sb.st[0]);
	return NULL;
    }
/*
  sent.s_port is supposed to be returned by UCX in network byte order.
  However, UCX 2.0 through 2.0C did not do this; 2.0D and later do it.
  But there is no way of knowing which UCX version, so we have a user-settable
  runtime variable.  Note: UCX 2.0 was only for the VAX.
*/
    debug(F101,"UCX getservbyname port","",sent.s_port);
    debug(F101,"UCX getservbyname ntohs(port)","",ntohs(sent.s_port));
    if (ucx_port_bug) {
	sent.s_port = htons(sent.s_port);
	debug(F100,"UCX-PORT-BUG ON: swapping bytes","",0);
	debug(F101,"UCX swapped port","",sent.s_port);
	debug(F101,"UCX swapped ntohs(port)","",ntohs(sent.s_port));
    }
    return &sent;
}
#endif /* __DECC */
#endif /* DEC_TCPIP */
#endif /* EXCELAN */
#endif /* TCPSOCKET */

#ifndef NOTCPOPTS
#ifndef datageneral
int
ck_linger(onoff, timo) int onoff; int timo; {
/*
  The following, from William Bader, turns off the socket linger parameter,
  which makes a close() block until all data is sent.  "I don't think that
  disabling linger can ever cause kermit to lose data, but you telnet to a
  flaky server (or to our modem server when the modem is in use), disabling
  linger prevents kermit from hanging on the close if you try to exit."

  Modified by Jeff Altman to be generally useful.
*/
#ifdef SOL_SOCKET
#ifdef SO_LINGER
    struct linger set_linger_opt;
    struct linger get_linger_opt;
    SOCKOPT_T x;

    if (ttyfd == -1 ||
	nettype != NET_TCPA && nettype != NET_TCPB || ttmdm >= 0) {
	tcp_linger = onoff;
	tcp_linger_tmo = timo;
	return(1);
    }
    x = sizeof(get_linger_opt);
    if (getsockopt(ttyfd, SOL_SOCKET, SO_LINGER,
                    (char *)&get_linger_opt, &x)) {
	debug(F111,"TCP ck_linger can't get SO_LINGER",ck_errstr(),errno);
    } else if (x != sizeof(get_linger_opt)) {
#ifdef OS2
	struct _linger16 {
	    short s_linger;
	    short s_onoff;
	} get_linger_opt16, set_linger_opt16;
	if ( x == sizeof(get_linger_opt16) ) {
	    debug(F111,"TCP setlinger warning: SO_LINGER","len is 16-bit",x);
	    if (getsockopt(ttyfd,
			   SOL_SOCKET, SO_LINGER,
			   (char *)&get_linger_opt16, &x)
		) {
		debug(F111,
		      "TCP ck_linger can't get SO_LINGER",ck_errstr(),errno);
	    } else if (get_linger_opt16.s_onoff != onoff ||
		       get_linger_opt16.s_linger != timo)
            {
		set_linger_opt16.s_onoff  = onoff;
		set_linger_opt16.s_linger = timo;
		if (setsockopt(ttyfd,
			       SOL_SOCKET,
			       SO_LINGER,
			       (char *)&set_linger_opt16,
			       sizeof(set_linger_opt16))
		    ) {
		    debug(F111,
			  "TCP ck_linger can't set SO_LINGER",
			  ck_errstr(),
			  errno
			  );
		    tcp_linger = get_linger_opt16.s_onoff;
		    tcp_linger_tmo = get_linger_opt16.s_linger;
		} else {
		    debug(F101,
			  "TCP ck_linger new SO_LINGER","",
			  set_linger_opt16.s_onoff);
		    tcp_linger = set_linger_opt16.s_onoff;
		    tcp_linger_tmo = set_linger_opt16.s_linger;
		    return 1;
                }
            } else {
                debug(F101,"TCP ck_linger SO_LINGER unchanged","",
                       set_linger_opt16.s_onoff);
                tcp_linger = set_linger_opt16.s_onoff;
                tcp_linger_tmo = set_linger_opt16.s_linger;
                return 1;
            }
            return(0);
	}
#endif /* OS2 */
	debug(F111,"TCP ck_linger error: SO_LINGER","len",x);
	debug(F111,"TCP ck_linger SO_LINGER",
	      "expected len",sizeof(get_linger_opt));
	debug(F111,"TCP ck_linger SO_LINGER","linger_opt.l_onoff",
	      get_linger_opt.l_onoff);
	debug(F111,"TCP linger SO_LINGER","linger_opt.l_linger",
	       get_linger_opt.l_linger);
    } else if (get_linger_opt.l_onoff != onoff ||
	       get_linger_opt.l_linger != timo) {
	set_linger_opt.l_onoff  = onoff;
	set_linger_opt.l_linger = timo;
	if (setsockopt(ttyfd,
		       SOL_SOCKET,
		       SO_LINGER,
		       (char *)&set_linger_opt,
		       sizeof(set_linger_opt))) {
	    debug(F111,"TCP ck_linger can't set SO_LINGER",ck_errstr(),errno);
            tcp_linger = get_linger_opt.l_onoff;
            tcp_linger_tmo = get_linger_opt.l_linger;
	 } else {
	     debug(F101,
		   "TCP ck_linger new SO_LINGER",
		   "",
		   set_linger_opt.l_onoff
		   );
             tcp_linger = set_linger_opt.l_onoff;
             tcp_linger_tmo = set_linger_opt.l_linger;
	     return 1;
	 }
    } else {
	debug(F101,"TCP ck_linger SO_LINGER unchanged","",
	      set_linger_opt.l_onoff);
        tcp_linger = set_linger_opt.l_onoff;
        tcp_linger_tmo = set_linger_opt.l_linger;
	return 1;
    }
#else
    debug(F100,"TCP ck_linger SO_LINGER not defined","",0);
#endif /* SO_LINGER */
#else
    debug(F100,"TCP ck_linger SO_SOCKET not defined","",0);
#endif /* SOL_SOCKET */
    return(0);
}

int
sendbuf(size) int size; {
/*
  The following, from William Bader, allows changing of socket buffer sizes,
  in case that might affect performance.

  Modified by Jeff Altman to be generally useful.
*/
#ifdef SOL_SOCKET
#ifdef SO_SNDBUF
    int i, j, rc = 0;
    SOCKOPT_T x;

    if (ttyfd == -1 ||
	nettype != NET_TCPA && nettype != NET_TCPB || ttmdm >= 0) {
	tcp_sendbuf = size;
	return 1;
    }
    x = sizeof(i);
    if (getsockopt(ttyfd, SOL_SOCKET, SO_SNDBUF, (char *)&i, &x)) {
	debug(F111,"TCP sendbuf can't get SO_SNDBUF",ck_errstr(),errno);
    } else if (x != sizeof(i)) {
#ifdef OS2
	short i16,j16;
	if (x == sizeof(i16)) {
	    debug(F111,"TCP sendbuf warning: SO_SNDBUF","len is 16-bit",x);
	    if (getsockopt(ttyfd,
			   SOL_SOCKET, SO_SNDBUF,
			   (char *)&i16, &x)
		) {
		debug(F111,"TCP sendbuf can't get SO_SNDBUF",
		      ck_errstr(),errno);
	    } else if (size <= 0) {
		tcp_sendbuf = i16;
		debug(F101,"TCP sendbuf SO_SNDBUF retrieved","",i16);
		return 1;
	    } else if (i16 != size) {
		j16 = size;
		if (setsockopt(ttyfd,
			       SOL_SOCKET,
			       SO_SNDBUF,
			       (char *)&j16,
			       sizeof(j16))
		    ) {
		    debug(F111,"TCP sendbuf can't set SO_SNDBUF",
			  ck_errstr(),errno);
		} else {
		    debug(F101,"TCP sendbuf old SO_SNDBUF","",i16);
		    debug(F101,"TCP sendbuf new SO_SNDBUF","",j16);
		    tcp_sendbuf = size;
		    return 1;
		}
	    } else {
		debug(F101,"TCP sendbuf SO_SNDBUF unchanged","",i16);
		tcp_sendbuf = size;
		return 1;
	    }
	    return(0);
	}
#endif /* OS2 */
	debug(F111,"TCP sendbuf error: SO_SNDBUF","len",x);
	debug(F111,"TCP sendbuf SO_SNDBUF","expected len",sizeof(i));
	debug(F111,"TCP sendbuf SO_SNDBUF","i",i);
    } else if (size <= 0) {
	tcp_sendbuf = i;
	debug(F101,"TCP sendbuf SO_SNDBUF retrieved","",i);
	return 1;
    } else if (i != size) {
	j = size;
	if (setsockopt(ttyfd, SOL_SOCKET, SO_SNDBUF, (char *)&j, sizeof(j))) {
	    debug(F111,"TCP sendbuf can't set SO_SNDBUF",ck_errstr(),errno);
            tcp_sendbuf = i;
	} else {
	    debug(F101,"TCP sendbuf old SO_SNDBUF","",i);
	    debug(F101,"TCP sendbuf new SO_SNDBUF","",j);
	    tcp_sendbuf = size;
	    return 1;
	}
    } else {
	debug(F101,"TCP sendbuf SO_SNDBUF unchanged","",i);
	tcp_sendbuf = size;
	return 1;
    }
#else
    debug(F100,"TCP sendbuf SO_SNDBUF not defined","",0);
#endif /* SO_SNDBUF */
#else
    debug(F100,"TCP sendbuf SO_SOCKET not defined","",0);
#endif /* SOL_SOCKET */
    return(0);
}

int
recvbuf(size) int size; {
/*
  The following, from William Bader, allows changing of socket buffer sizes,
  in case that might affect performance.

  Modified by Jeff Altman to be generally useful.
*/
#ifdef SOL_SOCKET
#ifdef SO_RCVBUF
    int i, j, rc = 0;
    SOCKOPT_T x;

    if (ttyfd == -1 ||
	nettype != NET_TCPA && nettype != NET_TCPB || ttmdm >= 0) {
	tcp_recvbuf = size;
	return(1);
    }
    x = sizeof(i);
    if (getsockopt(ttyfd, SOL_SOCKET, SO_RCVBUF, (char *)&i, &x)) {
	debug(F111,"TCP recvbuf can't get SO_RCVBUF",ck_errstr(),errno);
    } else if (x != sizeof(i)) {
#ifdef OS2
	short i16,j16;
	if ( x == sizeof(i16) ) {
	    debug(F111,"TCP recvbuf warning: SO_RCVBUF","len is 16-bit",x);
	    if (getsockopt(ttyfd,
			   SOL_SOCKET, SO_RCVBUF,
			   (char *)&i16, &x)
		) {
		debug(F111,"TCP recvbuf can't get SO_RCVBUF",
		      ck_errstr(),errno);
	    } else if (size <= 0) {
		tcp_recvbuf = i16;
		debug(F101,"TCP recvbuf SO_RCVBUF retrieved","",i16);
		return 1;
	    } else if (i16 != size) {
		j16 = size;
		if (setsockopt(ttyfd, SOL_SOCKET, SO_RCVBUF, (char *)&j16,
			       sizeof(j16))) {
		    debug(F111,"TCP recvbuf can' set SO_RCVBUF",
			  ck_errstr(),errno);
		} else {
		    debug(F101,"TCP recvbuf old SO_RCVBUF","",i16);
		    debug(F101,"TCP recvbuf new SO_RCVBUF","",j16);
		    tcp_recvbuf = size;
		    return 1;
		}
	    } else {
		debug(F101,"TCP recvbuf SO_RCVBUF unchanged","",i16);
		tcp_recvbuf = size;
		return 1;
	    }
	    return(0);
	}
#endif /* OS2 */
	debug(F111,"TCP recvbuf error: SO_RCVBUF","len",x);
	debug(F111,"TCP recvbuf SO_RCVBUF","expected len",sizeof(i));
	debug(F111,"TCP recvbuf SO_RCVBUF","i",i);
    } else if (size <= 0) {
	tcp_recvbuf = i;
	debug(F101,"TCP recvbuf SO_RCVBUF retrieved","",i);
	return 1;
    } else if (i != size) {
	j = size;
	if (setsockopt(ttyfd, SOL_SOCKET, SO_RCVBUF, (char *)&j, sizeof(j))) {
	    debug(F111,"TCP recvbuf can't set SO_RCVBUF",ck_errstr(),errno);
            tcp_recvbuf = i;
	} else {
	    debug(F101,"TCP recvbuf old SO_RCVBUF","",i);
	    debug(F101,"TCP recvbuf new SO_RCVBUF","",j);
	    tcp_recvbuf = size;
	    return 1;
	}
    } else {
	debug(F101,"TCP recvbuf SO_RCVBUF unchanged","",i);
	tcp_recvbuf = size;
	return 1;
    }
#else
    debug(F100,"TCP recvbuf SO_RCVBUF not defined","",0);
#endif /* SO_RCVBUF */
#else
    debug(F100,"TCP recvbuf SO_SOCKET not defined","",0);
#endif /* SOL_SOCKET */
    return 0;
}

int
keepalive(onoff) int onoff; {
#ifdef SOL_SOCKET
#ifdef SO_KEEPALIVE
    int get_keepalive_opt;
    int set_keepalive_opt;
    SOCKOPT_T x;

    if (ttyfd == -1 ||
	nettype != NET_TCPA && nettype != NET_TCPB || ttmdm >= 0) {
	tcp_keepalive = onoff;
	return 1;
    }
    x = sizeof(get_keepalive_opt);
    if (getsockopt(ttyfd,
		   SOL_SOCKET, SO_KEEPALIVE, (char *)&get_keepalive_opt, &x)) {
	debug(F111,"TCP keepalive can't get SO_KEEPALIVE",ck_errstr(),errno);
    } else if (x != sizeof(get_keepalive_opt)) {
#ifdef OS2
	short get_keepalive_opt16;
	short set_keepalive_opt16;
	if (x == sizeof(get_keepalive_opt16)) {
	    debug(F111,"TCP keepalive warning: SO_KEEPALIVE",
		  "len is 16-bit",x);
	    if (getsockopt(ttyfd,
			   SOL_SOCKET, SO_KEEPALIVE,
			   (char *)&get_keepalive_opt16, &x)
		) {
		debug(F111,
		      "TCP keepalive can't get SO_KEEPALIVE",
		      ck_errstr(),
		      errno
		      );
	    } else if (get_keepalive_opt16 != onoff) {
		set_keepalive_opt16 = onoff;
		if (setsockopt(ttyfd,
			       SOL_SOCKET,
			       SO_KEEPALIVE,
			       (char *)&set_keepalive_opt16,
			       sizeof(set_keepalive_opt16))
		    ) {
		    debug(F111,
			  "TCP keepalive can't clear SO_KEEPALIVE",
			  ck_errstr(),
			  errno
			  );
                    tcp_keepalive = get_keepalive_opt16;
		} else {
		    debug(F101,
			  "TCP keepalive new SO_KEEPALIVE","",
			  set_keepalive_opt16);
		    tcp_keepalive = set_keepalive_opt16;
		    return 1;
		}
	    } else {
		debug(F101,"TCP keepalive SO_KEEPALIVE unchanged","",
		      set_keepalive_opt16);
		tcp_keepalive = onoff;
		return 1;
	    }
	    return(0);
	}
#endif /* OS2 */
	debug(F111,"TCP keepalive error: SO_KEEPALIVE","len",x);
	debug(F111,
	      "TCP keepalive SO_KEEPALIVE",
	      "expected len",
	      sizeof(get_keepalive_opt)
	      );
	debug(F111,
	      "TCP keepalive SO_KEEPALIVE",
	      "keepalive_opt",
	      get_keepalive_opt
	      );
    } else if (get_keepalive_opt != onoff) {
	    set_keepalive_opt = onoff;
	    if (setsockopt(ttyfd,
			    SOL_SOCKET,
			    SO_KEEPALIVE,
			    (char *)&set_keepalive_opt,
			    sizeof(set_keepalive_opt))
		) {
		debug(F111,
		      "TCP keepalive can't clear SO_KEEPALIVE",
		      ck_errstr(),
		      errno
		      );
                tcp_keepalive = get_keepalive_opt;
	    } else {
		debug(F101,
		      "TCP keepalive new SO_KEEPALIVE",
		      "",
		      set_keepalive_opt
		      );
		tcp_keepalive = onoff;
		return 1;
	    }
	} else {
	    debug(F101,"TCP keepalive SO_KEEPALIVE unchanged",
		  "",
		  get_keepalive_opt
		  );
	    tcp_keepalive = onoff;
	    return 1;
    }
#else
    debug(F100,"TCP keepalive SO_KEEPALIVE not defined","",0);
#endif /* SO_KEEPALIVE */
#else
    debug(F100,"TCP keepalive SO_SOCKET not defined","",0);
#endif /* SOL_SOCKET */
    return(0);
}

int
no_delay(onoff)	 int onoff; {
#ifdef SOL_SOCKET
#ifdef TCP_NODELAY
    int get_nodelay_opt;
    int set_nodelay_opt;
    SOCKOPT_T x;

    if (ttyfd == -1 ||
	nettype != NET_TCPA && nettype != NET_TCPB || ttmdm >= 0) {
	tcp_nodelay = onoff;
	return(1);
    }
    x = sizeof(get_nodelay_opt);
    if (getsockopt(ttyfd,IPPROTO_TCP,TCP_NODELAY,
		   (char *)&get_nodelay_opt,&x)) {
	debug(F111,
	      "TCP no_delay can't get TCP_NODELAY",
	      ck_errstr(),
	      errno);
    } else if (x != sizeof(get_nodelay_opt)) {
#ifdef OS2
	short get_nodelay_opt16;
	short set_nodelay_opt16;
	if (x == sizeof(get_nodelay_opt16)) {
	    debug(F111,"TCP no_delay warning: TCP_NODELAY","len is 16-bit",x);
	    if (getsockopt(ttyfd,
			   IPPROTO_TCP, TCP_NODELAY,
			   (char *)&get_nodelay_opt16, &x)
		) {
		debug(F111,
		      "TCP no_delay can't get TCP_NODELAY",
		      ck_errstr(),
		      errno);
	    } else if (get_nodelay_opt16 != onoff) {
		set_nodelay_opt16 = onoff;
		if (setsockopt(ttyfd,
			       IPPROTO_TCP,
			       TCP_NODELAY,
			       (char *)&set_nodelay_opt16,
			       sizeof(set_nodelay_opt16))
		    ) {
		    debug(F111,
			  "TCP no_delay can't clear TCP_NODELAY",
			  ck_errstr(),
			  errno);
                    tcp_nodelay = get_nodelay_opt16;
		} else {
		    debug(F101,
			  "TCP no_delay new TCP_NODELAY",
			  "",
			  set_nodelay_opt16);
		    tcp_nodelay = onoff;
		    return 1;
		}
	    } else {
		debug(F101,"TCP no_delay TCP_NODELAY unchanged","",
		      set_nodelay_opt16);
		tcp_nodelay = onoff;
		return 1;
	    }
	    return(0);
	}
#endif /* OS2 */
	debug(F111,"TCP no_delay error: TCP_NODELAY","len",x);
	debug(F111,"TCP no_delay TCP_NODELAY","expected len",
	      sizeof(get_nodelay_opt));
	debug(F111,"TCP no_delay TCP_NODELAY","nodelay_opt",get_nodelay_opt);
    } else if (get_nodelay_opt != onoff) {
	set_nodelay_opt = onoff;
	if (setsockopt(ttyfd,
		       IPPROTO_TCP,
		       TCP_NODELAY,
		       (char *)&set_nodelay_opt,
		       sizeof(set_nodelay_opt))) {
	    debug(F111,
		  "TCP no_delay can't clear TCP_NODELAY",
		  ck_errstr(),
		  errno
		  );
            tcp_nodelay = get_nodelay_opt;
	} else {
	    debug(F101,"TCP no_delay new TCP_NODELAY","",set_nodelay_opt);
	    tcp_nodelay = onoff;
	    return 1;
	}
    } else {
	debug(F101,"TCP no_delay TCP_NODELAY unchanged","",set_nodelay_opt);
	tcp_nodelay = onoff;
	return(1);
    }
#else
    debug(F100,"TCP no_delay TCP_NODELAY not defined","",0);
#endif /* TCP_NODELAY */
#else
    debug(F100,"TCP no_delay SO_SOCKET not defined","",0);
#endif /* SOL_SOCKET */
    return 0;
}
#endif /* datageneral */
#endif /* NOTCPOPTS */

#ifdef SUNX25
#ifndef X25_WR_FACILITY
/* For Solaris 2.3 / SunLink 8.x - see comments in ckcnet.h */
void
bzero(s,n) char *s; int n; {
    memset(s,0,n);
}
#endif /* X25_WR_FACILITY */
#endif /* SUNX25 */

#ifdef TCPSOCKET
#ifndef OS2
#ifndef NOLISTEN

#ifdef BSDSELECT
#ifndef VMS
#ifndef BELLV10
#ifndef datageneral
#ifdef hp9000s500			/* HP-9000/500 HP-U 5.21 */
#include <time.h>
#else

/******	THIS SECTION ADDED BY STEVE RANCE - OS9 NETWORK SERVER
*	------------------------------------------------------
*
*	Due to OS9's Lack of a select() call, the following seems to be
*	enough to fool the rest of the code into compiling. The only
*	effect that I can see is using control L to refresh the status
*	display gets qued up until some network packets arrive.
*
*	This solution is by no means elegant but works enough to be
*	a (the) solution.
*
*	Also with the defines I had specified in my makefile I had to
*	have an #endif right at the end of the file when compiling.
*	I did not bother speding time to find out why.
*
*	COPTS	= -to=osk -d=OSK -d=TCPSOCKET -d=SELECT -d=VOID=void -d=SIG_V \
*	   -d=DYNAMIC -d=PARSENSE -d=KANJI -d=MYCURSES -d=ZFCDAT \
*	   -d=CK_APC -d=CK_REDIR -d=RENAME -d=CK_TTYFD -d=NOOLDMODEMS \
*	   -d=CK_ANSIC -d=CK_XYZ -tp=68040d -l=netdb.l -l=socklib.l \
*	   -l=termlib.l -l=math.l -l=sys_clib.l
*
*	stever@ozemail.com.au
*/

#ifdef	OSK
#define	BSDSELECT			/* switch on BSD select code */
#define	FD_SETSIZE 32			/* Max # of paths in OS9 */
#define	FD_ZERO(p)			((*p)=0)
#define	FD_SET(n,b)			((*b)|=(1<<(n)))
#define	FD_ISSET(n,b)		1	/* always say data is ready */
#define	select(a,b,c,d,e)	1	/* always say 1 path has data */
typedef	int	fd_set;			/* keep BSD Code Happy */
struct timeval {int tv_sec,tv_usec;};	/* keep BSD Code Happy */

/******	END OF OS9 MODS FROM STEVE RANCE **************************/
#endif /* OSK */

#include <sys/time.h>
#endif /* hp9000s500 */
#endif /* datageneral */
#endif /* BELLV10 */
#endif /* VMS */
#ifdef SELECT_H
#include <sys/select.h>
#endif /* SELECT_H */
#endif /* BSDSELECT */

#ifdef SELECT
#ifdef CK_SCOV5
#include <sys/select.h>
#endif /* CK_SCOV5 */
#endif /* SELECT */

#ifdef TCPSOCKET
#ifndef SO_OOBINLINE			/* Hopefully only HP-UX 7.0 */
#define SO_OOBINLINE 0x0100
#endif /* SO_OOBINLINE */
#endif /* TCPSOCKET */

#ifdef NOTUSED

/* T C P S O C K E T _ O P E N -- Open a preexisting socket number */

int
tcpsocket_open(name,lcl,nett,timo) char * name; int * lcl; int nett; int timo {
    int on = 1;
    static struct servent *service, servrec;
    static struct hostent *host;
    static struct sockaddr_in saddr;
    static int saddrlen;
#ifdef BSDSELECT
    fd_set rfds;
    struct timeval tv;
#else
#ifdef BELLSELECT
    fd_set rfds;
#else
    fd_set rfds;
    fd_set rfds;
    struct timeval {
	long tv_sec;
	long tv_usec;
    } tv;
#endif /* BELLSELECT */
#endif /* BSDSELECT */

    debug(F101,"tcpsocket_open nett","",nett);
    *ipaddr = '\0';

    if (nett != NET_TCPB)
      return(-1);			/* BSD socket support */

    netclos();				/* Close any previous connection. */
    strncpy(namecopy, name, NAMECPYL);	/* Copy the hostname. */
    if (ttnproto != NP_TCPRAW)
      ttnproto = NP_NONE;		/* No protocol selected yet. */
    debug(F110,"tcpsocket_open namecopy",namecopy,0);

    /* Assign the socket number to ttyfd and then fill in tcp structures */
    ttyfd = atoi(&name[1]);
    debug(F111,"tcpsocket_open","ttyfd",ttyfd);

#ifndef NOTCPOPTS
#ifdef SOL_SOCKET
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);

#ifndef datageneral
#ifdef TCP_NODELAY
    no_delay(tcp_nodelay);
#endif /* TCP_NODELAY */
#ifdef SO_KEEPALIVE
    keepalive(tcp_keepalive);
#endif /* SO_KEEPALIVE */
#ifdef SO_LINGER
    ck_linger(tcp_linger, tcp_linger_tmo);
#endif /* SO_LINGER */
#ifdef SO_SNDBUF
    sendbuf(tcp_sendbuf);
#ifdef COMMENT
    if (tcp_sendbuf < (2*MAXSP))
      sendbuf(((2*MAXSP+1460)/1460)*1460);
#endif /* OS2 */
#endif /* SO_SNDBUF */
#ifdef SO_RCVBUF
    recvbuf(tcp_recvbuf);
#ifdef COMMENT
    if (tcp_recvbuf < (10*MAXRP))
      recvbuf(((10*MAXRP+1460)/1460)*1460);
#endif /* OS2 */
#endif /* SO_RCVBUF */
#endif /* datageneral */
#endif /* SOL_SOCKET */
#endif /* NOTCPOPTS */

#ifdef NT_TCP_OVERLAPPED
    OverlappedWriteInit();
    OverlappedReadInit();
#endif /* NT_TCP_OVERLAPPED */


    /* Get the name of the host we are connected to */

    saddrlen = sizeof(saddr);
    getpeername(ttyfd,(struct sockaddr *)&saddr,&saddrlen);

    if (tcp_rdns == SET_ON) {
        if (!quiet) {
	    printf(" Reverse DNS Lookup... ");
	    fflush(stdout);
	}
	if (host = gethostbyaddr((char *)&saddr.sin_addr,4,PF_INET)) {
	    debug(F100,"tcpsocket_open gethostbyaddr != NULL","",0);
	    if (!quiet) {
		printf("(OK)\n");
		fflush(stdout);
	    }
	    strncpy(name, host->h_name, 79);
	    strncat(name, ":", 80 - strlen(name));
#ifdef COMMENT
	    itoa(ntohs(saddr.sin_port), name + strlen(name), 10);
#else
	    sprintf(name + strlen(name),"%d",ntohs(saddr.sin_port));
#endif /* COMMENT */
	    sprintf(ipaddr,"%s", (char *)inet_ntoa(saddr.sin_addr));
	    if (!quiet
#ifndef NOICP
		&& !doconx
#endif /* NOICP */
		)
	      printf("%s connected on port %d\n",
		   host->h_name,
		   ntohs(saddr.sin_port)
		   );
	}  else {
	    if (!quiet) printf("Failed.\n");
	}
    } else if (!quiet) printf("(OK)\n");
    if (!quiet) fflush(stdout);
    ttnet = nett;			/* TCP/IP (sockets) network */

#ifdef RLOGCODE
    if (ntohs(saddr.sin_port) == 513)
        ttnproto = NP_LOGIN;
    else
#endif /* RLOGCODE */
    /* Assume the service is TELNET. */
    if (ttnproto != NP_TCPRAW)
        ttnproto = NP_TELNET;		/* Yes, set global flag. */
    tn_ini();   			/* Start/Reset TELNET negotiations */

    if (*lcl < 0) *lcl = 1;		/* Local mode. */

    return(0);				/* Done. */
}
#endif /* NOTUSED */

/*  T C P S R V _ O P E N  --  Open a TCP/IP Server connection	*/
/*
  Calling conventions same as ttopen(), except third argument is network
  type rather than modem type.
*/
int
tcpsrv_open(name,lcl,nett,timo) char * name; int * lcl; int nett; int timo; {
    char *p;
    int i, x;
    SOCKOPT_T on = 1;
    int ready_to_accept = 0;
    static struct servent *service, servrec;
    static struct hostent *host;
    static struct sockaddr_in saddr;
    static SOCKOPT_T saddrlen;

#ifdef BSDSELECT
    fd_set rfds;
    struct timeval tv;
#else
#ifdef BELLSELCT
    fd_set rfds;
#else
    fd_set rfds;
    struct timeval {
	long tv_sec;
	long tv_usec;
    } tv;
#endif /* BELLSELECT */
#endif /* BSDSELECT */

    debug(F101,"tcpsrv_open nett","",nett);
    *ipaddr = '\0';

    if (nett != NET_TCPB)
      return(-1);			/* BSD socket support */

    netclos();				/* Close any previous connection. */
    strncpy(namecopy, name, NAMECPYL);	/* Copy the hostname. */
    if (ttnproto != NP_TCPRAW)
      ttnproto = NP_NONE;		/* No protocol selected yet. */
    debug(F110,"tcpsrv_open namecopy",namecopy,0);

#ifdef COMMENT
    if (tcpsrfd != -1) {
#ifdef TCPIPLIB
        socket_close(tcpsrfd);
#else /* TCPIPLIB */
        close(tcpsrfd);
#endif /* TCPIPLIB */
	tcpsrfd = -1;
	tcpsrv_port = 0;
    }
#endif /* COMMENT */

    p = namecopy;			/* Was a service requested? */
    while (*p != '\0' && *p != ':')
      p++; /* Look for colon */
    if (*p == ':') {			/* Have a colon */
	*p++ = '\0';			/* Get service name or number */
    } else {				/* Otherwise use kermit */
	p = "kermit";
    }
    debug(F110,"tcpsrv_open service requested",p,0);
    if (isdigit(*p)) {			/* Use socket number without lookup */
	service = &servrec;
	service->s_port = htons((unsigned short)atoi(p));
    } else {				/* Otherwise lookup the service name */
	service = getservbyname(p, "tcp");
    }
    if (!service && !strcmp("kermit",p)) { /* Use Kermit service port */
	service = &servrec;
	service->s_port = htons(1649);
    }
#ifdef RLOGCODE
    if (service && !strcmp("login",p) && service->s_port != htons(513)) {
	fprintf(stderr,
		"  Warning: login service on port %d instead of port 513\n",
		 ntohs(service->s_port));
	fprintf(stderr, "  Edit SERVICES file if RLOGIN fails to connect.\n");
	debug(F101,"tcpsrv_open login on port","",ntohs(service->s_port));
    }
#endif /* RLOGCODE */
    if (!service) {
	fprintf(stderr, "Cannot find port for service: %s\n", p);
	debug(F111,"tcpsrv_open can't get service",p,errno);
	errno = 0;			/* rather than mislead */
	return(-1);
    }

    /* If we currently have a listen active but port has changed then close */

    debug(F101,"tcpsrv_open checking previous connection","",tcpsrfd);
    debug(F101,"tcpsrv_open previous tcpsrv_port","",tcpsrv_port);
    if (tcpsrfd != -1 &&
	tcpsrv_port != ntohs((unsigned short)service->s_port)) {
	debug(F100,"tcpsrv_open closing previous connection","",0);
#ifdef TCPIPLIB
	socket_close(tcpsrfd);
#else
	close(tcpsrfd);
#endif /* TCPIPLIB */
	tcpsrfd = -1;
    }
    debug(F100,"tcpsrv_open tcpsrfd","",tcpsrfd);
    if (tcpsrfd == -1) {

	/* Set up socket structure and get host address */

	bzero((char *)&saddr, sizeof(saddr));
	debug(F100,"tcpsrv_open bzero ok","",0);
	saddr.sin_family = AF_INET;
        if (tcp_address)
	  saddr.sin_addr.s_addr = inet_addr(tcp_address);
	else
	  saddr.sin_addr.s_addr = INADDR_ANY;

	/* Get a file descriptor for the connection. */

	saddr.sin_port = service->s_port;
	ipaddr[0] = '\0';

	debug(F100,"tcpsrv_open calling socket","",0);
	if ((tcpsrfd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	    perror("TCP socket error");
	    debug(F101,"tcpsrv_open socket error","",errno);
	    return (-1);
	}
	errno = 0;

	/* Specify the Port may be reused */

	debug(F100,"tcpsrv_open calling setsockopt","",0);
	x = setsockopt(tcpsrfd,
		       SOL_SOCKET,SO_REUSEADDR,(char *)&on,sizeof on);
	debug(F101,"tcpsrv_open setsockopt","",x);

       /* Now bind to the socket */
	printf("\nBinding socket to port %d ...\n",
	       ntohs((unsigned short)service->s_port));
	if (bind(tcpsrfd, (struct sockaddr *)&saddr, sizeof(saddr)) < 0) {
	    i = errno;			/* Save error code */
#ifdef TCPIPLIB
            socket_close(tcpsrfd);
#else /* TCPIPLIB */
            close(tcpsrfd);
#endif /* TCPIPLIB */
	    tcpsrfd = -1;
	    tcpsrv_port = 0;
	    ttyfd = -1;
	    errno = i;			/* and report this error */
	    debug(F101,"tcpsrv_open bind errno","",errno);
	    return(-1);
	}
	debug(F100,"tcpsrv_open bind OK","",0);
	printf("Listening ...\n");
	if (listen(tcpsrfd, 15) < 0) {
	    i = errno;			/* Save error code */
#ifdef TCPIPLIB
            socket_close(tcpsrfd);
#else /* TCPIPLIB */
            close(tcpsrfd);
#endif /* TCPIPLIB */
	    tcpsrfd = -1;
	    tcpsrv_port = 0;
	    ttyfd = -1;
	    errno = i;			/* And report this error */
	    debug(F101,"tcpsrv_open listen errno","",errno);
	    return(-1);
	}
	debug(F100,"tcpsrv_open listen OK","",0);
	tcpsrv_port = ntohs((unsigned short)service->s_port);
    }
    printf("\nWaiting to Accept a TCP/IP connection on port %d ...\n",
	   ntohs((unsigned short)service->s_port));
    saddrlen = sizeof(saddr);

#ifdef BSDSELECT
    tv.tv_sec  = tv.tv_usec = 0L;
    if (timo < 0)
      tv.tv_usec = (long) -timo * 10000L;
    else
      tv.tv_sec = timo;
    debug(F101,"tcpsrv_open BSDSELECT","",timo);
#else
    debug(F101,"tcpsrv_open not BSDSELECT","",timo);
#endif /* BSDSELECT */

    if (!timo) {
	while (!ready_to_accept) {
#ifdef BSDSELECT
	    FD_ZERO(&rfds);
	    FD_SET(tcpsrfd, &rfds);
	    ready_to_accept =
	      ((select(FD_SETSIZE,
#ifdef HPUX
#ifdef HPUX1010
		       (fd_set *)
#else

		       (int *)
#endif /* HPUX1010 */
#else
#ifdef __DECC
		       (fd_set *)
#endif /* __DECC */
#endif /* HPUX */
		       &rfds, NULL, NULL, &tv) > 0) &&
	       FD_ISSET(tcpsrfd, &rfds));
#else /* BSDSELECT */
#ifdef IBMSELECT
#define ck_sleepint 250
	    ready_to_accept =
	      (select(&tcpsrfd, 1, 0, 0,
		      timo < 0 ? -timo :
		      (timo > 0 ? timo * 1000L : ck_sleepint)) == 1
	       );
#else
#ifdef BELLSELECT
	    FD_ZERO(rfds);
	    FD_SET(tcpsrfd, rfds);
	    ready_to_accept =
	      ((select(128, rfds, NULL, NULL, timo < 0 ? -timo :
		      (timo > 0 ? timo * 1000L)) > 0) &&
	       FD_ISSET(tcpsrfd, rfds));
#else
/* Try this - what's the worst that can happen... */

	    FD_ZERO(&rfds);
	    FD_SET(tcpsrfd, &rfds);
	    ready_to_accept =
	      ((select(FD_SETSIZE,
		       (fd_set *) &rfds, NULL, NULL, &tv) > 0) &&
	       FD_ISSET(tcpsrfd, &rfds));

#endif /* BELLSELECT */
#endif /* IBMSELECT */
#endif /* BSDSELECT */
	}
    }
    if (ready_to_accept) {
	if ((ttyfd = accept(tcpsrfd,
			    (struct sockaddr *)&saddr,&saddrlen)) < 0) {
	    i = errno;			/* save error code */
#ifdef TCPIPLIB
            socket_close(tcpsrfd);
#else /* TCPIPLIB */
            close(tcpsrfd);
#endif /* TCPIPLIB */
	    ttyfd = -1;
	    tcpsrfd = -1;
	    tcpsrv_port = 0;
	    errno = i;			/* and report this error */
	    debug(F101,"tcpsrv_open accept errno","",errno);
	    return(-1);
	}
	setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);

#ifndef NOTCPOPTS
#ifndef datageneral
#ifdef SOL_SOCKET
#ifdef TCP_NODELAY
	no_delay(tcp_nodelay);
	debug(F101,"tcpsrv_open no_delay","",tcp_nodelay);
#endif /* TCP_NODELAY */
#ifdef SO_KEEPALIVE
	keepalive(tcp_keepalive);
	debug(F101,"tcpsrv_open keepalive","",tcp_keepalive);
#endif /* SO_KEEPALIVE */
#ifdef SO_LINGER 
	ck_linger(tcp_linger, tcp_linger_tmo);
	debug(F101,"tcpsrv_open linger","",tcp_linger_tmo);
#endif /* SO_LINGER */
#ifdef SO_SNDBUF
    sendbuf(tcp_sendbuf);
#ifdef COMMENT
    if (tcp_sendbuf < (2*MAXSP))
      sendbuf(((2*MAXSP+1460)/1460)*1460);
#endif /* OS2 */
#endif /* SO_SNDBUF */
#ifdef SO_RCVBUF
    recvbuf(tcp_recvbuf);
#ifdef COMMENT
    if (tcp_recvbuf < (10*MAXRP))
      recvbuf(((10*MAXRP+1460)/1460)*1460);
#endif /* OS2 */
#endif /* SO_RCVBUF */
#endif /* SOL_SOCKET */
#endif /* datageneral */
#endif /* NOTCPOPTS */

	ttnet = nett;			/* TCP/IP (sockets) network */
	/* See if the service is TELNET. */
	if ((x = ntohs((unsigned short)service->s_port)) ==
	    getservbyname("telnet", "tcp")->s_port) {
	    if (ttnproto != NP_TCPRAW)	/* Yes and if raw port not requested */
	      ttnproto = NP_TELNET;	/* Set protocol to TELNET. */
	    tn_ini();			/* Start TELNET negotiations. */
	} else {
	    tn_ini();			/* Initialize TELNET negotiations. */
	}
	debug(F101,"tcpsrv_open service","",x);
	if (*lcl < 0)			/* Set local mode. */
	  *lcl = 1;

#ifdef COMMENT
#ifdef TCPIPLIB
        socket_close(tcpsrfd);
#else /* TCPIPLIB */
        close(tcpsrfd);
#endif /* TCPIPLIB */
	tcpsrfd = -1;
	tcpsrv_port = 0;
#endif /* COMMENT */

        if (tcp_rdns) {
#ifdef NT
            if ( isWin95() )
                sleep(1);
#endif /* NT */
            if (!quiet) {
		printf(" Reverse DNS Lookup... ");
		fflush(stdout);
	    }
	    if (host = gethostbyaddr((char *)&saddr.sin_addr,4,PF_INET)) {
		debug(F100,"tcpsrv_open gethostbyaddr != NULL","",0);
		if (!quiet) {
		    printf("(OK)\n");
		    fflush(stdout);
		}
		name[0] = '*';
		strncpy(&name[1],host->h_name,79);
		strncat(name,":",80-strlen(name));
		strncat(name,p,80-strlen(name));
		sprintf(ipaddr,"%s", (char *)inet_ntoa(saddr.sin_addr));
		if (!quiet
#ifndef NOICP
		    && !doconx
#endif /* NOICP */
		    )
		  printf("%s connected on port %s\n",host->h_name,p);
	    } else {
		if (!quiet) printf("Failed.\n");
	    }
	} else if (!quiet) printf("(OK)\n");
	if (!quiet) fflush(stdout);

#ifdef NT_TCP_OVERLAPPED
        OverlappedWriteInit();
        OverlappedReadInit();
#endif /* NT_TCP_OVERLAPPED */
	return(0);			/* Done. */
    } else {
	i = errno;			/* save error code */
#ifdef TCPIPLIB
        socket_close(tcpsrfd);
#else /* TCPIPLIB */
        close(tcpsrfd);
#endif /* TCPIPLIB */
	ttyfd = -1;
	tcpsrfd = -1;
	tcpsrv_port = 0;
	errno = i;			/* and report this error */
	debug(F101,"tcpsrv_open accept errno","",errno);
	return(-1);
    }
}
#endif /* NOLISTEN */
#endif /* OS2 */
#endif /* TCPSOCKET */

/*  N E T O P E N  --  Open a network connection  */
/*
  Calling conventions same as ttopen(), except third argument is network
  type rather than modem type.	Designed to be called from within ttopen.
*/
int
netopen(name, lcl, nett) char *name; int *lcl, nett; {
    char *p;
    int i, x, dns = 0;
#ifdef TCPSOCKET
    int isconnect = 0;
#ifdef SO_OOBINLINE
    int on = 1;
#endif /* SO_OOBINLINE */
    struct servent *service=NULL, servrec;
    struct hostent *host=NULL;
    struct sockaddr_in saddr;
#ifdef EXCELAN
    struct sockaddr_in send_socket;
#endif /* EXCELAN */

#ifdef INADDRX
/* inet_addr() is of type struct in_addr */
#ifdef datageneral
    extern struct in_addr inet_addr();
#endif /* datageneral */
#endif /* INADDRX */
    long iax;
#endif /* TCPSOCKET */

#ifdef SUNX25				/* Code for SunLink X.25 support */
#define X29PID 1			/* X.29 Protocol ID */
_PROTOTYP(SIGTYP x25oobh, (int) );
    CONN_DB x25host;
#ifndef X25_WR_FACILITY
    FACILITY x25facil;
#else
    FACILITY_DB x25facil;
#endif /* X25_WR_FACILITY */
    static int needh = 1;
    PID_T pid;
    extern int linkid, lcn, x25ver;
#endif /* SUNX25 */
#ifdef ANYX25
    extern int revcall, closgr, cudata;
    extern char udata[];
#endif /* ANYX25 */

#ifdef IBMX25				/* Variables for IBM X25 */
    extern int x25port;			/* Logical port to use */
    extern x25addr_t local_nua;		/* Local X.25 address */
    extern x25addr_t remote_nua;	/* Remote X.25 address */
    extern char	x25name[];		/* X25 device name (sx25a0) */
    extern char x25dev[];		/* X25 device file /dev/x25pkt */
    ulong bind_flags = 0;		/* Flags for binding the X25 stream */
    ulong token = 0;			/* Temporary return code */
#endif /* IBMX25 */

    debug(F101,"netopen nett","",nett);
    *ipaddr = '\0';			/* Initialize IP address string */

#ifdef SUNX25
    if (nett == NET_SX25) {		/* If network type is X.25 */
	netclos();			/* Close any previous net connection */
	ttnproto = NP_NONE;		/* No protocol selected yet */

	/* Set up host structure */
	bzero((char *)&x25host,sizeof(x25host));
	if ((x25host.hostlen = pkx121(name,x25host.host)) < 0) {
	    fprintf (stderr,"Invalid X.121 host address %s\n",name);
	    errno = 0;
	    return (-1);
	}
	x25host.datalen = X29PIDLEN;
	x25host.data[0] = X29PID;

	/* Set call user data if specified */
	if (cudata) {
	    strncpy((char *)x25host.data+X29PIDLEN,udata,(int)strlen(udata));
	    x25host.datalen += (int)strlen(udata);
	}

	/* Open SunLink X.25 socket */
	if (!quiet && *name) {
	    printf(" Trying %s... ", name);
	    fflush(stdout);
	}
	if ((ttyfd = socket(AF_X25, SOCK_STREAM, 0)) < 0) {
	    debug(F101,"netopen socket error","",errno);
	    perror ("X.25 socket error");
	    return (-1);
	}

	/* Setting X.25 out-of-band data handler */
	pid = getpid();
	if (ioctl(ttyfd,SIOCSPGRP,&pid)) {
	    perror("X.25 set process group id error");
	    return(-1);
	}
	(VOID) signal(SIGURG,x25oobh);

	/* Set reverse charge call and closed user group if requested */
	bzero ((char *)&x25facil,sizeof(x25facil));

#ifndef X25_WR_FACILITY
/*  New SunLink (7.0 or 8.0, not sure which)... */
	x25facil.type = T_REVERSE_CHARGE; /* Reverse Charge */
	x25facil.f_reverse_charge = revcall ? 1 : 0;
	if (ioctl(ttyfd,X25_SET_FACILITY,&x25facil) < 0) {
	    perror ("Setting X.25 reverse charge");
	    return (-1);
	}
	if (closgr > -1) {		/* Closed User Group (Outgoing) */
	    bzero ((char *)&x25facil,sizeof(x25facil));
	    x25facil.type = T_CUG;
	    x25facil.f_cug_req = CUG_REQ_ACS;
	    x25facil.f_cug_index = closgr;
	    if (ioctl(ttyfd,X25_SET_FACILITY,&x25facil) < 0) {
		perror ("Setting X.25 closed user group");
		return (-1);
	    }
	}
#else
/*  Old SunLink 6.0 (or 7.0?)... */
	if (revcall) x25facil.reverse_charge = revcall;
	if (closgr > -1) {
	    x25facil.cug_req = 1;
	    x25facil.cug_index = closgr;
	}
	if (ioctl(ttyfd,X25_WR_FACILITY,&x25facil) < 0) {
	    perror ("Setting X.25 facilities");
	    return (-1);
	}
#endif /* X25_WR_FACILITY */

	/*  Need X.25 header with bits Q and M */
	if (ioctl (ttyfd,X25_HEADER,&needh) < 0) {
	    perror ("Setting X.25 header");
	    return (-1);
	}

	/* Connects to remote host via SunLink X.25 */
	if (connect(ttyfd,(struct sockaddr *)&x25host,sizeof(x25host)) < 0) {
	    i = errno;
	    debug(F101,"netopen connect errno","",i);
	    if (i) {
		perror("netopen x25 connect");
		x25diag();
	    }
	    (VOID) netclos();
	    ttyfd = -1;
	    ttnproto = NP_NONE;
	    errno = i;
	    return (-1);
	}

	/* Get X.25 link identification used for the connection */
	if (ioctl(ttyfd,X25_GET_LINK,&linkid) < 0) {
	    perror ("Getting X.25 link id");
	    return (-1);
	}

	/* Get X.25 logical channel number used for the connection */
	if (ioctl(ttyfd,X25_RD_LCGN,&lcn) < 0) {
	    perror ("Getting X.25 lcn");
	    return (-1);
	}

	/* Get SunLink X.25 version */
	if (ioctl(ttyfd,X25_VERSION,&x25ver) < 0) {
	    perror ("Getting SunLink X.25 version");
	    return (-1);
	}
	ttnet = nett;			/* Sunlink X.25 network */
	ttnproto = NP_X3;		/* PAD X.3, X.28, X.29 protocol */
	if (*lcl < 0) *lcl = 1;		/* Local mode */
	return(0);
    } else /* Note that SUNX25 support can coexist with TCP/IP support. */
#endif /* SUNX25 */

#ifdef IBMX25
    /* riehm */
    if (nett == NET_IX25) {		/* IBM AIX X.25 */
	netclos();			/* Close any previous net connection */
	ttnproto = NP_NONE;		/* No protocol selected yet */

	/* find out who we are - this is not so easy on AIX */
	/* riehm: need to write the code that finds this out
	 * automatically, or at least allow it to be configured
	 * somehow
	 */
	if (!local_nua[0] && !x25local_nua(local_nua)) {
	    return(-1);
	}

	/* Initialise the X25 API (once per process? once per connection?) */

	debug(F110, "Opening ", x25dev, 0 );
	/* set O_NDELAY to allow polling? */
	if ((ttyfd = open(x25dev, O_RDWR)) < 0) {
	    perror ("X.25 device open error");
	    debug(F101,"netopen: device open error","",errno);
	    return (-1);
	}

	/* push the NPI onto the STREAM */
	if (ioctl(ttyfd,I_PUSH,"npi") < 0 ) {
	    close(ttyfd);
	    ttyfd = -1;
	    perror( "kermit: netopen(): couldn't push npi on the X25 stream" );
	    debug(F101,"netopen: can't push npi on the X25 stream","",errno);
	    return (-1);
	}

	/* set up server mode - bind the x25 port and wait for
	 * incoming connections
	 */
	if (name[0] == '*') {		/* Server */
	    /* set up a server - see the warning in x25bind() */
	    bind_flags |= TOKEN_REQUEST;

	    /* bind kermit to the local X25 address */
	    token = x25bind(ttyfd,
			    local_nua,
			    udata,
			    (int)strlen( udata ),
			    1,
			    x25port,
			    bind_flags
			    );
	    if (token < 0) {
		debug(F100,"netopen: couldn't bind to local X25 address","",0);
		netclos();
		return(-1);
	    }
	    /* Currently not connected to a remote host */

	    remote_nua[0] = '\0';

	    /* store the fd so that incoming calls can have their own fd
	     * This is almost support for a true server (ie: a'la ftpd)
	     * but we're not quite there yet.
	     * used in netclos()
	     */
	    x25serverfd = ttyfd;
	    /*
	     * wait for an incoming call
	     * this should happen in the "server" command and not in
	     * the "set host *" command.
	     */
	    if ((ttyfd = x25getcall(ttyfd)) < 0) {
		netclos();
		return(-1);
	    }
	} else {			/* Client */
	    /* Bind kermit to the local X25 address */
	    token = x25bind(
			    ttyfd,
			    local_nua,
			    (char *)NULL,
			    0,
			    0,
			    x25port,
			    bind_flags
			    );
	    if (token < 0) {
		debug(F100,"netopen: couldn't bind to local X25 address","",0);
		netclos();
		return(-1);
	    }
/* riehm: this should be done via the CONNECT command, not HOST! */
	    {
		x25serverfd = 0;
		/* call the remote host */
		/* name == address of remote host as char* */
		if (x25call(ttyfd, name, udata) < 0 ) {
		    debug(F100,
			  "netopen: couldn't connect to remote X25 address",
			  "", 0);
		    netclos();
		    return(-1);
		}
		strcpy(remote_nua, name);
	    }
	}
	ttnet = nett;			/* AIX X.25 network */
	if (*lcl < 0) *lcl = 1;		/* Local mode */
	return(0);

    } else /* Note that IBMX25 support can coexist with TCP/IP support. */
#endif /* IBMX25 */

/*   Add support for other networks here. */

      if (nett != NET_TCPB) return(-1);	/* BSD socket support */

#ifdef TCPSOCKET
    netclos();				/* Close any previous connection. */
    strncpy(namecopy, name, NAMECPYL);	/* Copy the hostname. */
    debug(F110,"netopen namecopy",namecopy,0);

#ifndef NOLISTEN
    if (name[0] == '*')
      return(tcpsrv_open(name, lcl, nett, 0));
#endif /* NOLISTEN */

    p = namecopy;			/* Was a service requested? */
    while (*p != '\0' && *p != ':') p++; /* Look for colon */
    if (*p == ':') {			/* Have a colon */
	debug(F110,"netopen name has colon",namecopy,0);
	*p++ = '\0';			/* Get service name or number */
#ifdef CK_URL
	/*
	   Here we have to check for various popular syntaxes:
	   host:port (our original syntax)
	   URL such as telnet:host or telnet://host/
	   Or even telnet://user:password@host:port/
	   Or a malformed URL such as generated by Netscape 4.0 like:
	   telnet:telnet or telnet::host.
	*/
	if (*p == ':')			/* a second colon */
	  *p++ = '\0';			/* get rid of that one too */
        while (*p == '/') *p++ = '\0';	/* and slashes */
	x = strlen(p);			/* Length of remainder */
	if (p[x-1] == '/')		/* If there is a trailing slash */
	  p[x-1] = '\0';		/* remove it. */
	debug(F110,"netopen namecopy after stripping",namecopy,0);
	debug(F110,"netopen p after stripping",p,0);
	service = getservbyname(namecopy,"tcp");
	if (service || !xxstrcmp("rlogin",namecopy,NAMECPYL)) {
	    char temphost[80], tempservice[80];
	    char * q = p, *r = p, *w = p;
	    /* Check for userid and possibly password */
	    while (*p != '\0' && *p != '@') p++; /* look for @ */
	    if (*p == '@') {
		/* found username and perhaps password */
		debug(F110,"netopen namecopy found @","",0);
		*p = '\0'; p++;
		while (*w != '\0' && *w != ':')
		  w++;
		if (*w == ':')
		  *w++ = '\0';
		/* r now points to username, save it and discard password */
		debug(F110,"netopen namecopy username",r,0);
		debug(F110,"netopen namecopy password",w,0);
		strncpy(uidbuf,r,64);
		q = p;			/* Host after user and pwd */
	    } else {
		p = q;			/* No username or password */
	    }
	    /* Now we must look for the optional port. */
	    debug(F110,"netopen x p",p,0);
	    debug(F110,"netopen x q",q,0);
	    while (*p != '\0' && *p != ':') /* Look for another colon */
	      p++;
	    if (*p == ':') {
		debug(F110,"netopen found port",q,0);
		*p++ = '\0';		/* Found a port name or number */
		debug(F110,"netopen port",p,0);
		if (ttnproto == NP_NONE) {
		    /* namecopy[] identifies a protocol, so use it */
		    if (!xxstrcmp("telnet",namecopy,NAMECPYL))
		    ttnproto = NP_TELNET;
#ifdef RLOGCODE
		    else if (!xxstrcmp("login",namecopy,NAMECPYL) ||
			     !xxstrcmp("rlogin",namecopy,NAMECPYL)) {
			ttnproto = NP_RLOGIN;
		    }
#endif /* RLOGCODE */
		}
		strncpy(tempservice,p,79);
		strncpy(temphost,q,79);
		strncpy(namecopy,temphost,NAMECPYL);
		debug(F110,"netopen tempservice",tempservice,0);
		debug(F110,"netopen temphost",temphost,0);
		x = strlen(namecopy);
		p = namecopy + x + 1;
		strncpy(p, tempservice, NAMECPYL - x - 1);
	    } else {
		/* We didn't find another port, but if q is a service */
		/* then assume that namecopy is actually a host.      */
		if (getservbyname(q,"tcp")) {
		    p = q;
		} else {
#ifdef RLOGCODE
		    /* rlogin is not a valid service */
		    if (!xxstrcmp("rlogin",namecopy,6)) {
			strncpy(namecopy,"login",NAMECPYL);
		    }
#endif /* RLOGCODE */
		    /* Reconstruct namecopy */
		    strncpy(tempservice,namecopy,79);
		    strncpy(temphost,q,79);
		    strncpy(namecopy,temphost,NAMECPYL);
		    debug(F110,"netopen tempservice",tempservice,0);
		    debug(F110,"netopen temphost",temphost,0);
		    x = strlen(namecopy);
		    p = namecopy + x + 1;
		    strncpy(p, tempservice, NAMECPYL - x - 1);
		}
	    }
	    debug(F110,"netopen URL result",namecopy,0);
	}
#endif /* CK_URL */
    } else {				/* Otherwise use telnet */
#ifdef COMMENT
	p = "telnet";
#else
	p = "23";
#endif /* COMMENT */
    }
/*
  By the time we get here, namecopy[] should hold the null-terminated
  hostname or address, and p should point to the service name or number.
*/
    debug(F110,"netopen host",namecopy,0);
    debug(F110,"netopen service requested",p,0);
    if (isdigit(*p)) {			/* Use socket number without lookup */
	service = &servrec;
	service->s_port = htons((unsigned short)atoi(p));
    } else {				/* Otherwise lookup the service name */
	service = getservbyname(p, "tcp");
    }
    if (!service) {
	fprintf(stderr, "Cannot find port for service %s\n", p);
#ifdef TGVORWIN
	debug(F101,"netopen can't get service","",socket_errno);
#else
	debug(F101,"netopen can't get service","",errno);
#endif /* TGVORWIN */
	errno = 0;			/* rather than mislead */
	return(-1);
    }
    strncpy(svcbuf,p,79);
    svcbuf[79] = '\0';
    debug(F110,"netopen service ok",svcbuf,0);

    if (ttnproto == NP_TELNET && service && 
	strcmp("telnet",p) && service->s_port != htons(23)) {
        ttnproto = NP_NONE;		/* No protocol selected yet. */
    }

#ifdef RLOGCODE
    if (service && !strcmp("login",p) && service->s_port != htons(513)) {
	fprintf(stderr,
		"  Warning: login service on port %d instead of port 513\n",
		 ntohs(service->s_port));
	fprintf(stderr, "  Edit SERVICES file if RLOGIN fails to connect.\n");
	debug(F101,"tcpsrv_open login on port","",ntohs(service->s_port));
    }
#endif /* RLOGCODE */

    /* Set up socket structure and get host address */

    bzero((char *)&saddr, sizeof(saddr));
    debug(F100,"netopen bzero ok","",0);
/*
   NOTE: Originally the inet_addr() check was #ifdef NT, but is enabled for
   all as of 20 Sep 97, to allow people to "set host" to a specific numeric IP
   address without going through the multihomed host sequence and winding up
   at a different place than the one requested.
*/
    iax =
#ifndef datageneral
      inet_addr(namecopy);
#else
      -1L;
#endif /* datageneral */
    debug(F111,"netopen inet_addr",namecopy,iax);

    dns = 0;
    if (
#ifdef INADDR_NONE
	iax == INADDR_NONE
#else
	iax < 0
#endif /* INADDR_NONE */
	) {
	if (!quiet) {
	    printf(" DNS Lookup... ");
	    fflush(stdout);
	}
	if ((host = gethostbyname(namecopy)) != NULL) {
	    debug(F100,"netopen gethostbyname != NULL","",0);
	    dns = 1;			/* Remember we performed dns lookup */
#ifdef OS2
	    strncpy(name,host->h_name,80);
	    strncat(name,":",80-strlen(name));
	    strncat(name,p,80-strlen(name));
#endif /* OS2 */
	    saddr.sin_family = host->h_addrtype;
#ifdef HADDRLIST
#ifdef h_addr
	    /* This is for trying multiple IP addresses - see <netdb.h> */
	    if (!(host->h_addr_list))
	      return(-1);
	    bcopy(host->h_addr_list[0],
		  (caddr_t)&saddr.sin_addr,
		  host->h_length
		  );
#else
	    bcopy(host->h_addr, (caddr_t)&saddr.sin_addr, host->h_length);
#endif /* h_addr */
#else  /* HADDRLIST */
	    bcopy(host->h_addr, (caddr_t)&saddr.sin_addr, host->h_length);
#endif /* HADDRLIST */
#ifndef EXCELAN
	    debug(F111,"BCOPY","host->h_addr",host->h_addr);
#endif /* EXCELAN */
	    debug(F111,"BCOPY"," (caddr_t)&saddr.sin_addr",
		  (caddr_t)&saddr.sin_addr);
	    debug(F111,"BCOPY","host->h_length",host->h_length);
	}
    }
    if (!dns) {
#ifdef INADDRX
/* inet_addr() is of type struct in_addr */
	struct in_addr ina;
	unsigned long uu;
	debug(F100,"netopen gethostbyname == NULL: INADDRX","",0);
	ina = inet_addr(namecopy);
	uu = *(unsigned long *)&ina;
#else /* Not INADDRX */
/* inet_addr() is unsigned long */
	unsigned long uu;
	debug(F100,"netopen gethostbyname == NULL: Not INADDRX","",0);
	uu = inet_addr(namecopy);
#endif /* INADDRX */
	debug(F101,"netopen uu","",uu);
	if ((saddr.sin_addr.s_addr = uu) != ((unsigned long)-1)) {
	    saddr.sin_family = AF_INET;
	} else {
	    fprintf(stderr, "Can't get address for %s\n", namecopy);
#ifdef TGVORWIN
	    debug(F101,"netopen can't get address","",socket_errno);
#else
	    debug(F101,"netopen can't get address","",errno);
#endif /* TGVORWIN */
	    errno = 0;			/* Rather than mislead */
	    return(-1);
	}
    }

    /* Get a file descriptor for the connection. */

    saddr.sin_port = service->s_port;
    sprintf(ipaddr,"%s", (char *)inet_ntoa(saddr.sin_addr));
    debug(F110,"netopen trying",ipaddr,0);
    if (!quiet && *ipaddr) {
	printf(" Trying %s... ", ipaddr);
	fflush(stdout);
    }

    /* Loop to try additional IP addresses, if any. */

    do {
#ifdef EXCELAN
	send_socket.sin_family = AF_INET;
	send_socket.sin_addr.s_addr = 0;
	send_socket.sin_port = 0;
	if ((ttyfd = socket(SOCK_STREAM, (struct sockproto *)0,
			    &send_socket, SO_REUSEADDR)) < 0)
#else  /* EXCELAN */
#ifdef NT
#ifdef COMMENT_X
       /*
	 Must make sure that all sockets are opened in
	 Non-overlapped mode since we use the standard
	 C RTL functions to read and write data.
	 But it doesn't seem to work as planned.
       */
	  {
	      int optionValue = SO_SYNCHRONOUS_NONALERT;
	      if (setsockopt(INVALID_SOCKET, SOL_SOCKET, SO_OPENTYPE,
			     (char *) &optionValue, sizeof(optionValue))
		  != NO_ERROR)
		return(-1);
	  }
#endif /* COMMENT */
#endif /* NT */

	if ((ttyfd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
#endif /* EXCELAN */
	    {
#ifdef EXCELAN
		experror("TCP socket error");
#else
#ifdef TGVORWIN
#ifdef OLD_TWG
		errno = socket_errno;
#endif /* OLD_TWG */
		socket_perror("TCP socket error");
		debug(F101,"netopen socket error","",socket_errno);
#else
		perror("TCP socket error");
		debug(F101,"netopen socket error","",errno);
#endif /* TGVORWIN */
#endif /* EXCELAN */
		return (-1);
	    }
	errno = 0;

#ifdef RLOGCODE
       /* Not part of the RLOGIN RFC, but the BSD implementation     */
       /* requires that the client port be a priviliged port (<1024) */
       /* on a Unix system this would require SuperUser permissions  */
       /* thereby saying that the root of the Unix system has given  */
       /* permission for this connection to be created		     */
       if (service->s_port == htons((unsigned short)RLOGIN_PORT)) {
	   struct sockaddr_in sin;
	   static unsigned short lport = 1024;	/* max reserved port */
	   int s_errno;

	   lport--;			/* Make sure we do not reuse a port */
	   if (lport == 512)
	     lport = 1023;

	   sin.sin_family = AF_INET;
           if (tcp_address)
	     sin.sin_addr.s_addr = inet_addr(tcp_address);
	   else
	     sin.sin_addr.s_addr = INADDR_ANY;
	   while (1) {
	       sin.sin_port = htons(lport);
	       if (bind(ttyfd, (struct sockaddr *)&sin, sizeof(sin)) >= 0)
		 break;
#ifdef OS2
	       s_errno = socket_errno;
	       if (s_errno && /* OS2 bind fails with 0, if already in use */
#ifdef NT
		   s_errno != WSAEADDRINUSE
#else
		   s_errno != SOCEADDRINUSE &&
		   s_errno != (SOCEADDRINUSE - SOCBASEERR)
#endif /* NT */
		   )
#else /* OS2 */
#ifdef TGVORWIN
		 if (socket_errno != EADDRINUSE)
#else
		 if (errno != EADDRINUSE)
#endif /* TGVORWIN */
#endif /* OS2 */
		   {
		       printf("\nBind failed with errno %d  for port %d.\n",
#ifdef OS2
			      s_errno
#else
#ifdef TGVORWIN
			      socket_errno
#else
			      errno
#endif /* TGVORWIN */
#endif /* OS2 */
			      , lport
			      );
#ifdef OS2
		       debug(F101,"rlogin bind failed","",s_errno);
#else
#ifdef TGVORWIN
		       debug(F101,"rlogin bind failed","",socket_errno);
#ifdef OLD_TWG
		       errno = socket_errno;
#endif /* OLD_TWG */
		       socket_perror("rlogin bind");
#else
		       debug(F101,"rlogin bind failed","",errno);
		       perror("rlogin bind");
#endif /* TGVORWIN */
#endif /* OS2 */
		       netclos();
		       return -1;
		   }
	       lport--;
	       if (lport == 512 /* lowest reserved port to use */ ) {
		   printf("\nNo reserved ports available.\n");
		   netclos();
		   return -1;
	       }
	   }
	   debug(F101,"rlogin lport","",lport);
	   ttnproto = NP_RLOGIN;
       } else
#endif /* RLOGCODE  */

       /* If a specific TCP address on the local host is desired we */
       /* must bind it to the socket.                               */
#ifndef datageneral
	 if (tcp_address) {
	     struct sockaddr_in sin;
	     int s_errno;

	     debug(F110,"netopen binding socket to",tcp_address,0);
	     sin.sin_family = AF_INET;
	     sin.sin_addr.s_addr = inet_addr(tcp_address);
	     sin.sin_port = 0;
	     if (bind(ttyfd, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
		 i = errno;		/* Save error code */
#ifdef TCPIPLIB
		 socket_close(ttyfd);
#else /* TCPIPLIB */
		 close(ttyfd);
#endif /* TCPIPLIB */
		 ttyfd = -1;
		 errno = i;		/* and report this error */
		 debug(F101,"netopen bind errno","",errno);
		 return(-1);
	     }
	 }
#endif /* datageneral */

/* Now connect to the socket on the other end. */

#ifdef EXCELAN
	if (connect(ttyfd, &saddr) < 0)
#else
#ifdef NT
	  WSASafeToCancel = 1;
#endif /* NT */
	if (connect(ttyfd, (struct sockaddr *)&saddr, sizeof(saddr)) < 0)
#endif /* EXCELAN */
	  {
#ifdef NT
	      WSASafeToCancel = 0;
#endif /* NT */
#ifdef OS2
	      i = socket_errno;
#else /* OS2 */
#ifdef TGVORWIN
	      i = socket_errno;
#else
	      i = errno;		/* Save error code */
#endif /* TGVORWIN */
#endif /* OS2 */
#ifdef RLOGCODE
	      if (
#ifdef OS2
		 i && /* OS2 bind fails with 0, if already in use */
#ifdef NT
		 i == WSAEADDRINUSE
#else
		 (i == SOCEADDRINUSE ||
		 i == (SOCEADDRINUSE - SOCBASEERR))
#endif /* NT */
#else /* OS2 */
#ifdef TGVORWIN
		  socket_errno == EADDRINUSE
#else
		  errno == EADDRINUSE
#endif /* TGVORWIN */
#endif /* OS2 */
		  && ttnproto == NP_RLOGIN) {
#ifdef TCPIPLIB
		   socket_close(ttyfd); /* Close it. */
#else
		   close(ttyfd);
#endif /* TCPIPLIB */
		   continue;		/* Try a different lport */
	       }
#endif /* RLOGCODE */
#ifdef HADDRLIST
#ifdef h_addr
	      if (host && host->h_addr_list && host->h_addr_list[1]) {
		  perror("");
		  host->h_addr_list++;
		  bcopy(host->h_addr_list[0],
			(caddr_t)&saddr.sin_addr,
			host->h_length);

		  sprintf(ipaddr,"%s", (char *)inet_ntoa(saddr.sin_addr));
		  debug(F110,"netopen h_addr_list",ipaddr,0);
		  if (!quiet && *ipaddr) {
		      printf(" Trying %s... ", ipaddr);
		      fflush(stdout);
		  }
#ifdef TCPIPLIB
		  socket_close(ttyfd); /* Close it. */
#else
		  close(ttyfd);
#endif /* TCPIPLIB */
		  continue;
	      }
#endif /* h_addr */
#endif	/* HADDRLIST */
	      netclos();
	      ttyfd = -1;
	      ttnproto = NP_NONE;
	      errno = i;		/* And report this error */
#ifdef EXCELAN
	      if (errno) experror("netopen connect");
#else
#ifdef TGVORWIN
	      debug(F101,"netopen connect error","",socket_errno);
	      /* if (errno) socket_perror("netopen connect"); */
#ifdef OLD_TWG
	      errno = socket_errno;
#endif /* OLD_TWG */
	      socket_perror("netopen connect");
#else /* TGVORWIN */
	      debug(F101,"netopen connect errno","",errno);
#ifdef DEC_TCPIP
	      perror("netopen connect");
#endif /* DEC_TCPIP */
#ifdef CMU_TCPIP
	      perror("netopen connect");
#endif /* CMU_TCPIP */
#endif /* TGVORWIN */
#endif /* EXCELAN */
	      return(-1);
	  }
#ifdef NT
	WSASafeToCancel = 0;
#endif /* NT */
	isconnect = 1;
    } while (!isconnect);

#ifdef SO_OOBINLINE
/*
  The symbol SO_OOBINLINE is not known to Ultrix 2.0.
  It means "leave out of band data inline".  The normal value is 0x0100,
  but don't try this on systems where the symbol is undefined.
*/
/*
  Note from Jeff Altman: 12/13/95
  In implementing rlogin protocol I have come to the conclusion that it is
  a really bad idea to read out-of-band data inline.
  At least Windows and OS/2 does not handle this well.
  And if you need to know that data is out-of-band, then it becomes
  absolutely pointless.

  Therefore, at least on OS2 and Windows (NT) I have changed the value of
  on to 0, so that out-of-band data stays out-of-band.

  12/18/95
  Actually, OOB data should be read inline when possible.  Especially with
  protocols that don't care about the Urgent flag.  This is true with Telnet.
  With Rlogin, you need to be able to catch OOB data.  However, the best
  way to do this is to set a signal handler on SIGURG.	This isn't possible
  on OS/2 and Windows.	But it is in UNIX.  We will also need OOB data for
  FTP so better create a general mechanism.

  The reason for making OOB data be inline is that the standard ttinc/ttoc
  calls can be used for reading that data on UNIX systems.  If we didn't
  have the OOBINLINE option set then we would have to use recv(,MSG_OOB)
  to read it.
*/
#ifdef RLOGCODE
#ifdef TCPIPLIB
    if (ttnproto == NP_RLOGIN || ttnproto == NP_FTP)
      on = 0;
#else /* TCPIPLIB */
    if (ttnproto == NP_RLOGIN) {
	debug(F100,"Installing rlogoobh on SIGURG","",0);
	signal(SIGURG, rlogoobh);
    } else
#ifdef FTPCODE
      if (ttnproto == NP_FTP) {
	  signal(SIGURG, ftpoobh);
      } else
#endif /* FTPCODE */
	{
	    signal(SIGURG, SIG_DFL);
	}
#endif /* TCPIPLIB */
#endif /* RLOGCODE */

#ifdef datageneral
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
#ifdef BSD43
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
#ifdef OSF1
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
#ifdef POSIX
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
#ifdef MOTSV88R4
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
#ifdef SOLARIS
/*
  Maybe this applies to all SVR4 versions, but the other (else) way has been
  compiling and working fine on all the others, so best not to change it.
*/
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
#ifdef OSK
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
#ifdef OS2
    {
	int rc;
	rc = setsockopt(ttyfd,
			SOL_SOCKET,
			SO_OOBINLINE,
			(char *) &on,
			sizeof on
			);
	debug(F111,"setsockopt SO_OOBINLINE",on ? "on" : "off" ,rc);
    }
#else
#ifdef VMS /* or, at least, VMS with gcc */
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE,(char *) &on, sizeof on);
#else
    setsockopt(ttyfd, SOL_SOCKET, SO_OOBINLINE, &on, sizeof on);
#endif /* VMS */
#endif /* OS2 */
#endif /* OSK */
#endif /* SOLARIS */
#endif /* MOTSV88R4 */
#endif /* POSIX */
#endif /* BSD43 */
#endif /* OSF1 */
#endif /* datageneral */
#endif /* SO_OOBINLINE */

#ifndef NOTCPOPTS
#ifndef datageneral
#ifdef SOL_SOCKET
#ifdef TCP_NODELAY
    no_delay(tcp_nodelay);
#endif /* TCP_NODELAY */
#ifdef SO_KEEPALIVE
    keepalive(tcp_keepalive);
#endif /* SO_KEEPALIVE */
#ifdef SO_LINGER
    ck_linger(tcp_linger, tcp_linger_tmo);
#endif /* SO_LINGER */
#ifdef SO_SNDBUF
    sendbuf(tcp_sendbuf);
#ifdef COMMENT
    if (tcp_sendbuf < (2*MAXSP))
      sendbuf(((2*MAXSP+1460)/1460)*1460);
#endif /* OS2 */
#endif /* SO_SNDBUF */
#ifdef SO_RCVBUF
    recvbuf(tcp_recvbuf);
#ifdef COMMENT
    if (tcp_recvbuf < (10*MAXRP))
      recvbuf(((10*MAXRP+1460)/1460)*1460);
#endif /* OS2 */
#endif /* SO_RCVBUF */
#endif /* SOL_SOCKET */
#endif /* datageneral */
#endif /* NOTCPOPTS */

#ifdef NON_BLOCK_IO
    on = 1;
    x = socket_ioctl(ttyfd,FIONBIO,&on);
    debug(F101,"netopen FIONBIO","",x);
#endif /* NON_BLOCK_IO */

#ifdef NT_TCP_OVERLAPPED
    OverlappedWriteInit();
    OverlappedReadInit();
#endif /* NT_TCP_OVERLAPPED */

    ttnet = nett;			/* TCP/IP (sockets) network */

    x = ntohs((unsigned short)service->s_port);
    svcnum = x;
    /* See if the service is TELNET. */
    if (x == TELNET_PORT) {
	if (ttnproto != NP_TCPRAW)	/* Yes, so if raw port not requested */
	  ttnproto = NP_TELNET;		/* select TELNET protocol. */
    }
#ifdef RLOGCODE
    else if (x == RLOGIN_PORT) {
	ttnproto = NP_RLOGIN;
    }
#endif /* RLOGCODE */
#ifdef COMMENT /* not yet */
    else if (x == KERMIT_PORT) {
	ttnproto = NP_KERMIT;
    }
#endif /* COMMENT */

#ifndef datageneral
/* Find out our own IP address */
    {
	struct sockaddr_in sa;

#ifndef GSOCKNAME_T
#define GSOCKNAME_T int
#ifdef UNIXWARE
#undef GSOCKNAME_T
#define GSOCKNAME_T size_t
#else
#ifdef VMS
#ifdef DEC_TCPIP
#ifdef __DECC_VER
#undef GSOCKNAME_T
#define GSOCKNAME_T size_t
#endif /* __DECC_VER */
#endif /* DEC_TCPIP */
#endif /* VMS */
#endif /* UNIXWARE */
#endif /* GSOCKNAME_T */

	GSOCKNAME_T slen;

	slen = sizeof(sa);
#ifdef COMMENT
/* memset is not portable */
	memset(&sa, 0, slen);
#else
	bzero((char *)&sa, slen);
#endif /* COMMENT */
#ifndef EXCELAN
	if (!getsockname(ttyfd, (struct sockaddr *)&sa, &slen) ) {
	    sprintf(myipaddr,"%s", (char *)inet_ntoa(sa.sin_addr));
	    debug(F110,"getsockname",myipaddr,0);
	}
#endif /* EXCELAN */
    }
#endif /* datageneral */

/*
  This is really only needed for Kerberos IV but is useful information in any
  case.  If we connect to a name that is really a pool, we need to get the
  name of the machine we are actually connecting to for K4 to authenticate
  properly.  This way we also update the names properly.

  Note: This does not work on Windows 95 or Windows NT 3.5x.  This is because 
  of the Microsoft implementation of gethostbyaddr() in both Winsock 1.1
  and Winsock 2.0 on those platforms.  Their algorithm is:

  1. Check the HOSTENT cache. 
  2. Check the HOSTS file at %SystemRoot%\System32\DRIVERS\ETC. 
  3. Do a DNS query if the DNS server is configured for name resolution. 
  4. Do an additional NetBIOS remote adapter status to an IP address for its
     NetBIOS name table. This step is specific only to the Windows NT version
     3.51 implementation.

  The problem is the use of the HOSTENT cache.  It means that gethostbyaddr()
  can not be used to resolve the real name of machine if it was originally
  accessed by an alias used to represent a cluster.
*/
    if (tcp_rdns && dns || tcp_rdns == SET_ON) {
#ifdef NT
        if (isWin95())
	  sleep(1);       
#endif /* NT */
        if (!quiet) {
	    printf(" Reverse DNS Lookup... ");
	    fflush(stdout);
	}
        if (host = gethostbyaddr((char *)&saddr.sin_addr,4,PF_INET)) {
	    debug(F100,"netopen gethostbyname != NULL","",0);
	    if (!quiet) {
		printf("(OK)\n");
		fflush(stdout);
	    }
	    strncpy(name,host->h_name,79);
	    strncat(name,":",80-strlen(name));
	    strncat(name,p,80-strlen(name));
	    if (!quiet
#ifndef NOICP
		&& !doconx
#endif /* NOICP */
		) {
		printf(" %s connected on port %s\n",host->h_name,p);
#ifdef COMMENT
		if (host->h_aliases) {
		    char ** a = host->h_aliases;
		    while (*a) {
			printf(" alias => %s\n",*a);
			a++;
		    }
		}
#endif /* COMMENT */
	    }
	} else {
	    if (!quiet) printf("Failed.\n");
	}
    } else if (!quiet) printf("(OK)\n");
    if (!quiet) fflush(stdout);

    /* This should already have been done but just in case */
    sprintf(ipaddr,"%s", (char *)inet_ntoa(saddr.sin_addr));

#ifdef CK_AUTHENTICATION
    /* Before Initialization Telnet/Rlogin Negotiations Init Kerberos */
    ck_krb_init((host && host->h_name && host->h_name[0]) ?
		host->h_name : ipaddr,
		ipaddr,
		uidbuf,
		ttyfd
		);
#endif /* CK_AUTHENTICATION */
    tn_ini();                           /* Reset/Start Telnet negotiations */
#ifdef RLOGCODE
    if (ttnproto == NP_RLOGIN) {
	if (rlog_ini() < 0) {
	    debug(F100,"rlogin initialization failed","",0);
	    netclos();
	    return -1;
	}
    }
#endif /* RLOGCODE */

    debug(F101,"netopen service","",svcnum);
    if (*lcl < 0) *lcl = 1;		/* Local mode. */
#endif /* TCPSOCKET */
    return(0);				/* Done. */
}

/*  N E T C L O S  --  Close current network connection.  */

int
netclos() {
    int x = 0;
    debug(F101,"netclos","",ttyfd);
    if (ttyfd == -1)			/* Was open? */
      return(0);			/* Wasn't. */
#ifndef OS2
    if (ttyfd > -1)			/* Was. */
#endif /* OS2 */
      {
#ifdef TNCODE
#ifdef COMMENT
#ifdef CK_ENCRYPTION
	if (u_encrypt)
	  ttflui();
	else
#endif /* CK_ENCRYPTION	*/
#endif /* COMMENT */
          tn_sopt(DO,TELOPT_LOGOUT);    /* Send LOGOUT option before close */
#endif /* TNCODE */
#ifdef VMS	
	  ck_cancio();			/* Cancel any outstanding reads. */
#endif /* VMS */
#ifdef TCPIPLIB
	  x = socket_close(ttyfd);	/* Close it. */
#else
#ifndef OS2
#ifdef IBMX25
	if (ttnet == NET_IX25) {
	    /* riehm: should send a disc_req - but only if link is still OK */
	    x = x25clear();
	    close(ttyfd);
	    if (x25serverfd) {
		  /* we were the passive client of a server, now we
		   * go back to being the normal client.
		   * I hope that kermit can cope with the logic that
		   * there can still be a connection after netclos
		   * has been called.
		   */
		  ttyfd = x25serverfd;
		  x25serverfd = 0;
		  /*
		   * need to close the server connection too - because
		   * all file descriptors connected to the NPI have the
		   * same status.
		   *
		   * The problem is that any waiting connections get
		   * lost, the client doesn't realise, and hangs.
		   */
		  netclos();
	      }
	    x25_state = X25_CLOSED;	/* riehm: dead code? */
	} else
#endif /* IBMX25 */
	  x = close(ttyfd);
#endif /* OS2 */
#endif /* TCPIPLIB */
      }
    ttyfd = -1;				/* Mark it as closed. */
#ifdef COMMENT
/* Don't do this in case the reconnect */
    ttnproto = NP_NONE;			/* Reset the protocol type */
#endif /* COMMENT */
    debug(F100,"netclose setting tn_init = 0","",0);
    tn_init = 0;			/* Remember about telnet protocol... */
    *ipaddr = '\0';			/* Zero the IP address string */
#ifdef TCPIPLIB
/*
  Empty the internal buffers so they won't be used as invalid input on
  the next connect attempt (rlogin).
*/
    ttibp = 0;
    ttibn = 0;
#endif /* TCPIPLIB */
    return(x);
}

#ifdef OS2
int
os2socketerror( int s_errno )
{
    switch (s_errno) {
    case 0:     /* NO ERROR */
        debug(F100,"os2socketerror NOERROR","",0);
        return(0);
#ifdef OS2ONLY
    case ENOENT:        /* ENOENT */
        debug(F100,"os2socketerror ENOENT","",0);
        return(0);
    case EPASTEOF:        /* EPASTEOF */
        debug(F100,"os2socketerror EPASTEOF","",0);
        return(0);
#endif /* OS2ONLY */
#ifdef NT
    case WSAECONNRESET:
#else /* NT */
    case SOCECONNRESET:
    case SOCECONNRESET - SOCBASEERR:
#endif /* NT */
        debug(F100,"os2socketerror ECONRESET","",0);
        netclos();		/* *** *** */
        return(-1);		/* Connection is broken. */
#ifdef NT
    case WSAECONNABORTED:
#else /* NT */
    case SOCECONNABORTED:
    case SOCECONNABORTED - SOCBASEERR:
#endif /* NT */
        debug(F100,"os2socketerror ECONNABORTED","",0);
        netclos();		/* *** *** */
        return(-1);		/* Connection is broken. */
#ifdef NT
    case WSAENETRESET:  
#else /* NT */
    case SOCENETRESET:
    case SOCENETRESET - SOCBASEERR:
#endif /* NT */
        debug(F100,"os2socketerror ENETRESET","",0);
        netclos();		/* *** *** */
        return(-1);		/* Connection is broken. */
#ifdef NT
    case WSAENOTCONN:
#else /* NT */
    case SOCENOTCONN:
    case SOCENOTCONN - SOCBASEERR:
#endif /* NT */
        debug(F100,"os2socketerror ENOTCONN","",0);
        netclos();		/* *** *** */
        return(-1);		/* Connection is broken. */
#ifdef NT
    case WSAESHUTDOWN:
#endif /* NT */
        debug(F100,"os2socketerror ESHUTDOWN","",0);
        netclos();		/* *** *** */
        return(-1);		/* Connection is broken. */
#ifdef NT
    case WSAEWOULDBLOCK:
#else
    case SOCEWOULDBLOCK:
    case SOCEWOULDBLOCK - SOCBASEERR:
#endif /* NT */
        debug(F100,"os2socketerror EWOULDBLOCK","",0);
        return(0);
#ifdef NT
    case ERROR_IO_INCOMPLETE:
    case ERROR_IO_PENDING:
    case ERROR_OPERATION_ABORTED:
        return(0);
#endif /* NT */
    default:
        return(-2);
    }
    return(0);
}
#endif /* OS2 */

/*  N E T T C H K  --  Check if network up, and how many bytes can be read */
/*
  Returns number of bytes waiting, or -1 if connection has been dropped.
*/
int					/* Check how many bytes are ready */
nettchk() {				/* for reading from network */
#ifdef TCPIPLIB
    long count = 0;
    int x = 0;
    long y;
    char c;
#ifdef NT
    extern int ionoblock;               /* For Overlapped I/O */
#endif /* NT */

    debug(F101,"nettchk entry ttibn","",ttibn);
    debug(F101,"nettchk entry ttibp","",ttibp);
#ifndef OS2
#ifndef BEBOX
    socket_errno = 0; /* This is a function call in NT, and BeOS */
#endif /* BEBOX */
#endif /* OS2 */

    if (ttyfd == -1) {
	debug(F100,"nettchk socket is closed","",0);
	return(-1);
    }
/*
  Note: this socket_ioctl() call does NOT return an error if the
  connection has been broken.  (At least not in MultiNet.)
*/
#ifdef COMMENT
/*  Another trick that can be tried here is something like this: */

    if (ttnet == NET_TCPB) {
	char dummy;
	x = read(ttyfd,&dummy,0);	/* Try to read nothing */
	if (x < 0) {			/* "Connection reset by peer" */
	    perror("TCP/IP");		/* or somesuch... */
	    ttclos(0);			/* Close our end too. */
	    return(-1);
	}
    }
#endif /* COMMENT */

    if (socket_ioctl(ttyfd,FIONREAD,
#ifdef COMMENT
    /* Now we've changed the ioctl(..,..,x) prototype for DECC to (void *) */
#ifdef __DECC
    /* NOTE: "&count" might need to be "(char *)&count" in some settings. */
		     /* Cast needed for DECC 4.1 & later? */		     
		     /* Maybe, but __DECC_VER only exists in 5.0 and later */
		     (char *)
#endif /* __DECC */
#endif /* COMMENT */
		     &count
		     ) < 0) {
	debug(F101,"nettchk socket_ioctl error","",socket_errno);
        /* If the connection is gone, the connection is gone. */
        netclos();
#ifdef NT_TCP_OVERLAPPED
        /* Is there anything in the overlapped I/O buffers? */
        count += OverlappedDataWaiting(); 
#endif /* NT_TCP_OVERLAPPED */
        count += ttibn;
        return(count>0?count:-1);
    }
    debug(F101,"nettchk count","",count);
#ifdef NT_TCP_OVERLAPPED
    /* Is there anything in the overlapped I/O buffers? */
    count += OverlappedDataWaiting(); 
    debug(F101,"nettchk count w/overlapped","",count);
#endif /* NT_TCP_OVERLAPPED */

/* For the sake of efficiency, if there is still data in the ttibuf */
/* do not go to the bother of checking to see of the connection is  */
/* still valid.  The handle is still good, so just return the count */
/* of the bytes that we already have left to process.               */
#ifdef OS2
    if ( ttibn > 8 ) {
        debug(F101,"nettchk returns","",count+ttibn);
        return(count+ttibn);
    } else {
        if ( ttibn == 0 )
            ttibp = 0;      /* reset for next read */
    }
#else /* OS2 */
    if ( ttibn ) {
        debug(F101,"nettchk returns","",count+ttibn);
        return(count+ttibn);
    }
#endif /* OS2 */

/*
  The following code works well in most settings, but messes things up in
  others, including CMU/Tek TCP/IP and UCX 2.0, where it somehow manages to
  make it impossible to ever make a new connection to the same host again with
  CONNECT, once it has been logged out from the first time.  Not even if you
  HANGUP first, or SET HOST<CR>, or SET LINE<CR>.  Reportedly, however, it
  does work OK in later releases of UCX.  But there is no way we can
  accommodate both old and new -- we might have static linking or dynamic
  linking, etc etc.  If we have static, I only have access to 2.0, where this
  doesn't work, etc etc blah blah.

  In the following lines, we define a symbol NOCOUNT for builds where we want
  to omit this code.  By default, it is omitted for CMU/Tek.  You can force
  omission of it for other combinations by defining NOCOUNT in CFLAGS.	You
  can force inclusion of this code, even for CMU/Tek, by including NONOCOUNT
  in CFLAGS.
*/
#ifdef NONOCOUNT
#ifdef NOCOUNT
#undef NOCOUNT
#endif /* NOCOUNT */
#else
#ifndef NOCOUNT
#ifdef CMU_TCPIP
#define NOCOUNT
#endif /* CMU_TCPIP */
#endif /* NOCOUNT */
#endif /* NONOCOUNT */

    /* we know now that count >= 0 and that ttibn == 0 */

    if (count == 0) {
#ifndef NOCOUNT
/*
  Here we need to tell the difference between a 0 count on an active
  connection, and a 0 count because the remote end of the socket broke the
  connection.  There is no mechanism in TGV MultiNet (or WIN/TCP?) to query
  the status of the connection, so we have to do a read.  -1 means there was
  no data available (socket_errno == EWOULDBLOCK), 0 means the connection is
  down.	 But if, by chance, we actually get a character, we have to put it
  where it won't be lost.
*/
#ifndef NON_BLOCK_IO
        y = 1;				/* Turn on nonblocking reads */
	x = socket_ioctl(ttyfd,FIONBIO,&y);
	debug(F101,"nettchk FIONBIO","",x);
#endif /* NON_BLOCK_IO */
#ifdef NT_TCP_OVERLAPPED
        ionoblock = 1;                  /* For Overlapped I/O */
#endif /* NT_TCP_OVERLAPPED */
#ifdef OS2
        x = socket_read(ttyfd,&ttibuf[ttibp+ttibn],
                         TTIBUFL-ttibp-ttibn);	/* Returns -1 if no data */
#else /* OS2 */
        x = socket_read(ttyfd,&c,1);	/* Returns -1 if no data */
#endif /* OS2 */
	debug(F101,"nettchk socket_read","",x);
	if (x == -1) {
	    int s_errno = socket_errno;	/* socket_errno may be a function */
	    debug(F101,"nettchk socket_read errno","",s_errno);
#ifdef OS2
            if (os2socketerror(s_errno) < 0)
	      return(-1);
#endif /* OS2 */
	}
#ifndef NON_BLOCK_IO
	y = 0;				/* Turn them back off */
	socket_ioctl(ttyfd,FIONBIO,&y);
#endif /* NON_BLOCK_IO */
#ifdef NT_TCP_OVERLAPPED
        ionoblock = 0;                  /* For Overlapped I/O */
#endif /* NT_TCP_OVERLAPPED */
	if (x == 0) {
	    debug(F100,"nettchk connection closed","",0);
	    netclos();			/* *** *** */
	    return(-1);			/* Connection is broken. */
	}
	if (x >= 1) {			/* Oops, actually got a byte? */
	    debug(F101,"nettchk socket_read char","",c);
	    debug(F101,"nettchk ttibp","",ttibp);
	    debug(F101,"nettchk ttibn","",ttibn);
#ifdef OS2
            /* In OS/2 we read directly into ttibuf[] */
            ttibn += x;
#else /* OS2 */
#ifndef NT_TCP_OVERLAPPED
/*
  So put the byte we got into the buffer at the current position.
  Increment the buffer count, but DON'T increment the buffer pointer.
*/
	    ttibuf[ttibp+ttibn] = c;
	    ttibn++;
#else /* NT_TCP_OVERLAPPED */
/* in the case of Overlapped I/O the character would have come from */
/* the beginning of the buffer, so put it back                      */
            if ( ttibp > 0 ) {
                ttibp--;
                ttibuf[ttibp] = c;
                ttibn++;
            }
            else {
                ttibuf[ttibp+ttibn] = c;
                ttibn++;
            }
#endif /* NT_TCP_OVERLAPPED */
#endif /* OS2 */
#ifdef DEBUG
	    ttibuf[ttibp+ttibn] = '\0';
	    debug(F111,"nettchk ttibn",ttibuf,ttibn);
#endif /* DEBUG */
	}
#else
	if (ttnet == NET_TCPB) {
	    char dummy;
	    x = read(ttyfd,&dummy,0);	/* Try to read nothing */
	    if (x < 0) {		/* "Connection reset by peer" */
		perror("TCP/IP");	/* or somesuch... */
		ttclos(0);		/* Close our end too. */
		return(-1);
	    }
	}
#endif /* NOCOUNT */
    }
    debug(F101,"nettchk returns","",count+ttibn);
    return(count + ttibn);

#else /* Not TCPIPLIB */
/*
  UNIX just uses ttchk(), in which the ioctl() calls on the file descriptor
  seem to work OK.
*/
    return(0);
#endif /* TCPIPLIB */
/*
  But what about X.25?
*/
}

#ifndef OS2
VOID
nettout(i) int i; {			/* Catch the alarm interrupts */
    debug(F100,"nettout caught timeout","",0);
    ttimoff();
    cklongjmp(njbuf, -1);
}
#endif /* !OS2 */

#ifdef TCPIPLIB

VOID
#ifdef CK_ANSIC
donetinc(void * threadinfo)
#else /* CK_ANSIC */
donetinc(threadinfo) VOID * threadinfo;
#endif /* CK_ANSIC */
/* donetinc */ {
#ifdef NTSIG
    extern int TlsIndex;
    setint();
    if (threadinfo) {			/* Thread local storage... */
	TlsSetValue(TlsIndex,threadinfo);
    }
#endif /* NTSIG */
    while (1) {
	if (ttbufr() < 0)		/* Keep trying to refill it. */
	  break;			/* Till we get an error. */
	if (ttibn > 0)			/* Or we get a character. */
	  break;
    }
}
#endif /* TCPIPLIB */

VOID
#ifdef CK_ANSIC
failnetinc(void * threadinfo)
#else /* CK_ANSIC */
failnetinc(threadinfo) VOID * threadinfo;
#endif /* CK_ANSIC */
/* failnetinc */ {
    ; /* Nothing to do on an error */
}

/* N E T X I N -- Input block of characters from network */

int 
netxin(n,buf) int n; char * buf; {
    int len;
    int rc;
    int i, j;
    if (ttyfd == -1) {
	debug(F100,"netinc socket is closed","",0);
	return(-2);
    }
#ifdef TCPIPLIB
    if (!ttibn)
      if ((rc = ttbufr()) <= 0)
	return(rc);

    if (ttibn <= n) {
	len = ttibn;
	memcpy(buf,&ttibuf[ttibp],len);
	ttibp += len;
	ttibn = 0;
    } else {
	memcpy(buf,&ttibuf[ttibp],n);
	ttibp += n;
	ttibn -= n;
	len = n;
    }
#else /* TCPIPLIB */
    for (i = 0; i < n; i++) {
	if ((j = netinc(0)) < 0) {
	    if (j < -1)
	      return(j);
	    else 
	      break;
	}
	buf[i] = j;
    }
    len = i;
#endif /* TCPIPLIB */

#ifdef COMMENT
#ifdef CK_ENCRYPTION
    /* This would be great if it worked.  But what if the buffer we read  */
    /* contains a telnet negotiation that changes the state of the        */
    /* encryption.  If so, we would be either decrypting unencrypted text */
    /* or not decrypting encrypted text.  So we must move this call to    */
    /* all functions that call ttxin().  In OS2 that means os2_netxin()   */
    /* where the Telnet Negotiations are handled.                         */
    if (u_encrypt)
      ck_krb_decrypt(buf,len);
#endif /* CK_ENCRYPTION */
#endif /* COMMENT */

    return(len);
}

/*  N E T I N C --  Input character from network */

int			
netinc(timo) int timo; {
#ifdef TCPIPLIB
    int x; unsigned char c;		/* The locals. */

    if (ttyfd == -1) {
	debug(F100,"netinc socket is closed","",0);
	return(-2);
    }
    if (ttibn > 0) {			/* Something in internal buffer? */
#ifdef COMMENT
	debug(F100,"netinc char in buf","",0); /* Yes. */
#endif /* COMMENT */
	x = 0;				/* Success. */
    } else {				/* Else must read from network. */
	x = -1;				/* Assume failure. */
#ifdef DEBUG
	debug(F101,"netinc goes to net, timo","",timo);
	ttibuf[ttibp+1] = '\0';
	debug(F111,"netinc ttibuf",ttibuf,ttibp);
#endif /* DEBUG */
	if (timo == 0) {		/* Untimed case. */
	    while (1) {			/* Wait forever if necessary. */
		if (ttbufr() < 0)	/* Refill buffer. */
		  break;		/* Error, fail. */
		if (ttibn > 0) {	/* Success. */
		    x = 0;
		    break;
		}
	    }
	} else {			/* Timed case... */
#ifdef NT_TCP_OVERLAPPED
            /* This code is for use on NT when we are using */
            /* Overlapped I/O to handle reads.  In the case */
            /* of outstanding reads select() doesn't work   */
            
            if (WaitForOverlappedReadData(timo)) {
                while (1) {
                    if (ttbufr() < 0)	/* Keep trying to refill it. */
                        break;		/* Till we get an error. */
                    if (ttibn > 0) {	/* Or we get a character. */
                        x = 0;
                        break;
                    }
                }
            }
#else /* NT_TCP_OVERLAPPED */
#ifdef BSDSELECT
	    fd_set rfds;
	    struct timeval tv;
	    FD_ZERO(&rfds);
	    FD_SET(ttyfd, &rfds);
	    tv.tv_sec  = tv.tv_usec = 0L;
	    if (timo < 0)
#ifdef NT
	      tv.tv_usec = (long) -timo * 1000L;
#else  /* NT */
	      tv.tv_usec = (long) -timo * 10000L;
#endif /* NT */
	    else
	      tv.tv_sec = timo;
	    debug(F101,"netinc BSDSELECT","",timo);
#ifdef NT
                WSASafeToCancel = 1;
#endif /* NT */
                if (select(FD_SETSIZE,
#ifndef __DECC
                            (fd_set *)
#endif /* __DECC */
                            &rfds,
                            NULL, NULL, &tv) > 0 &&
                     FD_ISSET(ttyfd, &rfds)) {
#ifdef NT
                    WSASafeToCancel = 0;
#endif /* NT */
                    while (1) {
                        if (ttbufr() < 0) /* Keep trying to refill it. */
                            break;	  /* Till we get an error. */
                        if (ttibn > 0) {  /* Or we get a character. */
                            x = 0;
                            break;
                        }
                    }
                }	 
#ifdef NT
	    WSASafeToCancel = 0;
#endif /* NT */
#else /* !BSDSELECT */
#ifdef IBMSELECT
/*
  Was used by OS/2, currently not used, but might come in handy some day...
  ... and it came in handy!  For our TCP/IP layer, it avoids all the fd_set
  and timeval stuff since this is the only place where it is used.
*/
	    int socket = ttyfd;
	    debug(F101,"netinc IBMSELECT","",timo);
	    if (select(&socket, 1, 0, 0,
                         timo < 0 ? -timo : timo * 1000L) == 1)
	      while (1) {
		  if (ttbufr() < 0)	/* Keep trying to refill it. */
		    break;		/* Till we get an error. */
		  if (ttibn > 0) {	/* Or we get a character. */
		      x = 0;
		      break;
		  }
	      }
#else /* !IBMSELECT */
#ifdef WINSOCK
       /* Actually, under WinSock we have a better mechanism than select() */
       /* for setting timeouts (SO_RCVTIMEO, SO_SNDTIMEO) */
	    SOCKET socket = ttyfd;
	    debug(F101,"netinc NTSELECT","",timo);
	    if (setsockopt(socket, SOL_SOCKET, SO_RCVTIMEO, (char *)&timo, 
			    sizeof(timo))  == NO_ERROR)
	      while (1) {
		  if (ttbufr() < 0)	/* Keep trying to refill it. */
		    break;		/* Till we get an error. */
		  if (ttibn > 0) {	/* Or we get a character. */
		      x = 0;
		      break;
		  }
	      }
#else /* WINSOCK */
/*
  If we can't use select(), then we use the regular alarm()/signal()
  timeout mechanism.
*/
	    debug(F101,"netinc alarm","",timo);
	    x = alrm_execute(ckjaddr(njbuf),timo,nettout,donetinc,failnetinc);
	    ttimoff();			/* Timer off. */
#endif /* WINSOCK */
#endif /* IBMSELECT */
#endif /* BSDSELECT */
#endif /* NT_TCP_OVERLAPPED */
	}
    }
    if (x < 0) {			/* Return -1 if we failed. */
	debug(F100,"netinc timed out","",0);
	return(-1);
    } else {				/* Otherwise */
	ttibn--;			/* Return what we got. */
	c = ttibuf[ttibp++];
	if (deblog) {
#ifndef COMMENT
	    debug(F101,"netinc returning","",c);
#endif /* COMMENT */
	    if (c == 0) {
		debug(F101,"netinc 0 ttibn","",ttibn);
		debug(F101,"netinc 0 ttibp","",ttibp);
	    }
	}

#ifdef CK_ENCRYPTION
        if (u_encrypt)
	  ck_krb_decrypt(&c,1);
#endif /* CK_ENCRYPTION */
	return(c);
    }
#else /* Not using TCPIPLIB */
    return(-1);
#endif /* TCPIPLIB */
}

/*  N E T T O L	 --  Output a string of bytes to the network  */
/*
  Call with s = pointer to string, n = length.
  Returns number of bytes actually written on success, or
  -1 on i/o error, -2 if called improperly.
*/

nettol(s,n) char *s; int n; {
#ifdef TCPIPLIB
    int count = 0;
    int len = n;
    int try = 0;

    if (ttyfd == -1) {
	debug(F100,"nettol socket is closed","",0);
	return -1;
    }
    debug(F101,"nettol TCPIPLIB ttnet","",ttnet);
#ifdef CK_ENCRYPTION
    if (me_encrypt)
      ck_krb_encrypt(s,n);
#endif /* CK_ENCRYPTION */

  nettol_retry:
    try++;                              /* Increase the try counter */

    if (ttnet == NET_TCPB) {
#ifdef BSDSELECT
	fd_set wfds;
	struct timeval tv;
	FD_ZERO(&wfds);
	FD_SET(ttyfd, &wfds);
	tv.tv_sec  = tv.tv_usec = 0L;
	tv.tv_sec = 999;
	debug(F101,"nettol BSDSELECT","",0);
#ifdef NT
	WSASafeToCancel = 1;
#endif /* NT */
	if (!(select(FD_SETSIZE, NULL,
#ifdef __DECC
#ifndef __DECC_VER
		     (int *)
#endif /* __DECC_VER */
#endif /* __DECC */
		     &wfds, NULL, &tv) > 0 &&

	       FD_ISSET(ttyfd, &wfds))) {
	    debug(F101,"nettol select failed","",socket_errno);
#ifdef BETATEST
            printf("nettol select failed\n");
#endif /* BETATEST */
#ifdef NT
	    WSASafeToCancel = 0;
	    if (!win95selectbug)
#endif /* NT */
	    return(-1);
	}
#ifdef NT
	WSASafeToCancel = 0;
#endif /* NT */
#else /* BSDSELECT */
#ifdef IBMSELECT
	{
	    int tries = 0;
	    debug(F101,"nettol IBMSELECT","",0);
	    while (select(&ttyfd, 0, 1, 0, 1000) != 1) {
		int count;
		if (tries++ >= 999) {
		    /* if after 60 seconds we can't get permission to write */
		    debug(F101,"nettol select failed","",socket_errno);
		    return(-1);
		}
		if ((count = nettchk()) < 0) {
		    debug(F111,"nettol","nettchk()",count);
		    return(count);
		}
	    }
	}
#endif /* IBMSELECT */
#endif /* BSDSELECT */
	if ((count = socket_write(ttyfd,s,n)) < 0) {
            int s_errno = socket_errno; /* maybe a function */
	    debug(F101,"nettol socket_write error","",s_errno);
#ifdef OS2
            if (os2socketerror(s_errno) < 0)
	      return(-2);
#endif /* OS2 */
	    return(-1);			/* Call it an i/o error */
	} else if (count < n) {
	    debug(F111,"nettol socket_write",s,count);
	    if (try > 25) {
		/* don't try more than 25 times */
		debug(F100,"nettol tried more than 25 times","",0);
		return(-1);
	    }
	    s += count;
	    n -= count;
	    debug(F111,"nettol retry",s,n);
	    goto nettol_retry;
	} else {
	    debug(F111,"nettol socket_write",s,count);
	    return(len); /* success - return total length */
	}
    } else 
      return(-2);
#else
    debug(F100,"nettol TCPIPLIB not defined","",0);
    return(-2);
#endif /* TCPIPLIB */
}

/*  N E T T O C	 --   Output character to network */
/*
  Call with character to be transmitted.
  Returns 0 if transmission was successful, or
  -1 upon i/o error, or -2 if called improperly.
*/
int			
#ifdef CK_ANSIC
nettoc(char c)
#else
nettoc(c) char c;
#endif /* CK_ANSIC */
/* nettoc */ {
#ifdef UNIX
    return(ttoc(c));
#else
#ifdef TCPIPLIB
    unsigned char cc;
    if (ttyfd == -1) {
	debug(F100,"nettoc socket is closed","",0);
	return -1;
    }
    cc = c;
    debug(F101,"nettoc cc","",cc);
#ifdef CK_ENCRYPTION
        if ( me_encrypt )
            ck_krb_encrypt(&cc,1);
#endif /* CK_ENCRYPTION */
    if (ttnet == NET_TCPB) {
#ifdef BSDSELECT
	fd_set wfds;
	struct timeval tv;
	FD_ZERO(&wfds);
	FD_SET(ttyfd, &wfds);
	tv.tv_sec  = tv.tv_usec = 0L;
	tv.tv_sec = 999;
	debug(F101,"nettoc BSDSELECT","",0);
#ifdef NT
	WSASafeToCancel = 1;
#endif /* NT */
	if (!(select(FD_SETSIZE, NULL,
#ifdef __DECC
#ifndef __DECC_VER
		     (int *)
#endif /* __DECC_VER */
#endif /* __DECC */
		     &wfds, NULL, &tv) > 0 && FD_ISSET(ttyfd, &wfds))) {
	    debug(F100,"nettoc select failed","",0);
#ifdef NT
	    WSASafeToCancel = 0;
	    if (!win95selectbug)
#endif /* NT */
	      return(-1);
	}
#ifdef NT
	WSASafeToCancel = 0;
#endif /* NT */
#else /* BSDSELECT */
#ifdef IBMSELECT
#ifndef COMMENT
	{
	    int tries = 0;
	    while (select(&ttyfd, 0, 1, 0, 1000) != 1) {
		int count;
		if (tries++ >= 999) {
		    /* if after 60 seconds we can't get permission to write */
		    debug(F101,"nettoc select failed","",socket_errno);
		    return(-1);
		}
		if ((count = nettchk()) < 0) {
		    debug(F111,"nettoc","nettchk()",count);
		    return(count);
		}
	    }
	}
#else /* COMMENT */
	if (select(&ttyfd, 0, 1, 0, 60) != 1) {
	    debug(F100,"nettoc select failed","",0);
	    return(-1);
	}
#endif /* COMMENT */
#endif /* IBMSELECT */
#endif /* BSDSELECT */
	if (socket_write(ttyfd,&cc,1) < 1) {
            int s_errno = socket_errno;         /* maybe a function */
	    debug(F101,"nettoc socket_write error","",s_errno);
#ifdef OS2
            if (os2socketerror(s_errno) < 0)
	      return(-2);
#endif /* OS2 */
	    return(-1);
	}
	debug(F101,"nettoc socket_write","", cc);
	return(0);   
    } else return(-2);
#else
    return(-2);
#endif /* TCPIPLIB */
#endif /* UNIX */
}

/*  N E T F L U I  --  Flush network input buffer  */

int
netflui() {
    int n;
#ifdef TCPIPLIB
    ttibuf[ttibp+ttibn] = '\0';
    debug(F111,"netflui 1",ttibuf,ttibn);
#ifdef CK_ENCRYPTION
    if (u_encrypt) {
        ck_krb_decrypt(&ttibuf[ttibp],ttibn);
    }
#endif /* CK_ENCRYPTION */
    ttibn = ttibp = 0;			/* Flush internal buffer *FIRST* */
    if (ttyfd < 1)
      return(0);
    if ((n = nettchk()) > 0) {		/* Now see what's waiting on the net */
	if (n > TTIBUFL) n = TTIBUFL;	/* and sponge it up */
	debug(F101,"netflui 2","",n);	/* ... */
	n = socket_read(ttyfd,ttibuf,n); /* into our buffer */
	if (n >= 0) ttibuf[n] = '\0';
	debug(F111,"netflui 3",ttibuf,n);
#ifdef CK_ENCRYPTION
        if (u_encrypt) {
            ck_krb_decrypt(&ttibuf[ttibp],n);
        }
#endif /* CK_ENCRYPTION */
	ttibuf[0] = '\0';
    }
#else
/*
  It seems the UNIX ioctl()s don't do the trick, so we have to read the
  stuff ourselves.  This is portable if not elegant.
*/
    if (ttyfd < 1)
      return(0);
    if ((n = ttchk()) > 0) {
	debug(F101,"netflui non-TCPIPLIB","",n);
	while ((n--) && ttinc(0) > -1)	/* Don't worry, ttinc() is buffered */
	  ;				/* and it handles the decryption... */
    }
#endif /* TCPIPLIB */
    return(0);
}

/* getlocalipaddr() attempts to resolve an IP Address for the local machine.
 *   If the host is multi-homed it returns only one address.
 * 
 * Two techniques are used.  
 * (1) get the local host name and perform a reverse DNS lookup, then take
 *     the first entry;
 * (2) open a UDP socket, use it to connect to a fictitious host (it's OK,
 *    no data is sent), then retrieve the local address from the socket.
 * Note: the second technique won't work on Microsoft systems.  See 
 * Article ID: Q129065 PRB: Getsockname() Returns IP Address 0.0.0.0 for UDP
 */

int
getlocalipaddr() {
#ifndef datageneral
    char localhost[256];
    struct hostent * host=NULL;
    struct sockaddr_in l_sa;
    struct sockaddr_in r_sa;
#ifdef VMS
    GSOCKNAME_T slen = sizeof(struct sockaddr_in);
#else
    int slen = sizeof(struct sockaddr_in);
#endif /* VMS */
    int sock;
    int rc;  
    char messageBuf[60]; 
    struct in_addr laddr;	 

    /* init local address (to zero) */
    l_sa.sin_addr.s_addr = INADDR_ANY;

    /* get local host name */
    rc = gethostname(localhost, 256);
    debug(F110,"getlocalipaddr localhost",localhost,0);
    if (!rc) {
        /* resolve host name for local address */
        host = gethostbyname(localhost);
        if (host) {
            l_sa.sin_addr.s_addr = *((unsigned long *) (host->h_addr));
	    sprintf(myipaddr,"%s", (char *)inet_ntoa(l_sa.sin_addr));
	    debug(F110,"getlocalipaddr setting myipaddr to",myipaddr,0);

#ifdef HADDRLIST
#ifdef h_addr
            if ( deblog || tcp_address ) {
                /* This is for reporting multiple IP Address */
                while (host->h_addr_list && host->h_addr_list[0]) {
                    l_sa.sin_addr.s_addr = 
                        *((unsigned long *) (host->h_addr_list[0]));
                    sprintf(messageBuf,"%s",
                             (char *)inet_ntoa(l_sa.sin_addr));
                    if (tcp_address) {
                        if (!strcmp(messageBuf,tcp_address)) 
			  strcpy(myipaddr,tcp_address);
                    }
                    debug(F110,"getlocalipaddr ip address list",
                           messageBuf,0);
                    host->h_addr_list++;
                }
            }
#endif /* h_addr */
#endif	/* HADDRLIST */
            return(0);
        }
    }

#ifndef OS2
    /* if still not resolved, then try second strategy */
    /* This second strategy does not work on Windows */
    if (l_sa.sin_addr.s_addr == INADDR_ANY) {
        /* get a UDP socket */
        sock = socket(AF_INET, SOCK_DGRAM, 0);
        if (sock != -1) {
            /* connect to arbirary port and address (NOT loopback) */
            r_sa.sin_family = AF_INET;
            r_sa.sin_port = htons( IPPORT_ECHO );

	    /* The following is an "illegal conversion" in AOS/VS */
	    /* (and who knows where else) */

            r_sa.sin_addr.s_addr = inet_addr("128.127.50.1");
            rc = connect(sock,
			 (struct sockaddr *) &r_sa,
                            sizeof(struct sockaddr)
			 );
            if (!rc) {			    
                /* get local address */
#ifdef VMS
                getsockname( sock,(struct sockaddr *) &l_sa, &slen);
#else
                getsockname( sock,(struct sockaddr *) &l_sa, (int *)&slen);
#endif /* VMS */
            }
#ifdef TCPIPLIB
            socket_close(sock);		/* We're done with the socket */
#else
            close(sock);
#endif /* TCPIPLIB */
	    sprintf(myipaddr,"%s", (char *)inet_ntoa(l_sa.sin_addr));
            debug(F110,"getlocalipaddr setting myipaddr to",myipaddr,0);
            return(0);
        } 
    }
#endif /* OS2 */
#endif /* datageneral */
    return(-1);
}

#ifdef RLOGCODE			/* TCP/IP RLOGIN protocol support code */
#ifndef OS2
static
#endif /* OS2 */
int
rlog_naws() {
    struct rlog_naws {
	char id[4];
	unsigned short rows, cols, ypix, xpix;
    } nawsbuf;

    if (ttnet != NET_TCPB)
      return 0;
    if (ttnproto != NP_RLOGIN)
      return 0;
    if (!nawsflg)
      return 0;

    debug(F100,"rlogin Window Size sent","",0);

    nawsbuf.id[0] = nawsbuf.id[1] = 0xFF;
    nawsbuf.id[2] = nawsbuf.id[3] = 's';
#ifdef OS2
    nawsbuf.rows = htons((unsigned short) (VscrnGetHeight(VTERM)
			  -(tt_status?1:0)));
    nawsbuf.cols = htons((unsigned short) VscrnGetWidth(VTERM));
#else /* OS2 */
    nawsbuf.rows = htons((unsigned short) tt_rows);
    nawsbuf.cols = htons((unsigned short) tt_cols);
#endif /* OS2 */
    nawsbuf.ypix = htons(0);		/* y pixels */

    nawsbuf.xpix = htons(0);		/* x pixels */
    if (ttol((CHAR *) &nawsbuf, 12) < 0)
      return -1;
    return 0;
}

#ifdef OS2
#define RLOGOUTBUF
#endif /* OS2 */
static int
rlog_ini() {
#ifdef RLOGOUTBUF
    char outbuf[512];
    int  outbytes=0;
#endif /* RLOGOUTBUF */
    int flag = 0;
#define TERMLEN 16
    char localuser[255];
    int userlen = 0;
    char terminal[TERMLEN+1];
#ifdef CONGSPD
#define CONSPDLEN 16
    char conspeed[CONSPDLEN+1];
    long conspd = -1L;
#endif /* CONGSPD */
#ifdef OS2
    extern int tt_type, max_tt;
    extern struct tt_info_rec tt_info[];
#endif /* OS2 */
    int i, n;

    int rc = 0;
    nawsflg = 0;			/* Assume no NAWS */
#ifdef CK_AUTHENTICATION
    me_auth = 0;                        /* Not in Auth mode */
#endif /* CK_AUTHENTICATION */
#ifdef CK_ENCRYPTION
    me_encrypt = 0;                     /* Not in Encrypt mode */
    u_encrypt = 0;
#endif /* CK_AUTHENTICATION */
#ifdef IKS_OPTION
    me_iks = u_iks = me_iks_start = u_iks_start = 0;
#endif /* IKS_OPTION */

#ifdef CK_TTGWSIZ
/*
  But compute the values anyway before the first read since the out-
  of-band NAWS request would arrive before the first data byte (NULL).
*/
#ifdef OS2
    /* Console terminal screen rows and columns */
    debug(F101,"rlog_ini tt_rows 1","",VscrnGetHeight(VTERM)
	   -(tt_status?1:0));
    debug(F101,"rlog_ini tt_cols 1","",VscrnGetWidth(VTERM));
    /* Not known yet */
    if (VscrnGetWidth(VTERM) < 0 || 
	VscrnGetHeight(VTERM)-(tt_status?1:0) < 0) {
	ttgwsiz();			/* Try to get screen dimensions */
    }
    debug(F101,"rlog_ini tt_rows 2","",VscrnGetHeight(VTERM)-(tt_status?1:0));
    debug(F101,"rlog_ini tt_cols 2","",VscrnGetWidth(VTERM));
#else /* OS2 */
    debug(F101,"rlog_ini tt_rows 1","",tt_rows);
    debug(F101,"rlog_ini tt_cols 1","",tt_cols);
    if (tt_rows < 0 || tt_cols < 0) {	/* Not known yet */
	ttgwsiz();			/* Try to find out */
    }
    debug(F101,"rlog_ini tt_rows 2","",tt_rows);
    debug(F101,"rlog_ini tt_cols 2","",tt_cols);
#endif /* OS2 */
#endif /* CK_TTGWSIZ */

    ttflui();                           /* Start by flushing the buffers */

    rlog_mode = RL_COOKED;
#ifdef RLOGOUTBUF
    outbuf[outbytes++] = 0;
#else 
    ttoc(0);				/* Send an initial NUL as wake-up */
#endif /* RLOGOUTBUF */

    /* Followed by client username ... */

    localuser[0] = '\0';
#ifdef NT
    {
	char localuid[64];
	unsigned long len = 64;
	localuid[0] = '\0';
	WNetGetUser(NULL, localuid, &len);
#ifdef RLOGOUTBUF
        strcpy(&outbuf[outbytes],localuid);
        outbytes += strlen(localuid) + 1;
#else
        ttol(localuid,strlen(localuid)+1);  /* strlen + 1 */
#endif  /* RLOGOUTBUF */
    }
#else /* NT */
    {
	char *s; char *p;
	char * user = getenv("USER");
	debug(F110,"rlogin getenv(USER)",user,0);
	if (!user)
	  user = "";
	userlen = strlen(user);
	s = user;
	p = (char *)localuser;
#ifdef VMS				/* Convert username to lowercase */
	for (s = user; *s; s++,p++)
	  *p = isupper(*s) ? tolower(*s) : *s;
	*p = '\0';
#else
	while (*p++ = *s++) ;
#endif /* VMS */
#ifdef RLOGOUTBUF
        strcpy(&outbuf[outbytes],localuser);
        outbytes += userlen+1;
#else
	rc = ttol((CHAR *)localuser,userlen+1); /* strlen + 1 */
#endif /* RLOGOUTBUF */
	debug(F111,"rlog_ini","ttol local user",rc);
    }
#endif /* NT */

    /* Then the server userid... */

    if (uidbuf[0]) {
#ifdef RLOGOUTBUF
        strcpy(&outbuf[outbytes],uidbuf);
        outbytes += strlen(uidbuf) + 1;
#else
        rc = ttol((CHAR *) uidbuf,strlen(uidbuf)+1); /* strlen + 1 */
#endif /* RLOGOUTBUF */
	debug(F111,"rlog_ini","ttol server user",rc);
    } else if (localuser[0]) {
#ifdef RLOGOUTBUF
        strcpy(&outbuf[outbytes],localuser);
        outbytes += strlen(localuser) + 1;
#else
	rc = ttol((CHAR *) localuser,userlen+1);
#endif /* RLOGOUTBUF */
	debug(F111,"rlog_ini","ttol server user",rc);
    } else {
#ifdef RLOGOUTBUF
        outbuf[outbytes++]=0;
#else
	rc = ttoc(0);
#endif /* RLOGOUTBUF */
	debug(F111,"rlog_ini","ttoc NUL server user",rc);
    }
    /* Finally the terminal type and speed */

    terminal[0] = '\0';
    if (tn_term) {			/* SET TELNET TERMINAL-TYPE value */
	if (*tn_term) {			/* (if any) takes precedence. */
	    strncpy(terminal, tn_term, TERMLEN);
	    terminal[TERMLEN] = '\0';
	    flag = 1;
	}
    } else {				/* Otherwise the local terminal type */
#ifdef OS2
	/* In terminal-emulating versions, it's the SET TERM TYPE value */
	strncpy(terminal, (tt_type >= 0 && tt_type <= max_tt) ?
		tt_info[tt_type].x_name : "network", TERMLEN);
#else
	/* In the others, we just look at the TERM environment variable */
	{
	    char *p = getenv("TERM");
	    if (p)
	      strncpy(terminal,p,TERMLEN);
	    else
	      terminal[0] = '\0';
#ifdef VMS
	    for (p = (char *) terminal; *p; p++) {
		if (*p == '-' && (!strcmp(p,"-80") || !strcmp(p,"-132")))
		  break;
		else if (isupper(*p))
		  *p = tolower(*p);
	    }
	    *p = '\0';
#endif /* VMS */
	}
#endif /* OS2 */
    }
    n = strlen(terminal);
    if (n > 0) {			/* We have a terminal type */
	if (!flag) {			/* If not user-specified */
	    for (i = 0; i < n; i++)	/* then lowercase it.	 */
	      if (isupper(terminal[i]))
		terminal[i] = tolower(terminal[i]);
	}
#ifdef RLOGOUTBUF
        strcpy(&outbuf[outbytes],terminal);
        outbytes += n;
#else   
	rc = ttol((CHAR *)terminal,n);
#endif /* RLOGOUTBUF */
	debug(F111,"rlog_ini","ttol terminal",rc);
#ifdef CONGSPD
	/* conspd() is not yet defined in all ck*tio.c modules */
	conspd = congspd();
	if (conspd > 0L) {
	    sprintf(conspeed,"/%ld",conspd);
	    n = strlen(conspeed);
#ifdef RLOGOUTBUF
            strcpy(&outbuf[outbytes],conspeed);
            outbytes += n+1;
#else
	    rc = ttol((CHAR *)conspeed,n+1);
#endif /* RLOGOUTBUF */
	} else 
#endif /* CONGSPD */
        {
#ifdef RLOGOUTBUF
            strcpy(&outbuf[outbytes],"/19200");
            outbytes += 7;
#else
            rc = ttol((CHAR *)"/19200",7); /* strlen + 1 */
#endif /* RLOGOUTBUF */
        }
	debug(F111,"rlog_ini","ttol speed",rc);
    } else {
#ifdef RLOGOUTBUF
        outbuf[outbytes++]=0;
#else
	rc = ttoc(0); 
#endif /* RLOGOUTBUF */
	debug(F111,"rlog_ini","ttoc NUL terminal/speed",rc);
    }

#ifdef RLOGOUTBUF
    ttol(outbuf,outbytes);
#endif /* RLOGOUTBUF */

    /* Now we are supposed to get back a single zero byte as confirmation */
    errno = 0;
    rc = ttinc(60);
    debug(F101,"rlogin first ttinc","",rc);
    if (rc > 0) {
	debug(F101,"rlogin ttinc 1","",rc);
	printf("Rlogin protocol error - 0x%x received instead of 0x00\n", rc);
	return(-1);
    } else if (rc < 0) {
	debug(F101,"rlogin ttinc errno","",errno);
	/* printf("Network error: %d\n", errno); */
	return(-1);
    }	
    return(0);
}

#ifdef TCPIPLIB
static VOID
rlog_oob(oobdata, count) CHAR * oobdata; int count; {
    int i;

    for (i = 0; i<count; i++)	{
	debug(F101,"rlogin out_of_band","",oobdata[i]);
	if (oobdata[i] == 0x02) { /* Flush Buffered Data not yet displayed */
	    debug(F101,"rlogin Flush Buffered Data command","",oobdata[i]);
	    ttflui();
	}
	if (oobdata[i] & 0x10) {	/* Switch to RAW mode */
	    debug(F101,"rlogin Raw Mode command","",oobdata[i]);
	    rlog_mode = RL_RAW;
	}

	if (oobdata[i] & 0x20) {	/* Switch to COOKED mode */
	    debug(F101,"rlogin Cooked Mode command","",oobdata[i]);
	    rlog_mode = RL_COOKED;
	}
	if (oobdata[i] & 0x80) {	/* Send Window Size Info */
	    debug(F101,"rlogin Window Size command","",oobdata[i]);
	    /* Remember to send WS Info when Window Size changes */
	    nawsflg = 1;
	    rlog_naws();
	}
    }
}
#else /* TCPIPLIB */
static SIGTYP
rlogoobh(sig) int sig; {
#ifdef SOLARIS
    char				/* Or should it be char for all? */
#else
    CHAR
#endif /* SOLARIS */
      oobdata;

    int	 count = 0;

    while (recv(ttyfd, &oobdata, 1, MSG_OOB) < 0) { 
      /* 
       * We need to do some special processing here.
       * Just in case the socket is blocked for input
       * 
       */
	switch (errno) {
	  case EWOULDBLOCK:
	    break;
	  default:
	    return;
	}
    }
    debug(F101,"rlogin out_of_band","",oobdata);
    if (oobdata == 0x02) {	/* Flush Buffered Data not yet displayed */
	debug(F101,"rlogin Flush Buffered Data command","",oobdata);
	netflui();
    }
    if (oobdata & 0x10) {		/* Switch to raw mode */
	debug(F101,"rlogin Raw Mode command","",oobdata);
	rlog_mode = RL_RAW;
    }
    if (oobdata & 0x20) {		/* Switch to cooked mode */
	debug(F101,"rlogin Cooked Mode command","",oobdata);
	rlog_mode = RL_COOKED;
    }
    if (oobdata & 0x80) {		  /* Send Window Size Info */
	debug(F101,"rlogin Window Size command","",oobdata);
	nawsflg = 1; /* Remember to send WS Info when Window Size changes */
	rlog_naws();
    }
}
#endif /* TCPIPLIB */
#endif /* RLOGCODE */

#ifdef TNCODE				/* Compile in telnet support code */

/* TCP/IP TELNET protocol negotiation support code */

static int sgaflg = 0;			/* SUPRRESS GO-AHEAD state */
static int ttyflg = 0;			/* TERMINAL TYPE state */
static int dosndloc = 0;		/* SENDLOC flag */
static int nsndloc = 0;			/* SENDLOC count */

static int wnawsflg = 0;		/* Initial WILL NAWS sent, no reply */
static int wmebinflg = 0,  /* initial WILL TX-BINARY sent, no reply */
	   dubinflg  = 0;  /* initial DO TX-BINARY sent, no reply */

static int wnenvflg = 0,   /* Initial WILL NEW-ENVIRONMENT sent, no reply */
	   nenvflg = 0;	   /* NEW-ENVIRONMENT state */

static int wauthflg = 0;        /* WILL AUTHENTICATION */
static int wencryptflg = 0;     /* WILL ENCRYPTION */
static int dencryptflg = 0;     /* DO ENCRYPTION */
static int dlogoutflg = 0;      /* DO LOGOUT */

static int wxdisploc = 0;       /* WILL XDISPLOC */
static int doxdisploc = 0;      /* DO XDISPLOC */

static int wiksflg = 0;     /* WILL IKS */
static int diksflg = 0;     /* DO IKS */

#ifndef TELCMDS
char *telcmds[] = {
    "EOF", "SUSP", "ABORT", "EOR", 
    "SE", "NOP", "DMARK", "BRK",  "IP",	  "AO", "AYT",	"EC",
    "EL", "GA",	 "SB",	  "WILL", "WONT", "DO", "DONT", "IAC"
};
int ntelcmds = sizeof(telcmds) / sizeof(char *);
#endif /* TELCMDS */

/* The following list is current as of Feb 1997 PROTOCOL STANDARDS RFC2200. */

char *tnopts[] = {
    "TRANSMIT-BINARY",			/* RFC 856 */
    "ECHO",				/* RFC 857 */
    "RECONNECTION",			/* NIC 50005 */
    "SUPPRESS-GO-AHEAD",		/* RFC 858 */
    "APPROX-MESSAGE-SIZE",		/* ETHERNET */
    "STATUS",				/* RFC 859 */
    "TIMING-MARK",			/* RFC 860 */
    "REMOTE-CONTROL-TRANS-ECHO",	/* RFC 726 */
    "OPTION-LINE-WIDTH",		/* NIC 50005 */
    "OPTION-PAGE-SIZE",			/* NIC 50005 */
    "OUTPUT-CR-DISPOSITION",		/* RFC 652 */
    "OUTPUT-HORIZ-TABSTOPS",		/* RFC 653 */
    "OUTPUT-HORIZ-TAB-DISPOSITION",	/* RFC 654 */
    "OUTPUT-FF-DISPOSITION",		/* RFC 655 */
    "OUTPUT-VERT-TABSTOPS",		/* RFC 666 */
    "OUTPUT-VERT-TAB-DISPOSITION",	/* RFC 667 */
    "OUTPUT-LF-DISPOSITION",		/* RFC 668 */
    "EXTENDED-ASCII",			/* RFC 698 */
    "LOGOUT",				/* RFC 727 */
    "BYTE-MACRO",			/* RFC 735 */
    "DATA-ENTRY-TERMINAL",		/* RFC 1043, RFC 732 */
    "SUPDUP",				/* RFC 736, RFC 734 */
    "SUPDUP-OUTPUT",			/* RFC 749 */
    "SEND-LOCATION",			/* RFC 779 */
    "TERMINAL-TYPE",			/* RFC 1091 */
    "END-OF-RECORD",			/* RFC 885 */
    "TACACS-UID",			/* RFC 927 */
    "OUTPUT-MARKING",			/* RFC 933 */
    "TERMINAL-LOCATION-NUMBER",		/* RFC 946 */
    "TELNET-3270-REGIME",		/* RFC 1041 */
    "X.3-PAD",				/* RFC 1053 */
    "NEGOTIATE-ABOUT-WINDOW-SIZE",	/* RFC 1073 */
    "TERMINAL-SPEED",			/* RFC 1079 */
    "REMOTE-FLOW-CONTROL",		/* RFC 1372 */
    "LINEMODE",				/* RFC 1184 */
    "X-DISPLAY-LOCATION",		/* RFC 1096 */
    "ENVIRONMENT",			/* RFC 1408 */
    "AUTHENTICATION",			/* RFC 1409 */
    "ENCRYPTION",			/* Borman */
    "NEW-ENVIRONMENT",			/* RFC 1572 */
    "TN3270E",				/* RFC 1647 */
    "XAUTH",                            /* Earhart */
    "CHARSET",				/* RFC 2066 */
    "REMOTE-SERIAL-PORT (RSP)",         /* Barnes */
    "COM-PORT-CONTROL",                  /* RFC 2217 */
#ifdef IKS_OPTION
    "NEGOTIATE-ABOUT-KERMIT-SERVER",    /* experimental */
#endif /* IKS_OPTION */
#ifdef COMMENT
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "UNKNOWN",
    "EXTENDED-OPTIONS-LIST"		/* 255, RFC 861 */
#endif /* COMMENT */
};

/*
   Telnet Authentication Types

   In [RFC1409], a list of authentication types is introduced.	Additions
   to the list are registerd by the IANA and documented here.

   Type	      Description		   Reference
     0	      NULL			   [RFC1409]
     1	      KERBEROS_V4		   [RFC1409]
     2	      KERBEROS_V5		   [RFC1409]
     3	      SPX			   [RFC1409]
     4-5      Unassigned
     6	      RSA			   [RFC1409]
     7-9      Unassigned
    10	      LOKI			   [RFC1409]
    11	      SSA			   [Schoch]
*/

/*
  In order to prevent an infinite telnet negotiation loop we maintain a
  count of the number of times the same telnet negotiation message is
  sent. When this count hits MAXTNCNT, we do not send any more of the
  message. The count is stored in the tncnts[][] array.
  
  The tncnts[][] array is indexed by negotiation option (SUPPRESS GO AHEAD,
  TERMINAL TYPE, NAWS, etc. - see the tnopts[] array) and the four
  negotiation message types (WILL, WONT, DO, DONT).  All telnet negotiations
  are kept track of in this way.

  The count for a message is zeroed when the "opposite" message is sent.
  WILL is the opposite of WONT, and DO is the opposite of DONT.
  For example sending "WILL SGA" increments tncnts[TELOPT_SGA][0]
  and zeroes tncnts[TELOPT_SGA][1].

  The code that does this is in tn_sopt().

  rogersh@fsj.co.jp, 18/3/1995
*/

#define MAXTNCNT 4	/* Permits 4 intermediate telnet firewalls/gateways */

char tncnts[sizeof(tnopts) / sizeof(char *)][4];	/* counts */
char tnopps[4] = { 1,0,3,2 };				/* opposites */

int ntnopts = sizeof(tnopts) / sizeof(char *);

#ifdef CK_ENVIRONMENT
#define TSBUFSIZ 1024
char tn_env_acct[64];
char tn_env_disp[64];
char tn_env_job[64];
char tn_env_prnt[64];
char tn_env_sys[64];
extern char uidbuf[];
#else /* CK_ENVIRONMENT */
#define TSBUFSIZ 41
#endif /* CK_ENVIRONMENT */
#endif /* TNCODE */

/* Send network BREAK */
/*
  Returns -1 on error, 0 if nothing happens, 1 if BREAK sent successfully.
*/
int
netbreak() {
    CHAR buf[3];
    if (ttnet == NET_TCPB) {
	if (ttnproto == NP_TELNET) {
#ifdef TNCODE
	    buf[0] = (CHAR) IAC; buf[1] = (CHAR) BREAK; buf[2] = (CHAR) 0;
	    if (
#ifdef OS2
		nettol((char *) buf, 2)
#else
		ttol(buf, 2)
#endif /* OS2 */
		< 2)
	      return(-1);
	    debug(F101,"telnet BREAK ok","",BREAK);
	    return(1);
#else
	    debug(F100,"netbreak no TNCODE","",0);
	    return(0);
#endif /* TNCODE */
	}
	/* Insert other TCP/IP protocols here */
    }
    /* Insert other networks here */
    return(0);
}

/* Send a telnet option, avoid loops. */
/* Returns 1 if command was sent, 0 if not, -1 on error */

int
tn_sopt(cmd,opt) int cmd, opt; {	/* TELNET SEND OPTION */
    CHAR buf[5];
    int n,m;

    if (ttnet != NET_TCPB) return(0);	/* Must be TCP/IP */
    if (ttnproto != NP_TELNET) return(0); /* Must be telnet protocol */
#ifdef TNCODE
    if (cmd == DO && opt == TELOPT_LOGOUT) /* Bad hack */
      dlogoutflg = 1;
    n = cmd - LAST_TN_CMD;
    m = cmd - WILL;
    if (n < 0 || n > ntelcmds) return(0);
    if (m >= 0 && m < 4 && opt < ntnopts) {	/* See comment above about   */
	if (tncnts[opt][m] > MAXTNCNT) {	/* preventing infinite loops */
	    if (debses || deblog) {
		sprintf(tn_msg,"TELNET negotiation loop %s %s",telcmds[n],
			tnopts[opt]);
		debug(F101,tn_msg,"",opt);
		if (debses) tn_debug(tn_msg);
	    }
	    return(0);
	}
	tncnts[opt][m]++;
	tncnts[opt][tnopps[m]] = 0;
    }
    buf[0] = (CHAR) IAC;
    buf[1] = (CHAR) (cmd & 0xff);
    buf[2] = (CHAR) (opt & 0xff);
    buf[3] = (CHAR) 0;
    if ((debses || deblog) && cmd != SB) {
	sprintf(tn_msg,"TELNET SENT %s %s",telcmds[n],
		(opt < ntnopts) ? tnopts[opt] : "UNKNOWN");
	debug(F101,tn_msg,"",opt);
	if (debses) tn_debug(tn_msg);
    }
    if (ttol(buf,3) < 3)
      return(-1);
    return(1);
#else
    debug(F100,"tn_sopt no TNCODE","",0);
    return(0);
#endif /* TNCODE */
}

/* Initialize a telnet connection. */
/* Returns -1 on error, 0 if nothing happens, 1 if init msgs sent ok */

int
tn_ini() {
    int x,i,j;
#ifndef TNCODE
    debug(F100,"tn_ini no TNCODE","",0);
    return(0);
#else /* TELNET protocol support */
    debug(F101,"tn_ini ttnproto","",ttnproto);
    debug(F101,"tn_ini tn_init","",tn_init);

    if (ttnet != NET_TCPB)		/* Make sure connection is TCP/IP */
      return(0);
    if (ttnproto == NP_RLOGIN)          /* Reset flags even when RLOGIN */
      return(0);
    if (tn_init)			/* Have we done this already? */
      return(0);			/* Don't do it again. */

    /* Reset the TELNET OPTIONS counts */
    for (i = 0; i < sizeof(tnopts) / sizeof(char *); i++)
	for (j = 0; j < 4; j ++)
	    tncnts[i][j] = 0;
    debug(F101,"tn_ini tn_duplex","",tn_duplex);

    duplex = tn_duplex;			/* Assume local echo. */
    sgaflg = 0;				/* Assume Go-Ahead suppressed. */
    nawsflg = 0;			/* Assume NAWS should not be sent. */
    nenvflg = 0;			/* Assume NEW-ENV should not be sent */
    ttyflg = 0;				/* Assume TTYPE should not be sent */
    dosndloc = 0;			/* Reset all other flags too... */
    nsndloc = 0;
    wnawsflg = 0;
    wmebinflg = 0;
    dubinflg = 0;
    wnenvflg = 0;
    nenvflg = 0;
    wauthflg = 0;
    wencryptflg = 0;
    dencryptflg = 0;
    dlogoutflg = 0;
    wxdisploc = 0;
    doxdisploc = 0;
    me_binary = 0;			/* We are not in binary mode */
    u_binary = 0;
#ifdef CK_AUTHENTICATION
    me_auth = 0;                        /* Not in Auth mode */
#endif /* CK_AUTHENTICATION */
#ifdef CK_ENCRYPTION
    me_encrypt = 0;                     /* Not in Encrypt mode */
    u_encrypt = 0;
#endif /* CK_AUTHENTICATION */
#ifdef IKS_OPTION
    me_iks = u_iks = me_iks_start = u_iks_start = 0;
#endif /* IKS_OPTION */

#ifdef OS2
    ttnum = -1;                         /* Reset TermType negotiation */
    ttnumend = 0;
#endif /* OS2 */
    
    if (ttnproto == NP_NONE) {		/* If not talking to a telnet port, */
        ttnproto = NP_TELNET;		/* pretend it's telnet anyway, */
	tn_init = 1;			/* but don't send initial options. */
	debug(F100,"tn_ini skipping telnet negotiations","",0);
	return(0);
    } else if (ttnproto == NP_TCPRAW)	/* Raw socket requested. */
      return(0);

    debug(F100,"tn_ini about to send WILL TTYPE","",0);
/* 
  Talking to TELNET port, so send WILL TERMINAL TYPE and DO SGA.
  Also send WILL NAWS if we know our screen dimensions.
*/
    if ((x = tn_sopt(WILL,TELOPT_TTYPE)) < 0) { /* Will send terminal type. */
	debug(F101,"tn_ini tn_sopt WILL TTYPE failed","",x);
	return(-1);
    }
    debug(F100,"tn_ini sent WILL TTYPE ok","",0);
    ttyflg = 1;				/* Remember I said I would. */
#ifdef CK_NAWS
    /* Console terminal screen rows and columns */
#ifdef OS2
    debug(F101,"tn_ini tt_rows 1","",VscrnGetHeight(VTERM)-(tt_status?1:0));
    debug(F101,"tn_ini tt_cols 1","",VscrnGetWidth(VTERM));
    /* Not known yet */
    if (VscrnGetWidth(VTERM) < 0 ||
	VscrnGetHeight(VTERM)-(tt_status?1:0) < 0) {
	ttgwsiz();			/* Try to find out */
    }
    debug(F101,"tn_ini tt_rows 2","",VscrnGetHeight(VTERM)-(tt_status?1:0));
    debug(F101,"tn_ini tt_cols 2","",VscrnGetWidth(VTERM));
    /* Now do we know? */
    if (VscrnGetWidth(VTERM) > 0 &&
	VscrnGetHeight(VTERM)-(tt_status?1:0) > 0) {
	if (tn_sopt(WILL, TELOPT_NAWS) < 0)
	  return(-1);
	wnawsflg = 1;			/* OK, we sent an initial WILL NAWS. */
    }
#else /* OS2 */
    debug(F101,"tn_ini tt_rows 1","",tt_rows);
    debug(F101,"tn_ini tt_cols 1","",tt_cols);
    if (tt_rows < 0 || tt_cols < 0) {	/* Not known yet */
	ttgwsiz();			/* Try to find out */
    }
    debug(F101,"tn_ini tt_rows 2","",tt_rows);
    debug(F101,"tn_ini tt_cols 2","",tt_cols);
    if (tt_rows > 0 && tt_cols > 0) {	/* Now do we know? */
	if (tn_sopt(WILL, TELOPT_NAWS) < 0)
	  return(-1);
	wnawsflg = 1;			/* Ok, we sent an initial WILL NAWS. */
    }
#endif /* OS2 */
#endif /* CK_NAWS */

#ifdef CK_AUTHENTICATION
    if (tn_auth == TN_NG_RQ || tn_auth == TN_NG_MU) {
	if (tn_sopt(WILL, TELOPT_AUTHENTICATION) < 0)
	  return(-1);
	wauthflg = 1;			/* We sent an initial WILL AUTH. */
    }
    me_auth = 0;
#endif /* CK_AUTHENTICATION */
#ifdef CK_ENCRYPTION
    if (tn_encrypt == TN_NG_RQ || tn_encrypt == TN_NG_MU) {
	if (tn_sopt(WILL, TELOPT_ENCRYPTION) < 0)
	  return(-1);
	wencryptflg = 1;		/* We sent an initial WILL ENCRYPT. */
	if (tn_sopt(DO, TELOPT_ENCRYPTION) < 0)
	  return(-1);
	dencryptflg = 1;		/* We sent an initial DO ENCRYPT. */
    }
    me_encrypt = 0;
    u_encrypt = 0;
#endif /* CK_AUTHENTICATION */
#ifdef IKS_OPTION
    if (tn_iks == TN_NG_RQ || tn_iks == TN_NG_MU) {
	if (tn_sopt(WILL, TELOPT_IKS) < 0)
	  return(-1);
	wiksflg = 1;		/* We sent an initial WILL ENCRYPT. */
	if (tn_sopt(DO, TELOPT_IKS) < 0)
	  return(-1);
	diksflg = 1;		/* We sent an initial DO ENCRYPT. */
    }
    me_iks = 0;
    u_iks = 0;
#endif /* IKS_OPTION */
    if (tn_binary == TN_NG_RQ || tn_binary == TN_NG_MU) {
	if (tn_sopt(WILL, TELOPT_BINARY) < 0)
	  return(-1);
	wmebinflg = 1;			/* We sent an initial WILL BINARY. */
	if (tn_sopt(DO, TELOPT_BINARY) < 0)
	  return(-1);
	dubinflg = 1;			/* We sent an initial DO BINARY. */
    }
    me_binary = 0;			/* We are not in binary mode */
    u_binary = 0;

#ifdef CK_ENVIRONMENT
    /* Will send terminal environment. */
    if (tn_env_flg) {
	if ((x = tn_sopt(WILL, TELOPT_NEWENVIRON)) < 0) {
	    debug(F101,"tn_ini tn_sopt WILL NEWENVIRON failed","",x);
	    return(-1);
	}
	debug(F100,"tn_ini sent WILL NEWENVIRON ok","",tn_env_flg);
	wnenvflg = 1;			/* We sent an initial WILL NEW-ENV */
    }
#endif /* CK_ENVIRONMENT */

#ifdef CK_SNDLOC
    /* RFC 779 says to send this up front */
    nsndloc = 0;			/* Reset from earlier connections */
    dosndloc = 0;
    if (tn_loc) {
	if ((x = tn_sopt(WILL, TELOPT_SNDLOC)) < 0) {
	    debug(F101,"tn_ini tn_sopt WILL SNDLOC failed","",x);
	    return(-1);
	}
	dosndloc = 1;			/* Remember I said I will */
    }
#endif /* CK_SNDLOC */

#ifdef CK_ENVIRONMENT
#ifdef CK_XDISPLOC
    doxdisploc = 0;
    wxdisploc  = 0;
    if (tn_xdisploc /* || tn_env_disp[0] */ ) {
	if ((x = tn_sopt(WILL, TELOPT_XDISPLOC)) < 0) {
	    debug(F101,"tn_ini tn_sopt WILL XDISPLOC failed","",x);
	    return(-1);
	}
	wxdisploc = 1;			/* Remember I said I will */
    }
#endif /* CK_XDISPLOC */
#endif /* CK_ENVIRONMENT */

    if (tn_sopt(DO,TELOPT_SGA) < 0)	/* Please suppress go-ahead. */
      return(-1);

    tn_init = 1;			/* Set telnet-initialized flag. */

    /* Don't send anthing else! */

    debug(F101,"tn_ini duplex","",duplex);
    debug(F101,"tn_ini done, tn_init","",tn_init);
    return(1);
#endif /* TNCODE */
}

VOID
tn_debug(s) char *s; {
#ifdef OS2
    void cwrite(unsigned short);
    char *p = s;
    _PROTOTYP (void os2bold, (void));
#endif /* OS2 */

#ifdef OS2
    debug(F111,"tn_debug",s,0);
    if (debses == 0) /* Emulator is always active in OS/2 */
      return;

    if (!scrninitialized[VTERM]) {
	USHORT x,y;
	checkscreenmode();
	GetCurPos(&y, &x);
	SaveCmdMode(x+1,y+1);
	scrninit();
	RestoreCmdMode();
    }
    os2bold();				/* Toggle boldness */
    while (*p) 
      cwrite((CHAR) *p++);		/* Go boldly ... */
    os2bold();				/* Toggle boldness back */
    debses = 0;
    cwrite((CHAR) '\015');
    cwrite((CHAR) '\012');
    debses = 1;
#else
    debug(F111,"tn_debug",s,what);
    if (what != W_CONNECT || debses == 0) /* CONNECT command must be active */
      return;
    conoll(s);
#endif /* OS2 */
}

/*
  Process in-band Telnet negotiation characters from the remote host.
  Call with the telnet IAC character and the current duplex setting
  (0 = remote echo, 1 = local echo), and a pointer to a function to call
  to read more characters.  Returns:
    3 if server has sent us a quoted IAC
    2 if local echo must be changed to remote
    1 if remote echo must be changed to local
    0 if nothing happens or no action necessary
   -1 on failure (= internal or i/o error)
*/

#ifdef IKS_OPTION
int
tn_siks(cmd) int cmd; {	        /* TELNET SEND IKS SUB */
    CHAR buf[8];
    int n,m;

    if (ttnet != NET_TCPB) return(0);	/* Must be TCP/IP */
    if (ttnproto != NP_TELNET) return(0); /* Must be telnet protocol */
#ifdef TNCODE
    if ( cmd == 0 || cmd == 1 )
        me_iks_start = !cmd;

    buf[0] = (CHAR) IAC;
    buf[1] = (CHAR) SB;
    buf[2] = (CHAR) TELOPT_IKS;
    buf[3] = (CHAR) (cmd & 0xff);
    buf[4] = (CHAR) IAC;
    buf[5] = (CHAR) SE;
    buf[6] = (CHAR) 0;
    if (debses || deblog) {
        char * s = 0;
        switch ( cmd ) {
	  case 0: s = "START-KERMIT-SERVER"; break;
	  case 1: s = "STOP-KERMIT-SERVER"; break;
	  case 2: s = "REQ-START-KERMIT-SERVER"; break;
	  case 3: s = "REQ-STOP-KERMIT-SERVER"; break;
        }
	sprintf(tn_msg,
		"TELNET SENT SB NEGOTIATE-ABOUT-KERMIT-SERVER %s IAC SE",
		s
		);
	debug(F101,tn_msg,"",cmd);
	if (debses) tn_debug(tn_msg);
    }
    if (ttol(buf,6) < 6)
      return(-1);
    return(1);
#else
    debug(F100,"tn_siks no TNCODE","",0);
    return(0);
#endif /* TNCODE */
}
#endif /* IKS */

unsigned char sb[TSBUFSIZ+8];		/* Buffer for subnegotiations */

/* tn_sb() performs Telnet Subnegotiation Parsing and Debugging */
/* returns <= 0 on error, 1 on success */

int
#ifdef CK_ANSIC                         /* TELNET SB */
tn_sb( int opt, int * len, int (*fn)(int) ) 
#else 
tn_sb( opt, len, fn ) int opt; int * len; int (*fn)();
#endif /* CK_ANSIC */
/* tn_sb */ {
    int c, x, y, n, m, flag;
    *len = 0;                   /* Initialize Len to 0 */
    n = flag = 0;		/* Flag for when done reading SB */
    while (n < TSBUFSIZ) {	/* Loop looking for IAC SE */
        if ((y = (*fn)(0)) < 0)	/* Read a byte */
            return(y);
        y &= 0xff;		/* Make sure it's just 8 bits. */
        sb[n++] = (char) y;	/* Deposit in buffer. */
        if (seslog && sessft)	/* Take care of session log */
            if (zchout(ZSFILE, (char) y) < 0)
                seslog = 0;
        if (y == IAC) {		/* If this is an IAC */
            if (flag) {		/* If previous char was IAC */
                n--;		/* it's quoted, keep one IAC */
                flag = 0;	/* and turn off the flag. */
            } else flag = 1;	/* Otherwise set the flag. */
        } else if (flag) {	/* Something else following IAC */
            if (y == SE)	/* If not SE, it's a protocol error */
                break;
            else if ( y == DONT ) { /* Used DONT instead of SE */
                debug(F100,
                    "TELNET Subnegotiation error - used DONT instead of SE!",
                       "",0);
                if (debses)
                    tn_debug(
"TELNET Subnegotiation error - used DONT instead of SE!");
			flag = 3;
			break;
            } else {		/* Other protocol error */
                flag = 0;
                break;
            }
        } 
#ifndef CK_ENCRYPTION
        /* This test is sure to be triggered when we are using encryption */
        /* Therefore, we must take it out, otherwise, our subnegotiations */
        /* will be truncated and failure will result.                     */
        /* This bug was only seen on BeOS DR7 and has been fixed.         */
        else if (!flag && y == SE) { /* Forgot the IAC ? */
            flag = 2;
            debug(F100,
                   "TELNET Subnegotiation error - forgot the IAC before SE!",
                   "",0);
            if (debses)
                tn_debug(
"TELNET Subnegotiation error - forgot the IAC before SE!");
            break;
        }
#endif /* CK_ENCRYPTION */
    }
    if (!flag) {		/* Make sure we got a valid SB */
        debug(F100, "TELNET Subnegotiation prematurely broken", "",0);
        if (debses) 
            tn_debug("TELNET Subnegotiation prematurely broken");
        return(0);	/* Was -1 but that would be taken as */
        /* an I/O error, so absorb it and go on. */
    }
    if (deblog || debses) {
        int i;
        char * s[16];
        s[0] = "UNKNOWN";
        for ( i=1;i<16;i++ )
            s[i] = "";
        i = 1;

        switch (sb[0]) {
	  case 0:
#ifdef IKS_OPTION
            if (opt == TELOPT_IKS)
	      s[0] = "START";
            else
#endif /* IKS_OPTION */
	      s[0] = "IS";
#ifdef CK_ENCRYPTION
            if (opt == TELOPT_ENCRYPTION) {
                i++;
                if ( sb[1] < ENCTYPE_CNT ) {
                    s[1] = enctype_names[sb[1]];
                    switch(sb[2]) {
                    case 1:
                        s[2] = "FB64_IV";
                        break;
                    case 2:
                        s[2] = "FB64_IV_OK";
                        break;
                    case 3:
                        s[2] = "FB64_IV_BAD";
                        break;
                    case 4:
                        s[2] = "FB64_CHALLENGE";
                        break;
                    case 5:
                        s[2] = "FB64_RESPONSE";
                        break;
                    }
                } else {
                    s[0] = "UNKNOWN";
                }
            }
#endif /* CK_ENCRYPTION */
            break;
	  case 1:
            switch (opt) {
#ifdef IKS_OPTION
	      case TELOPT_IKS:
                s[0] = "STOP";
                break;
#endif /* IKS_OPTION */
	      case TELOPT_AUTHENTICATION:
#ifdef CK_AUTHENTICATION
                s[0] = "SEND";
                hexbuf[0] = '\0';
                for ( ; i < n-2; i += 2 ) {
                    sprintf(tn_msg,"%s %s ", authtype_names[sb[i]], 
			    authmode_names[sb[i+1]]);
                    strcat(hexbuf,tn_msg);
                }
                s[1] = hexbuf;
#endif /* CK_AUTHENTICATION */
                break;

	      case TELOPT_ENCRYPTION:
#ifdef CK_ENCRYPTION
                s[0] = "SUPPORT";
                while (i < n-2) {
                    s[i] = enctype_names[sb[i]];
                    i++;
                }
#endif /* CK_ENCRYPTION */
                break;

	      default:
                s[0] = "SEND";
            }
            break;

	  case 2:
            switch (opt) {
#ifdef IKS_OPTION
	      case TELOPT_IKS:
                s[0] = "REQ-START";
                break;
#endif /* IKS_OPTION */
	      case TELOPT_NEWENVIRON:
                s[0] = "INFO";
                break;
	      case TELOPT_AUTHENTICATION:
                s[0] = "REPLY";
                i=4;
#ifdef CK_AUTHENTICATION
                s[1] = authtype_names[sb[1]];
                s[2] = authmode_names[sb[2]];
#else
		s[1] = "<AUTH_TYPE>";
		s[2] = "<AUTH_MODE>";
#endif /* CK_AUTHENTICATION */
                switch (sb[3]) {
		  case 0:
                    s[3] = "AUTH";
                    break;
		  case 1:
                    s[3] = "REJECT";
                    break;
		  case 2:
                    s[3] = "ACCEPT";
                    break;
		  case 3:
                    switch (sb[1]) {
		      case 1: /* KERBEROS_v4 */
		      case 5: /* SRP */
                        s[3] = "CHALLENGE";
                        break;  
		      case 2: /* KERBEROS_v5 */
                        s[3] = "RESPONSE";
                        break;  
                    }
                    break;
		  case 4:
                    switch (sb[1]) {
		      case 1: /* KERBEROS_V4 */
		      case 5: /* SRP */
                        s[3] = "RESPONSE";
                        break;  
		      case 2: /* KERBEROS_V5 */
                        s[3] = "FORWARD";
                        break;  
                    }
                    break;
		  case 5:
		    switch (sb[1]) {
		      case 5: /* SRP */
			s[3] = "FORWARD";
			break;  
		      case 2: /* KERBEROS_V5 */
			s[3] = "FORWARD_ACCEPT";
			break;  
		    }
		    break;
		  case 6:
		    switch (sb[1]) {
		      case 5: /* SRP */
			s[3] = "FORWARD_ACCEPT";
			break;  
		      case 2: /* KERBEROS_V5 */
			s[3] = "FORWARD_REJECT";
			break;  
		    }
		    break;
                  case 7:
		    switch (sb[1]) {
		      case 5: /* SRP */
			s[3] = "FORWARD_REJECT";
			break;  
		    }
		    break;
		  case 8:
		    switch ( sb[1] ) {
		      case 5: /* SRP */
			s[3] = "EXP";
			break;  
		    }
		    break;
		  case 9:
		    switch (sb[1]) {
		      case 5: /* SRP */
			s[3] = "PARAMS";
			break;  
		    }
		    break;
                }
                break;
	      case TELOPT_ENCRYPTION:
                s[0] = "REPLY";
#ifdef CK_ENCRYPTION
                s[1] = enctype_names[sb[1]];
#else /* CK_ENCRYPTION */
                s[1] = "<ENCRYPT_TYPE>";
#endif /* CK_ENCRYPTION */
                i++;
                switch (sb[2]) {
		  case 1:
                    i++;
                    s[2] = "FB64_IV";
                    break;
		  case 2:
                    i++;
                    s[2] = "FB64_IV_OK";
                    break;
		  case 3:
                    i++;
                    s[2] = "FB64_IV_BAD";
                    break;
		  case 4:
                    i++;
                    s[2] = "FB64_CHALLENGE";
                    break;
		  case 5:
                    i++;
                    s[2] = "FB64_RESPONSE";
                    break;
                }
                break;
            }
            break;
	  case 3:
            switch (opt) {
#ifdef IKS_OPTION
	      case TELOPT_IKS:
                s[0] = "REQ-STOP";
                break;
#endif /* IKS_OPTION */
	      case TELOPT_AUTHENTICATION:
                s[0] = "NAME";
                break;
	      case TELOPT_ENCRYPTION:
                s[0] = "START";
                break;
            }
            break;
	  case 4:
            switch (opt) {
	      case TELOPT_ENCRYPTION:
                s[0] = "END";
                break;
            }
            break;
	  case 5:
            switch (opt) {
	      case TELOPT_ENCRYPTION:
                s[0] = "REQUEST-START";
                break;
            }
            break;
	  case 6:
            switch (opt) {
	      case TELOPT_ENCRYPTION:
                s[0] = "REQUEST-END";
                break;
            }
            break;
	  case 7:
            switch (opt) {
	      case TELOPT_ENCRYPTION:
                s[0] = "ENC-KEYID";
                break;
            }
            break;
	  case 8:
            switch (opt) {
	      case TELOPT_ENCRYPTION:
                s[0] = "DEC-KEYID";
                break;
            }
            break;
        }
        sprintf(tn_msg,
                 "TELNET RCVD SB \
%s %s %s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s%s",
		tnopts[opt],s[0],
		 s[ 1], s[ 1][0]?" ":"",
                 s[ 2], s[ 2][0]?" ":"",
                 s[ 3], s[ 3][0]?" ":"",
                 s[ 4], s[ 4][0]?" ":"",
                 s[ 5], s[ 5][0]?" ":"",
                 s[ 6], s[ 6][0]?" ":"",
                 s[ 7], s[ 7][0]?" ":"",
                 s[ 8], s[ 8][0]?" ":"",
                 s[ 9], s[ 9][0]?" ":"",
                 s[10], s[10][0]?" ":"",
                 s[11], s[11][0]?" ":"",
                 s[12], s[12][0]?" ":"",
                 s[13], s[13][0]?" ":"",
                 s[14], s[14][0]?" ":"",
                 s[15], s[15][0]?" ":"");
#ifdef HEXDISP
        {
            int was_hex = 1;
            for (; i < n-2; i++) {
                if ( sb[i] < 32 || sb[i] >= 127) {
                    sprintf(hexbuf,"%s%02X ",was_hex?"":"\" ",sb[i]);
                    was_hex = 1;
                } else {
                    sprintf(hexbuf,"%s%c",was_hex?"\"":"",sb[i]);
                    was_hex = 0;
                }
                strcat(tn_msg,hexbuf);
            }
            if ( !was_hex )
                strcat(tn_msg,"\" ");
        }
#else /* HEXDISP */
        memcpy(hexbuf,&sb[i],n-i-2);
        hexbuf[n-i-2] = ' ';
        hexbuf[n-i-1] = '\0';
        strcat(tn_msg,hexbuf);
#endif /* HEXDISP */
        if (flag == 2)
            strcat(tn_msg," SE");
        else if (flag == 3)
            strcat(tn_msg," IAC DONT");
        else 
            strcat(tn_msg," IAC SE");
        debug(F100,tn_msg,"",0);
        if (debses) tn_debug(tn_msg);
    }
#ifdef CK_ENCRYPTION
    /* We need to put a call in here to decrypt the sub negotiation */
    /* under certain circumstances.  decrypt_ks_hack()              */
#endif /* CK_ENCRYPTION */

    *len = n;           /* return length */
    return(1);          /* success */
}       

int
#ifdef CK_ANSIC				/* TELNET DO OPTION */
tn_doop(CHAR z, int echo, int (*fn)(int))
#else
tn_doop(z, echo, fn) CHAR z; int echo; int (*fn)();
#endif /* CK_ANSIC */
/* tn_doop */ {
    int c, x, y, n, m, flag;
#ifdef IKS_OPTION
    extern int server;
#ifdef CK_AUTODL
    extern int autodl, inautodl;
#endif /* CK_AUTODL */
#endif /* IKS_OPTION */

#ifndef TNCODE
    debug(F100,"tn_doop no TNCODE","",0);
    return(0);
#else
    if (z != (CHAR) IAC) {
	debug(F101,"tn_doop bad call","",z);
	return(-1);
    }
    if (ttnet != NET_TCPB)		/* Check network type */
      return(0);
    if (ttnproto != NP_TELNET &&
         ttnproto != NP_NONE)		/* Check protocol */
      return(0);

/* Have IAC, read command character. */

    c = (*fn)(0) & 0xff;		/* Read command character */
    m = c - LAST_TN_CMD; 		/* Check validity */
    if (m < 0 || m > ntelcmds) {
	debug(F101,"tn_doop bad cmd","",c);
	return(0);
    }
    if (ttnproto == NP_NONE) {
        debug(F100,"tn_doop discovered a Telnet command",
	      "ttnproto = NP_TELNET",0);
        ttnproto = NP_TELNET;
    }
    if (seslog && sessft) {		/* Copy to session log, if any. */
	if (zchout(ZSFILE, (char) z) < 0) /* Log IAC. */
	  seslog = 0;
	else if (zchout(ZSFILE, (char) c) < 0) /* Log command */
	  seslog = 0;
    }
    if (c == (CHAR) IAC)		/* Quoted IAC */
      return(3);
    if (c < SB)	{			/* Other command with no arguments. */
        switch (c) {			/* What we would like to do here    */
	  case TN_GA:			/* Is substitute ASCII characters   */
            break;                      /* for the Telnet Command so that   */
	  case TN_EL:			/* the command may be processed by  */
            break;                      /* either the internal emulator or  */
	  case TN_EC:			/* by the superior process or shell */
            break;
	  case TN_AYT:
            ttol((CHAR *)"[Yes]\0x0D\0x0A",7);
            break;
	  case TN_AO:
#ifdef BETATEST
	    bleep(BP_NOTE);
#endif /* BETATEST */
            break;
	  case TN_IP:
            break;
	  case BREAK:
            break;
	  case TN_DM:
            break;
	  case TN_NOP:
            break;
	  case SE:
            break;
	  case TN_EOR:
            break;
	  case TN_ABORT:
            break;
	  case TN_SUSP:
            break;
	  case TN_EOF:
            break;
        }
        return(0);
    }

/* SB, WILL, WONT, DO, or DONT need more bytes... */

    if ((x = (*fn)(0)) < 0)		/* Get the option. */
      return(-1);
    x &= 0xff;				/* Trim to 8 bits. */

    if (seslog && sessft)		/* Session log */
      if (zchout(ZSFILE, (char) x) < 0)
	seslog = 0;

    if ((deblog || debses) && c != SB) {
	sprintf(tn_msg,"TELNET RCVD %s %s",telcmds[m],
		(x < ntnopts) ? tnopts[x] : "UNKNOWN");
	debug(F101,tn_msg,"",x);
	if (debses) tn_debug(tn_msg);
    }

    /* Now handle the command */

    switch (x) {
#ifdef CK_AUTHENTICATION
      case TELOPT_AUTHENTICATION:	/* TELNET AUTHENTICATION mode. */
	switch (c) {			/* Command... */
	  case WILL:                    
            if (tn_sopt(DONT,x) < 0)    /* we can't authenticate host */
	      return(-1);
            else 
	      return(0);
	  case WONT:
            return(0);                  /* we would never ask it to */
	  case DO:
	    if (tn_auth == TN_NG_RF) {
		if (tn_sopt(WONT,x) < 0) 
		  return (-1);
		else
		  return (0);
	    } else if (!me_auth) {
		if (!wauthflg) {	/* Reply only if we did not initiate */
		    if (tn_sopt(WILL,x) < 0)   
		      return -1;
		} else {
		    wauthflg = 0;
		}
		me_auth = 1;
	    }
	    return(0);
	  case DONT:
            if (tn_auth == TN_NG_MU) {
                printf("Host refuses to Authenticate.\n");
                ttclos(0);
                return(-1);
            }
	    if (me_auth) {
		me_auth = 0;
		if (tn_sopt(WONT,x) < 0) 
		  return(-1);
		else
		  return(0);
	    } else
	      return(0);
	  case SB:			/* Subnegotiation */
            if ((y = tn_sb(x,&n,fn)) <= 0)
	      return(y);
              if (ck_krb_tn_sb_auth(sb,n) < 0) {
                  if (tn_auth == TN_NG_MU) {
                      printf("Authentication failed.\n");
                      ttclos(0);
                      return(-1);
                  }
                  me_auth = 0;
                  if (tn_sopt(WONT,x) < 0)
                      return(-1);
#ifdef CK_ENCRYPTION 
                  if (me_encrypt || wencryptflg) {
                      me_encrypt = 0;
                      if (tn_sopt(WONT,TELOPT_ENCRYPTION) < 0)
                          return(-1);
                  }
                  if (u_encrypt || dencryptflg ) {
                      u_encrypt = 0;
                      if (tn_sopt(DONT,TELOPT_ENCRYPTION) < 0)
                          return(-1);
                  }
#endif /* CK_ENCRYPTION */
              }
            return(0);
	  default:
	    return(0);
	}
#endif /* CK_AUTHENTICATION */
#ifdef CK_ENCRYPTION
      case TELOPT_ENCRYPTION:		/* TELNET ENCRYPTION mode. */
	switch (c) {			/* Command... */
	  case WILL:
	    if (tn_encrypt == TN_NG_RF) { /* If encrypt mode disabled */
		if (tn_sopt(DONT,x) < 0) 
		  return(-1);
		else 
		  return(0);
	    } else if (!u_encrypt) {
		if (!dencryptflg) {	/* Reply only if we did not initiate */
		    if (tn_sopt(DO,x) < 0)   
		      return -1;
		} else {
		    dencryptflg = 0;
		}
		u_encrypt = 1;

                /* Perform subnegotiation */
                ck_encrypt_send_support(); 
                if (!me_encrypt && !wencryptflg) {
                    if (tn_sopt(WILL, x) < 0)
		      return(-1);
                    wencryptflg = 1;	/* We sent an initial WILL ENCRYPT. */
                }
	    }
	    return(0);
	  case WONT:
	    if (tn_encrypt == TN_NG_MU) {
		printf("Host refuses to Encrypt\n");
		ttclos(0);
		return(-1);
	    }
	    if (u_encrypt) {
		u_encrypt = 0;
		if (tn_sopt(DONT,x) < 0) 
		  return (-1);
		else
		  return(0);
	    } else return(0);
	  case DO:
	    if (tn_encrypt == TN_NG_RF) {
		if (tn_sopt(WONT,x) < 0) 
		  return (-1);
		else
		  return (0);
	    } else if (!me_encrypt) {
		if (!wencryptflg) {	/* Reply only if we did not initiate */
		    if (tn_sopt(WILL,x) < 0)   
		      return -1;
		} else {
		    wencryptflg = 0;
		}
		me_encrypt = 1;
                if (!u_encrypt && !dencryptflg) {
                    if (tn_sopt(DO, x) < 0)
		      return(-1);
                    dencryptflg = 1;/* We sent an initial DO ENCRYPT. */
                }
	    }
	    return(0);
	  case DONT:
	    if (tn_encrypt == TN_NG_MU) {
		printf("Host refuses Encryption\n");
		ttclos(0);
		return(-1);
	    }
	    if (me_encrypt) {
		me_encrypt = 0;
		if (tn_sopt(WONT,x) < 0) 
		  return(-1);
		else
		  return(0);
	    } else
	      return(0);
	  case SB:			/* Subnegotiation */
	    if ((y = tn_sb(x,&n,fn)) <= 0)
	      return(y);
            ck_krb_tn_sb_encrypt( sb, n );
	    return(0);
	  default:
	    return(0);
	}
#endif /* CK_ENCRYPTION */

#ifdef IKS_OPTION
      case TELOPT_IKS:    		/* TELNET IKS mode. */
	switch (c) {			/* Command... */
	  case WILL:
	    if (tn_iks == TN_NG_RF) {	/* If IKS disabled */
		if (tn_sopt(DONT,x) < 0) 
		  return(-1);
		else 
		  return(0);
	    } else if (!u_iks) {
		if (!diksflg) {		/* Reply only if we did not initiate */
		    if (tn_sopt(DO,x) < 0)   
		      return -1;
		} else {
		    diksflg = 0;
		}
		u_iks = 1;
                if (!me_iks && !wiksflg) {
                    if (tn_sopt(WILL, x) < 0)
		      return(-1);
                    wiksflg = 1;	/* We sent an initial WILL IKS. */
                }
	    }
	    return(0);
	  case WONT:
	    if (tn_iks == TN_NG_MU) {
		printf("Host refuses to negotiate Kermit-Server option.\n");
		ttclos(0);
		return(-1);
	    }
	    if (u_iks) {
		u_iks = 0;
		if (tn_sopt(DONT,x) < 0) 
		  return (-1);
		else
		  return(0);
	    } else
	      return(0);
	  case DO:
	    if (tn_iks == TN_NG_RF) {
		if (tn_sopt(WONT,x) < 0) 
		  return (-1);
		else
		  return(0);
	    } else if (!me_iks) {
		if (!wiksflg) {		/* Reply only if we did not initiate */
		    if (tn_sopt(WILL,x) < 0)   
		      return -1;
		} else {
		    wiksflg = 0;
		}
		me_iks = 1;
                if (!u_iks && !diksflg) {
                    if (tn_sopt(DO, x) < 0)
		      return(-1);
                    diksflg = 1;	/* We sent an initial DO IKS. */
                }

/* If currently processing Kermit server packets, must tell the other side */ 

#ifdef CK_AUTODL
                if (server || (what == W_CONNECT && autodl) ||
		    (what != W_CONNECT && inautodl))
		  tn_siks(0);		/* START */
#endif /* CK_AUTODL */
	    }
	    return(0);
	  case DONT:
	    if (tn_iks == TN_NG_MU) {
		printf("Host refuses Kermit Server negotiations.\n");
		ttclos(0);
		return(-1);
	    }
	    if (me_iks) {
		me_iks = 0;
		if (tn_sopt(WONT,x) < 0) 
		  return(-1);
		else
		  return(0);
	    } else
	      return(0);
	  case SB:			/* Subnegotiation */
	    if ((y = tn_sb(x,&n,fn)) <= 0)
	      return(y);
	    switch (sb[0]) {
              case 0:			/* START */
		u_iks_start = 1;
		break;
              case 1:			/* STOP */
		u_iks_start = 0;
		break;
              case 2:			/* REQ-START */
              case 3:			/* REQ-STOP */
                  /* The protocol requires that the request be responded to */
                  /* either by changing states or by reporting the current  */
                  /* state.  So for now we will report the current state.   */
#ifdef CK_AUTODL
		if (server || (what == W_CONNECT && autodl) ||
		    (what != W_CONNECT && inautodl))
		  tn_siks(0);		/* START */
		else
#endif /* CK_AUTODL */
		  tn_siks(1);		/* STOP */
		break;
	    }
            return(0);
	  default:
	    return(0);
	}
#endif /* IKS_OPTION */

      case TELOPT_BINARY:		/* TELNET BINARY mode. */
	switch (c) {			/* Command... */
	  case WILL:
	    if (tn_binary == TN_NG_RF) { /* If binary mode disabled */
		if (tn_sopt(DONT,x) < 0) 
		  return(-1);
		else 
		  return(0);
	    } else if (!u_binary) {
		if (!dubinflg) {	/* Reply only if we did not initiate */
		    if (tn_sopt(DO,x) < 0)   
		      return -1;
		} else {
		    dubinflg = 0;
		}
		u_binary = 1;
	    }
	    return(0);
	  case WONT:
	    if (tn_binary == TN_NG_MU) {
		printf("Host refuses to use Binary Mode\n");
		ttclos(0);
		return(-1);
	    }
	    if (u_binary) {
		u_binary = 0;
		if (tn_sopt(DONT,x) < 0) 
		  return (-1);
		else
		  return(0);
	    } else return(0);
	  case DO:
	    if (tn_binary == TN_NG_RF) {
		if (tn_sopt(WONT,x) < 0) 
		  return (-1);
		else
		  return (0);
	    } else if (!me_binary) {
		if (!wmebinflg) {	/* Reply only if we did not initiate */
		    if (tn_sopt(WILL,x) < 0)   
		      return -1;
		} else {
		    wmebinflg = 0;
		}
		me_binary = 1;
		if ((tn_binary == TN_NG_RQ || tn_binary == TN_NG_MU) && 
                     !u_binary) {
		    if (!dubinflg) {
			if (tn_sopt(DO,x) < 0)
			  return(-1);
			dubinflg = 1;	/* We sent an initial DO BINARY. */
		    }
		}
	    }
	    return(0);
	  case DONT:
	    if (tn_binary == TN_NG_MU) {
		printf("Host refuses to allow Binary Mode\n");
		ttclos(0);
		return(-1);
	    }
	    if (me_binary) {
		me_binary = 0;
		if (tn_sopt(WONT,x) < 0) 
		  return(-1);
		else
		  return(0);
	    } else
	      return(0);
	  default:
	    return(0);
	}

      case TELOPT_ECHO:			/* ECHO mode. */
	switch (c) {			/* Command... */
	  case WILL:			/* Host says it will echo.	     */
	    if (echo) {			/* We're locally echoing right now,  */
		if (tn_sopt(DO,x) < 0)	/* so switch to remote.	 */
		  return (-1); 
		else 
		  return(2);
	    } else
	      return(0);		/* We're already remote echoing.     */
	  case WONT:			/* Host says it won't echo.	     */
	    if (!echo) {		/* We're remote echoing right now,   */
		if (tn_sopt(DONT,x) < 0) /* so switch to local. */
		  return (-1);
		else
		  return (1);
	    } else			/* We're already locally echoing.    */
	      return(0);
	  case DO:			/* Host wants me to echo.	     */
	  case DONT:			/* Host doesn't want me to echo.     */
					/* ...But the client never echoes.   */
	      if (tn_sopt(WONT,x) < 0)
		return (-1);
	      else
		return (0);
	  default:
	    return(0);
	}

    case TELOPT_SGA:			/* Suppress Go-Ahead */
/*
  Note: There are lots of #ifdef COMMENT sections in the SGA code
  This is on purpose because some hosts (DG) will hang if an SGA response
  does not follow an ECHO request even if the state has not changed.
*/
	switch (c) {			/* Command... */
	  case WILL:			/* Server says it will SGA.	     */
#ifdef COMMENT
	    if (sgaflg) {		/* Remember new SGA state, but	     */
#endif /* COMMENT */
	      sgaflg = 0;		/* don't change echo state.	     */
	      if (tn_sopt(DO,x) < 0)
		return(-1);
	      else
		return(0);
#ifdef COMMENT
	    } else return(0);
#endif /* COMMENT */
	  case WONT:			/* Server says it won't SGA.	     */
#ifdef COMMENT
            if (!sgaflg) {		/* Remember new SGA state, and	     */
#endif /* COMMENT */
	      sgaflg = 1;		/* switch to local echo if needed.   */
	      if (tn_sopt(DONT,x) < 0)
		return(-1);
#ifdef COMMENT
	    }
#endif /* COMMENT */
            return(echo ? 0 : 1);
/*
  Note: The concerns expressed in the older comment below are now taken
  care of by the negotiation loop prevention code in tn_sopt() - see the
  comment about this near the definition of MAXTNCNT, above.
*/
/*
  Note: The following is proper behavior, and required for talking to the
  Apertus interface to the NOTIS library system, e.g. at Iowa State U:
  scholar.iastate.edu.	Without this reply, the server hangs forever.  This
  code should not be loop-inducing, since C-Kermit never sends WILL SGA as
  an initial bid, so if DO SGA comes, it is never an ACK.
*/
	  case DO:			/* Server wants me to SGA,	     */
					/* so I will.			     */
	  case DONT:			/* Server wants me not to SGA,	     */
					/* but I will anyway.		     */
	    if (tn_sopt(WILL,x) < 0)
	      return(-1);
	    else
	      return(0);

	  default:
	    return(0);
	}

#ifdef TELOPT_TTYPE
      case TELOPT_TTYPE:		/* Terminal Type */
	switch (c) {
	  case DONT:
	    if (ttyflg) {
	      ttyflg = 0;
	      if (tn_sopt(WONT,x) < 0) 
		return (-1);
	      else 
		return (0);
	    } else return(0);
	  case DO:
	    if (!ttyflg) {
	      ttyflg = 1;
	      if (tn_sopt(WILL,x) < 0) 
		return(-1);
	      else 
		return (0);
	    } else
	      return(0);
	  case WILL:
	  case WONT:
	    if (!ttyflg) {
		ttyflg = 1;
		if (tn_sopt(DONT,x) < 0) 
		  return(-1);
		else 
		  return (0);
	    } else
	      return(0);
          case SB:
	    if ((y = tn_sb(x,&n,fn)) <= 0)
	      return(y);
	    if (sb[0] == 1) {		/* SEND terminal type? */
		if (tn_sttyp() < 0)	/* Yes, so send it. */
		  return(-1);
	    }
#ifdef OS2
	    /* IS terminal type -- host has chosen from the list */
	    else {
		int i = 0;
		/* Isolate the specified terminal type string */
		while (sb[i++] != IAC) {
		    if (i >= TSBUFSIZ)
		      return (-1);
		    if (sb[i] == IAC) {
			sb[i] = '\0';
			break;
		    }
		}
		strupr(&(sb[1]));	/* Upper case it */
		for (i = 0; i <= max_tt; i++) { /* find it in our list */
		    if (!strcmp(&(sb[1]),tt_info[i].x_name)) {
			/* Set terminal type to the one chosen */
			settermtype(i,0);
			break;
		    }
		}
	    }
#endif /* OS2 */
	  default:			/* Others, ignore */
	    return(0);
	}
#endif /* TELOPT_TTYPE */

#ifdef CK_SNDLOC
      case TELOPT_SNDLOC:		/* Send Location */
	switch (c) {
	  case DONT:
	    if (dosndloc) {		/* I said I will */
		dosndloc = 0;		/* So OK I won't... */
		if (tn_sopt(WONT,x) < 0) 
		  return(-1);
		else 
		  return(0);
	    } else return(0);		/* Never said I would */
	  case DO:
	    if (tn_loc) {		/* Do I have a location? */
		dosndloc = 1;		/* So OK I will */
		if (tn_sopt(WILL, x) < 0)
		  return(-1);
		if (nsndloc++ < 1)	/* And do it now if I didn't already */
		  return(tn_sndloc());
	    } else {			/* I don't have a location */
		dosndloc = 0;
		if (tn_sopt(WONT, x) < 0) /* So I won't */
		  return(-1);
	    }
	    return(0);
	  case WILL:
	  case WONT:
	    if (!dosndloc) {		/* I don't care about your location */
		dosndloc = 1;
		if (tn_sopt(DONT,x) < 0) 
		  return(-1);
		else 
		  return(0);
	    } else
	      return(0);
	}
#endif /* CK_SNDLOC */

#ifdef CK_ENVIRONMENT
#ifdef CK_XDISPLOC
      case TELOPT_XDISPLOC:		/* Send X-Display Location */
	switch (c) {
	  case DONT:
	    if (wxdisploc) {		/* I said I will */
		wxdisploc = 0;		/* So OK I won't... */
		if (tn_sopt(WONT,x) < 0) 
		  return(-1);
		else 
		  return(0);
	    } else return(0);		/* Never said I would */
	  case DO:
	    if (tn_xdisploc || tn_env_disp[0]) {/* Do I have a display? */
		doxdisploc = 1;		/* So OK I will */
                if (!wxdisploc)
		  if (tn_sopt(WILL, x) < 0)
		    return(-1);
	    } else {			/* I don't have a display */
		doxdisploc = 0;
                wxdisploc = 0;          /* No WILL outstanding */
		if (tn_sopt(WONT, x) < 0) /* So I won't */
		  return(-1);
	    }
	    return(0);
	  case WILL:
	  case WONT:
	    if (tn_sopt(DONT,x) < 0) 
	      return(-1);
	    else 
	      return(0);
          case SB:
	    if ((y = tn_sb(x,&n,fn)) <= 0)
	      return(y);
	    if (sb[0] == 1) {		/* SEND X-Display Loc? */
		if (tn_sxdisploc() < 0)	/* Yes, so send it. */
		  return(-1);
	    }
	    /* IS terminal type -- X Display Location (not supported) */
	    else if (sb[0] == 0) {
		int i = 0;
		/* Isolate the specified X-display string */
		while (sb[i++] != IAC) {
		    if (i >= TSBUFSIZ)
		      return (-1);
		    if (sb[i] == IAC) {
			sb[i] = '\0';
			break;
		    }
		}
                debug(F110,"TELNET XDISPLOC IS",&sb[1],0);
	    }
	}
#endif /* CK_XDISPLOC */
#endif /* CK_ENVIRONMENT */

#ifdef CK_NAWS
      case TELOPT_NAWS:			/* Terminal width and height */
	switch (c) {
	  case DO:
	    /* Get window size again in case it changed */
	    if (ttgwsiz() > 0) {
		if (!wnawsflg) {	/* Reply WILL only if we */
		    if (tn_sopt(WILL,x) < 0) /* didn't initiate this */
		      return(-1);	/* negotiation with a WILL */
		} else
		  wnawsflg = 0;

		nawsflg = 1;
#ifndef NOSIGWINCH
#ifdef SIGWINCH
#ifdef UNIX
		if (sw_armed++ < 1) {	/* Catch window-size changes. */ 
		    debug(F100,"tn_doop arming SIGWINCH","",0);
		    signal(SIGWINCH,winchh);
		}
#else
		debug(F100,"SIGWINCH defined but not used","",0);
#endif /* UNIX */    
#endif /* SIGWINCH */
#endif /* NOSIGWINCH */
		return((tn_snaws() < 0) 
#ifdef RLOGCODE
		       || (rlog_naws() < 0)
#endif /* RLOGCODE */
		       ? -1 : 0);	/* And now do it. */
	    } else {
		nawsflg = 0;
		wnawsflg = 0;
		return((tn_sopt(WONT,x) < 0) ? -1 : 0);
	    }
	  case DONT:
	    nawsflg = 0;
	    wnawsflg = 0;
	    return ((tn_sopt(WONT,x) < 0) ? -1 : 0);
	  case WILL:			/* For when we are a server */
	    nawsflg = 0;
	    wnawsflg = 0;
	    return ((tn_sopt(DONT,x) < 0) ? -1 : 0);
	  case WONT:
	    /* return ((tn_sopt(DONT,x) < 0) ? -1 : 0); */
	  default:
	    return(0);
	}
#endif /* CK_NAWS */

#ifdef CK_ENVIRONMENT
      case TELOPT_NEWENVIRON:		/* Telnet New-Environment */
	switch (c) {
	  case DO:
	    if (!wnenvflg) {
		wnenvflg = 1;
		return((tn_sopt(tn_env_flg ? WILL : WONT,x) < 0) ? -1 : 0);
	    }
	    nenvflg = tn_env_flg;
	    return(0);
          case DONT:
	    if (wnenvflg) {
		nenvflg = 0;
		wnenvflg = 0;
		return((tn_sopt(WONT,x) < 0) ? -1 : 0);
	    }
	  case WILL: /* For when we are a server */
	    nenvflg = 0;
	    wnenvflg = 0;
	    return((tn_sopt(DONT,x) < 0) ? -1 : 0);
          case WONT:
	    /* We never sent DO so there is no reason */
	    /* to send DONT here since there is no state change */
	    return(0);
	  case SB: {
              if ((y = tn_sb(x,&n,fn)) <= 0)
		return(y);
	      switch (sb[0]) {
		case 0:			/* IS */
		  /* Ignore, we're not a server - yet */
		  break;
		case 1:			/* SEND */
		  /* We need to take the sb[] and build a structure */
		  /* containing all of the variables and types that */
		  /* we are supposed to keep track of and send to   */
		  /* the host, then call tn_snenv().		    */
		  /* Or we can punt ...				    */
		  if (tn_snenv(&sb[1],n-3) < 0)	/* Yes, so send it. */
		    return(-1);
		  break;
		case 2:			/* INFO */
		  /* Ignore, we're not a server - yet */
		  break;
	      }
	  }
	  default:
	    return(0);
	}
#endif /* CK_ENVIRONMENT */

      case TELOPT_LOGOUT:               /* When DO LOGOUT is received */
	switch(c) {			/* disconnect the session     */
	  case WILL:			/* You will? */
            if (!dlogoutflg)
              return((tn_sopt(DONT,x) < 0) ? -1 : 0); /* Please don't. */
            return(0);
	  case DO: {			/* You want me to? */
	      int rc = tn_sopt(WILL,x);	/* Send WILL LOGOUT */
	      ttclos(0);		/* And then hangup */
	      return(rc ? -1 : 0);	/* We did. */
          }
	  case WONT:			/* You won't? */
	  case DONT:			/* You don't want me to? */
	  default:
	    return(0);
	}
        break;

      default:				/* All others: refuse */
	switch(c) {
	  case WILL:			/* You will? */
	    return((tn_sopt(DONT,x) < 0) ? -1 : 0); /* Please don't. */
	  case DO:			/* You want me to? */
	    return((tn_sopt(WONT,x) < 0) ? -1 : 0); /* Please don't. */
	  case WONT:			/* You won't? */
	  case DONT:			/* You don't want me to? */
	  default:
	    return(0);
	}
    }
#endif /* TNCODE */
}

#ifdef CK_ENVIRONMENT
/* Telnet send new environment */
/* Returns -1 on error, 0 if nothing happens, 1 on success */

int
#ifdef CK_ANSIC
tn_snenv(CHAR * sb, int len) 
#else
tn_snenv(sb, len) CHAR * sb; int len;
#endif /* CK_ANSIC */
/* tn_snenv */ {			/* Send new environment */
#ifndef TNCODE
    debug(F100,"tn_snenv no TNCODE","",0);
    return(0);
#else
    char varname[16];
    char * reply = 0, * s = 0;
    int i,j,n;				/* Worker. */
    int type = 0;	/* 0 for NONE, 1 for VAR, 2 for USERVAR in progress */

    if (ttnet != NET_TCPB) return(0);
    if (ttnproto != NP_TELNET) return(0);

    /* First determine the size of the buffer we will need */
    for (i = 0, j = 0, n = 0, type = 0, varname[0]= '\0'; i <= len; i++) {
	switch (sb[i]) {
	  case 0:			/* VAR */
	  case 3:			/* USERVAR */
	  case IAC:			/* End of the list */
	    switch (type) {
	      case 0:			/* Nothing in progress */
		/* If we get IAC only, then that means send all */
		/* VAR and USERVAR.  But since we don't support */
		/* USERVAR yet, we can just pass through	*/
		if (!(j == 0 && sb[i] == IAC))
		  break;
	      case 1:			/* VAR in progress */
		varname[j] = '\0' ;
		if (!varname[0]) {	/* Send All */
		    if (uidbuf[0])
		      n += strlen(uidbuf) + 4 + 2;
		    if (tn_env_job[0])
		      n += strlen(tn_env_job) + 3 + 2;
		    if (tn_env_acct[0])
		      n += strlen(tn_env_acct) + 4 + 2;	   
		    if (tn_env_prnt[0])
		      n += strlen(tn_env_prnt) + 7 + 2;
		    if (tn_env_sys[0])
		      n += strlen(tn_env_sys) + 10 + 2;
		    if (tn_env_disp[0])
		      n += strlen(tn_env_disp) + 7 + 2;
		} else if (!strcmp(varname,"USER") && uidbuf[0])
		  n += strlen(uidbuf) + 4 + 2;
		else if (!strcmp(varname,"JOB") && tn_env_job[0])
		  n += strlen(tn_env_job) + 3 + 2;
		else if (!strcmp(varname,"ACCT") && tn_env_acct[0])
		  n += strlen(tn_env_acct) + 4 + 2;
		else if (!strcmp(varname,"PRINTER") && tn_env_prnt[0])
		  n += strlen(tn_env_prnt) + 7 + 2;
		else if (!strcmp(varname,"SYSTEMTYPE") && tn_env_sys[0])
		  n += strlen(tn_env_sys) + 10 + 2;
		else if (!strcmp(varname,"DISPLAY") && tn_env_disp[0])
		  n += strlen(tn_env_disp) + 7 + 2;
		break;
	      case 2:			/* USERVAR in progress */
		break;			/* We don't support this yet */
	    }
	    varname[0] = '\0';
	    j = 0;
	    type = (sb[i] == 3 ? 2 :	/* USERVAR */
		    sb[i] == 0 ? 1 :	/* VAR */
		    0
		   );
	    break;
	  case 1:			/* VALUE */
	    /* Protocol Error */
	    debug(F100, "TELNET Subnegotiation error - VALUE in SEND", "",0);
	    if (debses) 
	      tn_debug("TELNET Subnegotiation error - VALUE in SEND");
	    return(0);	/* Was -1 but that would be taken as */
			/* an I/O error, so absorb it and go on. */
	  case 2:	/* ESC */
	    /* Not sure what this for.	Quote next character? */
	    break;
	  default:
	    varname[j++] = sb[i];
	}
    }
    reply = malloc(n + 7);		/* Leave room for IAC stuff */
    if (!reply) {
	debug(F100, "TELNET Subnegotiation error - malloc failed", "",0);
	if (debses) 
	  tn_debug("TELNET Subnegotiation error - malloc failed");

	/* Send a return packet with no variables so that the host */
	/* may continue with additional negotiations		   */
	sb[0] = (CHAR) IAC;		/* I Am a Command */
	sb[1] = (CHAR) SB;		/* Subnegotiation */
	sb[2] = TELOPT_NEWENVIRON;	/* New Environment */
	sb[3] = (CHAR) 0;		/* Is... */
	sb[4] = (CHAR) IAC;		/* End of Subnegotiation */
	sb[5] = (CHAR) SE;		/* marked by IAC SE */
	if (deblog || debses) {
	    sprintf(tn_msg,"TELNET SENT SB %s IS  IAC SE",
		     tnopts[TELOPT_NEWENVIRON]);
	    debug(F100,tn_msg,"",0);
	    if (debses) tn_debug(tn_msg);
	}
	if (ttol((CHAR *)sb,6) < 0)	/* Send it. */
	  return(-1);
	sb[4] = '\0';			/* For debugging */
	return(0);     
    }

    /* Now construct the real reply */
    reply[0] = (CHAR) IAC;			/* I Am a Command */
    reply[1] = (CHAR) SB;			/* Subnegotiation */
    reply[2] = TELOPT_NEWENVIRON;		/* New Environment */
    reply[3] = (CHAR) 0;			/* Is... */
    n = 4; 
/* Pairs of <type> [VAR=0, VALUE=1, ESC=2, USERVAR=3] <value> "unterminated" */
    /* follow here until done */
    for (i = 0, j = 0, type = 0, varname[0]= '\0'; i <= len; i++) {
	switch (sb[i]) {
	  case 0:			/* VAR */
	  case 3:			/* USERVAR */
	  case IAC:			/* End of the list */
	    switch (type) {
	      case 0:			/* Nothing in progress */
		/* If we get IAC only, then that means send all */
		/* VAR and USERVAR.  But since we don't support */
		/* USERVAR yet, we can just pass through	*/
		if (!(j == 0 && sb[i] == IAC))
		  break;
	      case 1:			/* VAR in progress */
		varname[j] = '\0';
		if (!varname[0]) {
		    /* Send All */
		    if ( uidbuf[0] ) {
			reply[n] = 0;	/* VAR */
			strcpy(&reply[n+1],"USER");
			reply[n+5] = 1;		/* VALUE */
			strcpy(&reply[n+6],uidbuf);
			n += strlen(uidbuf) + 4 + 2;
		    }
		    if (tn_env_job[0]) {
			reply[n] = 0;	/* VAR */
			strcpy(&reply[n+1],"JOB");
			reply[n+4] = 1;	/* VALUE */
			strcpy(&reply[n+5],tn_env_job);
			n += strlen(tn_env_job) + 3 + 2;
		    }
		    if (tn_env_acct[0]) {
			reply[n] = 0;	/* VAR */
			strcpy(&reply[n+1],"ACCT");
			reply[n+5] = 1;	/* VALUE */
			strcpy(&reply[n+6],tn_env_acct);
			n += strlen(tn_env_acct) + 4 + 2;
		    }
		    if (tn_env_prnt[0]) {
			reply[n] = 0;	/* VAR */
			strcpy(&reply[n+1],"PRINTER");
			reply[n+8] = 1;	/* VALUE */
			strcpy(&reply[n+9],tn_env_prnt);
			n += strlen(tn_env_prnt) + 7 + 2;
		    }
		    if (tn_env_sys[0]) {
			reply[n] = 0;	/* VAR */
			strcpy(&reply[n+1],"SYSTEMTYPE");
			reply[n+11] = 1; /* VALUE */
			strcpy(&reply[n+12],tn_env_sys);
			n += strlen(tn_env_sys) + 10 + 2;
		    }
		    if (tn_env_disp[0]) {
			reply[n] = 0;	/* VAR */
			strcpy(&reply[n+1],"DISPLAY");
			reply[n+8] = 1;	/* VALUE */
			strcpy(&reply[n+9],tn_env_disp);
			n += strlen(tn_env_disp) + 7 + 2;
		    }
		} else if (!strcmp(varname,"USER") && uidbuf[0]) {
		    reply[n] = 0;	/* VAR */
		    strcpy(&reply[n+1],"USER");
		    reply[n+5] = 1;	/* VALUE */
		    strcpy(&reply[n+6],uidbuf);
		    n += strlen(uidbuf) + 4 + 2;
		} else if (!strcmp(varname,"JOB") && tn_env_job[0]) {
		    reply[n] = 0;	/* VAR */
		    strcpy(&reply[n+1],"JOB");
		    reply[n+4] = 1;	/* VALUE */
		    strcpy(&reply[n+5],tn_env_job);
		    n += strlen(tn_env_job) + 3 + 2;
		} else if (!strcmp(varname,"ACCT") && tn_env_acct[0]) {
		    reply[n] = 0;	/* VAR */
		    strcpy(&reply[n+1],"ACCT");
		    reply[n+5] = 1;	/* VALUE */
		    strcpy(&reply[n+6],tn_env_acct);
		    n += strlen(tn_env_acct) + 4 + 2;
		} else if (!strcmp(varname,"PRINTER") && tn_env_prnt[0]) {
		    reply[n] = 0;	/* VAR */
		    strcpy(&reply[n+1],"PRINTER");
		    reply[n+8] = 1;	/* VALUE */
		    strcpy(&reply[n+9],tn_env_prnt);
		    n += strlen(tn_env_prnt) + 7 + 2;
		} else if (!strcmp(varname,"SYSTEMTYPE") && tn_env_sys[0]) {
		    reply[n] = 0;	/* VAR */
		    strcpy(&reply[n+1],"SYSTEMTYPE");
		    reply[n+11] = 1;	/* VALUE */
		    strcpy(&reply[n+12],tn_env_sys);
		    n += strlen(tn_env_sys) + 10 + 2;
		} else if (!strcmp(varname,"DISPLAY") && tn_env_disp[0]) {
		    reply[n] = 0;	/* VAR */
		    strcpy(&reply[n+1],"DISPLAY");
		    reply[n+8] = 1;	/* VALUE */
		    strcpy(&reply[n+9],tn_env_disp);
		    n += strlen(tn_env_disp) + 7 + 2;
		}
		break;
	    case 2:	/* USERVAR in progress */
		/* we don't support this yet */
		break;
	    }
	    varname[0] = '\0';
	    j = 0;
	    type = (sb[i] == 3 ? 2 :	/* USERVAR */
		    sb[i] == 0 ? 1 :	/* VAR */
		    0
		   );
	    break;
	  case 1: /* VALUE */
	    /* Protocol Error */
	    debug(F100, "TELNET Subnegotiation error - VALUE in SEND", "",0);
	    if (debses) 
	      tn_debug("TELNET Subnegotiation error - VALUE in SEND");
	    return(0);	/* Was -1 but that would be taken as */
			/* an I/O error, so absorb it and go on. */
	  case 2:	/* ESC */
	    /* Not sure what this for.	Quote next character? */
	    break;
	  default:
	    varname[j++] = sb[i];
	}
    }
    reply[n++] = (CHAR) IAC;		/* End of Subnegotiation */
    reply[n++] = (CHAR) SE;		/* marked by IAC SE */
    reply[n] = '\0';			/* For debugging */
    if (deblog || debses) {
	int i;
	sprintf(tn_msg,"TELNET SENT SB %s %s ",
		 tnopts[TELOPT_NEWENVIRON],
		 reply[3] == 1 ? "SEND" : reply[3] == 0 ? "IS" : "INFO");
	for (i = 4; i < n-2; i++) {
	    sprintf(hexbuf,"%c",reply[i]);
	    strcat(tn_msg,hexbuf);
	}
	strcat(tn_msg," IAC SE");
	debug(F100,tn_msg,"",0);
	if (debses) tn_debug(tn_msg);
    }
    if (ttol((CHAR *)reply,n) < 0) {	/* Send it. */
	free(reply);
	return(-1);
    }
    free(reply);
    return(1);
#endif /* TNCODE */
}
#endif /* CK_ENVIRONMENT */

/* Telnet send terminal type */
/* Returns -1 on error, 0 if nothing happens, 1 if type sent successfully */

int
tn_sttyp() {				/* Send telnet terminal type. */
#ifndef TNCODE
    debug(F100,"tn_sttyp no TNCODE","",0);
    return(0);
#else
    char *ttn;				/* Name of terminal type. */
    int i;				/* Worker. */
    int tntermflg = 0;
    int settype = 0;

    if (ttnet != NET_TCPB) return(0);
    if (ttnproto != NP_TELNET) return(0);

    ttn = NULL;

#ifdef OS2
    if (!tn_term) {
	if (ttnum == -1) {
	    ttnum = tt_type;
	    settype = 0;
	} else if (ttnumend) {
	    ttnumend = 0;
	    settype = 0;
	} else {
	    if (--tt_type < 0)
	      tt_type = max_tt;
	    if (ttnum == tt_type)
	      ttnumend = 1;
            settype = 1;
	}
	if (tt_type >= 0 && tt_type <= max_tt) {
	    ttn = tt_info[tt_type].x_name;
#ifdef COMMENT
	    if (settype)
	      settermtype(tt_type,0);
#endif /* COMMENT */
	} else
	  ttn = NULL;
    }
    else settype = 0;
#endif /* OS2 */

    if (tn_term) {			/* Terminal type override? */
	debug(F110,"tn_sttyp",tn_term,0);
	if (*tn_term) {
	    ttn = tn_term;
	    tntermflg = 1;
	}
    } else debug(F100,"tn_sttyp no term override","",0);

#ifndef datageneral
    if (!ttn) {				/* If no override, */
	ttn = getenv("TERM");		/* get it from the environment. */
    }
#endif /* datageneral */
    if ((ttn == ((char *)0)) || ((int)strlen(ttn) >= TSBUFSIZ))
      ttn = "UNKNOWN";
    sb[0] = (CHAR) IAC;			/* I Am a Command */
    sb[1] = (CHAR) SB;			/* Subnegotiation */
    sb[2] = TELOPT_TTYPE;		/* Terminal Type */
    sb[3] = (CHAR) 0;			/* Is... */
    for (i = 4; *ttn; ttn++,i++) {	/* Copy and uppercase it */
#ifdef VMS
	if (!tntermflg && *ttn == '-' &&
	    (!strcmp(ttn,"-80") || !strcmp(ttn,"-132")))
	  break;
	else
#endif /* VMS */
	sb[i] = (char) ((!tntermflg && islower(*ttn)) ? toupper(*ttn) : *ttn);
    }
    ttn = (char *)sb;			/* Point back to beginning */
    if (deblog || debses) {
        sb[i] = '\0';			/* For debugging */
	sprintf(tn_msg,"TELNET SENT SB %s IS %s IAC SE",
                 tnopts[TELOPT_TTYPE],sb+4);
	debug(F100,tn_msg,"",0);
	if (debses) tn_debug(tn_msg);
    }
    sb[i++] = (CHAR) IAC;		/* End of Subnegotiation */
    sb[i++] = (CHAR) SE;		/* marked by IAC SE */
    if (ttol((CHAR *)sb,i) < 0)		/* Send it. */
      return(-1);
#ifdef OS2
    if (settype)
	settermtype(tt_type,0);
#endif /* OS2 */
    return(1);
#endif /* TNCODE */
}

#ifdef CK_ENVIRONMENT
#ifdef CK_XDISPLOC

/* Telnet send xdisplay location */
/* Returns -1 on error, 0 if nothing happens, 1 if type sent successfully */

int
tn_sxdisploc() {			/* Send telnet X display location. */
#ifndef TNCODE
    debug(F100,"tn_s no TNCODE","",0);
    return(0);
#else
    char * ttn=NULL;
    char tmploc[256];
    int i;

    tmploc[0] = '\0';
    if (ttnet != NET_TCPB) return(0);
    if (ttnproto != NP_TELNET) return(0);

    if (!doxdisploc) return(0);

    if (tn_xdisploc) 
      ttn = tn_xdisploc;
    else if (tn_env_disp[0])
      ttn = tn_env_disp;
    else {
        sprintf(tmploc,"%s:0.0",namecopy);
        ttn = tmploc;
    }
    debug(F110,"tn_sxdisploc",tn_xdisploc,0);

    sb[0] = (CHAR) IAC;			/* I Am a Command */
    sb[1] = (CHAR) SB;			/* Subnegotiation */
    sb[2] = TELOPT_XDISPLOC;		/* X-Display Location */
    sb[3] = (CHAR) 0;			/* Is... */
    for (i = 4; *ttn; ttn++,i++) {	/* Copy and uppercase it */
	sb[i] = (char) *ttn;
    }
    ttn = (char *)sb;			/* Point back to beginning */
    if (deblog || debses) {
        sb[i] = '\0';			/* For debugging */
	sprintf(tn_msg,
		"TELNET SENT SB %s IS %s IAC SE",
		tnopts[TELOPT_XDISPLOC],
		sb+4
		);
	debug(F100,tn_msg,"",0);
	if (debses) tn_debug(tn_msg);
    }
    sb[i++] = (CHAR) IAC;		/* End of Subnegotiation */
    sb[i++] = (CHAR) SE;		/* marked by IAC SE */
    if (ttol((CHAR *)sb,i) < 0)		/* Send it. */
      return(-1);
    return(1);
#endif /* TNCODE */
}
#endif /* CK_XDISPLOC */
#endif /* CK_ENVIRONMENT */

#ifdef CK_SNDLOC
static int
tn_sndloc() {				/* Send location. */
#ifndef TNCODE
    debug(F100,"tn_sndloc no TNCODE","",0);
    return(0);
#else
    int i;				/* Worker. */
    char *ttloc;

    ttloc = (tn_loc ? tn_loc : "");	/* In case we are being called even */
					/* though there is no location. */
    sb[0] = (CHAR) IAC;			/* I Am a Command */
    sb[1] = (CHAR) SB;			/* Subnegotiation */
    sb[2] = TELOPT_SNDLOC;		/* Location */
    for (i = 3; *ttloc && i < TSBUFSIZ; ttloc++,i++) /* Copy it */
      sb[i] = (char) *ttloc;
    sb[i++] = (CHAR) IAC;		/* End of Subnegotiation */
    sb[i++] = (CHAR) SE;		/* marked by IAC SE */
    if (ttol((CHAR *)sb,i) < 0)		/* Send it. */
      return(-1);
    sb[i-2] = '\0';			/* For debugging */
#ifdef DEBUG
    if (deblog || debses) {
	sprintf(tn_msg,"TELNET SENT SB %s %s IAC SE",
	tnopts[TELOPT_SNDLOC],sb+3);
	debug(F100,tn_msg,"",0);
	if (debses) tn_debug(tn_msg);
    }
#endif /* DEBUG */
    return(0);
#endif /* TNCODE */
}
#endif /* CK_SNDLOC */

#ifdef CK_NAWS			/*  NAWS = Negotiate About Window Size	*/
int
tn_snaws() {			/*  Send terminal width and height, RFC 1073 */
#ifndef TNCODE
    debug(F100,"tn_snaws no TNCODE","",0);
#else
    int i = 0;
#ifdef OS2 
    int x = VscrnGetWidth(VTERM), 
    y = VscrnGetHeight(VTERM) - (tt_status ? 1 : 0);
#else /* OS2 */
    int x = tt_cols, y = tt_rows;
#endif /* OS2 */

    if (ttnet != NET_TCPB) return(0);
    if (ttnproto != NP_TELNET) return(0);
    if (!nawsflg) return(0);

    if (x < 0) x = 0;
    if (y < 0) y = 0;

    sb[i++] = (CHAR) IAC;		/* Send a subnegotiation */
    sb[i++] = (CHAR) SB;
    sb[i++] = TELOPT_NAWS;
    sb[i++] = (CHAR) (x >> 8) & 0xff;
    /* IAC in data must be doubled */
    if ((CHAR) sb[i-1] == (CHAR) IAC) sb[i++] = (CHAR) IAC;
    sb[i++] = (CHAR) (x & 0xff);
    if ((CHAR) sb[i-1] == (CHAR) IAC) sb[i++] = (CHAR) IAC;
    sb[i++] = (CHAR) (y >> 8) & 0xff;
    if ((CHAR) sb[i-1] == (CHAR) IAC) sb[i++] = (CHAR) IAC;
    sb[i++] = (CHAR) (y & 0xff);
    if ((CHAR) sb[i-1] == (CHAR) IAC) sb[i++] = (CHAR) IAC;
    sb[i++] = (CHAR) IAC;
    sb[i++] = (CHAR) SE;
    if (deblog || debses) {
	sprintf(tn_msg,"TELNET SENT SB NAWS %d %d IAC SE",x,y);
	debug(F100,tn_msg,"",0);
	if (debses) tn_debug(tn_msg);
    }
    if (ttol((CHAR *)sb,i) < 0)		/* Send it. */
      return(-1);
#endif /* TNCODE */
    return (0);
}
#endif /* CK_NAWS */

#ifdef SUNX25
/*
  SunLink X.25 support by Marcello Frutig, Catholic University,
  Rio de Janeiro, Brazil, 1990.
*/

/* PAD X.3, X.28 and X.29 support */

static CHAR x29err[MAXPADPARMS+3] = { X29_ERROR, INVALID_PAD_PARM, '\0' };

/* Initialize PAD */

extern CHAR padparms[];

VOID
initpad() {
  padparms[PAD_BREAK_CHARACTER]	       = 0;  /* Break character */
  padparms[PAD_ESCAPE]		       = 1;  /* Escape permitted */
  padparms[PAD_ECHO]		       = 1;  /* Kermit PAD does echo */
  padparms[PAD_DATA_FORWARD_CHAR]      = 2;  /* forward character CR */
  padparms[PAD_DATA_FORWARD_TIMEOUT]   = 0;  /* no timeout forward condition */
  padparms[PAD_FLOW_CONTROL_BY_PAD]    = 0;  /* not used */
  padparms[PAD_SUPPRESSION_OF_SIGNALS] = 1;  /* allow PAD service signals */
  padparms[PAD_BREAK_ACTION]	       = 21; /* brk action: INT pk + brk ind*/
  padparms[PAD_SUPPRESSION_OF_DATA]    = 0;  /* no supression of user data */
  padparms[PAD_PADDING_AFTER_CR]       = 0;  /* no padding after CR */
  padparms[PAD_LINE_FOLDING]	       = 0;  /* no line fold */
  padparms[PAD_LINE_SPEED]	       = 0;  /* line speed - don't care */
  padparms[PAD_FLOW_CONTROL_BY_USER]   = 0;  /* flow cont of PAD - not used */
  padparms[PAD_LF_AFTER_CR]	       = 0;  /* no LF insertion after CR */
  padparms[PAD_PADDING_AFTER_LF]       = 0;  /* no padding after LF */
  padparms[PAD_EDITING]		       = 1;  /* can edit */
  padparms[PAD_CHAR_DELETE_CHAR]       = 8;  /* character delete character */
  padparms[PAD_BUFFER_DELETE_CHAR]     = 21; /* buffer delete character */
  padparms[PAD_BUFFER_DISPLAY_CHAR]    = 18; /* buffer display character */
}

/* Set PAD parameters */

VOID
setpad(s,n) CHAR *s; int n; {
    int i;
    CHAR *ps = s;

    if (n < 1) {
	initpad();
    } else {
	for (i = 0; i < n; i++) {
	    if (*ps > MAXPADPARMS)
	      x29err[i+2] = *ps;
	    else
	      padparms[*ps] = *(ps+1);
	    ps += 2;
	}
    }
}

/* Read PAD parameters */

VOID
readpad(s,n,r) CHAR *s; int n; CHAR *r; {
    int i;
    CHAR *ps = s;
    CHAR *pr = r;

    *pr++ = X29_PARAMETER_INDICATION;
    if (n > 0) {
	for (i = 0; i < n; i++, ps++) {
	    if (*ps > MAXPADPARMS) {
		x29err[i+2] = *ps++;
	    } else {
		*pr++ = *ps;
		*pr++ = padparms[*ps++];
	    }
	}
    } else {
	for (i = 1; i < MAXPADPARMS; i++) {
	    *pr++ = i;
	    *pr++ = padparms[i];
	}
    }
}

int
qbitpkt(s,n) CHAR *s; int n; {
    CHAR *ps = s;
    int x29cmd = *ps;
    CHAR *psa = s+1;
    CHAR x29resp[(MAXPADPARMS*2)+1];

    switch (x29cmd) {

	case X29_SET_PARMS:
	    setpad (ps+1,n/2);
	    if ((int)strlen((char *)x29err) > 2) {
		ttol(x29err,(int)strlen((char *)x29err));
		x29err[2] = '\0';
	    }
	    return (-2);
	case X29_READ_PARMS:
	    readpad (ps+1,n/2,x29resp);
	    setqbit ();
	    ttol (x29resp,(n>1)?(n+1):(2*MAXPADPARMS+1));
	    if ((int)strlen((char *)x29err) > 2) {
		ttol(x29err,(int)strlen((char *)x29err));
		x29err[2] = '\0';
	    }
	    resetqbit();
	    break;
	case X29_SET_AND_READ_PARMS:
	    setpad (ps+1,n/2);
	    readpad (ps+1,n/2,x29resp);
	    setqbit();
	    ttol (x29resp,(n>1)?(n+1):(2*MAXPADPARMS+1));
	    if ((int)strlen((char *)x29err) > 2) {
		ttol (x29err,(int)strlen((char *)x29err));
		x29err [2] = '\0';
	    }
	    resetqbit();
	    return (-2);
	case X29_INVITATION_TO_CLEAR:
	    (VOID) x25clear();
	    return (-1);
	case X29_INDICATION_OF_BREAK:
	    break;
    }
    return (0);
}

/* PAD break action processor */

VOID
breakact() {
    extern char x25obuf[MAXOX25];
    extern int obufl;
    extern int active;
    extern unsigned char tosend;
    static CHAR indbrk[3] = {
	X29_INDICATION_OF_BREAK,
	PAD_SUPPRESSION_OF_DATA,
	1
    };
    CHAR intudat, cause, diag;

    if (x25stat() < 0) return;	/* Ignore if no virtual call established */

    if (padparms[PAD_BREAK_ACTION] != 0) /* Forward condition */
	if (ttol((CHAR *)x25obuf,obufl) < 0) {
	    perror ("\r\nCan't send characters");
	    active = 0;
	} else {
	    bzero (x25obuf,sizeof(x25obuf));
	    obufl = 0;
	    tosend = 0;
	};

    switch (padparms[PAD_BREAK_ACTION]) {

       case 0 : break;			/* do nothing */
       case 1 : /* send interrupt packet with interrupt user data field = 1 */
		intudat = 1;
		x25intr (intudat);
		break;
       case 2 : /* send reset packet with cause and diag = 0 */
		cause = diag = 0;
		x25reset (cause,diag);
		break;
       case 5 : /* send interrupt packet with interrupt user data field = 0 */
		intudat = 0;
		x25intr (intudat);
		setqbit ();
		/* send indication of break without a parameter field */
		ttoc(X29_INDICATION_OF_BREAK);
		resetqbit ();
		break;
       case 8 : active = 0;		/* leave data transfer */
		conol ("\r\n");
		break;
       case 21: /* send interrupt packet with interrupt user data field = 0 */
		intudat = 0;
		x25intr (intudat);
		setpad (indbrk+1,2);	/* set pad to discard input */
		setqbit ();
		/* send indication of break with parameter field */
		ttol (indbrk,sizeof(indbrk));
		resetqbit ();
		break;
     }
}

/* X.25 support functions */

X25_CAUSE_DIAG diag;

/*
  Convert a null-terminated string representing an X.121 address
  to a packed BCD form.
*/
int
pkx121(str,bcd) char *str; CHAR *bcd; {
    int i, j;
    u_char c;

    i = j = 0;
    while (str[i]) {
	if (i >= 15 || str [i] < '0' || str [i] > '9')
	  return (-1);
	c = str [i] - '0';
	if (i & 1)
	  bcd [j++] |= c;
	else
	  bcd [j] = c << 4;
	i++;
    }
    return (i);
}

/* Reads and prints X.25 diagnostic */

int
x25diag () {
    int i;

    bzero ((char *)&diag,sizeof(diag));
    if (ioctl(ttyfd,X25_RD_CAUSE_DIAG,&diag)) {
	perror ("Reading X.25 diagnostic");
	return(-1);
    }
    if (diag.datalen > 0) {
	printf ("X.25 Diagnostic :");
	for (i = 0; i < (int)diag.datalen; i++)
	  printf(" %02h",diag.data[i])+
	printf ("\r\n");
    }
    return(0);
}

/* X.25 Out-of-Band Signal Handler */

SIGTYP
x25oobh(foo) int foo; {
    int oobtype;
    u_char oobdata;
    int t;

    (VOID) signal(SIGURG,x25oobh);
    do {
	if (ioctl(ttyfd,X25_OOB_TYPE,&oobtype)) {
	    perror ("Getting signal type");
	    return;
	}
	switch (oobtype) {
	  case INT_DATA:
	    if (recv(ttyfd,(char *)&oobdata,1,MSG_OOB) < 0) {
		perror ("Receiving X.25 interrupt data");
		return;
	    }
	    t = oobdata;
	    printf ("\r\nInterrupt received, data = %d\r\n", t);
	    break;
	  case VC_RESET:
	    printf ("\r\nVirtual circuit reset\r\n");
	    x25diag ();
	    break;
	  case N_RESETS:
	    printf ("\r\nReset timeout\r\n");
	    break;
	  case N_CLEARS:
	    printf ("\r\nClear timeout\r\n");
	    break;
	  case MSG_TOO_LONG:
	    printf ("\r\nMessage discarded, too long\r\n");
	    break;
	  default:
	    if (oobtype) printf("\r\nUnknown oob type %d\r\n",oobtype);
	    break;
	}
    } while (oobtype);
}

/* Send a X.25 interrupt packet */

int
#ifdef CK_ANSIC
x25intr(char intr)
#else
x25intr(intr) char intr;
#endif /* CK_ANSIC */
/* x25intr */ {
    if (send(ttyfd,&intr,1,MSG_OOB) < 0) return(-1);
    debug(F100,"X.25 intr","",0);
    return(0);
}

/* Reset X.25 virtual circuit */
int
#ifdef CK_ANSIC
x25reset(char cause, char diagn)
#else
x25reset(cause, diagn) char cause; char diagn;
#endif /* CK_ANSIC */
/* x25reset */ {
    bzero ((char *)&diag,sizeof(diag));
    diag.flags	 = 0;
    diag.datalen = 2;
    diag.data[0] = cause;
    diag.data[1] = diagn;
    if (ioctl(ttyfd,X25_WR_CAUSE_DIAG,&diag) < 0)
      return(-1);
    debug(F100,"X.25 reset","",0);
    return(0);
}

/* Clear X.25 virtual circuit */
int
x25clear() {
    int i;
    debug(F100,"X.25 clear","",0);
    bzero ((char *)&diag,sizeof(diag));
    diag.flags = (1 << DIAG_TYPE);
    diag.datalen = 2;
    diag.data[0] = 0;
    diag.data[1] = 0;
    ioctl (ttyfd,X25_WR_CAUSE_DIAG,&diag); /* Send Clear Request */
    return(ttclos(0));			/* Close socket */
}

/* X.25 status */
int
x25stat() {
    if (ttyfd == -1) return (-1);
    return(0);
}

/* Set Q_BIT on */
VOID
setqbit() {
    static int qbiton = 1 << Q_BIT;
    ioctl (ttyfd,X25_SEND_TYPE,&qbiton);
}

/* Set Q_BIT off */
VOID
resetqbit() {
    static int qbitoff = 0;
    ioctl (ttyfd,X25_SEND_TYPE,&qbitoff);
}

/* Read n characters from X.25 circuit into buf */

int
x25xin(n,buf) int n; CHAR *buf; {
    register int x, c;
    int qpkt;

    do {
	x = read(ttyfd,buf,n);
	if (buf[0] & (1 << Q_BIT)) { /* If Q_BIT packet, process it */
	    /* If return -1 : invitation to clear; -2 : PAD changes */
	    if ((c=qbitpkt(buf+1,x-2)) < 0) return(c);
	    qpkt = 1;
	} else qpkt = 0;
    } while (qpkt);

#ifdef COMMENT			/* Disabled by Stephen Riehm 19.12.97 */
    /* BUG!
     * if buf[] is full, then this null lands in nirvana!
     * I was unable to find any code which needs a trailing null in buf[]
     */
    if (x > 0) buf[x] = '\0';
#endif /* COMMENT */
    if (x < 1) x = -1;
    debug(F101,"x25xin x","",x);

    return(x);
}

#ifdef COMMENT /* NO LONGER NEEDED! */
/* X.25 read a line */

int
#ifdef PARSENSE
#ifdef CK_ANSIC
x25inl(CHAR *dest, int max,int timo, CHAR eol, CHAR start)
#else
x25inl(dest,max,timo,eol,start) int max,timo; CHAR *dest, eol, start;
#endif /* CK_ANSIC */
#else /* not PARSENSE */
#ifdef CK_ANSIC
x25inl(CHAR *dest, int max,int timo, CHAR eol)
#else
x25inl(dest,max,timo,eol) int max,timo; CHAR *dest, eol;
#endif /* __SDTC__ */
#endif /*PARSENSE */
 /* x25inl */ {
    CHAR *pdest;
    int pktype, goteol, rest, n;
    int i, flag = 0;
    extern int ttprty, ttpflg;
    int ttpmsk;

    ttpmsk = (ttprty) ? 0177 : 0377;	/* Set parity stripping mask */

    debug(F101,"x25inl max","",max);
    debug(F101,"x25inl eol","",eol);
    pdest  = dest;
    rest   = max;
    goteol = 0;
    do {
	n = read(ttyfd,pdest,rest);
	n--;
	pktype = *pdest & 0x7f;
	switch (pktype) {
	  case 1 << Q_BIT:
	    if (qbitpkt(pdest+1,--n) < 0) return(-2);
	    break;
	  default:
	    if (flag == 0) { /* if not in packet, search start */
		for (i = 1; (i < n) &&
		     !(flag = ((dest[i] & 0x7f) == start));
		     i++);
		if (flag == 0) { /* not found, discard junk */
		    debug(F101,"x25inl skipping","",n);
		    continue;
		} else {		/* found, discard junk before start */
		    int k;
		    n = n - i + 1;
		    for (k = 1; k <= n; k++, i++) dest[k] = dest[i];
		}
	    }
	    for (i = 0; (i < n) && /* search for eol */
		 !(goteol=(((*pdest = *(pdest+1)&ttpmsk)&0x7f)== eol));
		 i++,pdest++);
	    *pdest = '\0';
	    rest -= n;
	}
    } while ((rest > 0) && (!goteol));

    if (goteol) {
	n = max - rest;
	debug (F111,"x25inl X.25 got",(char *) dest,n);
	if (timo) ttimoff();
	if (ttpflg++ == 0 && ttprty == 0) {
	    if ((ttprty = parchk(dest,start,n)) > 0) {
		int j;
		debug(F101,"x25inl senses parity","",ttprty);
		debug(F110,"x25inl packet before",(char *)dest,0);
		ttpmsk = 0x7f;
		for (j = 0; j < n; j++)
		  dest[j] &= 0x7f; /* Strip parity from packet */
		debug(F110,"x25inl packet after ",dest,0);
	    } else {
		debug(F101,"parchk","",ttprty);
		if (ttprty < 0) { ttprty = 0; n = -1; }
	    }
	}
	ttimoff();
	return(n);
    }
    ttimoff();
    return(-1);
}
#endif /* COMMENT */
#endif /* SUNX25 */

#ifdef IBMX25
/*
 * IBM X25 support - using the NPI streams interface
 * written by Stephen Riehm, pc-plus, Munich Germany
 */

/* riehm: missing functions / TODO list */

/*
  x25intr() - Send an interrupt packet
*/

/* return an error message depending on packet type */
char *
x25err(n) int n; {
    static char buf[30];
    switch (n) {
      case NBADADDR:     return "invalid address";
      case NBADOPT:      return "invalid options";
      case NACCESS:      return "no permission";
      case NNOADDR:      return "unable to allocate address";
      case NOUTSTATE:    return "invalid state";
      case NBADSEQ:      return "invalid sequence number";
      case NSYSERR:      return "system error";
      case NBADDATA:     return "invalid data size";
      case NBADFLAG:     return "invalid flag";
      case NNOTSUPPORT:	 return "unsupported primitive";
      case NBOUND:       return "address in use";
      case NBADQOSPARAM: return "bad QOS parameters";
      case NBADQOSTYPE:	 return "bad QOS type";
      case NBADTOKEN:    return "bad token value";
      case NNOPROTOID:	 return "protocol id could not be allocated";
      case NODDCUD:      return "odd length call user data";
      default: (void) sprintf(buf, "Unknown NPI error %d", n); return buf;
    }
}

/* turn a meaningless primitive number into a meaningful primitive name */
char *
x25prim(n) int n; {
    static char buf[30];
    switch(n) {
      case N_BIND_ACK:     return "N_BIND_ACK";
      case N_BIND_REQ:     return "N_BIND_REQ";
      case N_CONN_CON:     return "N_CONN_CON";
      case N_CONN_IND:     return "N_CONN_IND";
      case N_CONN_REQ:     return "N_CONN_REQ";
      case N_CONN_RES:     return "N_CONN_RES";
      case N_DATACK_IND:   return "N_DATAACK_IND";
      case N_DATACK_REQ:   return "N_DATAACK_REQ";
      case N_DATA_IND:     return "N_DATA_IND";
      case N_DATA_REQ:     return "N_DATA_REQ";
      case N_DISCON_IND:   return "N_DISCON_IND";
      case N_DISCON_REQ:   return "N_DISCON_REQ";
      case N_ERROR_ACK:    return "N_ERROR_ACK";
      case N_EXDATA_IND:   return "N_EXDATA_IND";
      case N_EXDATA_REQ:   return "N_EXDATA_REQ";
      case N_INFO_ACK:     return "N_INFO_ACK";
      case N_INFO_REQ:     return "N_INFO_REQ";
      case N_OK_ACK:       return "N_OK_ACK";
      case N_OPTMGMT_REQ:  return "N_OPTMGMT_REQ";
      case N_RESET_CON:    return "N_RESET_CON";
      case N_RESET_IND:    return "N_RESET_IND";
      case N_RESET_REQ:    return "N_RESET_REQ";
      case N_RESET_RES:    return "N_RESET_RES";
      case N_UDERROR_IND:  return "N_UDERROR_IND";
      case N_UNBIND_REQ:   return "N_UNBIND_REQ";
      case N_UNITDATA_REQ: return "N_UNITDATA_REQ";
      case N_UNITDATA_IND: return "N_UNITDATA_IND";
      default: (void) sprintf(buf, "UNKNOWN (%d)", n); return buf;
    }
}

/*****************************************************************************
 * Function: x25getmsg()
 * Description:	get a STREAMS message, and check it for errors
 *
 * Parameters:
 * fd		- file descriptor to x25 device (opened)
 * control	- control buffer (pre-allocated)
 * ctl_size	- size of control buffer
 * data		- data buffer (pre-allocated)
 * data_size	- size of data buffer
 * flags	- flags for getmsg()
 * expected	- expected Primitive type
 *
 * Return Value:
 * 	>= 0	OK (size of data returned)
 * 	-1	error
 *
 */
int
x25getmsg( fd, control, ctl_size, data, data_size, get_flags, expected )
    int			fd;		/* X25 device (opened) */
    N_npi_ctl_t		*control;	/* control buffer (pre-allocated) */
    int			ctl_size;	/* size of control buffer */
    N_npi_data_t	*data;		/* data buffer (pre-allocated) */
    int			data_size;	/* size of data buffer */
    int			*get_flags;	/* getmsg() flags */
    int			expected;	/* expected primitive type */
/* x25getmsg */ {
    int			rc = 0;		/* return code */
    struct strbuf	*get_ctl=NULL;	/* getmsg control */
    struct strbuf	*get_data=NULL;	/* getmsg data */
    int			more = 0;	/* flag for more data etc */
    int			file_status = -1; /* file async status */
    N_npi_ctl_t		* result;	/* pointer to simplify switch() */
    int			packet_type = -1; /* unknown packet thus far */

#ifdef TRACE
    printf( "TRACE: entering x25getmsg\n" );
#endif /* TRACE */

    debug( F110, "x25getmsg waiting for packet ", x25prim( expected ), 0);
    /* prepare the control structures for getmsg */
    if (control) {
	if ((get_ctl = (struct strbuf*)malloc(sizeof(struct strbuf))) == NULL)
	  {
	      perror("kermit x25getmsg(): get_ctl malloc failed\n");
	      debug( F100, "x25getmsg malloc failed for get_ctl\n", "", 0);
	      return(-1);
	  }
	/* allow getmsg to return an unexpected packet type (which may be
	 * larger than the expected one)
	 */
	get_ctl->maxlen = NPI_MAX_CTL;
	get_ctl->len = 0;
	get_ctl->buf = (char *)control;
    } else {
	printf(
 "kermit x25getmsg(): internal error. control buffer MUST be pre-allocated!\n"
	       );
	debug(F100,"x25getmsg internal error. no buffer pre-allocated","",0);
	return( -1 );
    }
    if (data) {
	if ((get_data = (struct strbuf*)malloc(sizeof(struct strbuf))) == NULL)
	  {
	    perror("kermit x25getmsg(): get_data malloc failed\n");
	    debug( F100, "x25getmsg malloc failed for get_data\n", "", 0);
	    return(-1);
	}
	get_data->maxlen = (NPI_MAX_DATA < data_size ) ?
	  NPI_MAX_DATA :
	    data_size;
	get_data->len = 0;
	get_data->buf = (char *)data;
    }

    /* get an X.25 packet -
     * it may be any kind of packet, so check for special cases
     * it may be split into multiple parts - so loop if necessary
     */
    do {
#ifdef DEBUG
	printf( "kermit: x25getmsg(): getting a message\n" );
#endif /* DEBUG */
	errno = 0;
	if ((more = getmsg(fd, get_ctl, get_data, get_flags)) < 0) {
#ifdef DEBUG
	    printf( "kermit: x25getmsg(): getmsg returned an error\n" );
	    perror( "getmsg error was" );
#endif /* DEBUG */
	    debug(F101, "x25getmsg getmsg returned an error\n", "", errno);
	    if ((errno == EAGAIN) && (get_data && (get_data->len > 0)) ) {
		/* was in non-blocking mode, nothing to get, but we're
		 * already waiting for the rest of the packet -
		 * switch to blocking mode for the next read.
		 * file_status used to reset file status before returning
		 */
		if ((file_status = fcntl(fd, F_GETFL, 0)) < 0
		    || fcntl(fd, F_SETFL, file_status & ~O_NDELAY) < 0)
		  {
		      perror("x25getmsg(): couldn't change x25 blocking mode");
		      debug(F101,
			    "x25getmsg fcntl returned an error\n", "", errno);
		      /* netclos(); */
		      rc = -1;
		      break;
		  } else {
		      /* loop again into a blocking getmsg() */
		      continue;
		  }
	    } else {
		/* no data to get in non-blocking mode - return empty handed */
		perror( "x25getmsg(): getmsg failed" );
		debug(F101,"x25getmsg getmsg returned an error\n", "", errno);
		rc = -1;
		break;
	    }
	} else if (more & MORECTL) {
	    /* panic - the control information was larger than the
	     * maximum control buffer size!
	     */
	    /* riehm: close connection? */
#ifdef DEBUG
	    printf("x25getmsg(): received partial control packet - panic\n");
#endif /* DEBUG */
	    debug( F101, "x25getmsg getmsg bad control block\n", "", errno);
	    rc = -1;
	    break;
	}

	if (result = (N_npi_ctl_t *)control) {
	    packet_type = result->bind_ack.PRIM_type;
	    if (packet_type != N_OK_ACK) {
		x25lastmsg = packet_type;
	    }
	}
#ifdef DEBUG
	/* printf( "kermit: x25getmsg(): getting " ); */
	if (get_ctl->len > 0) {
	    x25dump_prim(result);
	}
	debug(F110,
	      "x25getmsg got packet ",
	      x25prim( result->bind_ack.PRIM_type ),
	      0
	      );
#endif /* DEBUG */

	if (get_ctl->len >= (int)sizeof(result->bind_ack.PRIM_type)) {
	    /* not as pretty as a switch(), but switch can't handle
	     * runtime variable values :-(
	     */
	    if (packet_type == expected ) {
		/* got what we wanted, special case for DATA_IND
		 * packets though */
		/* riehm: check Q-bit ? */
#ifdef DEBUG
		printf("x25getmsg(): got expected packet\nrc is %d\n", rc);
#endif /* DEBUG */
		if (packet_type == N_DATA_IND ) {
		    /* data received. May be incomplete, even though
		     * getmsg returned OK
		     */
		    if (result->data_ind.DATA_xfer_flags & N_MORE_DATA_FLAG)
			more |= MOREDATA;
		    if (result->data_ind.DATA_xfer_flags & N_RC_FLAG)
			printf( "x25getmsg(): data packet wants ack\n" );
		}
	    } else if( packet_type == N_DISCON_IND) {
		printf( "X25 diconnected\n" );
		/* riehm: need to acknowledge a disconnection? */
		x25clear();
		/* x25unbind( ttyfd ); */
		rc = -1;
	    } else if( packet_type == N_ERROR_ACK) {
		errno = result->error_ack.UNIX_error;
		perror( "X25 error received" );
		rc = -1;
	    } else {
		printf("x25getmsg(): failed %s\n", x25err(packet_type));
		rc = -1;
	    }
	}
#ifdef COMMENT
	else {
	    /* Panic - no control data */
	    printf( "kermit: x25getmsg(): no control data with packet\n" );
	    rc = -1;
	}
#endif /* COMMENT */

	if (get_data && (get_data->len >= 0)) {
	    get_data->buf += get_data->len;
	    get_data->maxlen -= get_data->len;
	}
    } while ((rc == 0)
	     && (get_data && (get_data->maxlen > 0))
	     && (more & MOREDATA)
	     );

    /* return the file status to its original value, unless its still
     * set to -1, or one of the fcntl's failed */
    if ((file_status >= 0) && fcntl(fd, F_SETFL, file_status) < 0)
        rc = -1;

    /*
     * Verify that we received an expected primitive
     * there is apparantly an error case where the primitive is set
     * correctly, but there is not enough data in the control structure
     */
    if ((packet_type != expected) && (get_ctl->len >= ctl_size) ) {
	fprintf(stderr,
		"x25getmsg(): %s NOT received. Primitive received was %s\n",
		x25prim( expected ), x25prim( packet_type ));
	debug(F110, "x25getmsg got an unexpected packet ",
	      x25prim(packet_type),
	      0
	      );
	rc = -1;
    }

    if (rc == 0) {
	if (get_data && ( get_data->len >= 0)) {
	    rc = get_data->len;
	}
    }

    if (get_ctl)  { free(get_ctl); get_ctl = NULL; }
    if (get_data) { free(get_data); get_data = NULL; }

#ifdef COMMENT
#ifdef DEBUG
    printf( "kermit x25getmsg(): returning %d\n", rc );
#endif /* DEBUG */
#endif /* COMMENT */
    debug(F110, "x25getmsg returning packet ", x25prim( packet_type ), 0);

#ifdef TRACE
    printf( "TRACE: leaving x25getmsg\n" );
#endif /* TRACE */
    return(rc);
}

/*****************************************************************************
 * Function: x25putmsg()
 *
 * Description:
 * 	send a message to a X25 STREAM
 *
 * Parameters:
 *	fd		- file descriptor to x25 device (opened)
 *	control		- control buffer (pre-allocated)
 *	data		- data buffer (pre-allocated)
 *	data_len	- length of data to be transmitted
 *	put_flags	- flags for putmsg()
 *
 * Return Value:
 * 	>= 0	number of bytes transmitted
 * 	-1	error
 */
int
x25putmsg(fd, control, data, data_len, put_flags)
    int			fd;		/* X25 device (opened) */
    N_npi_ctl_t		*control;	/* control buffer (pre-allocated) */
    N_npi_data_t	*data;		/* data buffer (pre-allocated) */
    int			data_len;	/* length of data (not the size of
					   the buffer) */
    int			*put_flags;	/* putmsg() flags */
/* x25putmsg */ {
    int			rc = 0;		/* return code */
    ulong		type;		/* primitive type */
    struct strbuf	*put_ctl = NULL; /* putmsg control */
    struct strbuf	*put_data = NULL; /* putmsg data */

#ifdef TRACE
    printf( "TRACE: entering x25putmsg\n" );
#endif /* TRACE */

#ifdef DEBUG
    printf( "kermit: x25putmsg(): putting " );
    x25dump_prim( control );
    printf( "\tdata:\t\t" );
    x25dump_data( data, 0, data_len );
    debug(F110,"x25putmsg: putting packet ",x25prim(control->PRIM_type),0);
#endif /* DEBUG */

    if (control) {
	put_ctl = (struct strbuf *)malloc( sizeof( struct strbuf ) );
	if (put_ctl == NULL) {
	    perror("kermit x25putmsg(): put_ctl malloc failed\n");
	    return(-1);
	}
	put_ctl->maxlen = 0;			/* unused by putmsg */
	put_ctl->len = NPI_MAX_CTL;
	put_ctl->buf = (char *)control;
    }
    if (data && ( data_len > 0)) {
	put_data = (struct strbuf *)malloc( sizeof( struct strbuf ) );
	if( put_data == NULL) {
	    perror("kermit x25putmsg(): put_data malloc failed\n");
	    return(-1);
	}
	put_data->maxlen = 0;			/* unused by putmsg */
	put_data->len = data_len;
	put_data->buf = (char *)data;
    }

    errno = 0;
    rc = putmsg (fd, put_ctl, put_data, 0);
    if (rc < 0) {
	printf("x25putmsg(): couldn't put %s\n",x25prim(control->PRIM_type));
	perror("kermit: x25putmsg(): putmsg failed");
	return(-1);
    }

    /* riehm: this should perhaps be discounted! */
    x25lastmsg = control->PRIM_type;

#ifdef COMMENT
#ifdef DEBUG
    printf( "kermit debug: x25putmsg() returning %d\n", data_len );
#endif /* DEBUG */
#endif /* COMMENT */
    debug( F101, "x25putmsg block size put ", "", data_len);

#ifdef TRACE
    printf( "TRACE: leaving x25putmsg\n" );
#endif /* TRACE */

    return( data_len );
}

/*****************************************************************************
* Function: x25bind
* Description:  The bind submitted to NPI provides the information required
*               by the packet layer for it to listen for suitable incoming
*               calls.
*
* WARNING:
*
* This routine needs to be called in a completely different manner for
* the client and server side. When starting a client, the
* num_waiting_calls and CUD information should all be set to 0! The
* client's CUD must be inserted in the CONN_REQ data block.
* When starting a server, the CUD must be set to a CUD pattern, and
* the number of waiting calls should be set to a number other than 0.
* (num waiting calls is the number of incomming calls which are to be
* put on hold while the server is servicing another client.)
*
* Who invented this crap?
*
* Parameters:
*	fd		- X25 device (opened)
*	addr		- local address
*	cud		- User Data (null terminated)
*	cud_len		- User Data length
*	num_waiting_calls - number of outstanding calls allowed on this stream
*	line		- logical port number (1)
*	flags		- 0, DEFAULT_LISTENER or TOKEN_REQUEST
*
* Return Value:
* 	if binding is successful, 0 is returned for a client, and a token is
* 	returned for a server
*
* Return code: 0 if successful
*              -1 if unsuccessful
*****************************************************************************/

ulong
x25bind(fd, addr, cud, cud_len, num_waiting_calls, line, bind_flags)
    int fd;				/* X25 device (opened) */
    char * addr;			/* local address */
    char * cud;				/* Call User Data (null terminated) */
    int cud_len;			/* User Data length */
    int num_waiting_calls;		/* Outstanding calls allowed */
    int line;				/* logical port number */
    ulong bind_flags;		/* 0, DEFAULT_LISTENER or TOKEN_REQUEST */
/* x25bind */ {
    ulong rc;				/* return code */
    int get_flags;			/* priority flag passed to getmsg */
    int put_flags = 0;			/* output flags for putmsg, always 0 */
    ulong type;				/* primitive type */
    N_bind_req_t *bind_req;		/* pointer to N_BIND_REQ primitive */
    N_bind_ack_t *bind_ack;		/* pointer to N_BIND_ACK primitive */
    char *addtl_info;			/* pointer to info in addition to
					 * the N_BIND_REQ primitive that is 
					 * passed in the control structure 
					 * to putmsg */
    int addr_len = 0;			/* length of address string */
    ulong bind_req_t_size;		/* for debugging only */

#ifdef TRACE
    printf("TRACE: entering x25bind\n" );
#endif /* TRACE */

#ifdef DEBUG
    printf("TRACE: x25bind( %d, %s, %s, %d, %d )\n",
	   fd, addr, cud, line, bind_flags
	   );
#endif /* DEBUG */

    /*
     * Allocate  and zero out space to hold the control portion of the
     * message passed to putmsg. This will contain the N_BIND_REQ
     * primitive and any additional info required for that.
     *
     * Note: allocated space is the size of the union typedef
     * N_npi_ctl_t to allow the use fo the generic x25putmsg routine.
     */
    bind_req = (N_bind_req_t *) malloc(sizeof( N_npi_ctl_t));
    if (bind_req == NULL) {
	perror("kermit: x25bind(): bind_req malloc failed");
	debug(F100, "x25bind bind_req malloc failed", "", 0);
	return(-1);
    }
    bzero((char *)bind_req, sizeof(N_npi_ctl_t));

    /* Build the Bind Request Primitive */
    bind_req->PRIM_type = (ulong) N_BIND_REQ;

    /* Note that the address length is n+2 and NOT n. Two bytes MUST preceed
     * the actual address in an N_BIND_REQ. The first byte contains the
     * line number being used with this address, and the second byte is the
     * X.121 address prefix, which must be zero.
     */
    addr_len = strlen(addr);
    bind_req->ADDR_length = (ulong) (addr_len + 2);
    bind_req->ADDR_offset = (ulong)(sizeof(N_bind_req_t));
    bind_req->CONIND_number = (ulong)num_waiting_calls;	/* server only */
    bind_req->BIND_flags = (ulong) bind_flags; /* 0 in client */
    bind_req->PROTOID_length = (ulong) cud_len; /* 0 in client */
    if (cud_len == 0) {
	bind_req->PROTOID_offset = (ulong) 0;
    } else {
	/* need to remember the trailing NULL in the address - not
	 * counted in the address length
	 */
	bind_req->PROTOID_offset
	  = (ulong) (sizeof(N_bind_req_t) + bind_req->ADDR_length);
    }

    /*
     * Now fill in the additional information required with this primitive
     * (address and protocol information (Call User Data))
     */
    addtl_info = (char *) ((void *)bind_req + bind_req->ADDR_offset);
    /*
     * The bitwise "&" ensures that the line number is only one byte long
     */
    *addtl_info++ = (char) line & 0xff;
    *addtl_info++ = (char) 0; /* X.121 format */
    bcopy( addr, addtl_info, addr_len ); /* include trailing null */
    addtl_info += addr_len;
    if (cud_len > 0)
      bcopy( cud, addtl_info, cud_len );
    /*
     * Call putmsg() to put the bind request message on the stream
     */
    if (x25putmsg(fd,
		  (N_npi_ctl_t*)bind_req,
		  (N_npi_data_t *)NULL,
		  0,
		  &put_flags
		  ) < 0) {
	printf( "kermit: x25bind(): x25putmsg failed\n" );
	return(-1);
    }

    /*
     * Allocate and zero out space for the N_BIND_ACK primitive
     */
    bind_ack = (N_bind_ack_t *) malloc(sizeof(N_npi_ctl_t));
    if (bind_ack == NULL){
	perror("kermit: x25bind(): bind_ack malloc failed");
	return(-1);
    }
    bzero(bind_ack, sizeof(N_npi_ctl_t));
    /*
     * Initialize the control structure and flag variable sent to getmsg
     */
    get_flags=0;

    /* get the ACK for the bind */
#ifdef DEBUG
    printf( "kermit: x25bind() trying to get a BIND_ACK\n" );
#endif /* DEBUG */
    rc = (ulong)x25getmsg( fd, (N_npi_ctl_t*)bind_ack,
	    (int)sizeof( N_bind_ack_t ), (N_npi_data_t*)NULL, 0, &get_flags,
	    N_BIND_ACK );

    /* turn quantitive return code into a qualitative one */
    if (rc > 0) rc = 0;

    /* if all went well, get the token from the acknowledgement packet */
    if ((bind_flags & TOKEN_REQUEST ) && ( rc >= 0)) {
	rc = bind_ack->TOKEN_value;
    }

    /* free up the memory we allocated earlier */
    free(bind_req);
    free(bind_ack);

#ifdef TRACE
    printf( "TRACE: leaving x25bind\n" );
#endif /* TRACE */

    return( rc );
}

/*****************************************************************************
* Function: x25call
* Description:  This routine builds and sends an N_CONN_REQ primitive, then
*		checks for an N_CONN_CON primitive in return.
*
* Parameters:
* fd	- file descriptor of stream
* caddr	- called address (remote address)
*
* Functions Referenced:
* malloc()
* bzero()
* getmsg()
* putmsg()
*
* Return code:
* 0 - if successful
* -1 if not successful
*****************************************************************************/
int
x25call(fd, remote_nua, cud)
    int fd;				/* X25 device (opened) */
    char * remote_nua;			/* remote address to call */
    char * cud;				/* call user data */
/* x25call */ {
    int rc;				/* return code */
    int flags;				/* Connection flags */
    int get_flags;			/* priority flags for getmsg */
    ulong type;				/* primitive type */
    N_conn_req_t *connreq_ctl;		/* pointer to N_CONN_REQ primitive */
    N_npi_data_t *connreq_data;		/* pointer to N_CONN_REQ data (CUD) */
    int connreq_data_len;		/* length of filled data buffer */
    N_conn_con_t *conncon_ctl;		/* pointer to N_CONN_CON primitive */
    N_npi_data_t *conncon_data;		/* pointer to any data associated with
					 * the N_CONN_CON primitive */
    char *addtl_info;			/* pointer to additional info needed
					 * for N_CONN_REQ primitive */
    int addr_len;			/* length of address */

#ifdef TRACE
    printf( "TRACE: entering x25call\n" );
#endif /* TRACE */

#ifdef DEBUG
    printf( "x25call( %d, %s )\n", fd, remote_nua );
    printf( "connecting to %s on fd %d\n", remote_nua, fd );
#endif /* DEBUG */

    /*
     * Allocate and zero out space for the N_CONN_REQ primitive
     * use the size of the generic NPI primitive control buffer
     */
    connreq_ctl  = (N_conn_req_t *) malloc(sizeof(N_npi_ctl_t));
    if (connreq_ctl == NULL){
	perror("kermit: x25call(): connreq_ctl malloc failed");
	return(-1);
    }
    bzero(connreq_ctl,sizeof(N_npi_ctl_t));
    /*
     * Build the Connection Request Primitive
     */
    flags = 0;
    connreq_ctl->PRIM_type = (ulong) N_CONN_REQ;

    /* Note that the address length is nchai+1 and not n+2. The line number
     * is only passed with the address for the bind. The first byte of
     * the address for the N_CONN primitives contains the X.121
     * address prefix, which must be zero. The remaining bytes are the
     * address itself.
     */
    addr_len = strlen( remote_nua );
    connreq_ctl->DEST_length = (ulong) (addr_len + 1);
    connreq_ctl->DEST_offset = (ulong) sizeof(N_conn_req_t);
    /* connreq_ctl->CONN_flags = (ulong)EX_DATA_OPT | REC_CONF_OPT; */
    connreq_ctl->CONN_flags = (ulong) 0;
    connreq_ctl->QOS_length = (ulong) 0;	/* unsupported in AIX 4.1 */
    connreq_ctl->QOS_offset = (ulong) 0;	/* unsupported in AIX 4.1 */

    addtl_info = (char *) ((void*)connreq_ctl + connreq_ctl->DEST_offset);
    *addtl_info++ = (char) 0; /* X.121 format */
    bcopy( remote_nua, addtl_info, addr_len );

    /*
     * setup the data buffer for the connection request
     */
    connreq_data  = (N_npi_data_t *) malloc(sizeof(N_npi_data_t));
    if (connreq_data == NULL){
	perror("kermit: x25call(): connreq_data malloc failed");
	return(-1);
    }
    bzero(connreq_data,sizeof(N_npi_data_t));

    /* facility selection needs to be put in the front of connreq_data */
    connreq_data_len = 0;
    connreq_data_len += x25facilities( (char *)connreq_data );
    if (cud && *cud) {
	bcopy(cud,
	      (char *)((char *)connreq_data + connreq_data_len),
	      strlen(cud)
	      );
	connreq_data_len += strlen( cud );
	}

    /*
     * Call putmsg() to put the connection request message on the stream
     */
    rc = x25putmsg( fd, (N_npi_ctl_t*)connreq_ctl, connreq_data,
	    connreq_data_len, &flags );
    if (rc < 0) {
	return(-1);
    }

    /*
     * Allocate and zero out space for the N_CONN_CON primitive
     */
    if ((conncon_ctl = (N_conn_con_t *) malloc(sizeof(N_npi_ctl_t))) == NULL) {
	perror("kermit: x25call(): conncon_ctl malloc failed");
	return(-1);
    }
    bzero(conncon_ctl, sizeof(N_npi_ctl_t));

    /*
     * Allocate and zero out space for any data associated with N_CONN_CON
     */
    if ( (conncon_data = (N_npi_data_t *) malloc(NPI_MAX_DATA)) == NULL) {
 	perror("kermit: x25call(): conncon_data malloc failed");
	return(-1);
    }
    bzero(conncon_data, NPI_MAX_DATA);

    /* Initialize and build the structures for getmsg */
    get_flags=0;

    rc = x25getmsg( fd, (N_npi_ctl_t*)conncon_ctl, (int)sizeof( N_conn_con_t ),
	    conncon_data, NPI_MAX_DATA, &get_flags, N_CONN_CON );

    /* turn quantitive return code into a qualitative one */
    if (rc > 0) rc = 0;

    /* Free the space that we no longer need */
    if (connreq_ctl) { free(connreq_ctl); connreq_ctl = NULL; }
    if (conncon_ctl) { free(conncon_ctl); conncon_ctl = NULL; }
    if (conncon_data) { free(conncon_data); conncon_data = NULL; }

#ifdef TRACE
    printf( "TRACE: leaving x25call\n" );
#endif /* TRACE */

    return(rc);
}

/*****************************************************************************
 * Function: x25getcall
 *
 * Description: This routine checks for an incomming call, verified
 * that it is a CONNIND (connection indication) message, and then
 * accepts the call and returns the file descriptor of the new stream
 *
 * Parameters:
 * fd	- file descriptor of listening stream
 *
 * Return Codes:
 * callfd	- file descriptor of connected incomming call.
 *		- set to -1 if an error occured
 *
 *****************************************************************************/
int
x25getcall(fd) int fd; {
    int x25callfd;			/* fd of incomming call */
    N_conn_ind_t *connind_ctl;		/* connind controll buffer */
    N_npi_data_t *connind_data;		/* connind data buffer */
    int get_flags;			/* flags for getmsg */
    ulong flags;			/* connection flags */
    int rc;				/* return code */

    extern x25addr_t remote_nua;	/* remote X.25 addr global var */

#ifdef TRACE
    printf( "TRACE: entering x25getcall\n" );
#endif /* TRACE */

    /* allocate space for connection indication buffers */
    if ((connind_ctl = (N_conn_ind_t *)malloc(sizeof(N_npi_ctl_t))) == NULL) {
	perror("kermit: x25getcall(): connind_ctl malloc failed");
	return (-1);
    }
    bzero(connind_ctl, sizeof(N_npi_ctl_t));

    if ((connind_data = (N_npi_data_t *)malloc(NPI_MAX_DATA)) == NULL) {
	perror("kermit: x25getcall(): connind_data malloc failed");
	return (-1);
    }
    bzero(connind_data, NPI_MAX_DATA);

    /* initialise control structures */
    get_flags = 0;

    /* call getmsg to check for a connection indication */
    if (x25getmsg(fd,
		  (N_npi_ctl_t*)connind_ctl,
		  (int)sizeof(N_conn_ind_t),
		  connind_data,
		  NPI_MAX_DATA,
		  &get_flags,
		  N_CONN_IND
		  ) < 0) {
#ifdef DEBUG
	printf( "x25getcall(): errno is: %d\n", errno );
#endif /* DEBUG */
	perror ("x25getcall(): getmsg failed");
	return(-1);
    }

    /* a connection indication was received
     * - pull it to bits and answer the call
     */
    x25seqno = connind_ctl->SEQ_number;
    flags = connind_ctl->CONN_flags;
#ifdef DEBUG
    printf( "setting remote_nua to a new value due to incomming call\n" );
#endif /* DEBUG */
    /*
     * no guarantee that the address is null terminated, ensure that
     * after copying that it is (assumption: remote_nua is longer than
     * the address + 1)
     */
    bzero(remote_nua, sizeof(remote_nua));
    /* note: connind_ctl contains a x121 address, which has a null as
     * the FIRST character - strip it off!
     */
    strncpy(remote_nua,
	    (char*)((char*)connind_ctl + connind_ctl->SRC_offset + 1),
	    connind_ctl->SRC_length - 1
	    );
#ifdef DEBUG
    printf( "remote_nua set to new value of %s\n", remote_nua );
#endif /* DEBUG */

    /* errors handled by callee */
    x25callfd = x25accept(x25seqno, flags);

    /* free the malloc'd buffers */
    if (connind_ctl) { free(connind_ctl); connind_ctl = NULL; }
    if (connind_data) { free(connind_data); connind_data = NULL; }

#ifdef TRACE
    printf( "TRACE: leaving x25getcall\n" );
#endif /* TRACE */

    /* return the file descriptor (or error if < 0) */
    return( x25callfd );
}

/*****************************************************************************
 * Function: x25accept
 *
 * Description: accept an incomming call
 *		This essentially means opening a new STREAM and sending
 *		an acknowledge back to the caller.
 *
 * Parameters:
 *	seqno	- sequence number for acknowledgement
 *	flags	- flags passed to us by the caller
 *
 * Return Codes:
 * 	fd	- file descriptor of new STREAM
 *		  set to -1 if an error occured
 *
 *****************************************************************************/
int
x25accept(seqno,flags)
    ulong seqno;			/* connection sequence number */
    ulong flags;			/* connection flags */
/* x25accept */ {
    int x25callfd;			/* fd for incomming call */
    int get_flags;			/* priority flags for getmsg */
    int put_flags = 0;			/* flags for putmsg, always 0 */
    int addr_len;			/* length of local address */
    ulong token;			/* connection token */
    N_conn_res_t *conn_res;		/* N_CONN_RES primitive */
    N_ok_ack_t *ok_ack;			/* N_OK_ACK primitive */
    char *addtl_info;			/* temp pointer */
    int rc;				/* temporary return code */

/* global variables from ckcmai.c */
    extern int revcall, closgr, cudata;
    extern char udata[];
    extern x25addr_t local_nua;		/* local X.25 address */
    extern char x25name[];		/* x25 device name (sx25a0) */
    extern char x25dev[];		/* x25 device file /dev/x25pkt */
    extern int x25port;			/* logical port to use */
    ulong bind_flags = 0;		/* flags for binding the X25 stream */

#ifdef TRACE
    printf( "TRACE: entering x25accept\n" );
#endif /* TRACE */

    /* open a new packet level stream */
    if ((x25callfd = open(x25dev, O_RDWR)) < 0) {
	perror ("kermit: x25accept(): X.25 device open error");
	debug(F101,"x25accept() device open error","",errno);
	return(-1);
    }

    /* push the NPI onto the STREAM */
    if (ioctl(x25callfd,I_PUSH,"npi") < 0) {
	perror( "kermit: x25accept(): couldn't push npi on the X25 stream" );
	debug(F101,"x25accept can't push npi on the X25 stream","",errno);
	return (-1);
    }

    /* bind kermit server to the local X25 address */
    /* taken from /usr/samples/sx25/npi/npiserver.c (AIX 4) */
    bind_flags |= TOKEN_REQUEST;
    token = x25bind(x25callfd,local_nua,(char *)NULL,0,0,x25port,bind_flags);
    if (token < 0) {
	printf( "kermit: x25accept(): couldn't bind to local X25 address\n" );
	netclos();
	return(-1);
    }

    /* allocate connection response primitive */
    if ((conn_res = (N_conn_res_t *)malloc( NPI_MAX_CTL )) == NULL) {
	perror("kermit: x25accept(): conn_res malloc failed");
	return (-1);
    }
    bzero((char *)conn_res, NPI_MAX_CTL);

    /* setup connection response primitive */
    addr_len = strlen( local_nua );
    conn_res->PRIM_type = (ulong)N_CONN_RES;
    conn_res->TOKEN_value = token;
    /* note address length is n+1 to accomodate the X.121 address prefix */
    conn_res->RES_length = (ulong)(addr_len + 1);
    conn_res->RES_offset = (ulong)sizeof( N_conn_res_t );
    conn_res->SEQ_number = seqno;
    conn_res->CONN_flags = 0;
    conn_res->QOS_length = 0;		/* unsupported - must be 0 (!?) */
    conn_res->QOS_offset = 0;

    addtl_info = (char *)((char *)conn_res + conn_res->RES_offset);
    *addtl_info++ = (char)0;	/* X.121 address prefix */
    bcopy( local_nua, addtl_info, addr_len );

    /*
     * send off the connect response
     */
    if (x25putmsg(x25callfd,
		  (N_npi_ctl_t*)conn_res,
		  (N_npi_data_t *)NULL,
		  0,
		  &put_flags
		  ) < 0 ) {
	perror("kermit: x25accept(): putmsg connect response failed");
	return(-1);
    }

    /*
     * Allocate and zero out space for the OK_ACK primitive
     */
    if ((ok_ack = (N_ok_ack_t *) malloc(sizeof(N_npi_ctl_t))) == NULL) {
	perror("kermit: x25call(): ok_ack malloc failed");
	return(-1);
    }
    bzero(ok_ack, sizeof(N_npi_ctl_t));

    /* Initialize and build the structures for getmsg */
    get_flags=0;

    rc = (int)x25getmsg(x25callfd,
			(N_npi_ctl_t*)ok_ack,
			(int)sizeof(N_ok_ack_t),
			(N_npi_data_t*)NULL,
			0,
			&get_flags,
			N_OK_ACK
			);
    if (rc == 0) {
	/* sequence number is only for disconnecting when not connected !? */
	x25seqno = 0;
    }

    /* free up malloc'ed buffer space */
    if (conn_res) { free(conn_res); conn_res = NULL; }
    if (ok_ack) { free(ok_ack); ok_ack = NULL; }

#ifdef TRACE
    printf( "TRACE: leaving x25accept\n" );
#endif /* TRACE */

    return( ( rc >= 0 ) ? x25callfd : -1 );
}

/*****************************************************************************
 * Function: x25unbind
 *
 * Description:  This subroutine builds and sends an unbind request and gets
 * the acknowledgement for it.
 *
 * Parameters:
 * fd - File descriptor of the stream
 *
 * Functions Referenced:
 * getmsg()
 * putmsg()
 * malloc()
 * bzero()
 *
 * Return code:
 * 0 - if successful
 * -1 - if not successful
 *****************************************************************************/
int
x25unbind(fd) int fd; {			/* X25 device (opened) */
    int rc;				/* return code */
    int flags;				/* bind flags */
    int get_flags;			/* priority flag for getmsg */
    ulong type;				/* primitive type */
    N_unbind_req_t *unbind_req;		/* pointer to N_UNBIND_REQ */
    N_ok_ack_t *ok_ack;			/* pointer to N_OK_ACK */

#ifdef TRACE
    printf( "TRACE: entering x25unbind\n" );
#endif /* TRACE */

#ifdef DEBUG
    /* printf( "x25unbind( %d )\n", fd ); */
#endif /* DEBUG */
    debug(F101,"x25unbind closing x25 connection #","",fd);

    /* Allocate and zero out space to hold the N_UNBIND_REQ primitive */
    unbind_req = (N_unbind_req_t *) malloc(sizeof(N_npi_ctl_t));
    if (unbind_req == NULL) {
	perror("kermit: x25unbind(): unbind_req malloc failed");
	return(-1);
    }
    bzero(unbind_req, sizeof(N_npi_ctl_t));

    /*
     * Build the Unbind Request Primitive
     */
    flags = 0;
    unbind_req->PRIM_type = (ulong) N_UNBIND_REQ;

    /*
     * Call putmsg() to put the bind request message on the stream
     */
    if (x25putmsg(fd,
		  (N_npi_ctl_t*)unbind_req,
		  (N_npi_data_t *)NULL,
		  0,
		  &flags
		  ) < 0) {
	perror ("kermit: x25unbind(): putmsg failed");
	return(-1);
    }

    /* Allocate and Zero out space for the N_OK_ACK primitive */
    ok_ack = (N_ok_ack_t *) malloc(sizeof(N_npi_ctl_t));
    if (ok_ack == NULL) {
	perror("kermit x25unbind(): ok_ack malloc failed\n");
	return(-1);
    }
    bzero(ok_ack, sizeof(N_npi_ctl_t));

    /* Initialize and build the control structure for getmsg */
    get_flags=0;

    /* Call getmsg() to check for an acknowledgement */
    rc = x25getmsg(fd,
		   (N_npi_ctl_t*)ok_ack,
		   (int)sizeof(N_ok_ack_t),
		   (N_npi_data_t*)NULL,
		   0,
		   &get_flags,
		   N_OK_ACK
		   );
    if (rc < 0) {
	perror ("kermit: x25unbind: getmsg failed");
	return(-1);
    }

    /* Free up the space that we no longer need */
    if (unbind_req) { free(unbind_req); unbind_req = NULL; }
    if (ok_ack) { free(ok_ack); ok_ack = NULL; }

#ifdef TRACE
    printf( "TRACE: leaving x25unbind\n" );
#endif /* TRACE */

    return(0);
}

/*****************************************************************************
 * Function: x25xin
 *
 * Description:
 * 	Read n characters from X.25 circuit into buf (AIX only)
 *
 * Parameters:
 * 	data_buf_len	maximum size of data buffer
 * 	data_buf	pointer to pre-allocated buffer space
 *
 * Return Value:
 * 	the number of characters actually read
 */
int
x25xin(data_buf_len,data_buf) int data_buf_len; CHAR *data_buf; {
    struct strbuf getmsg_ctl;		/* streams control structure */
    struct strbuf getmsg_data;		/* streams data structure */
    int rc = 0;				/* return code */
    int getmsg_flags;			/* packet priority flags */
    char * ctl_buf;			/* npi control buffer */
    N_npi_ctl_t	* result;		/* pointer to simplify switch() */

#ifdef TRACE
    printf( "TRACE: entering x25xin\n" );
#endif /* TRACE */

    /* ensure that no maximum's are overridden */
    data_buf_len = (NPI_MAX_DATA < data_buf_len) ? NPI_MAX_DATA : data_buf_len;

    /* allocate space for packet control info */
    if ((ctl_buf = (char *)malloc(NPI_MAX_CTL)) == NULL) {
	perror( "kermit: x25xin(): ctl_buf malloc" );
	return(-1);
    }
#ifdef COMMENT
    /* riehm: need zeroed buffer for getmsg? */
    bzero( ctl_buf, NPI_MAX_CTL );
    /* clear data buffer */
    bzero( data_buf, data_buf_len );
#endif /* COMMENT */

    getmsg_flags = 0;			/* get the first packet available */

    rc = x25getmsg(ttyfd,
		   ctl_buf,
		   NPI_MAX_CTL,
		   data_buf,
		   data_buf_len,
		   &getmsg_flags,
		   N_DATA_IND
		   );
#ifdef COMMENT
#ifdef DEBUG
    if (rc >= 0) {
	printf( "kermit: x25xin(): got " );
	x25dump_data( data_buf, 0, rc );
    } else {
	printf( "x25xin(): attempt to get data resulted in an error\n" );
    }
#endif /* DEBUG */
#endif /* COMMENT */

    /* free buffers */
    if (ctl_buf) { free(ctl_buf); ctl_buf = NULL; }

#ifdef TRACE
    printf( "TRACE: leaving x25xi\n" );
#endif /* TRACE */

    return(rc);
}

/*****************************************************************************
 * Function: x25write
 *
 * Description:
 * 	write a block of characters to the X25 STREAM (AIX)
 *
 * Parameters:
 * 	fd		file descriptor to write to
 * 	databuf		buffer containing data to write
 * 	databufsize		size of the buffer to write
 *
 * Return Value:
 * 	size		the number of bytes actually transmitted
 */
int
x25write(fd, databuf, databufsize)
    int		fd;		     /* X25 STREAMS file descriptor (ttyfd) */
    char	*databuf;		/* buffer to write */
    int		databufsize;		/* buffer size */
/* x25write */ {
    N_data_req_t *data_req_ctl;
    int rc;				/* return code (size transmitted) */
    int write_flags = 0;		/* always 0 !? */
 
#ifdef TRACE
    printf( "TRACE: entering x25write\n" );
#endif /* TRACE */

    if ((data_req_ctl = (N_data_req_t *)malloc(NPI_MAX_CTL) ) == NULL) {
	perror( "kermit: x25write(): data_req_ctl malloc" );
	return(-1);
    }
    data_req_ctl->PRIM_type = N_DATA_REQ;
    data_req_ctl->DATA_xfer_flags = 0;

    /* riehm: possible extension
     * possibly need to think about splitting up the data buffer
     * into multiple parts if databufsize > NPI_MAX_DATA
     */

#ifdef COMMENT
#ifdef DEBUG
    printf( "kermit: x25write(): writing data to x25 stream\n" );
    printf( "\tdata:\t" );
    x25dump_data(databuf, 0, databufsize);
#endif /* DEBUG */
#endif /* COMMENT */
    rc = x25putmsg(fd,
		   (N_npi_ctl_t*)data_req_ctl,
		   (N_npi_data_t*)databuf,
		   databufsize,
		   &write_flags
		   );
    if (data_req_ctl) { free(data_req_ctl);  data_req_ctl = NULL; }

#ifdef TRACE
    printf( "TRACE: leaving x25write\n" );
#endif /* TRACE */

    return(rc);
}

/*****************************************************************************
 * Function: x25local_nua
 *
 * Description:
 * 	This routine is only interesting for IBM computers. In order
 * 	to set up a connection (see x25bind()) you need to know the
 * 	local NUA (x25 address). Unfortunately, you need all this code
 * 	to find that out, I just hope this works for everyone else!
 *
 * Parameters:
 *	a pre-allocated character buffer, long enough to hold an X.25 address
 *	and the tailing null.
 *
 * Return Value:
 *	the length of the address string.
 *	0 = error
 */
int
x25local_nua(char *buf) {
    struct CuAt	*response;	/* structure to fill with info from ODM */
    CLASS_SYMBOL retClass;	/* ODM class */
    char query[64];		/* odm database query */
    int rc = 0;			/* return value (length of local NUA) */
    extern char	x25name[];	/* x25 device name (sx25a0) */

#ifdef TRACE
    printf( "TRACE: entering x25local_nua\n" );
#endif /* TRACE */

    /* set up query string */
    if (x25name[0] == '\0') {
#ifdef DEBUG
	printf( "kermit: x25local_nua(): No x25 device set, trying sx25a0\n" );
#endif /* DEBUG */
	strcpy( x25name, "sx25a0" );
    }
    sprintf(query, "name like %s and attribute like local_nua", x25name);

    /* initialise ODM database */
    odmerrno = 0;
    if (odm_initialize() == -1) {
	printf( "x25local_nua(): can't initialize ODM database");
	switch (odmerrno) {
	  case ODMI_INVALID_PATH:
	    printf( "invalid path\n" );
	    break;
	  case ODMI_MALLOC_ERR:
	    printf( "malloc failed\n" );
	    break;
	  default:
	    printf( "unknown error %d\nPlease call IBM\n", odmerrno );
	}
	return(rc);
    }

    /* open the CuAt class */
    retClass = odm_open_class(CuAt_CLASS);
    if (((int)retClass) == -1) {
	printf( "kermit: x25local_nua(): can't open CuAt class in odm. " );
	switch (odmerrno) {
	  case ODMI_CLASS_DNE:
	    printf( "CuAt class doesn't exist\n" );
	    break;
	  case ODMI_CLASS_PERMS:
	    printf( "permission to CuAt class file denied\n" );
	    break;
	  case ODMI_MAGICNO_ERR:
	    printf( "CuAt is an invalid ODM object class\n" );
	    break;
	  case ODMI_OPEN_ERR:
	    printf( "cannot open CuAt class - and don't know why!\n" );
	    break;
	  case ODMI_INVALID_PATH:
	    printf( "invalid path\n" );
	    break;
	  case ODMI_TOOMANYCLASSES:
	    printf( "too many object classes have been opened\n" );
	    break;
	  default:
	    printf( "unknown error %d\nPlease call IBM\n", odmerrno );
	}
	return(rc);
    }

#ifdef DEBUG
    printf("retClass= %d\n", retClass);
#endif /* DEBUG */

    response = (struct CuAt *)odm_get_first( retClass, query, NULL );
    if (((int)response) == -1) {
	printf( "kermit: x25local_nua(): odm query failed " );
	switch (odmerrno) {
	  case ODMI_BAD_CRIT:		/* Programming error */
	    printf( "bad search criteria\n" );
	    break;
	  case ODMI_CLASS_DNE:
	    printf( "CuAt class doesn't exist\n" );
	    break;
	  case ODMI_CLASS_PERMS:
	    printf( "permission to CuAt class file denied\n" );
	    break;
	  case ODMI_INTERNAL_ERR:
	    printf("odm internal error\nPlease contact your administrator\n" );
	    break;
	  case ODMI_INVALID_CLXN:
	    printf("CuAt is invalid or inconsistent odm class collection\n");
	    break;
	  case ODMI_INVALID_PATH:
	    printf( "invalid path\n" );
	    break;
	  case ODMI_MAGICNO_ERR:
	    printf( "CuAt is an invalid ODM object class\n" );
	    break;
	  case ODMI_MALLOC_ERR:
	    printf( "malloc failed\n" );
	    break;
	  case ODMI_OPEN_ERR:
	    printf( "cannot open CuAt class - and don't know why!\n" );
	    break;
	  case ODMI_TOOMANYCLASSES:
	    printf( "too many object classes have been opened\n" );
	    break;
	  default:
	    printf( "unknown error %d\nPlease call IBM\n", odmerrno );
	}
	return(rc);
    }

    /* check for a meaningfull response */
    if (response != NULL) {
	if (response->value != NULL) {
	    strcpy(buf, response->value);
	    rc = strlen( buf );
#ifdef DEBUG
/*
	    printf( "attribute name is: %s\n", (char *)response->attribute );
	    printf( "I think my address is %s\n", (char*)response->value );
*/
#endif /* DEBUG */
	} else {
	    printf( "kermit: x25local_nua(): couldn't find the local NUA\n" );
	}
    } else {
	switch (odmerrno) {
	  case ODMI_BAD_CRIT:
	    printf( "Error: ODMI_BAD_CRIT - bad criteria\n" );
	    break;
	  case ODMI_CLASS_DNE:
	    printf( "Error: ODMI_CLASS_DNE - class doesn't exist\n" );
	    break;
	  case ODMI_CLASS_PERMS:
	    printf( "Error: ODMI_CLASS_PERMS - class permissions\n" );
	    break;
	  case ODMI_INTERNAL_ERR:
	    printf( "Error: ODMI_INTERNAL_ERR - panic\n" );
	    break;
	  case ODMI_INVALID_CLXN:
	    printf( "Error: ODMI_INVALID_CLXN - invalid collection\n" );
	    break;
	  case ODMI_INVALID_PATH:
	    printf( "Error: ODMI_INVALID_PATH - invalid path - what path?\n" );
	    break;
	  case ODMI_MAGICNO_ERR:
	    printf( "Error: ODMI_MAGICNO_ERR - invalid object magic\n" );
	    break;
	  case ODMI_MALLOC_ERR:
	    printf( "Error: ODMI_MALLOC_ERR - malloc failed\n" );
	    break;
	  case ODMI_OPEN_ERR:
	    printf( "Error: ODMI_OPEN_ERR - cannot open class\n" );
	    break;
	  case ODMI_TOOMANYCLASSES:
	    printf( "Error: ODMI_TOOMANYCLASSES - too many classes\n" );
	    break;
	  default:
	    printf( "Unknown error!\n" );
	}
	return(rc);
    }

    /* close the database again */
    odm_close_class( retClass );

    /* forget about ODM all together */
    odm_terminate();

#ifdef TRACE
    printf( "TRACE: leaving x25local_nua\n" );
#endif /* TRACE */

    debug(F110, "x25local_nua local address is ", buf, 0);
    return(rc);
}

/*****************************************************************************
 * Function: x25facilities
 *
 * Description:
 *	build up the facilities data packet for a connection request
 *
 * Parameters:
 * 	a pre-allocated char buffer, normally NPI_MAX_DATA big.
 *
 * Return Value:
 *	the number of characters inserted into the buffer
 */
int
x25facilities(buffer) char *buffer; {
    extern int revcall;
    extern int closgr;
    char *p;				/* temp pointer */
    char *start;			/* temp pointer */

#ifdef TRACE
    printf( "TRACE: entering x25facilities\n" );
#endif /* TRACE */

    p = buffer + 1;
    start = p;

#ifdef DEBUG
    printf( "kermit: x25facilities(): getting X25 facilities\n" );
#endif /* DEBUG */

    if (revcall != 0) {
#ifdef DEBUG
 	printf("reverse charge: %d\n", revcall );
#endif /* DEBUG */
	*++p = 0x01;
	*++p = revcall;
    }
    if (closgr > 0) {
#ifdef DEBUG
	printf("closed user group: %d\n", closgr );
#endif /* DEBUG */
	*++p = 0x03;
	*++p = closgr;
    }

#ifdef DEBUG
    if (p == start) {
	printf( "no facilities\n" );
    }
#endif /* DEBUG */

    /* set the size of the facilities buffer */
    *buffer = (char)( p - start ) & 0xff;

#ifdef DEBUG
    printf( "kermit: x25facilities(): returning %d\n", (int)(p - buffer)  );
#endif /* DEBUG */

#ifdef TRACE
    printf( "TRACE: leaving x25facilities\n" );
#endif /* TRACE */

    /* return the size of the facilities with size byte */
    /* 1 == no facilities, 0 byte returned as facilities size */
    return( (int)(p - buffer) );
}

/*
 * reset the connection
 */
int
x25reset(cause, diagn) char cause; char diagn; {
    /* not implemented */

#ifdef TRACE
    printf( "TRACE: entering x25reset\n" );
#endif /* TRACE */

#ifdef TRACE
    printf( "TRACE: leaving x25reset\n" );
#endif /* TRACE */

    return(0);
}

/*
 * clear the x25 connection - ie: hang up
 */
int
x25clear() {
    int get_flags = 0;			/* priority flag for getmsg */
    int put_flags = 0;			/* send flags, always 0 */
    ulong type;				/* primitive type */
    N_discon_req_t *discon_req;		/* pointer to N_DISCON_REQ */
    N_discon_ind_t *discon_ind;		/* pointer to N_DISCON_IND */
    N_npi_data_t *discon_data;		/* pointer to N_DISCON_IND data */
    int rc = 0;				/* return code */
    
#ifdef TRACE
    printf( "TRACE: entering x25clear\n" );
#endif /* TRACE */

#ifdef DEBUG
    /* printf( "x25clear(): checking last msg: %s\n", x25prim(x25lastmsg)); */
#endif /* DEBUG */

    /*
    * The following checks are used to ensure that we don't disconnect
    * or unbind twice - this seems to throw the NPI interface right out of
    * kilter.
    */
    switch(x25lastmsg) {
      case N_BIND_ACK:
      case N_CONN_CON:
      case N_CONN_REQ:
      case N_DATA_REQ:
      case N_DATA_IND:
	{
#ifdef DEBUG
	    /* printf("x25clear(): actively disconnecting\n"); */
#endif /* DEBUG */

		discon_req = (N_discon_req_t *)malloc(NPI_MAX_CTL);
		if (discon_req == NULL) {
		    perror("kermit x25clear(): discon_req malloc failed\n");
		    /* fallthrough, try to unbind the NPI anyway */
		} else {
		    discon_req->PRIM_type = N_DISCON_REQ;
		    discon_req->DISCON_reason = 0;	/* not used by AIX */
		    discon_req->RES_length = 0;
		    discon_req->RES_offset = (ulong)(sizeof(N_discon_req_t));
		    discon_req->SEQ_number = x25seqno;	/* global */

		    if (x25putmsg(ttyfd,
				  (N_npi_ctl_t*)discon_req,
				  (N_npi_data_t*)NULL,
				  0,
				  &put_flags
				  ) < 0) {
			perror("x25putmsg failed in x25clear()");
		    }
		    discon_ind = (N_discon_ind_t *)malloc(NPI_MAX_CTL);
		    discon_data = (N_npi_data_t *)malloc(NPI_MAX_DATA);
		    if((discon_ind == NULL) || (discon_data == NULL)) {
 			perror("x25clear(): discon_ind malloc failed\n");
			/* fallthrough, try to unbind the NPI anyway */
		    } else {
			if(x25getmsg(ttyfd,
				     (N_npi_ctl_t*)discon_ind,
				     NPI_MAX_CTL,
				     (N_npi_data_t*)discon_data,
				     NPI_MAX_DATA,
				     &get_flags,
				     N_OK_ACK
				     ) < 0 ) {
			    perror("x25getmsg failed in x25clear()");
			    /* fallthrough, try to unbind the NPI anyway */
			}
		    }
		}
		break;
	    }
    }

    if (x25lastmsg != N_UNBIND_REQ) {
	rc = x25unbind(ttyfd);
    }

#ifdef TRACE
    printf( "TRACE: leaving x25clear\n" );
#endif /* TRACE */

    return(rc);
}

#ifdef DEBUG
/*
 * only for debugging
 *
 * turn the internal representation of a datablock into something
 * half-way readable. Because the length is known, we can print
 * the string including null's etc (important, because the first(!)
 * byte of an X121 address is a null! (X121 addr == 0 + X25 addr)
 */
x25dump_data(char *addr, ulong offset, ulong length) {
    char *ptr = addr + offset;
    ulong i = length;
    /* allocate enough memory for all unprintable chars */
    char *buf = (char *)malloc( length * 4 );
    char *bptr = buf;	/* pointer to current place in the print buffer */

    while (i > 0) {
	if (isprint(*ptr)) {
	    *bptr++ = *ptr;
	} else {
	    *bptr++ = '[';
	    bptr += sprintf(bptr, "%2.2x", *ptr);
	    *bptr++ = ']';
	}
	ptr++;
	i--;
    }
    if (length > 0) {
	*bptr = '\0';
	printf( "%s", buf );
    }
    printf( " (%d+%d)\n", offset, length );

    if (buf) { free(buf); buf = NULL; }
    return;
}

/*
 * only for debugging
 * print as much useful information about a packet as possible
 */
x25dump_prim(primitive)    N_npi_ctl_t *primitive; {
    printf("Primitive");
    switch (primitive->PRIM_type) {
      case N_BIND_ACK:
	printf( "\tN_BIND_ACK\n\taddress:\t" );
	x25dump_data( (char *)primitive,
		     primitive->bind_ack.ADDR_offset,
		     primitive->bind_ack.ADDR_length );
	printf( "\tproto id:\t" );
	x25dump_data( (char *)primitive,
		     primitive->bind_ack.PROTOID_offset,
		     primitive->bind_ack.PROTOID_length );
	printf( "\tconnind:\t%d\n\ttoken:\t\t%d\n",
	       primitive->bind_ack.CONIND_number,
	       primitive->bind_ack.TOKEN_value );
	break;

      case N_BIND_REQ:
	printf( "\tN_BIND_REQ\n\taddress:\t" );
	x25dump_data( (char *)primitive,
		     primitive->bind_req.ADDR_offset,
		     primitive->bind_req.ADDR_length );
	printf( "\tproto id:\t" );
	x25dump_data( (char *)primitive,
		     primitive->bind_req.PROTOID_offset,
		     primitive->bind_req.PROTOID_length );
	printf( "\tconnind:\t%d\n\tflags:\t\t%d\n",
	       primitive->bind_req.CONIND_number,
	       primitive->bind_req.BIND_flags );
	break;

      case N_CONN_CON:
	printf( "\tN_CONN_CON\n" );
	printf( "\tRES\t\t" );
	x25dump_data( (char *)primitive,
		     primitive->conn_con.RES_offset,
		     primitive->conn_con.RES_length );
	printf( "\tflags:\t%d\n", primitive->conn_con.CONN_flags );
	break;

      case N_CONN_IND:
	printf( "\tN_CONN_IND\n" );
	printf( "\tsource:\t\t" );
	x25dump_data( (char *)primitive,
		     primitive->conn_ind.SRC_offset,
		     primitive->conn_ind.SRC_length );
	printf( "\tdestination:\t" );
	x25dump_data( (char *)primitive,
		     primitive->conn_ind.DEST_offset,
		     primitive->conn_ind.DEST_length );
	printf( "\tSEQ_number:\t%d\n", primitive->conn_ind.SEQ_number );
	printf( "\tflags:\t%d\n", primitive->conn_ind.CONN_flags );
	break;

      case N_CONN_REQ:
	printf( "\tN_CONN_REQ\n\tdestination:\t" );
	x25dump_data( (char *)primitive,
		     primitive->conn_req.DEST_offset,
		     primitive->conn_req.DEST_length );
	printf( "\tflags:\t%d\n", primitive->conn_req.CONN_flags );
	break;

      case N_CONN_RES:
	printf( "\tN_CONN_RES\n" );
	printf( "\tTOKEN_value\t%d\n", primitive->conn_res.TOKEN_value );
	printf( "\tSEQ_number\t%d\n", primitive->conn_res.SEQ_number );
	printf( "\tCONN_flags\t%d\n", primitive->conn_res.CONN_flags );
	printf( "\tRES\t\t" );
	x25dump_data( (char *)primitive,
		     primitive->conn_res.RES_offset,
		     primitive->conn_res.RES_length );
	break;

      case N_DATACK_IND:
	printf( "\tN_DATACK_IND\n" );
	break;

      case N_DATACK_REQ:
	printf( "\tN_DATACK_REQ\n" );
	printf( "\tflags:\t%d\n", primitive->data_req.DATA_xfer_flags );
	break;

      case N_DATA_IND:
	printf( "\tN_DATA_IND\n" );
	printf( "\tflags:\t%d\n", primitive->data_ind.DATA_xfer_flags );
	break;

      case N_DATA_REQ:
	printf( "\tN_DATA_REQ\n" );
	break;
	
      case N_DISCON_IND:
	printf( "\tN_DISCON_IND\n" );
	printf( "\torigin:\t%d\n", primitive->discon_ind.DISCON_orig );
	printf( "\treason:\t\t%d\n", primitive->discon_ind.DISCON_reason );
	printf( "\tseq no:\t\t%d\n", primitive->discon_ind.SEQ_number );
	printf( "\tRES:\t" );
	x25dump_data( (char *)primitive,
		     primitive->discon_ind.RES_offset,
		     primitive->discon_ind.RES_length );
	break;

      case N_DISCON_REQ:
	printf( "\tN_DISCON_REQ\n" );
	printf( "\tDISCON_reason:\t%d\n",
	       primitive->discon_req.DISCON_reason );
	printf( "\tRES:\t" );
	x25dump_data( (char *)primitive,
		     primitive->discon_req.RES_offset,
		     primitive->discon_req.RES_length );
	printf( "\tSEQ_number:\t%d\n", primitive->discon_req.SEQ_number );
	break;

      case N_ERROR_ACK:
	printf( "\tN_ERROR_ACK\n" );
	printf( "\tCaused by:\t%s\n",
	       x25prim( primitive->error_ack.ERROR_prim ) );
	printf( "\tNPI error:\t%s\n",
	       x25err( primitive->error_ack.NPI_error ));
	errno = primitive->error_ack.UNIX_error;
	perror( "\t" );
	break;

      case N_EXDATA_IND:
	printf( "\tN_EXDATA_ACK\n" );
	break;

      case N_EXDATA_REQ:
	printf( "\tN_EXDATA_REQ\n" );
	break;

      case N_INFO_ACK:
	printf( "\tN_INFO_ACK\n" );
	printf( "\tNSDU size:\t%d\n", primitive->info_ack.NSDU_size );
	printf( "\tENSDU size:\t%d\n", primitive->info_ack.ENSDU_size );
	printf( "\tCDATA size:\t%d\n", primitive->info_ack.CDATA_size );
	printf( "\tDDATA size:\t%d\n", primitive->info_ack.DDATA_size );
	printf( "\tADDR size:\t%d\n", primitive->info_ack.ADDR_size );
	printf( "\tNIDU size:\t%d\n", primitive->info_ack.NIDU_size );
	break;

      case N_INFO_REQ:
	printf( "\tN_INFO_REQ\n" );
	break;

      case N_OK_ACK:
	printf( "\tN_OK_ACK\n" );
	break;

      case N_OPTMGMT_REQ:
	printf( "\tN_OPTMGMT_REQ\n" );
	break;

      case N_RESET_CON:
	printf( "\tN_RESET_CON\n" );
	break;

      case N_RESET_IND:
	printf( "\tN_RESET_IND\n" );
	printf( "\treason:\t\t%d\n", primitive->reset_ind.RESET_reason );
	printf( "\torigin:\t\t%d\n", primitive->reset_ind.RESET_orig );
	break;
	
      case N_RESET_REQ:
	printf( "\tN_RESET_REQ\n" );
	printf( "\treason:\t\t%d\n", primitive->reset_req.RESET_reason );
	break;

      case N_RESET_RES:
	printf( "\tN_RESET_RES\n" );
	break;

      case N_UDERROR_IND:
	printf( "\tN_UDERROR_IND\n" );
	break;

      case N_UNBIND_REQ:
	printf( "\tN_UNBIND_REQ\n" );
	break;
	
      case N_UNITDATA_REQ:
	printf( "\tN_UNITDATA_REQ\n" );
	break;

      case N_UNITDATA_IND:
	printf( "\tN_UNITDATA_IND\n" );
	break;

      default:
	(void) printf( "Unknown NPI error %d", primitive->PRIM_type );
	return 0;
    }
}
#endif /* DEBUG */

/* it looks like signal handling is not needed with streams! */
/* x25oobh()	- handle SIGURG signals - take from isode ? */

#endif /* IBMX25 */

#endif /* NETCONN */
