;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime1.9b/Ast/var.scm             */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu May 30 15:12:51 1996                          */
;*    Last change :  Wed Apr 16 12:18:33 1997 (serrano)                */
;*    -------------------------------------------------------------    */
;*    The variable class definition                                    */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_var

   (import engine_param
	   type_type)

   (export (class value)
	   
	   (class variable::object
	      ;; the variable identifier
	      (id::symbol read-only)
	      ;; the target name
	      (name (default #f))
	      ;; the variable type or the function type result
	      (type::type (default *_*))
	      ;; its type
	      value::value
	      ;; its access mode
	      (access (default 'read)
		      [assert (access) (memq access '(read
						      write
						      cell-callcc
						      cell-gobalize
						      cell-integrate))])
	      ;; a slot for fast alpha conversion
	      (fast-alpha (default #unspecified))
	      ;; does this variable can be removed
	      (removable (default 'now))
	      ;; the variable number of occurrences
	      (occurrence::long (default 0)))
	   
	   (final-class global::variable
	      ;; the global's module
	      (module::symbol read-only)
	      ;; the global's importation (is mutated in make_heap@heap_make)
	      (import [assert (import)
			      (memq import '(static export eval foreign))])
	      ;; is this global can be known by eval ?
	      (evaluable?::bool (default #t))
	      ;; is it a library variable ?
	      (library?::bool read-only (default *lib-mode*))
	      ;; a user pragma about the variable
	      (pragma::obj read-only (default '()))
	      ;; declaration source
	      src::obj)

	   (final-class local::variable
	      ;; the local's identification key
	      (key::long read-only))

	   (class fun::value
	      ;; the function arity
	      (arity::long read-only)
	      ;; side effect field
	      (side-effect? (default #unspecified))
	      ;; if this function is a predicate, the type tested
	      (predicate-of (default #f))
	      ;; an associated stack allocator
	      (stack-allocator (default #f))
	      ;; is this function `top' its arguments (for the cfa)
	      (top?::bool (default #t))
	      ;; the associated closure
	      (the-closure (default #unspecified)))

	   (final-class sfun::fun
	      ;; a property list
	      (property::obj (default '()))
	      ;; the formals parameters
	      (args (default '()))
	      ;; the body
	      (body (default #unspecified))
	      ;; a class
	      (class [assert (class) (memq class '(sfun
						   sifun
						   snifun
						   sgfun
						   smfun))])
	      ;; dsssl keyword arguments encoding
	      (dsssl-keywords (default '())))

	   (final-class cfun::fun
	      ;; the formal parameters' type
	      (args-type read-only)
	      ;; is it a macro function
	      (macro?::bool read-only)
	      ;; is it an infix macro ?
	      (infix?::bool (default #f)))

	   (final-class svar::value)

	   (final-class scnst::value
	      ;; a possible variable value
	      (node read-only)
	      ;; a class
	      (class [assert (class) (memq class '(sgfun
						   sfun
						   sstring
						   sreal
						   stvector))]))

	   (final-class cvar::value
	      ;; is it a macro variable
	      (macro?::bool read-only))

	   (final-class sexit::value
	      ;; the associated handling function
	      handler::obj
	      ;; is the handler detached (after globalize)
	      (detached?::bool (default #f)))))
