;* --------------------------------------------------------------------*/
;*    Copyright (c) 1992-1998 by Manuel Serrano. All rights reserved.  */
;*                                                                     */
;*                                     ,--^,                           */
;*                               _ ___/ /|/                            */
;*                           ,;'( )__, ) '                             */
;*                          ;;  //   L__.                              */
;*                          '   \   /  '                               */
;*                               ^   ^                                 */
;*                                                                     */
;*                                                                     */
;*    This program is distributed in the hope that it will be useful.  */
;*    Use and copying of this software and preparation of derivative   */
;*    works based upon this software are permitted, so long as the     */
;*    following conditions are met:                                    */
;*           o credit to the authors is acknowledged following         */
;*             current academic behaviour                              */
;*           o no fees or compensation are charged for use, copies,    */
;*             or access to this software                              */
;*           o this copyright notice is included intact.               */
;*      This software is made available AS IS, and no warranty is made */
;*      about the software or its performance.                         */
;*                                                                     */
;*      Bug descriptions, use reports, comments or suggestions are     */
;*      welcome. Send them to                                          */
;*        Manuel Serrano -- Manuel.Serrano@unice.fr                    */
;*-------------------------------------------------------------------- */
;*---------------------------------------------------------------------*/
;*    serrano/prgm/project/bigloo/recette/macro.scm ...                */
;*                                                                     */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Mon Nov 23 15:13:19 1992                          */
;*    Last change :  Fri Mar 25 14:08:28 1994 (serrano)                */
;*                                                                     */
;*    Des tests d'expanseurs.                                          */
;*---------------------------------------------------------------------*/

;*---------------------------------------------------------------------*/
;*    Le module                                                        */
;*---------------------------------------------------------------------*/
(module macro
   (import  (main "main.scm"))
   (include "test.sch")
   (static  (integer->char))
   (export  (test-macro)))

;*---------------------------------------------------------------------*/
;*    defun ...                                                        */
;*---------------------------------------------------------------------*/
(define-expander defun 
   (lambda (f e)
      (e `(define ,(cadr f) 
	     (begin
		,@(cddr f)
		1))
	 e)))

;*---------------------------------------------------------------------*/
;*    foo ...                                                          */
;*---------------------------------------------------------------------*/
(defun (foo x y)
   (+ x y))

;*---------------------------------------------------------------------*/
;*    integer->char ...                                                */
;*---------------------------------------------------------------------*/
(define (integer->char)
   1)

;*---------------------------------------------------------------------*/
;*    bar ...                                                          */
;*    -------------------------------------------------------------    */
;*    On verifie que les O-macros sont ecrasables par des variables    */
;*    locales                                                          */
;*---------------------------------------------------------------------*/
(define (bar read)
   (read))

;*---------------------------------------------------------------------*/
;*    Les formes interpretees                                          */
;*---------------------------------------------------------------------*/
(define-expander put
   (define a 4)
   (define b 6)
   (lambda (x e) ''dummy))

(put)

(define-macro (get)
   (+ a b))

(define eval-macro (get))

;*---------------------------------------------------------------------*/
;*    Une macro dans un case sur des integers (ca plantait jusqu'a     */
;*    la premiere version 1.6)                                         */
;*---------------------------------------------------------------------*/
(define-macro (case-test-macro x)
   x)

(define (case-macro x)
   (case (case-test-macro x)
      ((1) 1)
      ((2) 2)
      (else 3)))

;*---------------------------------------------------------------------*/
;*    test-macro ...                                                   */
;*---------------------------------------------------------------------*/
(define (test-macro)
   (test-module "macro" "macro.scm" #f)
   (test "expander" (foo 1 2) 1)
   (test "O-macro" (integer->char) 1)
   (test "O-macro" (bar (lambda () 1)) 1)
   (test "eval" eval-macro 10)
   (test "case-macro" (case-macro 2) 2))

 
