/*
** Copyright (c) Massachusetts Institute of Technology 1994-1998.
**          All Rights Reserved.
**          Unpublished rights reserved under the copyright laws of
**          the United States.
**
** THIS MATERIAL IS PROVIDED AS IS, WITH ABSOLUTELY NO WARRANTY EXPRESSED
** OR IMPLIED.  ANY USE IS AT YOUR OWN RISK.
**
** This code is distributed freely and may be used freely under the 
** following conditions:
**
**     1. This notice may not be removed or altered.
**
**     2. Works derived from this code are not distributed for
**        commercial gain without explicit permission from MIT 
**        (for permission contact lclint-request@sds.lcs.mit.edu).
*/
# ifndef exprNodeSList_H
# define exprNodeSList_H

/*
** like exprNodeList, except elements are dependent.
*/

typedef /*@dependent@*/ exprNode d_exprNode;

abst_typedef struct _exprNodeSList
{
  int nelements;
  int nspace;
  /*@reldef@*/ /*@relnull@*/ d_exprNode *elements;
} *exprNodeSList;

/*@iter exprNodeSList_elements (sef exprNodeSList x, yield exposed exprNode el); @*/
# define exprNodeSList_elements(x, m_el) \
   { int m_ind; exprNode *m_elements = &((x)->elements[0]); \
     for (m_ind = 0 ; m_ind < (x)->nelements; m_ind++) \
       { exprNode m_el = *(m_elements++); 

# define end_exprNodeSList_elements }}

extern /*@only@*/ exprNodeSList exprNodeSList_new(void);

extern /*@only@*/ exprNodeSList exprNodeSList_singleton (/*@exposed@*/ /*@dependent@*/ exprNode p_e) ;

extern /*@unused@*/ void 
  exprNodeSList_addh (exprNodeSList p_s, /*@exposed@*/ /*@dependent@*/ exprNode p_el);

extern /*@only@*/ /*@unused@*/ cstring exprNodeSList_unparse (exprNodeSList p_s);
extern void exprNodeSList_free (/*@only@*/ exprNodeSList p_s) ;

extern exprNodeSList 
  exprNodeSList_append (/*@returned@*/ exprNodeSList p_s1, /*@only@*/ exprNodeSList p_s2) ;

/*@constant int exprNodeSListBASESIZE;@*/
# define exprNodeSListBASESIZE SMALLBASESIZE

# endif




