/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* Defines to make different thread packages compatible */

#ifndef _my_pthread_h
#define _my_pthread_h

#ifndef __WIN32__
#ifdef HAVE_rts_threads
#define sigwait org_sigwait
#include <signal.h>
#undef sigwait
#endif
#undef _REENTRANT			/* Fix if _REENTRANT is in pthread.h */
#include <pthread.h>
#ifndef _REENTRANT
#define _REENTRANT
#endif
#ifdef HAVE_THR_SETCONCURRENCY
#include <thread.h>			/* Probably solaris */
#endif
#ifdef HAVE_SCHED_H
#include <sched.h>
#endif

my_bool my_thread_global_init(void);
extern my_bool my_thread_init(void);
extern void my_thread_end(void);
extern int my_pthread_getprio(pthread_t thread_id);
extern char *my_thread_name(void);
extern long my_thread_id(void);

#define pthread_key(T,V) pthread_key_t V
#define my_pthread_getspecific_ptr(T,V) my_pthread_getspecific(T,(V))
#define my_pthread_setspecific_ptr(T,V) pthread_setspecific(T,(void*) (V))
#define pthread_detach_this_thread()
#define pthread_handler_decl(A,B) void *A(void *B)
typedef void *(* pthread_handler)(void *);

/* Test first for RTS or FSU threads */

#if defined(PTHREAD_SCOPE_GLOBAL) && !defined(PTHREAD_SCOPE_SYSTEM)
#define HAVE_rts_threads
void *my_pthread_getspecific_imp(pthread_key_t key);
#define my_pthread_getspecific(A,B) ((A) my_pthread_getspecific_imp(B))
int my_sigwait(sigset_t *set,int *sig);
extern int my_pthread_create_detached;
#define pthread_sigmask(A,B,C) sigprocmask((A),(B),(C))
#define PTHREAD_CREATE_DETACHED &my_pthread_create_detached
#define PTHREAD_SCOPE_SYSTEM  PTHREAD_SCOPE_GLOBAL
#define PTHREAD_SCOPE_PROCESS PTHREAD_SCOPE_LOCAL
#define USE_ALARM_THREAD

#elif defined(HAVE_mit_thread)
#define USE_ALARM_THREAD
#ifndef HAVE_LOCALTIME_R
#define HAVE_LOCALTIME_R
#endif
#ifndef HAVE_PTHREAD_ATTR_SETSCOPE
#define HAVE_PTHREAD_ATTR_SETSCOPE
#endif
#define sigset(A,B) pthread_signal((A),(void (*)(int)) (B))
#define signal(A,B) pthread_signal((A),(void (*)(int)) (B))
#define my_pthread_attr_setprio(A,B)
#define my_pthread_getspecific(T,A) (T) pthread_getspecific(A)
#define my_sigwait(A,B) sigwait((A),(B))

#else
#ifndef HAVE_NONPOSIX_PTHREAD_GETSPECIFIC
#define my_pthread_getspecific(A,B) ((A) pthread_getspecific(B))
#define my_sigwait(A,B) sigwait((A),(B))
#else
#define my_pthread_getspecific(A,B) ((A) my_pthread_getspecific_imp(B))
void *my_pthread_getspecific_imp(pthread_key_t key);
/* #define sigwait(A,B) my_sigwait((A),(B)) */
#endif
#endif

#ifdef HAVE_SIGTHREADMASK
#define pthread_sigmask(A,B,C) sigthreadmask((A),(B),(C))
#endif

#if !defined(HAVE_SIGWAIT) && !defined(HAVE_mit_thread) && !defined(HAVE_rts_threads) && !defined(sigwait) && !defined(alpha_linux_port)
int sigwait(sigset_t *setp, int *sigp);		/* Use our implemention */
#endif
#if !defined(HAVE_SIGSET) && !defined(HAVE_mit_thread) && !defined(sigset)
#define sigset(A,B) signal((A),(B))
#endif

#ifndef my_pthread_setprio
#if defined(HAVE_PTHREAD_SETPRIO_NP)		/* FSU threads */
#define my_pthread_setprio(A,B) pthread_setprio_np((A),(B))
#elif defined(HAVE_PTHREAD_SETPRIO)
#define my_pthread_setprio(A,B) pthread_setprio((A),(B))
#else
extern void my_pthread_setprio(pthread_t thread_id,int prior);
#endif
#endif

#ifndef my_pthread_attr_setprio
#ifdef HAVE_PTHREAD_ATTR_SETPRIO
#define my_pthread_attr_setprio(A,B) pthread_attr_setprio((A),(B))
#else
extern void my_pthread_attr_setprio(pthread_attr_t *attr, int priority);
#endif
#endif

#ifndef HAVE_PTHREAD_ATTR_SETSCOPE
#define pthread_attr_setscope(A,B)
#undef	HAVE_GETHOSTBYADDR_R			/* No definition */
#endif

#ifndef HAVE_LOCALTIME_R
struct tm *localtime_r(const time_t *clock, struct tm *res);
#endif

#ifdef AIX_3_2
extern int pthread_no_free(void *);
extern int pthread_dummy(int);
int my_sigwait(sigset_t *set,int *sig);
#define pthread_mutex_init(a,b) my_pthread_mutex_init((a),(b))
extern int my_pthread_mutex_init(pthread_mutex_t *mp,
				 const pthread_mutexattr_t *attr);
#define pthread_cond_init(a,b) my_pthread_cond_init((a),(b))
extern int my_pthread_cond_init(pthread_cond_t *mp,
				const pthread_condattr_t *attr);
#define pthread_key_create(A,B) \
		pthread_keycreate(A,(B) ?\
				  (pthread_destructor_t) (B) :\
				  (pthread_destructor_t) pthread_dummy)
#define pthread_attr_init(A) pthread_attr_create(A)
#define pthread_attr_destroy(A) pthread_attr_delete(A)
#define pthread_attr_setscope(A,B) pthread_dummy(0)
#define pthread_attr_setdetachstate(A,B) pthread_dummy(0)
#define pthread_create(A,B,C,D) pthread_create((A),*(B),(C),(D))
#define pthread_sigmask(A,B,C) sigprocmask((A),(B),(C))
#define pthread_kill(A,B) pthread_dummy(0)
#undef	pthread_detach_this_thread
#define pthread_detach_this_thread() pthread_detach(&pthread_self())
#endif

#else /* __WIN32__ */

typedef CRITICAL_SECTION pthread_mutex_t;
typedef HANDLE           pthread_t;
typedef struct thread_attr {
    DWORD dwStackSize ;
    DWORD dwCreatingFlag ;
    int	priority ;
} pthread_attr_t ;

typedef struct { int dummy; } pthread_condattr_t;

/* Implementation of posix conditions */

typdef struct st_pthread_link {
  pthread_t thread;
  DWORD thread_id;
  struct st_pthread_link *next;
} pthread_link;

typedef struct {
  uint msg;
  pthread_link *link;
  pthread_mutex_t *lock;
} pthread_cond_t;


struct timespec {               /* For pthread_cond_timedwait() */
    time_t tv_sec;
    long tv_nsec;
};

extern __declspec(thread) pthread_t win_pthread_self;

#define pthread_handler_decl(A,B) unsigned __cdecl A(void *B)
typedef unsigned (__cdecl *pthread_handler)(void *);

int pthread_dummy(int);
int win_pthread_setspecific(void *A,void *B,uint length);
int pthread_create(pthread_t *,pthread_attr_t *,pthread_handler,void *);
int pthread_cond_init(pthread_cond_t *cond, const pthread_condattr_t *attr);
int pthread_cond_wait(pthread_cond_t *cond, pthread_mutex_t *mutex);
int pthread_cond_timedwait(pthread_cond_t *cond, pthread_mutex_t *mutex,
                           struct timespec *abstime);
int pthread_cond_signal(pthread_cond_t *cond);
int pthread_cond_broadcast(pthread_cond_t *cond);
int pthread_attr_init(pthread_attr_t *connect_att);
int pthread_attr_setstacksize(pthread_attr_t *connect_att,DWORD stack);
int pthread_attr_setprio(pthread_attr_t *connect_att,int priority);
int pthread_attr_destroy(pthread_attr_t *connect_att);
my_bool my_thread_global_init(void);
extern my_bool my_thread_init(void);
extern void my_thread_end(void);
extern char *my_thread_name(void);
extern long my_thread_id(void);
void pthread_exit(unsigned A);   /* was #define pthread_exit(A) ExitThread(A)*/

#define pthread_cond_destroy(A)
#define pthread_cond_broadcast(A) pthread_cond_signal(A)
#define ETIMEDOUT 145               /* Win32 doesn't have this */
#define getpid() GetCurrentThreadId()
#define pthread_self() win_pthread_self
#define localtime_r(A,B) (*B)= *localtime((A))
#define HAVE_LOCALTIME_R
#define pthread_key(T,V) __declspec(thread) T V
#define pthread_key_create(A,B) pthread_dummy(0)
#define pthread_getspecific(A) (&(A))
#define my_pthread_getspecific(T,A) (&(A))
#define my_pthread_getspecific_ptr(T,V) (V)
#define my_pthread_setspecific_ptr(T,V) ((T)=(V),0)
#define pthread_setspecific(A,B) win_pthread_setspecific(&(A),(B),sizeof(A))
#define pthread_equal(A,B) (A) == (B)
#define pthread_mutex_init(A,B)  InitializeCriticalSection(A)
#define pthread_mutex_lock(A)    (EnterCriticalSection(A),0)
#define pthread_mutex_unlock(A)  LeaveCriticalSection(A)
#define pthread_mutex_destroy(A) DeleteCriticalSection(A)
#define my_pthread_setprio(A,B)  SetThreadPriority(GetCurrentThread(), (B))
/* Dummy defines for easier code */
#define pthread_kill(A,B) pthread_dummy(0)
#define pthread_attr_setdetachstate(A,B) pthread_dummy(0)
#define my_pthread_attr_setprio(A,B) pthread_attr_setprio(A,B)
#define pthread_attr_setscope(A,B)
#define pthread_detach_this_thread()
//Irena: compiler does not like this:
//#define my_pthread_getprio(pthread_t thread_id) pthread_dummy(0)
#define my_pthread_getprio(thread_id) pthread_dummy(0)

#endif /* __WIN32__ */

#endif /* _my_ptread_h */
