/*
  Optimizer
  Holder header file
*/

/*
 *  Copyright (C) 1997,1998  Jesper Pedersen <jews@imada.ou.dk>
 *  This code is released under GNU GPL version 2 or later
 */


#ifndef _HOLDER_H_
#define _HOLDER_H_

typedef class Holder *PHolder;
typedef class Entry *PEntry;
typedef class IdEntry *PIdEntry;
typedef class GloblEntry *PGloblEntry;

//
//	Class name : Holder
//
//	Description :
//
class Holder {
  friend Entry,IdEntry,GloblEntry;
private:
  PEntry firstEntry;                // Pointer to the first entry
  PEntry lastEntry;                 // Pointer to the last entry
  PIdEntry Fidlist;                 // Pointer to the first global id
  PIdEntry Lidlist;                 // Pointer to the last global id
  PIdEntry Fstrlist;                // Pointer to the first string id
  PIdEntry Lstrlist;                // Pointer to the last string id
  PIdEntry Fextlist;                // Pointer to the first external id
  PIdEntry Lextlist;                // Pointer to the last external id
  PGloblEntry Fgbllist;             // Pointer to the first global variable
  PGloblEntry Lgbllist;             // Pointer to the last global variable
  PIdEntry Fvarlist;                // Pointer to the first local variable
  PIdEntry Lvarlist;                // Pointer to the last local variable
  unsigned int align;
public:
  Holder();                         // Constructor
  ~Holder();                        // Destructor
  void insert(YYSTYPE *entry);      // Inserts a entry
  void insertid(char *s1,char *s2,int where); // Inserts a global id
  void insertdata(char *s1,char *s2);  // Inserts a data-field
  void deleteid(char *s);           // Deletes an id

  void setcodealign(unsigned int size);  // Sets the alignment for the code
  void setvarsize(char *s1,char *s2,char *s3); // Sets the variable size
  void setgblsize(char *s1,unsigned int size); // Sets the variable size

  void optP5(void);                 // Optimize to Pentium (NASM)
  void optP6(void);                 // Optimize to Pentium Pro (NASM)
  void optMMX(void);                // Optimize with MMX support (NASM)

  void tofile(void);                // Outputs to the output-file
  void header(void);                // Outputs the header
  void footer(void);                // Outputs the footer

  void switchstr(void);             // Switches the reg-strings
  void change(void);                // Changes reg-names 
  void notation(void);              // Convert "as" notation to NASM
  void cleanup(void);               // Clean up unused entries
  PIdEntry findid(char *s);         // Finds a global id
  PIdEntry findvar(char *s);        // Finds a non-init variable
  PGloblEntry findglobl(char *s);   // Finds a init variable
  PIdEntry findfunc(char *s);       // Finds a function
  PIdEntry findstr(char *s);        // Finds a string
  void outvars(void);               // 

  void loadFile(void);              // Loads the source-file (GAS)
  void saveFile(void);              // Saves the buffer into dest-file (GAS)
  void GASoptP5(void);              // Optimize to Pentium (GAS)
  void GASoptP6(void);              // Optimize to Pentium Pro (GAS)
  void GASoptMMX(void);             // Optimize with MMX support (GAS)

  void printAll(unsigned int which); // Print all entries
};

#endif
