/* the hirev part of inst */

#include <stdio.h>	/*stderr*/
#include <string.h>	/*(memset)*/

#include "defs.h"	/*->hirev.h (u8,u15x,...)*/
#include "dacio.h"	/*(dacioXXX)*/
#include "hirev.h"	/*InstHirevInfo*/
#include "mem.h"	/*(memPerm)*/

#define MAX_FRAMELEN (MAX_OUTRATE * 60 / (MIN_TEMPO * 24))

static struct {
    i31 *p0;
    i31 *p;
    i15x len;
} buf;

void
instHirevInit(void)
{
    buf.p0 = memPerm(MAX_FRAMELEN * 2 * sizeof(*buf.p0));
    /*dacioInit();*/
    /*dacioConf();*/
    dacioIncomingBuf(buf.p0);
}

void
instHirevSetFrameLen(i15x l)
{
    dacioIncomingBufLen(l);
    buf.len = l;
}

#if 0
void
instHirevRewindBuf(/*i15x pan*/)
{
    /*buf.p = buf.p0 + (pan > 0);*/
    buf.p = buf.p0;
}
#endif

void
instHirevEraseBuf(void)
{
    memset(buf.p0, 0, sizeof(i31) * buf.len * 2);
}

void
instHirevFlushBuf(void)
{
    dacioOut();
#if 0
    i31 *lp,*rp,*ep;

    lp = buf.l;
    rp = buf.r;
    ep = lp + buf.len;
    for (; lp < ep; lp++,rp++) {
	dacioOut(*lp/(64*4)+128, *rp/(64*4)+128);
    }
#endif
}

#if 0
void
instHirevSetGlobalVol(i15x gv)
{
}
#endif

static u16x outRate;

void
instHirevSetOutRate(u16x or)
{
    outRate = or;
}

static void
fadeout(InstHirevInfo *ihip)
{
    i15x lastL = ihip->lastL / 64;
    i15x lastR = ihip->lastR / 64;
    i15x f = ihip->fadeout;

    if (f > 63) f = 63;
    if (lastL || lastR) {
	i31 *bufp = buf.p;
	i15x n = (buf.p0 + buf.len - bufp) / 2;
	if (n > f) n = f;
	for (; n > 0; n--,f--) {
	    *bufp++ += lastL * f;
	    *bufp++ += lastR * f;
	}
    }
    ihip->fadeout = f;
    if (!f) ihip->lastL = ihip->lastR = 0;
}

/* vol zero optimization: just calculates phase progress within this frame */
static void
vol0Opt(InstHirevInfo *ihip)
{
    if (ihip->lastL || ihip->lastR) {
	/* suddenly volume is turned to 0 -> click (chi_mai.s3m) */
	ihip->fadeout = 256;
	fadeout(ihip);
	ihip->fadeout = 0; /* don't note off (ambient_power.mod) */
    }
    ihip->wAcc = (u32x)(u16)ihip->wAcc + (u16)(ihip->w * buf.len);
    ihip->ptr += (ihip->w >> 16) * buf.len
	         + ((u16)ihip->w * buf.len >> 16)
	         + (ihip->wAcc >> 16);
    if (ihip->ptr >= ihip->end) {
	if (ihip->loopBeg) {
	    ihip->ptr = ihip->loopBeg +
		(ihip->ptr - ihip->end) % (ihip->end - ihip->loopBeg);
	} else {
	    ihip->ptr = NULL; /* note off */
	}
    }
    ihip->lastL = ihip->lastR = 0;
}

static InstHirevInfo ihi; /* cacheing */

static void
hirevLoop0(u32x n)
{
    i31 *bufp = buf.p;
    const u8 *ihiPtr = ihi.ptr;
    u32x ihiWAcc = ihi.wAcc;

    for (; n > 0; n--) {
	{
	    i15x d = (i7)*ihiPtr;
	    *bufp++ += d * ihi.volL;
	    *bufp++ += d * ihi.volR;
	}
	ihiWAcc = (u16)ihiWAcc + ihi.w; /*ihiWAcc & 0xffff + w*/
	ihiPtr += ihiWAcc >> 16;
    }
    buf.p = bufp;
    ihi.ptr = ihiPtr;
    ihi.wAcc = ihiWAcc;
}

static void
hirevLoop80(u32x n)
{
    i31 *bufp = buf.p;
    const u8 *ihiPtr = ihi.ptr;
    u32x ihiWAcc = ihi.wAcc;

    for (; n > 0; n--) {
	{
	    i15x d = (i7)(*ihiPtr ^ 0x80);
	    *bufp++ += d * ihi.volL;
	    *bufp++ += d * ihi.volR;
	}
	ihiWAcc = (u16)ihiWAcc + ihi.w; /*ihiWAcc & 0xffff + w*/
	ihiPtr += ihiWAcc >> 16;
    }
    buf.p = bufp;
    ihi.ptr = ihiPtr;
    ihi.wAcc = ihiWAcc;
}

#define hirevLoop(x) if (ihi.xor) hirevLoop80(x); else hirevLoop0(x)

#if 0
static void
fillLast(u32x n, i15x d)
{
    i31x lastL,lastR;

    lastL = ihi.lastL = d * ihi.volL;
    lastR = ihi.lastR = d * ihi.volR;
    if (!lastL && !lastR) {
	ihi.ptr = NULL; /* note off */
    } else {
	i31 *bufp = buf.p;
	for (; n > 0; n--) { /* fill with the last data */
	    *bufp++ += lastL;
	    *bufp++ += lastR;
	}
	ihi.fadeout = 256; /* fadeout next frame */
    }
}
#endif
    
void
instHirevLoop(InstHirevInfo *ihip)
{
    u32x restF;
    u32x restS;
    i15x lastD;

    if (ihip->ptr == NULL) return; /* note is off */
    buf.p = buf.p0;
    if (ihip->fadeout) {
	fadeout(ihip);
	if (!ihip->fadeout) ihip->ptr = NULL; /* note off */
	return;
    }
#if 1
    if (!ihip->volL && !ihip->volR) { vol0Opt(ihip); return; }
#endif
    ihi = *ihip; /* load to cache */
    restF = buf.len;
    do {
	i31x l8, l0;
	ihi.wAcc = (u16)ihi.wAcc;

	/* restS := ((end - ptr) << 16 + w-1 - wAcc) / w */
	l8 = (ihi.end - ihi.ptr) << 8;
	if (!l8 && !ihi.wAcc) { /* happens only on empty samples */
	    ihip->fadeout = 256;
	    fadeout(ihip);
	    if (!ihip->fadeout) ihip->ptr = NULL; /* note off */
	    return;
	}
#if 1
	if (l8 <= 0) {
	    fprintf(stderr, "bug: restF=%u\n",restF);
	    fprintf(stderr, "end-ptr=%d w=%u\n",ihi.end-ihi.ptr,ihi.w);
	    fprintf(stderr, "wAcc = %u\n",ihi.wAcc);
	    /*fprintf(stderr, "i = %d wAcc = %u\n",i, ihi.wAcc);*/
	    /*exit(1);*/
	}
#endif
	l0 = ihi.w - 1 - ihi.wAcc;
	l8 += l0 >> 8;
	l0 &= 0xff;
	restS = ((l8 / ihi.w) << 8) + (((l8 % ihi.w) << 8) + l0) / ihi.w;

	if (restF < restS) { /* sample is longer than frame */
	    hirevLoop(restF);
	    lastD = (i7)(*(ihi.ptr - (ihi.wAcc >> 16)) ^ ihi.xor);
	    break;
	}
	/* restF >= restS */
	hirevLoop(restS);
	lastD = (i7)(*(ihi.ptr - (ihi.wAcc >> 16)) ^ ihi.xor);
#if 1
	if (ihi.ptr < ihi.end || ihi.end <= ihi.ptr - (ihi.wAcc >> 16)) {
	    fprintf(stderr, "bug: restS = %u restF=%u end-ptr = %d, ptr=%u\n",
		    restS, restF, ihi.end-ihi.ptr, (u32x)ihi.ptr);
	    fprintf(stderr, "last ptr=%u\n",
		    (u32x)(ihi.ptr - (ihi.wAcc >> 16)));
	    exit(1);
	}
#endif
	restF -= restS;
	if (ihi.loopBeg) {
	    ihi.ptr = ihi.loopBeg +
		(ihi.ptr - ihi.end) % (ihi.end - ihi.loopBeg);
	} else {
#if 1
	    ihi.lastL = lastD * ihi.volL;
	    ihi.lastR = lastD * ihi.volR;
	    ihi.fadeout = 256;
	    fadeout(&ihi);
	    if (!ihi.fadeout) ihi.ptr = NULL; /* note off */
	    goto RET;
#else
	    fillLast(restF, lastD);
#endif
	    break;
	}
    } while (restF);
    ihi.lastL = lastD * ihi.volL;
    ihi.lastR = lastD * ihi.volR;
 RET:
    *ihip = ihi; /* save cache */
}
