module Utility (
       power, osc
       ) where


-- HIGHER-ORDER FUNCTIONS:

  -- power applies a single function n times to a seed
power :: Int -> (a->a) -> a -> a
power 0     f seed = seed
power (n+1) f seed = f (power n f seed)



-- FUNCTIONS OVER SEQUENCES:

  -- osc takes a list, and makes sure it oscillates. If the head is 
  -- equal to the tail, it simply repeats the sequence infinitely. If
  -- the head is not equal to the tail, it adds the sequence then adds
  -- the reversed sequence minus the first and last elements, and then repeats
osc :: [a] -> [a]
osc []  = []
osc [a] = repeat a
osc s   = cycle (s ++ (tail $ reverse $ tail $ s))

