/********************************************************************************
 * Copyright (c) Des Herriott 1993, 1994
 *               Erik Kunze   1995 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Des Herriott
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#include "config.h"
#ifdef XBELL_AUDIO
#ifndef lint
static char beep_c[] = "$Id: beep.c,v 4.3 1998/02/01 13:25:11 erik Rel $";
#endif

#include <X11/Xlib.h>
#include "config.h"
#include "debug.h"
#include "resource.h"
#include "mem.h"
#include "util.h"
#include "screen.h"
#include "beep.h"





void
SetBeepTrap(int model)
{
	uns16 bellAddr;
	int basicrom;
	switch (Machines[model].romType)
	{
		case ROM_STANDARD:
		case ROM_128:
		case ROM_PLUS2:
#ifdef XZX_PLUS3
		case ROM_PLUS3:
#endif
			bellAddr = 0x3b5;
			break;
		default:
			return;
	}
	basicrom = Machines[model].basicRom;
	RealMemory[basicrom][bellAddr] = 0xed;
	RealMemory[basicrom][bellAddr + 1] = BELL_BPT;
}

void
RingBell(int freq, int duration)
{
	XKeyboardState kbs, oldKbs;
#ifdef DEBUG
	if (GETCFG(debug) & D_AUDIO)
	{
		Msg(M_DEBUG, "BEEP: freq = %d Hz, time = %d ms", freq, duration);
	}
#endif
	XGetKeyboardControl(Dpy, &oldKbs);
	kbs.bell_pitch = freq;
	kbs.bell_duration = duration;
	kbs.bell_percent = GETCFG(volume);
#define KEYBOARD_FLAG (KBBellPitch | KBBellDuration | KBBellPercent)
	XChangeKeyboardControl(Dpy, KEYBOARD_FLAG, (XKeyboardControl *)&kbs);
	XBell(Dpy, 0);
	XChangeKeyboardControl(Dpy, KEYBOARD_FLAG, (XKeyboardControl *)&oldKbs);
#undef KEYBOARD_FLAG
	XFlush(Dpy);
}
#endif

