/********************************************************************************
 * Copyright (c) Razvan Surdulescu 1996
 *               Erik Kunze        1996 - 1998
 *
 * Permission to use, distribute, and sell this software and its documentation
 * for any purpose is hereby granted without fee, provided that the above
 * copyright notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that the name
 * of the copyright holder not be used in advertising or publicity pertaining to
 * distribution of the software without specific, written prior permission.  The
 * copyright holder makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or implied
 * warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
 *
 * THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Razvan Surdulescu
 *         Erik Kunze
 *
 * changed by EKU
 *******************************************************************************/
#ifndef lint
static char rcsid[] = "$Id: menu.c,v 4.7 1998/01/06 21:21:30 erik Rel $";
#endif

#include <X11/keysym.h>
#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "z80.h"
#include "resource.h"
#include "mem.h"
#include "util.h"
#ifdef AUDIO
#include "audio.h"
#endif
#include "dialog.h"
#include "emul.h"
#ifdef XZX_PLUS3
#include "fdc.h"
#endif
#ifdef XZX_IF1
#include "if1.h"
#endif
#ifdef JOY
#include "joystick.h"
#endif
#include "loadsave.h"
#include "monitor.h"
#include "screen.h"
#include "snapshot.h"
#include "menu.h"

#define PARAMETER_COLUMN	24

static int displayKeyboardLayout(void);
static void genericMenu(void);
#ifdef AUDIO
static void soundMenu(void);
#endif
static void joyMenu(void);
#if defined(XZX_IF1) || defined(XZX_PLUS3)
static void diskMenu(void);
#endif
static void tapeMenu(void);


static char *mainMenuTxt[] = {
	"Main Menu",
	"Keyboard layout             F1",
	"Save snapshot               F2",
	"Load snapshot               F3",
	"Save screenshot             F4",
	"Tape Options",
	"Reset                       F5",
	"NMI                         F6",
	"Debugger                    F7",
	"Generic Options",
#ifdef AUDIO
	"Sound Options",
#else
	"`Sound Options",
#endif
	"Joystick Options",
#if defined(XZX_IF1) || defined(XZX_PLUS3)
	"Interface I/+3 Options",
#else
	"`Interface I/+3 Options",
#endif
	"Choose Architecture         F9",
	"Quit                       F10",
	NULL
};
static char *architMenuTxt[] = {
	"Architecture Options",
	"Spectrum 48K  (reset)",
	"Spectrum 128k (reset)",
#ifdef XZX_PLUS3
	"Spectrum +3   (reset)",
#else
	"`Spectrum +3   (reset)",
#endif
	"",
	"Spectrum 48K  (no reset)",
	"Spectrum 128k (no reset)",
#ifdef XZX_PLUS3
	"Spectrum +3   (no reset)",
#else
	"`Spectrum +3   (no reset)",
#endif
	"",
#ifdef XZX_IF1
	"Interface I           [ ]",
#else
	"`Interface I           [ ]",
#endif
#ifdef XZX_MF128
	"Multiface 128         [ ]",
#else
	"`Multiface 128         [ ]",
#endif
	NULL
	};
static char *genericMenuTxt[] = {
	"Generic Options",
	"Flashing              [ ]",
	"Border                [ ]",
	"Ms/frame              [      ]",
	"Fast                  [ ]",
#ifdef SLOWDOWN
	"Slowdown              [      ]",
#else
	"`Slowdown              [      ]",
#endif
	"Refresh               [      ]",
	"Issue                 [ ]",
#ifdef DEBUG
	"Debug                 [      ]",
#else
	"`Debug                 [      ]",
#endif
	NULL
};
#ifdef AUDIO
static char *soundMenuTxt[] = {
	"Sound Options",
#if defined(PCSPKR_AUDIO) || defined(SUN_AUDIO)
	"Speaker               [ ]",
#else
	"`Speaker               [ ]",
#endif
#ifdef AYCHIP_AUDIO
	"AY8912                [ ]",
#else
	"`AY8912                [ ]",
#endif
#if defined(SUN_AUDIO) || defined(XBELL_AUDIO)
	"Volume                [    ]%",
#else
	"`Volume                [    ]%",
#endif
	NULL
};
#endif
static char *joyMenuTxt[] = {
	"Joystick Options",
	"Up                    [      ]",
	"Down                  [      ]",
	"Left                  [      ]",
	"Right                 [      ]",
	"Fire                  [      ]",
	"",
#ifdef JOY
	"Analogue joystick     [ ]",
	"Tolerance             [      ]",
	"Calibrate",
#else
	"`Analogue Joystick     [ ]",
	"`Tolerance             [      ]",
	"`Calibrate",
#endif
	NULL
};
#if defined(XZX_IF1) || defined(XZX_PLUS3)
static char *diskMenuTxt[] = {
	"Interface I/+3 Options",
#ifdef XZX_IF1
	"Select microdrive     [ ]",
	"Insert cartridge",
	"Take cartridge out",
	"",
	"Translate NL          [ ]",
	"Strip CR              [ ]",
#else
	"`Select microdrive     [ ]",
	"`Insert cartridge",
	"`Take cartridge out",
	"",
	"`Translate NL          [ ]",
	"`Strip CR              [ ]",
#endif
	"",
#ifdef XZX_PLUS3
	"Select drive          [ ]",
	"Insert disk",
	"Take disk out",
#else
	"`Select drive          [ ]",
	"`Insert disk",
	"`Take disk out",
#endif
	NULL
};
#endif
static char *tapeMenuTxt[] = {
	"Tape Options",
	"Select inputfile",
	"Close inputfile",
	"Browse through inputfile",
	"Playback inputfile    [    ]",
#if defined(PCSPKR_AUDIO) || defined(SUN_AUDIO)
	"Loading noise         [ ]",
#else
	"`Loading noise         [ ]",
#endif
	"",
	"Select outputfile",
	"Close outputfile",
	NULL
};

static int
displayKeyboardLayout()
{
	FILE *ifp;
	size_t nread;
	if (!(ifp = Fopen(GETCFG(kbdlayout), "rb")))
	{
		Msg(M_PERR, "couldn't open keyboard layout image <%s> for reading",
			GETCFG(kbdlayout));
		return -1;
	}
	nread = fread(RealMemory[ScreenSelect], 1, PIXEL_LENGTH + ATTR_LENGTH, ifp);

	if (nread != PIXEL_LENGTH + ATTR_LENGTH)
	{
		Msg(M_WARN, "layout image is only %d bytes", nread);
	}
	(void)fclose(ifp);
	SetBorderColor(BLACK);
	ForceScreenRefresh();
	ScreenRefresh();
	return 0;
}

void
MainMenu(int choice)
{
	int item = choice;
	int oldInDialog;
	assert(choice >= 0 && choice < NOPTS(mainMenuTxt));

	oldInDialog = EnterOSD();
  again:

	DisplayMenu(mainMenuTxt);
	for (;;)
	{
		switch (BrowseList(&item, NOPTS(mainMenuTxt), NOPTS(mainMenuTxt), NULL))
		{

			case XK_F1:
				item = 0;
				break;
			case XK_F2:
				item = 1;
				break;
			case XK_F3:
				item = 2;
				break;
			case XK_F4:
				item = 3;
				break;
			case XK_F5:
				item = 5;
				break;
			case XK_F6:
				item = 6;
				break;
			case XK_F7:
				item = 7;
				break;
			case XK_F9:
				item = 12;
				break;
			case XK_F10:
			case XK_F12:
				item = 13;
				break;
			case XK_Return:

				switch(item)
				{
					case 0:
						if (!displayKeyboardLayout())
						{

							(void)GetKey();
							SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
						}
						break;
					case 1:
						WriteSnapshotWithFS();
						break;
					case 2:
						ReadSnapshotWithFS();
						break;
					case 3:
						WriteScreenDumpWithFS();
						break;
					case 4:
						tapeMenu();
						break;
					case 5:
						Z80_Reset();
						break;
					case 6:
						Z80_NMI();
						break;
					case 7:
						Debugger(DBG_OSD);
						break;
					case 8:
						genericMenu();
						break;
#ifdef AUDIO
					case 9:
						soundMenu();
						break;
#endif
					case 10:
						joyMenu();
						break;
#if defined(XZX_IF1) || defined(XZX_PLUS3)
					case 11:
						diskMenu();
						break;
#endif
					case 12:
						HardwareMenu();
						break;
					case 13:
						Quit(0);
						break;
				}
				if (item != choice)
				{
					goto again;
				}

			case ESCAPE:
				goto quit;
		}
	}
  quit:

	LeaveOSD(oldInDialog);
}

static void
genericMenu(void)
{
	int item = 0;
	int oldInDialog;
	char buffer[7];
	int val;

	oldInDialog = EnterOSD();

	DisplayMenu(genericMenuTxt);
  again:

	SetAttr(MENU_SELECT_ATTR);
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y);
	PrintLetter(GETCFG(flashing) ? 'Y' : 'N');
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 1);
	PrintLetter(GETCFG(border) ? 'Y' : 'N');
	(void)sprintf(buffer, "%-6d", GETCFG(ms));
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 2);
	PrintString(buffer);
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 3);
	PrintLetter(GETCFG(fast) ? 'Y' : 'N');
#ifdef SLOWDOWN
	(void)sprintf(buffer, "%-6d", GETCFG(slowdown));
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 4);
	PrintString(buffer);
#endif
#ifdef MITSHM
	if (GETCFG(mitshm))
	{
		(void)sprintf(buffer, "%-6d", GETCFG(rrShm));
	}
	else
#endif
	{
		(void)sprintf(buffer, "%-6d", GETCFG(rrNoShm));
	}
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 5);
	PrintString(buffer);
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 6);
	PrintLetter('0' + GETCFG(issue));
#ifdef DEBUG
	(void)sprintf(buffer, "%-6d", GETCFG(debug));
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 7);
	PrintString(buffer);
#endif
	SetAttr(MENU_TEXT_ATTR);
	for (;;)
	{
		switch (BrowseList(&item, NOPTS(genericMenuTxt), NOPTS(genericMenuTxt),
						   NULL))
		{

			case XK_Return:

				switch(item)
				{
					case 0:
						SETCFG(flashing, !GETCFG(flashing));
						goto again;
					case 1:
						SETCFG(border, !GETCFG(border));
						goto again;
					case 2:
						SetAttr(MENU_SELECT_ATTR);
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						if (GetString(buffer, 6, 6))
						{
							val = atoi(buffer);
							if (val > 0 && val <= 100)
							{
								SETCFG(ms, val);
								IntFrequency(1000 * GETCFG(ms));
#ifdef SUN_AUDIO
								SpeakerReInit();
#endif
							}
						}
						SetAttr(MENU_TEXT_ATTR);
						goto again;
					case 3:
						SETCFG(fast, !GETCFG(fast));
						goto again;
#ifdef SLOWDOWN
					case 4:
						SetAttr(MENU_SELECT_ATTR);
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						if (GetString(buffer, 6, 6))
						{
							val = atoi(buffer);
							if (val >= 0 && val <= 9999)
							{
								SETCFG(slowdown, val);
							}
						}
						SetAttr(MENU_TEXT_ATTR);
						goto again;
#endif
					case 5:
						SetAttr(MENU_SELECT_ATTR);
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						if (GetString(buffer, 6, 6))
						{
							val = atoi(buffer);
							if (val > 0 && val <= 50)
							{
#ifdef MITSHM
								if (GETCFG(mitshm))
								{
									SETCFG(rrShm, val);
								}
								else
#endif
								{
									SETCFG(rrNoShm, val);
								}
							}
						}
						SetAttr(MENU_TEXT_ATTR);
						goto again;
					case 6:
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						SETCFG(issue, GETCFG(issue) == 2 ? 3 : 2);
						goto again;
#ifdef DEBUG
					case 7:
						SetAttr(MENU_SELECT_ATTR);
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						if (GetString(buffer, 6, 6))
						{
							val = atoi(buffer);
							if (val >= 0 && val <= 99999)
							{
								SETCFG(debug, val);
							}
						}
						SetAttr(MENU_TEXT_ATTR);
						goto again;
#endif
				}
				break;
			case ESCAPE:
				goto quit;
		}
	}
  quit:

	LeaveOSD(oldInDialog);
}

void
HardwareMenu(void)
{
	int item = 0;
	int oldInDialog;

	oldInDialog = EnterOSD();

	DisplayMenu(architMenuTxt);

	SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + 12);
	PrintString("Current mode is ");
	PrintString(GETCFG(machine) <= SP_48_3 ?
				"48K" : GETCFG(machine) == SP_128 ? "128K" : "+3");
#if defined(XZX_IF1) || defined(XZX_MF128)
  again:
#endif

	SetAttr(MENU_SELECT_ATTR);
#ifdef XZX_IF1
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 8);
	PrintLetter(GETCFG(machine) == SP_3 ? '-'
										: GETCFG(if1_active) ? 'Y' : 'N');
#endif
#ifdef XZX_MF128
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 9);
	PrintLetter(GETCFG(machine) == SP_3 ? '-'
										: GETCFG(mf128_active) ? 'Y' : 'N');
#endif
	SetAttr(MENU_TEXT_ATTR);
	for (;;)
	{
		switch (BrowseList(&item, NOPTS(architMenuTxt), NOPTS(architMenuTxt),
						   NULL))
		{

			case XK_Return:

				switch(item)
				{
					case 0:
						SelectModel(GETCFG(issue) == 2 ? SP_48_2 : SP_48_3, 1);
						goto quit;
					case 1:
						SelectModel(SP_128, 1);
						goto quit;
#ifdef XZX_PLUS3
					case 2:
						SelectModel(SP_3, 1);
						goto quit;
#endif
					case 4:
						SelectModel(GETCFG(issue) == 2 ? SP_48_2 : SP_48_3, 0);
						goto quit;
					case 5:
						SelectModel(SP_128, 0);
						goto quit;
#ifdef XZX_PLUS3
					case 6:
						SelectModel(SP_3, 0);
						goto quit;
#endif
#ifdef XZX_IF1
					case 8:
#ifdef XZX_PLUS3
						if (GETCFG(machine) != SP_3)
#endif
						{
							SETCFG(if1_active, !GETCFG(if1_active));
						}
						goto again;
#endif
#ifdef XZX_MF128
					case 9:
#ifdef XZX_PLUS3
						if (GETCFG(machine) != SP_3)
#endif
						{
							SETCFG(mf128_active, !GETCFG(mf128_active));
						}
						goto again;
#endif
				}
				break;
			case ESCAPE:
				goto quit;
		}
	}
  quit:

	LeaveOSD(oldInDialog);
}

#ifdef AUDIO
static void
soundMenu(void)
{
	int item = 0;
	int oldInDialog;
#if defined(SUN_AUDIO) || defined(XBELL_AUDIO)
	char buffer[4];
	int val;
#endif

	oldInDialog = EnterOSD();

	DisplayMenu(soundMenuTxt);
  again:

	SetAttr(MENU_SELECT_ATTR);
#if defined(PCSPKR_AUDIO) || defined(SUN_AUDIO)
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y);
	PrintLetter(SpActive ? OldSp ? 'Y' : 'N' : '-');
#endif
#ifdef AYCHIP_AUDIO
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 1);
	PrintLetter(AyActive ? OldAy ? 'Y' : 'N' : '-');
#endif
#if defined(SUN_AUDIO) || defined(XBELL_AUDIO)
	(void)sprintf(buffer, "%-3d", GETCFG(volume));
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 2);
	PrintString(buffer);
#endif
	SetAttr(MENU_SELECT_ATTR);
	for (;;)
	{
		switch (BrowseList(&item, NOPTS(soundMenuTxt), NOPTS(soundMenuTxt),
						   NULL))
		{

			case XK_Return:

				switch(item)
				{
#if defined(PCSPKR_AUDIO) || defined(SUN_AUDIO)
					case 0:
						if (SpActive)
						{
							OldSp = !OldSp;
#if defined(SUN_AUDIO) && defined(AYCHIP_AUDIO)
							if (AyActive & OldSp)
							{
								OldAy = 0;
							}
#endif
							goto again;
						}
						break;
#endif
#ifdef AYCHIP_AUDIO
					case 1:
						if (AyActive)
						{
							OldAy = !OldAy;
#ifdef SUN_AUDIO
							if (SpActive && OldAy)
							{
								OldSp = 0;
							}
#endif
							goto again;
						}
						break;
#endif
#if defined(SUN_AUDIO) || defined(XBELL_AUDIO)
					case 2:
						SetAttr(MENU_SELECT_ATTR);
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						if (GetString(buffer, 4, 4))
						{
							val = atoi(buffer);
							if (val >= 0 && val <= 100)
							{
								SETCFG(volume, val);
							}
						}
						SetAttr(MENU_TEXT_ATTR);
						goto again;
#endif
				}
				break;
			case ESCAPE:
				goto quit;
		}
	}
  quit:

	LeaveOSD(oldInDialog);
}
#endif

static void
joyMenu(void)
{
	int item = 0;
	int oldInDialog;
	char *p;
	int i, j;
#ifdef JOY
	char buffer[7];
	int val;
#endif

	oldInDialog = EnterOSD();
#ifdef JOY
  again:
#endif

	DisplayMenu(joyMenuTxt);
  again2:

	SetAttr(MENU_SELECT_ATTR);
	for (i = 0; i < 5; i++)
	{
		SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + i);
		p = XKeysymToString(GETCFG(joyKeys[i]));
		for (j = 0; j < 6 && *p; j++)
		{
			PrintLetter(*p++);
		}
		for (; j < 6; j++)
		{
			PrintLetter(' ');
		}
	}
#ifdef JOY
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 6);
	PrintLetter(JoyActive ? GETCFG(useJoy) ? 'Y' : 'N' : '-');
	(void)sprintf(buffer, "%-6d", GETCFG(joyTolerance));
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 7);
	PrintString(buffer);
#endif
	SetAttr(MENU_SELECT_ATTR);
	for(;;)
	{
		switch (BrowseList(&item, NOPTS(joyMenuTxt), NOPTS(joyMenuTxt), NULL))
		{

			case XK_Return:

				switch(item)
				{
					case 0:
					case 1:
					case 2:
					case 3:
					case 4:
						SetAttr(MENU_SELECT_ATTR);
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						PrintString("      ");
						SetAttr(MENU_TEXT_ATTR);
						ScreenRefresh();
						SETCFG(joyKeys[item], GetKey());
						goto again2;
#ifdef JOY
					case 6:
						if (JoyActive)
						{
							SETCFG(useJoy, !GETCFG(useJoy));
							goto again2;
						}
						break;
					case 7:
						SetAttr(MENU_SELECT_ATTR);
						SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + item);
						if (GetString(buffer, 6, 6))
						{
							val = atoi(buffer);
							if (val > 0 && val <= 9999)
							{
								SETCFG(joyTolerance, val);
							}
						}
						SetAttr(MENU_TEXT_ATTR);
						goto again2;
					case 8:
						if (JoyActive)
						{
							JoyCalibrate();
							goto again;
						}
						break;
#endif
				}
				break;
			case ESCAPE:
				goto quit;
		}
	}
  quit:

	LeaveOSD(oldInDialog);
}

#if defined(XZX_IF1) || defined(XZX_PLUS3)
static void
diskMenu(void)
{
	int item = 0;
	int oldInDialog;
#ifdef XZX_IF1
	static int mdr = 0;
#endif
#ifdef XZX_PLUS3
	static int disk = 0;
#endif

	oldInDialog = EnterOSD();
  again:

	DisplayMenu(diskMenuTxt);
  again2:

#ifdef XZX_IF1
	SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 2);
	PrintString("Current cartridge");
	SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 3);
	DrawBox(COLS - (MENU_CURSOR_X + 2), 1);
	PrintString(GetBaseName(If1CartName(mdr)));
#endif
#ifdef XZX_PLUS3
#ifdef XZX_IF1
	SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 5);
	PrintString("Current disk");
	SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 6);
	DrawBox(COLS - (MENU_CURSOR_X + 2), 1);
	PrintString(GetBaseName(FdcDiskName(disk)));
#else
	SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 2);
	PrintString("Current disk");
	SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(diskMenuTxt) + 3);
	DrawBox(COLS - (MENU_CURSOR_X + 2), 1);
	PrintString(GetBaseName(FdcDiskName(disk)));
#endif
#endif

#ifdef XZX_IF1
  again3:
	SetAttr(MENU_SELECT_ATTR);
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 0);
	PrintLetter((char)('1' + mdr));
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 4);
	PrintLetter(GETCFG(translate_nl) ? 'Y' : 'N');
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 5);
	PrintLetter(GETCFG(strip_nl) ? 'Y' : 'N');
	SetAttr(MENU_TEXT_ATTR);
#endif
#ifdef XZX_PLUS3
	SetAttr(MENU_SELECT_ATTR);
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 7);
	PrintLetter((char)('A' + disk));
	SetAttr(MENU_TEXT_ATTR);
#endif
	for (;;)
	{
		switch (BrowseList(&item, NOPTS(diskMenuTxt), NOPTS(diskMenuTxt), NULL))
		{

			case XK_Return:

				switch(item)
				{
#ifdef XZX_IF1
					case 0:
						mdr = ++mdr % IF1_DRIVES;
						goto again2;
					case 1:
						(void)If1InsertCart(mdr);
						goto again;
					case 2:
						If1EjectCart(mdr);
						goto again2;
					case 4:
						SETCFG(translate_nl, !GETCFG(translate_nl));
						goto again3;
					case 5:
						SETCFG(strip_nl, !GETCFG(strip_nl));
						goto again3;
#endif
#ifdef XZX_PLUS3
					case 7:
						disk = !disk;
						goto again2;
					case 8:
						(void)FdcInsertDisk(disk);
						goto again;
					case 9:
						FdcEjectDisk(disk);
						goto again2;
#endif
				}
				break;
			case ESCAPE:
				goto quit;
		}
	}
  quit:

	LeaveOSD(oldInDialog);
}
#endif

static void
tapeMenu(void)
{
	int item = 0;
	int oldInDialog;

	oldInDialog = EnterOSD();
  again:

	DisplayMenu(tapeMenuTxt);

	SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 2);
	PrintString("Current inputfile");
	SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 3);
	PrintString(GetBaseName(TpTapeName(TO_READ)));
	SetCursor(MENU_CURSOR_X + 1, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 5);
	PrintString("Current outputfile");
	SetCursor(MENU_CURSOR_X + 2, MENU_CURSOR_Y + NOPTS(tapeMenuTxt) + 6);
	PrintString(GetBaseName(TpTapeName(TO_WRITE)));
  again2:

	SetAttr(MENU_SELECT_ATTR);
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 3);
	PrintString(TpState & TS_ERRIN ? "ERR "
								   : TpState & TS_PLAY ? "PLAY" : "STOP");
#if defined(PCSPKR_AUDIO) || defined(SUN_AUDIO)
	SetCursor(PARAMETER_COLUMN, MENU_CURSOR_Y + 4);
	PrintLetter(GETCFG(noise) ? 'Y' : 'N');
#endif
	SetAttr(MENU_TEXT_ATTR);
	for (;;)
	{
		switch (BrowseList(&item, NOPTS(tapeMenuTxt), NOPTS(tapeMenuTxt), NULL))
		{

			case XK_Return:

				switch(item)
				{
					case 0:
						(void)TpInsertTape("Input Tape",
										   TO_READ | TO_TAP | TO_TZX);
						goto again;
					case 1:
						TpEjectTape(TO_READ);
						goto again;
					case 2:
						if (TpState & (TS_TAPIN | TS_TZXIN)
							&& !(TpState & (TS_PLAY | TS_ERRIN)))
						{
							TpBrowser();
							goto again;
						}
						break;
					case 3:
						if (TpState & TS_TZXIN && !(TpState & TS_ERRIN))
						{
							if (TpState & TS_PLAY)
							{
								TpStopPlayback();
								goto again2;
							}
							else if (!(TpState & TS_ENDIN))
							{
								TpStartPlayback();
								goto again2;
							}
						}
						break;
#if defined(PCSPKR_AUDIO) || defined(SUN_AUDIO)
					case 4:
						SETCFG(noise, !GETCFG(noise));
						goto again2;
#endif
					case 6:
						(void)TpInsertTape("Ouput Tape", TO_WRITE | TO_TAP);
						goto again;
					case 7:
						TpEjectTape(TO_WRITE);
						goto again;
				}
				break;
			case ESCAPE:
				goto quit;
		}
	}
  quit:

	LeaveOSD(oldInDialog);
}

void
WriteSnapshotWithFS(void)
{
	char *fname;
	if((fname = FileSelector("Save Snapshot", 0, "z80",
							 GETCFG(machine) <= SP_48_3 ?
							 "sna" : InSlt ?
							 "slt" : NULL,
							 GETCFG(machine) <= SP_48_3 &&
							 InSlt ? "slt" : NULL)))
	{
		if (InDialog)
		{
			RestoreScreen();
		}
		(void)WriteSnapshot(fname);
		free(fname);
	}
}
void
ReadSnapshotWithFS(void)
{
	char *fname;
	if ((fname = FileSelector("Load Snapshot", 1, "z80", "sna", "slt")))
	{
		(void)ReadSnapshot(fname);
		free(fname);
		if (InDialog)
		{
			SaveScreen();
			SetBorderColor((MENU_TEXT_ATTR & PAPER) >> 3);
		}
	}
}
void
WriteScreenDumpWithFS(void)
{
	char *fname;
	if((fname = FileSelector("Save Screenshot", 0, "scr", NULL, NULL)))
	{
		if (InDialog)
		{
			RestoreScreen();
		}
		(void)WriteScreenDump(fname);
		free(fname);
	}
}

